/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.roi;

import com.ge.med.cse.cvf.base.ROIUtils;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.PanZoomCapable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.jami.capable.UserAnnoCapable;
import com.ge.med.terra.jami.j3d.T3DComponent;
import com.ge.med.terra.jami.j3d.T3DViewport;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class DefaultROIUtils
implements ROIUtils {
    int width;
    int height;
    double x;
    double y;
    double w;
    double h;

    @Override
    public Point2D[] getROICoordinates(ROICapable roic, ROIUtils.ROITYPE roiType) throws UnsupportedOperationException {
        this.isValidImage(roic);
        XpVisualComponent imagevc = DefaultROIUtils.getImageVc(roic);
        if (imagevc == null) {
            throw new UnsupportedOperationException("Image VC is null");
        }
        switch (roiType) {
            case POINT: {
                Point2D[] pt = new Point2D[1];
                double w2 = 30.0;
                double h2 = 30.0;
                this.x = (double)this.width * 0.5 - w2 / 2.0;
                this.y = (double)this.height * 0.5 - h2 / 2.0;
                pt[0] = new Point2D.Double(this.x, this.y);
                return pt;
            }
            case LINE: {
                return this.getLineRoiPoints(imagevc);
            }
            case ANGLE: {
                return this.getAngleRoiPoints(imagevc);
            }
        }
        return null;
    }

    @Override
    public Shape getROIPosition(ROICapable roic, ROIUtils.ROITYPE roiType) throws UnsupportedOperationException {
        this.isValidImage(roic);
        switch (roiType) {
            case RECTANGLE: {
                return this.getRectangularRoiBound(roic);
            }
            case ELLIPSE: {
                Rectangle2D r2 = this.getRectangularRoiBound(roic);
                return new Ellipse2D.Double(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
            }
            case RECTMATTE: {
                return this.getMatteRoiBound(roic);
            }
            case ELLIPSEMATTE: {
                Rectangle2D r2 = this.getMatteRoiBound(roic);
                return new Ellipse2D.Double(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
            }
        }
        return null;
    }

    protected Rectangle2D getRectangularRoiBound(ROICapable roic) {
        double zo = ((PanZoomCapable)((Object)roic)).getZoom();
        XpVisualComponent imagevc = DefaultROIUtils.getImageVc(roic);
        if (imagevc == null) {
            throw new UnsupportedOperationException("Image VC is null");
        }
        Dimension d2 = imagevc.getSize();
        Point2D.Double dpt = new Point2D.Double(d2.getWidth() * 0.4, d2.getHeight() * 0.4);
        Point2D.Double ipt = new Point2D.Double();
        imagevc.transformDisplayToImage(dpt, (Point2D)ipt);
        this.x = ((Point2D)ipt).getX();
        if (this.x < 0.0) {
            this.x = 0.0;
        }
        this.y = ((Point2D)ipt).getY();
        if (this.y < 0.0) {
            this.y = 0.0;
        }
        this.w = d2.getWidth() * 0.1 / zo;
        this.h = d2.getHeight() * 0.1 / zo;
        this.w *= (double)this.width / d2.getWidth();
        this.h *= (double)this.height / d2.getHeight();
        if (this.x + this.w > (double)this.width) {
            double dx = this.x - (double)this.width + this.w;
            this.x -= dx;
        }
        if (this.y + this.h > (double)this.height) {
            double dy = this.y - (double)this.height + this.h;
            this.y -= dy;
        }
        return new Rectangle2D.Double(this.x, this.y, this.w, this.h);
    }

    protected Rectangle2D getMatteRoiBound(ROICapable roic) {
        double h2;
        XpVisualComponent vc = DefaultROIUtils.getImageVc(roic);
        if (vc == null) {
            throw new UnsupportedOperationException("Image VC is null");
        }
        double x2 = (double)vc.getX() + (double)vc.getWidth() * 0.2 / 2.0;
        double y2 = (double)vc.getY() + (double)vc.getHeight() * 0.2 / 2.0;
        Point2D.Double in1 = new Point2D.Double(x2, y2);
        Point2D.Double in2 = new Point2D.Double(x2 + (double)vc.getWidth() * 0.8, y2 + (double)vc.getHeight() * 0.8);
        Point2D.Double out1 = new Point2D.Double();
        Point2D.Double out2 = new Point2D.Double();
        vc.transformDisplayToImage(in1, (Point2D)out1);
        vc.transformDisplayToImage(in2, (Point2D)out2);
        x2 = ((Point2D)out1).getX();
        y2 = ((Point2D)out1).getY();
        double w2 = ((Point2D)out2).getX() - ((Point2D)out1).getX();
        if (w2 < 0.0) {
            x2 += w2;
        }
        if ((h2 = ((Point2D)out2).getY() - ((Point2D)out1).getY()) < 0.0) {
            y2 += h2;
        }
        return new Rectangle2D.Double(x2, y2, Math.abs(w2), Math.abs(h2));
    }

    protected Point2D[] getLineRoiPoints(XpVisualComponent vc) {
        double y2;
        Dimension d2 = vc.getSize();
        Point2D[] dpts = new Point2D[]{new Point2D.Double(d2.getWidth() * 0.45, d2.getHeight() * 0.45), new Point2D.Double(d2.getWidth() * 0.55, d2.getHeight() * 0.55)};
        Point2D.Double ipt = new Point2D.Double();
        vc.transformDisplayToImage(dpts[0], (Point2D)ipt);
        double x2 = ((Point2D)ipt).getX();
        if (x2 < 0.0) {
            x2 = 0.0;
        }
        if ((y2 = ((Point2D)ipt).getY()) < 0.0) {
            y2 = 0.0;
        }
        dpts[0] = new Point2D.Double(x2, y2);
        ipt = new Point2D.Double();
        vc.transformDisplayToImage(dpts[1], (Point2D)ipt);
        x2 = ((Point2D)ipt).getX();
        if (x2 >= (double)this.width) {
            x2 = this.width - 1;
        }
        if ((y2 = ((Point2D)ipt).getY()) >= (double)this.height) {
            y2 = this.height - 1;
        }
        dpts[1] = new Point2D.Double(x2, y2);
        return dpts;
    }

    protected Point2D[] getAngleRoiPoints(XpVisualComponent vc) {
        Dimension d2 = vc.getSize();
        Point2D[] dpts = new Point2D[]{new Point2D.Double(d2.getWidth() * 0.6, d2.getHeight() * 0.45), new Point2D.Double(d2.getWidth() * 0.4, d2.getHeight() * 0.55), new Point2D.Double(d2.getWidth() * 0.6, d2.getHeight() * 0.65)};
        Point2D[] ipts = new Point2D[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            ipts[i2] = new Point2D.Double();
            vc.transformDisplayToImage(dpts[i2], ipts[i2]);
            double x2 = ipts[i2].getX();
            double y2 = ipts[i2].getY();
            if (x2 < 0.0) {
                x2 = 0.0;
            }
            if (y2 < 0.0) {
                y2 = 0.0;
            }
            if (x2 > (double)this.width) {
                x2 = this.width - 1;
            }
            if (y2 > (double)this.height) {
                y2 = this.height - 1;
            }
            dpts[i2] = new Point2D.Double(x2, y2);
        }
        return dpts;
    }

    @Override
    public CPoint[] getUserAnnotationCoordinates(UserAnnoCapable unnocap) throws UnsupportedOperationException {
        CPoint[] cpt = new CPoint[2];
        if (unnocap instanceof FrameCapable) {
            FrameCapable fc = (FrameCapable)((Object)unnocap);
            if (fc.getFrame() == null) {
                return null;
            }
            this.width = fc.getFrame().getSlice().width;
            this.height = fc.getFrame().getSlice().height;
        }
        double hw = (double)this.width * 0.5;
        double hh = (double)this.height * 0.5;
        XpVisualComponent imagevc = DefaultROIUtils.getImageVc(unnocap);
        if (imagevc == null) {
            throw new UnsupportedOperationException("Image VC is null");
        }
        CPoint textAnchor = null;
        CPoint target = null;
        if (imagevc instanceof T3DComponent) {
            CPoint dpt = new CPoint(hw, hh, 0.0, 1);
            textAnchor = new CPoint();
            target = new CPoint();
            imagevc.transform(dpt, target, (byte)5);
            dpt.y -= 30.0;
            dpt.x -= 30.0;
            imagevc.transform(dpt, textAnchor, (byte)5);
        } else {
            CPoint ipt = new CPoint(hw - hw * 0.1, hh, 0.0, 0);
            CPoint dpt = new CPoint();
            imagevc.transform(ipt, dpt, (byte)1);
            textAnchor = new CPoint();
            imagevc.transform(dpt, textAnchor, (byte)3);
            target = new CPoint(hw, hh - hh * 0.1, 0.0, 0);
        }
        cpt[0] = textAnchor;
        cpt[1] = target;
        return cpt;
    }

    protected boolean isValidImage(Capable cap) {
        if (cap instanceof FrameCapable) {
            XpImage img = ((FrameCapable)((Object)cap)).getFrame();
            if (!CvUtils.measurementsValid(img)) {
                throw new UnsupportedOperationException("Image type unsupported for measurement");
            }
            this.width = img.getSlice().width;
            this.height = img.getSlice().height;
        }
        return true;
    }

    private static XpVisualComponent getImageVc(Capable c2) {
        if (c2 == null) {
            return null;
        }
        if (c2 instanceof XpSingularPort) {
            return ((XpSingularPort)c2).getMedicalImageVc().getImageVc();
        }
        if (c2 instanceof T3DViewport) {
            return ((T3DViewport)c2).getT3DComponent();
        }
        JComponent comp = null;
        while (c2 instanceof SelectionCapable) {
            comp = ((SelectionCapable)c2).getViewportComponent(((SelectionCapable)c2).getComponentSelection());
            c2 = comp instanceof SelectionCapable ? (SelectionCapable)((Object)comp) : null;
        }
        if (comp instanceof XpSingularPort) {
            return ((XpSingularPort)comp).getMedicalImageVc().getImageVc();
        }
        if (comp instanceof T3DViewport) {
            return ((J3DViewport)comp).getT3DComponent();
        }
        return null;
    }

    public static boolean configureROIStat(XpImage img) {
        String modSuffix;
        XpDicomElement elem = new XpDicomElement(8, 96);
        String modality = null;
        boolean calibrated = false;
        if (img instanceof XpDicomObject) {
            ((XpDicomObject)((Object)img)).getValue(elem);
            modality = elem.value != null ? elem.value.toString().toLowerCase() : null;
            calibrated = !CvUtils.needCalibration((XpDicomObject)((Object)img));
        }
        String string = modSuffix = modality != null ? "." + modality.toLowerCase() : "";
        if (!calibrated) {
            CvPropertiesManager.setProperty("cvf.roi.distance.suffix" + modSuffix, " pix");
            CvPropertiesManager.setProperty("cvf.roi.area.suffix" + modSuffix, " pix2");
            return false;
        }
        CvPropertiesManager.setProperty("cvf.roi.distance.suffix" + modSuffix, " mm");
        CvPropertiesManager.setProperty("cvf.roi.area.suffix" + modSuffix, " mm2");
        return true;
    }
}

