/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.saveimage;

import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.saveimage.DicomDecorator;
import com.ge.med.cse.cvf.saveimage.XpSaveParameters;
import com.ge.med.cse.cvf.saveimage.XpSaveUtil;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XpDicomComposite
extends DicomComposite {
    protected DicomComposite referenceComposite = null;
    protected XpSaveParameters saveParams = new XpSaveParameters();
    private DicomDecorator dcmDecorator = null;
    private static final Logger logger = Logger.getLogger(XpDicomComposite.class.getName());
    protected static NumberFormat decimalFormat = NumberFormat.getInstance(Locale.US);

    public XpDicomComposite(DicomComposite referenceComposite, XpSaveParameters saveParams) {
        this.referenceComposite = referenceComposite;
        this.saveParams = saveParams;
        this.initComposite();
    }

    public void setDecorator(DicomDecorator dcrtr) {
        this.dcmDecorator = dcrtr;
        this.dcmDecorator.setReferenceComposite(this.referenceComposite);
        this.dcmDecorator.setReferenceParameters(this.saveParams);
        this.dcmDecorator.Decorate(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initComposite() {
        XpSlice slice = this.saveParams.image.getSlice();
        InputStream inStream = this.referenceComposite.getInputStream();
        try {
            this.read(inStream);
        }
        catch (DMException ex) {
            logger.log(Level.WARNING, "Exception while reading the InputStream", ex.getLocalizedMessage());
            ex.printStackTrace();
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException e2) {
                logger.log(Level.WARNING, "Exception while closing the InputStream", e2.getLocalizedMessage());
                e2.printStackTrace();
            }
        }
        String imageUID = UidGenerator.newInstanceUID();
        this.setValue(2, 3, imageUID);
        Date currentDate = new Date();
        String date = XpSaveUtil.DICOM_VR_DA_FORMAT.format(currentDate);
        this.setValue(8, 18, date);
        String time = XpSaveUtil.DICOM_VR_TM_FORMAT.format(currentDate);
        this.setValue(8, 19, time);
        this.setValue(8, 24, imageUID);
        String seriesDateString = XpSaveUtil.DICOM_VR_DA_FORMAT.format(this.saveParams.seriesDate);
        this.setValue(8, 33, seriesDateString);
        this.setValue(8, 35, date);
        String seriesTimeString = XpSaveUtil.DICOM_VR_TM_FORMAT.format(this.saveParams.seriesDate);
        this.setValue(8, 49, seriesTimeString);
        this.setValue(8, 51, time);
        this.setValue(8, 4158, this.saveParams.seriesDescription);
        this.setValue(24, 80, XpDicomComposite.formatDouble(this.saveParams.imageThickness));
        this.setValue(24, 4352, XpDicomComposite.formatDouble((double)slice.width * slice.pixelSizeX));
        this.setValue(32, 14, this.saveParams.seriesUID);
        this.setValue(32, 17, new Integer(this.saveParams.seriesNum));
        this.setValue(32, 19, new Integer(this.saveParams.imageNum));
        this.setValue(32, 50, XpDicomComposite.formatDouble(-slice.ul.x) + "\\" + XpDicomComposite.formatDouble(-slice.ul.y) + "\\" + XpDicomComposite.formatDouble(slice.ul.z));
        this.setValue(32, 55, XpDicomComposite.formatDouble(-slice.I.x) + "\\" + XpDicomComposite.formatDouble(-slice.I.y) + "\\" + XpDicomComposite.formatDouble(slice.I.z) + "\\" + XpDicomComposite.formatDouble(-slice.J.x) + "\\" + XpDicomComposite.formatDouble(-slice.J.y) + "\\" + XpDicomComposite.formatDouble(slice.J.z));
        this.setValue(40, 48, XpDicomComposite.formatDouble(slice.pixelSizeY) + "\\" + XpDicomComposite.formatDouble(slice.pixelSizeX));
        this.setValue(40, 16, new Integer(slice.height));
        this.setValue(40, 17, new Integer(slice.width));
        if (this.saveParams.defaultWindowWidthLevel != null) {
            this.setValue(40, 4176, XpDicomComposite.formatDouble(this.saveParams.defaultWindowWidthLevel[1]));
            this.setValue(40, 4177, XpDicomComposite.formatDouble(this.saveParams.defaultWindowWidthLevel[0]));
        }
        if (this.saveParams.renderStyle != null && this.saveParams.renderStyle.equals("VOLUME")) {
            if (this.saveParams.image != null) {
                this.savePixelInformation(this.saveParams.image, (DicomComposite)this, true, false);
            }
        } else if (this.saveParams.image != null) {
            this.savePixelInformation(this.saveParams.image, (DicomComposite)this, false, this.saveParams.defaultWindowWidthLevel == null);
        }
        if (this.saveParams.renderStyle != null) {
            String imageType = "DERIVED\\SECONDARY\\REFORMATTED";
            if (this.saveParams.renderStyle.equals("MAJOR_AXIS_AVERAGE") || this.saveParams.renderStyle.equals("AVERAGE")) {
                imageType = imageType + "\\AVERAGE";
            }
            if (this.saveParams.renderStyle.equals("MAJOR_AXIS_MIP") || this.saveParams.renderStyle.equals("MIP")) {
                imageType = imageType + "\\MIP";
            }
            if (this.saveParams.renderStyle.equals("MAJOR_AXIS_MINIP") || this.saveParams.renderStyle.equals("MINIP")) {
                imageType = imageType + "\\MIN IP";
            }
            this.setValue(8, 8, imageType);
        }
    }

    protected void savePixelInformation(XpImage reformatImage, DicomComposite dc, boolean color, boolean calculatewwwl) {
        dc.setValue(40, 4178, XpDicomComposite.formatDouble(reformatImage.getRescaleIntercept()));
        dc.setValue(40, 4179, XpDicomComposite.formatDouble(reformatImage.getRescaleSlope()));
        DataBuffer db = reformatImage.getPixelData().getData().getDataBuffer();
        this.savePixelInformation(db, dc, color, calculatewwwl);
    }

    protected void savePixelInformation(DataBuffer db, DicomComposite dc, boolean color, boolean calculatewwwl) {
        short min = Short.MAX_VALUE;
        short max = Short.MIN_VALUE;
        if (!color) {
            dc.setValue(40, 2, new Integer(1));
            dc.setValue(40, 4, "MONOCHROME2");
            dc.setValue(40, 256, new Integer(16));
            dc.setValue(40, 257, new Integer(16));
            dc.setValue(40, 258, new Integer(15));
            dc.setValue(40, 259, new Integer(1));
            if (db instanceof DataBufferUShort) {
                short[] data = ((DataBufferUShort)db).getData();
                byte[] bdata = new byte[2 * data.length];
                for (int i2 = 0; i2 < data.length; ++i2) {
                    short d2 = data[i2];
                    if (d2 < min) {
                        min = d2;
                    }
                    if (d2 > max) {
                        max = d2;
                    }
                    int lo = (0xFF00 & d2) >> 8;
                    int hi = 0xFF & d2;
                    bdata[2 * i2 + 1] = (byte)lo;
                    bdata[2 * i2] = (byte)hi;
                }
                dc.setValue(32736, 16, bdata);
            } else if (db instanceof DataBufferShort) {
                short[] data = ((DataBufferShort)db).getData();
                byte[] bdata = new byte[2 * data.length];
                for (int i3 = 0; i3 < data.length; ++i3) {
                    short d3 = data[i3];
                    if (d3 < min) {
                        min = d3;
                    }
                    if (d3 > max) {
                        max = d3;
                    }
                    int hi = (0xFF00 & d3) >> 8;
                    int lo = 0xFF & d3;
                    bdata[2 * i3 + 1] = (byte)lo;
                    bdata[2 * i3] = (byte)hi;
                }
                dc.setValue(32736, 16, bdata);
            }
            dc.setValue(40, 262, new Short(min));
            dc.setValue(40, 263, new Short(max));
            if (calculatewwwl) {
                dc.setValue(40, 4176, XpDicomComposite.formatDouble((double)(max + min) / 2.0));
                dc.setValue(40, 4177, Integer.toString(max - min));
            }
        } else {
            dc.setValue(40, 2, new Integer(3));
            dc.setValue(40, 4, "RGB");
            dc.setValue(40, 256, new Integer(8));
            dc.setValue(40, 257, new Integer(8));
            dc.setValue(40, 258, new Integer(7));
            dc.setValue(40, 259, new Integer(0));
            if (db instanceof DataBufferInt) {
                int[] data = ((DataBufferInt)db).getData();
                byte[] bdata = new byte[3 * data.length];
                for (int i4 = 0; i4 < data.length; ++i4) {
                    for (int n2 = 0; n2 < 3; ++n2) {
                        bdata[i4 * 3 + 2 - n2] = (byte)(data[i4] >>> n2 * 8);
                    }
                }
                dc.setValue(32736, 16, bdata);
            } else if (db instanceof DataBufferByte) {
                byte[] bdata = ((DataBufferByte)db).getData();
                for (int i5 = 0; i5 < bdata.length; i5 += 3) {
                    byte t2 = bdata[i5];
                    bdata[i5] = bdata[i5 + 2];
                    bdata[i5 + 2] = t2;
                }
                dc.setValue(32736, 16, bdata);
            }
        }
    }

    protected String getSliceLocation(XpSlice slice, int planeType) {
        return XpDicomComposite.formatDouble(J3DGeomUtils.getSliceLocation(slice, planeType));
    }

    protected static String formatDouble(double value) {
        String strValue = Double.toString(value);
        int maxFracDigits = 8;
        while (strValue.length() > 16 && maxFracDigits > 0) {
            decimalFormat.setMaximumFractionDigits(maxFracDigits);
            strValue = decimalFormat.format(value);
            if (--maxFracDigits > 0) continue;
            throw new RuntimeException("Error formating double to string: value=" + value);
        }
        return strValue;
    }

    static {
        if (decimalFormat instanceof DecimalFormat) {
            ((DecimalFormat)decimalFormat).applyPattern("##.#");
            decimalFormat.setMaximumFractionDigits(8);
        }
    }
}

