/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.saveimage;

import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.saveimage.XpFillSaveParameters;
import com.ge.med.cse.cvf.saveimage.XpSaveParameters;
import com.ge.med.cse.cvf.saveimage.XpSaveUtil;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.image.XpBufferedImage;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.tap.dm.DMSession;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XpFillReformatSaveParameters
extends XpFillSaveParameters {
    private static final Logger logger = Logger.getLogger(XpFillReformatSaveParameters.class.getName());

    public XpFillReformatSaveParameters(XpViewport viewport) {
        super(viewport);
    }

    @Override
    public boolean fillSaveParameters(XpSaveParameters params) {
        if (!super.fillSaveParameters(params)) {
            return true;
        }
        T3DViewport t3dViewport = null;
        if (this.viewport instanceof T3DViewport) {
            t3dViewport = (T3DViewport)this.viewport;
        }
        if (t3dViewport == null || t3dViewport.getFrame() == null) {
            logger.log(Level.WARNING, "T3DViewport or its frame is null");
            return false;
        }
        DMSession osession = CvUtils.getDMSystem().getLocalDB();
        XjVolumeInfo volume = t3dViewport.getVolume();
        String renderStyle = t3dViewport.getRenderStyle();
        if (osession == null || volume == null || renderStyle == null) {
            logger.log(Level.WARNING, "DMSession or XjVolumeInfo or renderStyle is null");
            return false;
        }
        if (params.image == null) {
            params.image = (XpBufferedImage)t3dViewport.getFrame();
        }
        if (renderStyle.equals("FULLBODY_MIP") || renderStyle.equals("FULLBODY_MINIP") || renderStyle.equals("FULLBODY_AVERAGE")) {
            params.imageThickness = 0.0;
        } else if (params.imageThickness == -1.0) {
            double minThickness;
            double[] clip = t3dViewport.getViewClip(null);
            double thickness = Math.abs(clip[1] - clip[0]);
            ViewTypeCapable vtcap = (ViewTypeCapable)this.viewport.getCapable(ViewTypeCapable.class.getName());
            boolean oblique = false;
            if (vtcap != null) {
                oblique = vtcap.getViewType(vtcap.getViewType()).isObliqueControllable();
            }
            params.imageThickness = thickness > Math.abs(minThickness = J3DGeomUtils.getMinSliceThickness(volume, t3dViewport.getLookPoint(null), t3dViewport.getEyePoint(null), oblique)) && !renderStyle.startsWith("REFORMAT") ? thickness : Math.abs(minThickness);
        }
        if (params.sliceSpacing == -1.0) {
            params.sliceSpacing = -1.0;
        }
        if (params.renderStyle == null) {
            params.renderStyle = renderStyle;
        }
        if (params.defaultWindowWidthLevel == null) {
            params.defaultWindowWidthLevel = new double[2];
            double min = t3dViewport.getWinMin();
            double max = t3dViewport.getWinMax();
            params.defaultWindowWidthLevel[0] = max - min;
            params.defaultWindowWidthLevel[1] = (max + min) / 2.0;
        }
        if (!params.grayScaleInverted) {
            params.grayScaleInverted = t3dViewport.isVideoInverted();
        }
        if (params.seriesUID == null) {
            params.seriesUID = XpSaveUtil.getSeriesUID((String)volume.getValue(32, 13), params.seriesNum, osession);
        }
        if (params.seriesDate == -1L) {
            params.seriesDate = new Date().getTime();
        }
        if (params.imageNum == -1) {
            params.imageNum = 1;
        }
        if ((params.inputSliceI == null || params.inputSliceJ == null || params.inputSliceN == null) && (renderStyle.equals("FULLBODY_MIP") || renderStyle.equals("FULLBODY_MINIP") || renderStyle.equals("FULLBODY_AVERAGE"))) {
            XpDicomElement orientationElem = new XpDicomElement(32, 55);
            orientationElem.value = volume.getValue(orientationElem.group, orientationElem.element);
            double[] orientationValues = orientationElem.getDoubleArrayValue();
            params.inputSliceI = new JnVector3d(-orientationValues[0], -orientationValues[1], orientationValues[2]).normalize();
            params.inputSliceJ = new JnVector3d(-orientationValues[3], -orientationValues[4], orientationValues[5]).normalize();
            params.inputSliceN = JnVector3d.cross(params.inputSliceI, params.inputSliceJ);
        }
        return true;
    }
}

