/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.saveimage;

import com.ge.med.cse.cvf.saveimage.DicomDecorator;
import com.ge.med.cse.cvf.saveimage.XpDicomComposite;
import com.ge.med.cse.cvf.saveimage.XpFillSaveParameters;
import com.ge.med.cse.cvf.saveimage.XpSaveParameters;
import com.ge.med.cse.cvf.saveimage.XpSaveUtil;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XpSaveImage {
    private static final Logger logger = Logger.getLogger(XpSaveImage.class.getName());
    protected DicomComposite referenceComposite = null;
    protected DMSession outputDMSession = null;

    public void setReferenceDicomComposite(DicomComposite referenceComposite) {
        this.referenceComposite = referenceComposite;
    }

    public void setOutputSession(DMSession outputSession) {
        this.outputDMSession = outputSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveImage(SaveType saveType, ImageType type, XpSaveParameters saveParams) {
        XpDicomComposite composite = null;
        try {
            composite = this.createDicomComposite(type, saveParams);
            if (composite != null) {
                DMSession session = null;
                switch (saveType) {
                    case SaveToDB: {
                        session = this.outputDMSession != null ? this.outputDMSession : CvUtils.getDMSystem().getLocalDB();
                        break;
                    }
                    case SaveToFile: {
                        session = DMSession.getSession(new String[]{"file", XpSaveUtil.getFileSaveDirectory(saveParams.seriesUID)});
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Save Type not supported");
                    }
                }
                if (session == null) {
                    logger.log(Level.WARNING, "Unable to create DMSession for saving");
                    return false;
                }
                DMSession dMSession = session;
                synchronized (dMSession) {
                    session.install(composite.getInputStream(true, (String)this.referenceComposite.getValue(2, 16)));
                }
                return true;
            }
            logger.log(Level.WARNING, "Unable to create DicomComposite");
        }
        catch (Exception e2) {
            logger.log(Level.WARNING, "Unable to create/install DicomComposite");
            return false;
        }
        return false;
    }

    protected XpDicomComposite createDicomComposite(ImageType type, XpSaveParameters saveParams) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String dicomCompositeClassName = null;
        XpDicomComposite comp = null;
        switch (type) {
            case Reformat: {
                dicomCompositeClassName = CvPropertiesManager.getProperty("cvf.dicomComposite.default");
                comp = this.initializeDicomComposite(dicomCompositeClassName, saveParams);
                String modality = CvUtils.getModality(this.referenceComposite);
                if (modality != null && comp != null) {
                    if (modality.equalsIgnoreCase("CT")) {
                        DicomDecorator dc = (DicomDecorator)Class.forName(CvPropertiesManager.getProperty("cvf.dicomFiller.ct")).newInstance();
                        comp.setDecorator(dc);
                    } else if (modality.equalsIgnoreCase("MR")) {
                        DicomDecorator dc = (DicomDecorator)Class.forName(CvPropertiesManager.getProperty("cvf.dicomFiller.mr")).newInstance();
                        comp.setDecorator(dc);
                    }
                }
                return comp;
            }
            case SecondaryCapture: {
                dicomCompositeClassName = CvPropertiesManager.getProperty("cvf.dicomComposite.default");
                comp = this.initializeDicomComposite(dicomCompositeClassName, saveParams);
                DicomDecorator dc = (DicomDecorator)Class.forName(CvPropertiesManager.getProperty("cvf.dicomFiller.secondaryCapture")).newInstance();
                if (comp != null) {
                    comp.setDecorator(dc);
                }
                return comp;
            }
        }
        throw new IllegalArgumentException("Image type not supported");
    }

    private XpDicomComposite initializeDicomComposite(String className, XpSaveParameters saveParams) {
        XpDicomComposite dicomComposite = null;
        try {
            Class<?> dicomCompositeClass = Class.forName(className);
            Constructor<?> dicomCompositeCons = dicomCompositeClass.getConstructor(DicomComposite.class, XpSaveParameters.class);
            dicomComposite = (XpDicomComposite)dicomCompositeCons.newInstance(this.referenceComposite, saveParams);
        }
        catch (ClassNotFoundException e2) {
            logger.log(Level.WARNING, "Class " + className + " is not found." + e2.getLocalizedMessage());
        }
        catch (IllegalArgumentException e3) {
            logger.log(Level.WARNING, "Illegal arguments passed for creating Class " + className + " " + e3.getLocalizedMessage());
        }
        catch (InstantiationException e4) {
            logger.log(Level.WARNING, "Unable to instantiate Class " + className + " " + e4.getLocalizedMessage());
        }
        catch (IllegalAccessException e5) {
            logger.log(Level.WARNING, "Illegal access to constructor of Class " + className + " " + e5.getLocalizedMessage());
        }
        catch (InvocationTargetException e6) {
            logger.log(Level.WARNING, "Unable to invoke constructor of Class " + className + " " + e6.getLocalizedMessage());
        }
        catch (SecurityException e7) {
            logger.log(Level.WARNING, "Illegal access to constructor of Class " + className + " " + e7.getLocalizedMessage());
        }
        catch (NoSuchMethodException e8) {
            logger.log(Level.WARNING, "Unable to find constructor of Class " + className + " " + e8.getLocalizedMessage());
        }
        return dicomComposite;
    }

    public XpFillSaveParameters createFillSaveParameters(ImageType type, XpViewport viewport) {
        String fillSaveParametersClassName = null;
        switch (type) {
            case Reformat: {
                fillSaveParametersClassName = CvPropertiesManager.getProperty("cvf.fillSaveParameters.reformat");
                return this.initializeFillSaveParameters(fillSaveParametersClassName, viewport);
            }
            case SecondaryCapture: {
                fillSaveParametersClassName = CvPropertiesManager.getProperty("cvf.fillSaveParameters.secondaryCapture");
                return this.initializeFillSaveParameters(fillSaveParametersClassName, viewport);
            }
        }
        throw new IllegalArgumentException("Image type not supported");
    }

    private XpFillSaveParameters initializeFillSaveParameters(String className, XpViewport viewport) {
        XpFillSaveParameters fillSaveParameters = null;
        try {
            Class<?> fillSaveParametersClass = Class.forName(className);
            Constructor<?> fillSaveParametersCons = fillSaveParametersClass.getConstructor(XpViewport.class);
            fillSaveParameters = (XpFillSaveParameters)fillSaveParametersCons.newInstance(viewport);
        }
        catch (ClassNotFoundException e2) {
            logger.log(Level.WARNING, "Class " + className + " is not found." + e2.getLocalizedMessage());
        }
        catch (IllegalArgumentException e3) {
            logger.log(Level.WARNING, "Illegal arguments passed for creating Class " + className + " " + e3.getLocalizedMessage());
        }
        catch (InstantiationException e4) {
            logger.log(Level.WARNING, "Unable to instantiate Class " + className + " " + e4.getLocalizedMessage());
        }
        catch (IllegalAccessException e5) {
            logger.log(Level.WARNING, "Illegal access to constructor of Class " + className + " " + e5.getLocalizedMessage());
        }
        catch (InvocationTargetException e6) {
            logger.log(Level.WARNING, "Unable to invoke constructor of Class " + className + " " + e6.getLocalizedMessage());
        }
        catch (SecurityException e7) {
            logger.log(Level.WARNING, "Illegal access to constructor of Class " + className + " " + e7.getLocalizedMessage());
        }
        catch (NoSuchMethodException e8) {
            logger.log(Level.WARNING, "Unable to find constructor of Class " + className + " " + e8.getLocalizedMessage());
        }
        return fillSaveParameters;
    }

    public static enum SaveType {
        SaveToDB,
        SaveToFile;

    }

    public static enum ImageType {
        Reformat,
        SecondaryCapture;

    }
}

