/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.saveimage;

import com.ge.med.cse.cvf.saveimage.SaveDialog;
import com.ge.med.cse.cvf.saveimage.XpFillSaveParameters;
import com.ge.med.cse.cvf.saveimage.XpSaveImage;
import com.ge.med.cse.cvf.saveimage.XpSaveParameters;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.idc.XjDicomObject;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.DicomData;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class XpSaveUtil {
    private static final Logger logger = Logger.getLogger(XpSaveUtil.class.getName());
    public static final SimpleDateFormat DICOM_VR_DA_FORMAT = DicomData.DA_FORMAT_PARSE;
    public static final SimpleDateFormat DICOM_VR_TM_FORMAT = DicomData.TM_FORMAT_PARSE;
    private static Thread saveThread = null;

    public static void saveAsDicom(final XpViewport viewport) {
        final SaveDialog saveDialog = new SaveDialog(viewport, "Save Image As Dicom");
        saveDialog.addSaveActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                saveThread = new SaveThread(saveThread){

                    @Override
                    public void run() {
                        super.run();
                        saveDialog.setVisible(false);
                        XpSaveParameters params = new XpSaveParameters();
                        params.seriesDescription = saveDialog.getSeriesDescription();
                        boolean saveStatus = XpSaveUtil.saveFrame(viewport, params);
                        if (!saveStatus) {
                            logger.log(Level.WARNING, "Unable to save image as dicom.");
                        }
                        logger.log(Level.INFO, "Saving complete");
                    }
                };
                saveThread.setPriority(10);
                saveThread.start();
            }
        });
        saveDialog.setVisible(true);
    }

    public static void saveScreenAsDicom(final XPscreen screen) {
        final SaveDialog saveDialog = new SaveDialog(screen, "Save Screen As Dicom");
        saveDialog.addSaveActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                saveThread = new SaveThread(saveThread){

                    @Override
                    public void run() {
                        super.run();
                        saveDialog.setVisible(false);
                        XpSaveParameters params = new XpSaveParameters();
                        params.seriesDescription = saveDialog.getSeriesDescription();
                        XpSaveUtil.saveFrames(screen, params);
                        logger.log(Level.INFO, "Saving complete");
                    }
                };
                saveThread.setPriority(10);
                saveThread.start();
            }
        });
        saveDialog.setVisible(true);
    }

    public static void saveFrames(SelectionCapable frame, XpSaveParameters params) {
        SelectionCapable selcap = frame;
        for (int i2 = 0; i2 < selcap.getNumComponents(); ++i2) {
            JComponent port = selcap.getViewportComponent(i2);
            if (port instanceof SelectionCapable) {
                XpSaveUtil.saveFrames((SelectionCapable)((Object)port), params);
                continue;
            }
            if (!(port instanceof T3DViewport)) continue;
            params.image = null;
            params.imageNum = params.imageNum == -1 ? 1 : ++params.imageNum;
            boolean saveStatus = XpSaveUtil.saveFrame((T3DViewport)port, params);
            if (saveStatus) continue;
            logger.log(Level.WARNING, "Unable to save image as dicom.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveFrame(XpViewport vp, XpSaveParameters params) {
        if (vp == null) {
            logger.log(Level.WARNING, "XpViewport is null");
            return false;
        }
        T3DViewport t3dViewport = null;
        if (vp instanceof T3DViewport) {
            t3dViewport = (T3DViewport)vp;
        }
        if (t3dViewport == null || t3dViewport.getFrame() == null) {
            logger.log(Level.WARNING, "T3DViewport or its frame is null");
            return false;
        }
        DMSession osession = CvUtils.getDMSystem().getLocalDB();
        XjVolumeInfo volume = t3dViewport.getVolume();
        String renderStyle = t3dViewport.getRenderStyle();
        if (osession == null || volume == null || renderStyle == null) {
            logger.log(Level.WARNING, "DMSession or XjVolumeInfo or renderStyle is null");
            return false;
        }
        DicomComposite refComp = new DicomComposite();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(volume.getRelatedComposite());
            refComp.read(inStream);
        }
        catch (DMException ex) {
            logger.log(Level.WARNING, "Unable to read the DicomComposite file. " + ex.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARNING, "Unable to find DicomComposite file. " + ex.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e2) {
                    logger.log(Level.WARNING, "Unable to close the input stream. " + e2.getLocalizedMessage());
                    e2.printStackTrace();
                }
            }
        }
        String modality = CvUtils.getModality(refComp);
        XpSaveImage.ImageType imageType = null;
        int[] col = t3dViewport.getColorMap();
        if ("ct".equalsIgnoreCase(modality) && (renderStyle.equals("FULLBODY_MIP") || renderStyle.equals("FULLBODY_MINIP") || renderStyle.equals("FULLBODY_AVERAGE")) || renderStyle.equals("VOLUME") || col != null) {
            if (params.seriesNum == -1) {
                params.seriesNum = XpSaveUtil.findSeriesNumber(volume, osession, false, null);
            }
            imageType = XpSaveImage.ImageType.SecondaryCapture;
        } else {
            if (params.seriesNum == -1) {
                params.seriesNum = XpSaveUtil.findSeriesNumber(volume, osession, true, t3dViewport.getRenderStyle());
            }
            imageType = XpSaveImage.ImageType.Reformat;
        }
        return XpSaveUtil.doSave(XpSaveImage.SaveType.SaveToDB, imageType, t3dViewport, params);
    }

    public static boolean reformatSave(boolean saveToDB, boolean saveToFile, XpViewport vp, XpSaveParameters params) {
        if (vp == null) {
            logger.log(Level.WARNING, "XpViewport is null");
            return false;
        }
        T3DViewport t3dViewport = null;
        if (vp instanceof T3DViewport) {
            t3dViewport = (T3DViewport)vp;
        }
        if (t3dViewport == null || t3dViewport.getFrame() == null) {
            logger.log(Level.WARNING, "T3DViewport or its frame is null");
            return false;
        }
        DMSession osession = CvUtils.getDMSystem().getLocalDB();
        XjVolumeInfo volume = t3dViewport.getVolume();
        if (osession == null || volume == null) {
            logger.log(Level.WARNING, "DMSession or XjVolumeInfo or renderStyle is null");
            return false;
        }
        XpSaveImage.SaveType saveType = null;
        saveType = saveToDB ? XpSaveImage.SaveType.SaveToDB : XpSaveImage.SaveType.SaveToFile;
        return XpSaveUtil.doSave(saveType, XpSaveImage.ImageType.Reformat, t3dViewport, params);
    }

    public static boolean secondarySave(XpViewport vp) {
        if (vp == null) {
            logger.log(Level.WARNING, "XpViewport is null");
            return false;
        }
        T3DViewport t3dViewport = null;
        if (vp instanceof T3DViewport) {
            t3dViewport = (T3DViewport)vp;
        }
        if (t3dViewport == null || t3dViewport.getFrame() == null) {
            logger.log(Level.WARNING, "T3DViewport or its frame is null");
            return false;
        }
        DMSession osession = CvUtils.getDMSystem().getLocalDB();
        XjVolumeInfo volume = t3dViewport.getVolume();
        if (osession == null || volume == null) {
            logger.log(Level.WARNING, "DMSession or XjVolumeInfo or renderStyle is null");
            return false;
        }
        XpSaveParameters params = new XpSaveParameters();
        params.seriesNum = XpSaveUtil.findSeriesNumber(volume, osession, false, null);
        return XpSaveUtil.doSave(XpSaveImage.SaveType.SaveToDB, XpSaveImage.ImageType.SecondaryCapture, t3dViewport, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doSave(XpSaveImage.SaveType saveType, XpSaveImage.ImageType imageType, T3DViewport t3dViewport, XpSaveParameters params) {
        XjVolumeInfo volume = t3dViewport.getVolume();
        if (volume == null) {
            logger.log(Level.WARNING, "DMSession or XjVolumeInfo is null");
            return false;
        }
        DicomComposite refComp = new DicomComposite();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(volume.getRelatedComposite());
            refComp.read(inStream);
        }
        catch (DMException ex) {
            logger.log(Level.WARNING, "Unable to read the DicomComposite file. " + ex.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARNING, "Unable to find DicomComposite file. " + ex.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    logger.log(Level.WARNING, "Unable to close the input stream " + e2.getLocalizedMessage());
                }
            }
        }
        XpSaveImage save = new XpSaveImage();
        save.setReferenceDicomComposite(refComp);
        XpFillSaveParameters fillSaveParameters = save.createFillSaveParameters(imageType, t3dViewport);
        if (fillSaveParameters != null) {
            boolean fillStatus = fillSaveParameters.fillSaveParameters(params);
            if (!fillStatus) {
                logger.log(Level.WARNING, "Unable to fill the save parameters.");
                return false;
            }
        } else {
            logger.log(Level.WARNING, "Unable to fill the save parameters.");
            return false;
        }
        boolean saveStatus = save.saveImage(saveType, imageType, params);
        if (!saveStatus) {
            logger.log(Level.WARNING, "Unable to save the image.");
            return false;
        }
        return true;
    }

    public static void saveAsSeries(final XpViewport viewport) {
        final SaveDialog saveDialog = new SaveDialog(viewport, "Save Images As Series");
        saveDialog.addSaveActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                saveThread = new SaveThread(saveThread){

                    @Override
                    public void run() {
                        super.run();
                        saveDialog.setVisible(false);
                        boolean saveStatus = XpSaveUtil.saveAsSeries(viewport, saveDialog.getSeriesDescription());
                        if (!saveStatus) {
                            logger.log(Level.WARNING, "Unable to save images as Series.");
                        }
                        logger.log(Level.INFO, "Saving complete");
                    }
                };
                saveThread.setPriority(10);
                saveThread.start();
            }
        });
        saveDialog.setVisible(true);
    }

    private static boolean saveAsSeries(XpViewport vp, String serDesc) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveFrame(boolean saveToDB, boolean saveToFile, XjVolumeInfo volume, XpSaveParameters params, DMSession outputSession) {
        if (volume == null) {
            logger.log(Level.WARNING, "Volume is null");
            return false;
        }
        DicomComposite refComp = new DicomComposite();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(volume.getRelatedComposite());
            refComp.read(inStream);
        }
        catch (DMException ex) {
            logger.log(Level.WARNING, "Unable to read the DicomComposite file. " + ex.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARNING, "Unable to find DicomComposite file. " + ex.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        return XpSaveUtil.saveFrame(saveToDB, saveToFile, refComp, params, outputSession);
    }

    public static boolean saveFrame(boolean saveToDB, boolean saveToFile, DicomComposite refComp, XpSaveParameters params, DMSession outputSession) {
        if (refComp == null) {
            logger.log(Level.WARNING, "Reference composite is null");
            return false;
        }
        params.seriesDate = new Date().getTime();
        if (params.renderStyle.equals("FULLBODY_MIP") || params.renderStyle.equals("FULLBODY_MINIP") || params.renderStyle.equals("FULLBODY_AVERAGE")) {
            XpDicomElement orientationElem = new XpDicomElement(32, 55);
            orientationElem.value = refComp.getString(orientationElem.group, orientationElem.element);
            double[] orientationValues = orientationElem.getDoubleArrayValue();
            params.inputSliceI = new JnVector3d(-orientationValues[0], -orientationValues[1], orientationValues[2]).normalize();
            params.inputSliceJ = new JnVector3d(-orientationValues[3], -orientationValues[4], orientationValues[5]).normalize();
            params.inputSliceN = JnVector3d.cross(params.inputSliceI, params.inputSliceJ);
        }
        XpSaveImage save = new XpSaveImage();
        save.setReferenceDicomComposite(refComp);
        save.setOutputSession(outputSession);
        XpSaveImage.SaveType saveType = null;
        saveType = saveToDB ? XpSaveImage.SaveType.SaveToDB : XpSaveImage.SaveType.SaveToFile;
        boolean saveStatus = save.saveImage(saveType, XpSaveImage.ImageType.Reformat, params);
        if (!saveStatus) {
            logger.log(Level.WARNING, "Unable to save the image.");
            return false;
        }
        return true;
    }

    public static String getFileSaveDirectory(String seriesUID) {
        return System.getProperty("java.io.tmpdir") + File.separator + "Reformats_" + seriesUID;
    }

    public static String newInstanceUid() {
        UidGenerator uidGen = new UidGenerator();
        uidGen.setBH(CvPropertiesManager.getProperty("SYSTEM_IMPLEMENTATION_UID_PREFIX", uidGen.getBH()));
        return uidGen.newUID();
    }

    public static int findNextAvailableSeriesNumber(DMSession session, String examUID, int rangeBegin, int rangeEnd) {
        if (session == null || examUID == null) {
            throw new IllegalArgumentException("Session or examUID was null");
        }
        DMObject[] exams = session.getRelated("study", new DMQuery("(0x0020, 0x000D) = " + examUID));
        TreeSet<Integer> seriesNums = new TreeSet<Integer>();
        for (int i2 = 0; i2 < exams.length; ++i2) {
            DMObject[] series = exams[i2].getRelated("series");
            for (int j2 = 0; j2 < series.length; ++j2) {
                Integer seriesNum;
                Object seriesNumObj = series[j2].getValue(32, 17);
                if (seriesNumObj == null || (seriesNum = seriesNumObj instanceof Integer ? (Integer)seriesNumObj : new Integer(seriesNumObj.toString().trim())) < rangeBegin || seriesNum > rangeEnd) continue;
                seriesNums.add(seriesNum);
            }
        }
        int seriesNum = rangeBegin;
        Iterator itr = seriesNums.iterator();
        while (itr.hasNext()) {
            int nextInt = (Integer)itr.next();
            if (seriesNum < nextInt) {
                return seriesNum;
            }
            seriesNum = nextInt + 1;
        }
        if (seriesNum > rangeEnd) {
            return rangeEnd;
        }
        return seriesNum;
    }

    public static int findNextAvailableSeriesNumberByType(DMSession session, String examUID, int rangeBegin, int rangeEnd, String imageType) {
        if (session == null || examUID == null) {
            throw new IllegalArgumentException("Session or examUID was null");
        }
        DMObject[] exams = session.getRelated("study", new DMQuery("(0x0020, 0x000D) = " + examUID));
        TreeSet<Integer> seriesNums = new TreeSet<Integer>();
        for (int i2 = 0; i2 < exams.length; ++i2) {
            DMObject[] series = exams[i2].getRelated("series");
            for (int j2 = 0; j2 < series.length; ++j2) {
                Integer seriesNum;
                String type = DicomUtils.getImageType(series[j2], true);
                Object seriesNumObj = series[j2].getValue(32, 17);
                if (seriesNumObj == null || (seriesNum = seriesNumObj instanceof Integer ? (Integer)seriesNumObj : new Integer(seriesNumObj.toString().trim())) < rangeBegin || seriesNum > rangeEnd) continue;
                if (type != null && type.equalsIgnoreCase(imageType)) {
                    return seriesNum;
                }
                seriesNums.add(seriesNum);
            }
        }
        int seriesNum = rangeBegin;
        Iterator itr = seriesNums.iterator();
        while (itr.hasNext()) {
            int nextInt = (Integer)itr.next();
            if (seriesNum < nextInt) {
                return seriesNum;
            }
            seriesNum = nextInt + 1;
        }
        if (seriesNum > rangeEnd) {
            return rangeEnd;
        }
        return seriesNum;
    }

    public static String getSeriesUID(String examUID, int seriesNumber, DMSession session) {
        if (examUID == null || session == null) {
            throw new IllegalArgumentException("Session or examUID was null");
        }
        DMObject[] series = session.getRelated("study", new DMQuery("(0x0020, 0x000D) = " + examUID + " AND (0x0020, 0x0011) = " + seriesNumber));
        if (series == null || series.length == 0) {
            return XpSaveUtil.newInstanceUid();
        }
        String serUID = (String)series[0].getValue(32, 14);
        if (serUID == null) {
            serUID = XpSaveUtil.newInstanceUid();
        }
        return serUID;
    }

    public static double[] getDoubleArrayValue(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, "\\");
        double[] doubleArray = new double[tokenizer.countTokens()];
        for (int i2 = 0; i2 < doubleArray.length; ++i2) {
            doubleArray[i2] = Double.parseDouble(tokenizer.nextToken());
        }
        return doubleArray;
    }

    public static int getBitsPerPix(DMComposite image) {
        int bitsPerPix = 0;
        String imgType = ((String)image.getValue(40, 4)).trim();
        if (imgType.equals("MONOCHROME2") || imgType.equals("MONOCHROME1")) {
            bitsPerPix = (Integer)image.getValue(40, 256) == 16 ? 16 : 8;
        } else if (imgType.equals("RGB")) {
            bitsPerPix = 24;
        } else if (imgType.equals("PALETTE COLOR")) {
            bitsPerPix = (Integer)image.getValue(40, 256) == 16 ? 16 : 8;
        }
        return bitsPerPix;
    }

    public static int nextSeriesNumber(XjDicomObject refImage, DMSession session) {
        String examUID = (String)refImage.getValue(32, 13);
        Object seriesNumObj = refImage.getValue(32, 17);
        int se_no = 1;
        if (seriesNumObj != null) {
            se_no = seriesNumObj instanceof Integer ? (Integer)seriesNumObj : Integer.parseInt(seriesNumObj.toString().trim());
        }
        int minSeriesNum = se_no >= 100 ? se_no + 1 : se_no * 100;
        int maxSeriesNum = minSeriesNum - minSeriesNum % 100 + 99;
        return XpSaveUtil.findNextAvailableSeriesNumber(session, examUID, minSeriesNum, maxSeriesNum);
    }

    public static int findSeriesNumber(XjDicomObject refImage, DMSession session, boolean newSeries, String renderStyle) {
        if (newSeries) {
            return XpSaveUtil.nextSeriesNumber(refImage, session);
        }
        String examUID = (String)refImage.getValue(32, 13);
        Object seriesNumObj = refImage.getValue(32, 17);
        int se_no = seriesNumObj instanceof Integer ? (Integer)seriesNumObj : Integer.parseInt(seriesNumObj.toString().trim());
        int minSeriesNum = se_no >= 100 ? se_no + 1 : se_no * 100;
        int maxSeriesNum = minSeriesNum - minSeriesNum % 100 + 99;
        if (renderStyle == null) {
            return XpSaveUtil.findNextAvailableSeriesNumberByType(session, examUID, minSeriesNum, maxSeriesNum, "SSAVE");
        }
        String modality = (String)refImage.getValue(8, 96);
        if ("ct".equalsIgnoreCase(modality) && (renderStyle.equals("FULLBODY_MIP") || renderStyle.equals("FULLBODY_MINIP") || renderStyle.equals("FULLBODY_AVERAGE")) || renderStyle.equals("VOLUME")) {
            return XpSaveUtil.findNextAvailableSeriesNumberByType(session, examUID, minSeriesNum, maxSeriesNum, "SSAVE");
        }
        if ("mr".equalsIgnoreCase(modality) && (renderStyle.equals("FULLBODY_MIP") || renderStyle.equals("FULLBODY_MINIP") || renderStyle.equals("FULLBODY_AVERAGE"))) {
            return XpSaveUtil.findNextAvailableSeriesNumberByType(session, examUID, minSeriesNum, maxSeriesNum, "PJN");
        }
        return XpSaveUtil.findNextAvailableSeriesNumberByType(session, examUID, minSeriesNum, maxSeriesNum, "REFMT");
    }

    private static class SaveThread
    extends Thread {
        private Thread prev;

        public SaveThread(Thread prev) {
            this.prev = prev;
        }

        @Override
        public void run() {
            if (this.prev != null && this.prev.isAlive()) {
                logger.log(Level.INFO, "Waiting for saving image processing thread to terminate");
                this.prev.interrupt();
                logger.log(Level.INFO, "Done");
            }
        }
    }
}

