/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.screenbuilder;

import com.ge.med.cse.cvf.screenbuilder.PortLoaderBase;
import com.ge.med.cse.cvf.screenbuilder.PropertyPortState;
import com.ge.med.cse.cvf.screenbuilder.helper.Helper;
import com.ge.med.terra.xpv.base.XPscreen;
import java.util.Properties;
import javax.swing.JComponent;

public class HelperPortLoader
implements PortLoaderBase {
    private static final String HelperPackageName = Helper.class.getPackage().getName() + ".";
    private static ClassLoader cl = ClassLoader.getSystemClassLoader();
    private static final String HELPERS = ".helpers";
    private static final String LABEL = ".label";
    private static final String PORT_CLASS = ".portClass";

    private Helper getHelper(String name) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        String className = name.indexOf(46) < 0 ? HelperPackageName + name : name;
        Class<?> c2 = Class.forName(className, false, cl);
        return (Helper)c2.newInstance();
    }

    @Override
    public JComponent loadPort(String name, Properties prop) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        JComponent comp = null;
        String type = prop.getProperty(name + PORT_CLASS);
        if (type != null) {
            Class<?> c2 = Class.forName(type, false, cl);
            comp = (JComponent)c2.newInstance();
            String label = prop.getProperty(name + LABEL);
            comp.setName(label);
        } else {
            comp = new XPscreen.EmptyPort();
        }
        String helperLst = prop.getProperty(name + HELPERS);
        if (helperLst != null) {
            String[] helpers = helperLst.split(",");
            for (int i2 = 0; i2 < helpers.length; ++i2) {
                Helper hlp = this.getHelper(helpers[i2]);
                if (comp instanceof PropertyPortState) {
                    ((PropertyPortState)((Object)comp)).addHelper(hlp);
                }
                try {
                    hlp.config(comp, name, prop);
                    continue;
                }
                catch (Exception e2) {
                    InstantiationException e22 = new InstantiationException("Failed to configure port " + name + " with helper " + helpers[i2]);
                    e22.initCause(e2);
                    throw e22;
                }
            }
        }
        return comp;
    }
}

