/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.screenbuilder;

import com.ge.med.cse.cvf.screenbuilder.LayoutGenerator;
import com.ge.med.terra.xpv.base.XPscreenLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.StringTokenizer;

public class MultiMonLayout
extends XPscreenLayout {
    static final String DELIM = "X";
    private static GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
    private Section[] sect;
    private boolean stretchLast;

    public MultiMonLayout(String str) {
        super(MultiMonLayout.stripDelim(str));
        String[] monLayout = str.split(DELIM);
        this.sect = new Section[monLayout.length];
        for (int m2 = 0; m2 < monLayout.length; ++m2) {
            this.sect[m2] = new Section(monLayout[m2]);
        }
        this.stretchLast = !str.endsWith(DELIM);
    }

    private static String stripDelim(String orig) {
        String[] parts = orig.split(DELIM);
        if (parts.length == 1) {
            return parts[0];
        }
        StringBuffer res = new StringBuffer(orig.length());
        for (int i2 = 0; i2 < parts.length; ++i2) {
            int offset = i2 * 10000 / parts.length;
            StringTokenizer st = new StringTokenizer(parts[i2], "][");
            while (st.hasMoreTokens()) {
                String[] dim = st.nextToken().split(",");
                res.append("[");
                res.append(offset + Integer.parseInt(dim[0]) / parts.length);
                res.append("," + dim[1] + ",");
                res.append(Integer.parseInt(dim[2]) / parts.length);
                res.append("," + dim[3] + "]");
            }
        }
        return res.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        if (!parent.isShowing() || !parent.isVisible()) {
            return;
        }
        Object object = parent.getTreeLock();
        synchronized (object) {
            int monUsed = 0;
            Dimension size = parent.getSize();
            Component[] children = parent.getComponents();
            Point loc = parent.getLocationOnScreen();
            Rectangle win = parent.getBounds();
            win.x = loc.x;
            win.y = loc.y;
            GraphicsDevice[] gDevs = ge.getScreenDevices();
            int[] parts = new int[gDevs.length];
            int[] offsets = new int[gDevs.length];
            for (int i2 = 0; i2 < gDevs.length; ++i2) {
                Rectangle monR = gDevs[i2].getDefaultConfiguration().getBounds();
                Rectangle partR = win.intersection(monR);
                if (partR.isEmpty()) continue;
                parts[monUsed] = partR.width;
                offsets[monUsed] = Math.max(0, partR.x - win.x);
                ++monUsed;
            }
            int child = 0;
            int offset = 0;
            int section = 0;
            for (int mon = 0; mon < monUsed; ++mon) {
                int setcsInMon = this.sect.length / monUsed;
                if (mon < this.sect.length % monUsed) {
                    ++setcsInMon;
                }
                offset = offsets[mon];
                for (int s2 = 0; s2 < setcsInMon; ++s2) {
                    Rectangle[] rects = this.sect[section++].portDim;
                    for (int i3 = 0; i3 < rects.length && child < children.length; ++i3) {
                        try {
                            children[child].setVisible(true);
                            double ratio = this.stretchLast && section == this.sect.length ? (double)(win.width - offset) / 10000.0 : (double)parts[mon] / (double)setcsInMon / 10000.0;
                            children[child++].setBounds(new Rectangle((int)((double)offset + (double)rects[i3].x * ratio), rects[i3].y * size.height / 10000, (int)((double)rects[i3].width * ratio), rects[i3].height * size.height / 10000));
                            continue;
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                    offset += parts[mon] / setcsInMon;
                }
            }
            while (child < children.length) {
                children[child].setVisible(false);
                ++child;
            }
        }
    }

    static class Generator
    extends LayoutGenerator {
        Generator() {
        }

        @Override
        public XPscreenLayout build(String layoutStr) {
            return new MultiMonLayout(layoutStr);
        }
    }

    private static class Section {
        Rectangle[] portDim;

        public Section(String str) {
            StringTokenizer st = new StringTokenizer(str, "][");
            this.portDim = new Rectangle[st.countTokens()];
            int i2 = 0;
            while (st.hasMoreElements()) {
                String[] pos = st.nextToken().split(",");
                this.portDim[i2++] = new Rectangle(Integer.parseInt(pos[0]), Integer.parseInt(pos[1]), Integer.parseInt(pos[2]), Integer.parseInt(pos[3]));
            }
        }
    }
}

