/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.screenbuilder;

import com.ge.med.cse.cvf.j3d.J3DPortLinkingManager;
import com.ge.med.cse.cvf.screenbuilder.VScreen;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.base.XPscreenLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JComponent;

public class ScreenLoader {
    public static final String SCREEN_DISPLAYED = "ScreenDisplayed";
    public static final String FULL_SCREEN_PROP = "FullScreenChanged";
    public static final String SCREEN_ADDED = "SCREEN_ADDED";
    public static final String SCREEN_REMOVED = "SCREEN_REMOVED";
    public static final String INPUT_SCREEN_ADDED = "INPUT_SCREEN_ADDED";
    public static final String INPUT_SCREEN_REMOVED = "INPUT_SCREEN_REMOVED";
    public static final String SCREENS = "screens";
    private final FullScreenPortState originalPortState = new FullScreenPortState();
    protected XPscreen scrn;
    protected Properties prop;
    protected String[] vscreenNames;
    protected Hashtable<String, VScreen> vscreens = new Hashtable<String, VScreen>(){

        @Override
        public synchronized VScreen put(String key, VScreen value) {
            VScreen screen = super.put(key, value);
            ScreenLoader.this.propMgr.firePropertyChange(ScreenLoader.SCREEN_ADDED, null, value);
            return screen;
        }

        @Override
        public synchronized VScreen remove(Object key) {
            VScreen screen = (VScreen)super.remove(key);
            ScreenLoader.this.propMgr.firePropertyChange(ScreenLoader.SCREEN_REMOVED, null, screen);
            return screen;
        }
    };
    protected Hashtable<String, JComponent> ports = new Hashtable(20);
    protected VScreen currentScreen = null;
    protected PropertyChangeSupport propMgr = new PropertyChangeSupport(this);
    private boolean fullScreenMode = false;
    private J3DPortLinkingManager linkportmgr = null;
    PropertyChangeListener fullScreenListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue().toString().equals("true")) {
                if (!ScreenLoader.this.fullScreenMode && ScreenLoader.this.currentScreen != null) {
                    ((ScreenLoader)ScreenLoader.this).originalPortState.port = ScreenLoader.this.scrn.getSelectedPort();
                    ((ScreenLoader)ScreenLoader.this).originalPortState.selectionIndex = ScreenLoader.this.scrn.getSelectedPortNumber();
                    ScreenLoader.this.scrn.clearScreen();
                    ScreenLoader.this.scrn.setLayout(XPscreenLayout.layout1x1());
                    ScreenLoader.this.scrn.addPort(((ScreenLoader)ScreenLoader.this).originalPortState.port, 0);
                    ScreenLoader.this.scrn.setSelectedPortNumber(0);
                    ScreenLoader.this.scrn.updateSelection();
                    ScreenLoader.this.fullScreenMode = true;
                }
            } else if (ScreenLoader.this.fullScreenMode) {
                ScreenLoader.this.currentScreen.restoreLayout();
                ScreenLoader.this.currentScreen.display(ScreenLoader.this.scrn);
                ScreenLoader.this.scrn.setSelectedPortNumber(((ScreenLoader)ScreenLoader.this).originalPortState.selectionIndex);
                ScreenLoader.this.scrn.updateSelection();
                for (JComponent comp : ScreenLoader.this.currentScreen.getPorts()) {
                    if (comp instanceof XpViewport) {
                        ((XpViewport)comp).refreshContents();
                    }
                    comp.revalidate();
                }
                ScreenLoader.this.fullScreenMode = false;
            }
        }
    };

    public ScreenLoader(XPscreen scrn, Properties prop) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.scrn = scrn;
        this.prop = prop;
        String screens = prop.getProperty(SCREENS);
        if (screens == null) {
            throw new InstantiationException("no screens defined in property file");
        }
        this.vscreenNames = screens.split(",");
        scrn.addPropertyChangeListener(FULL_SCREEN_PROP, this.fullScreenListener);
    }

    public void showScreen(String name) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (!this.vscreens.containsKey(name)) {
            for (int i2 = 0; i2 < this.vscreenNames.length; ++i2) {
                if (!name.equalsIgnoreCase(this.vscreenNames[i2])) continue;
                this.vscreens.put(this.vscreenNames[i2], new VScreen(this.vscreenNames[i2], this.prop, this.ports));
            }
        }
        this.showScreen(this.vscreens.get(name));
    }

    public void showScreen(VScreen screen) throws ClassNotFoundException {
        if (screen == null) {
            throw new IllegalArgumentException("Screen does not exist");
        }
        if (screen != this.currentScreen) {
            if (this.fullScreenMode) {
                ScreenLoader.setFullScreenMode(false, this.scrn);
            }
            VScreen oldScreen = this.currentScreen;
            this.currentScreen = screen;
            if (this.linkportmgr == null) {
                this.linkportmgr = J3DPortLinkingManager.getInstance();
                this.linkportmgr.setScreenLoader(this);
            }
            this.linkportmgr.setPortsLinked(false);
            this.linkportmgr.setPermanentPortsLinked(false);
            this.currentScreen.display(this.scrn);
            this.linkportmgr.setPermanentPortsLinked(true);
            this.propMgr.firePropertyChange(SCREEN_DISPLAYED, oldScreen != null ? oldScreen.getName() : "", screen.getName());
        }
    }

    public void clearScreen() {
        if (this.fullScreenMode) {
            ScreenLoader.setFullScreenMode(false, this.scrn);
        }
        this.currentScreen = null;
        this.scrn.clearScreen();
        this.scrn.setName("");
        this.propMgr.firePropertyChange(SCREEN_DISPLAYED, this.currentScreen != null ? this.currentScreen.getName() : "", "");
    }

    public String[] getScreenDisplayNames() {
        return this.vscreenNames;
    }

    public String getScreenDisplayName(String name) {
        return this.getScreen(name).getDisplayName();
    }

    public VScreen getScreen(String name) {
        VScreen vscr = this.vscreens.get(name);
        if (vscr == null) {
            throw new IllegalArgumentException("Screen [" + name + "] does not exists");
        }
        return vscr;
    }

    public VScreen getVScreen() {
        return this.currentScreen;
    }

    public Collection<VScreen> getScreens() {
        return this.vscreens.values();
    }

    public XPscreen getScreen() {
        return this.scrn;
    }

    public XPscreen getSelectedXPscreen() {
        return this.getComponentScreen(this.scrn.getSelectedPort());
    }

    public Icon getScreenIcon(String name) {
        VScreen vscr = this.vscreens.get(name);
        if (vscr == null) {
            throw new IllegalArgumentException("Screen [" + name + "] does not exists");
        }
        return vscr.getOriginalLayout();
    }

    public static void setFullScreenMode(boolean fullscreen, XPscreen screen) {
        screen.firePropertyChange(FULL_SCREEN_PROP, !fullscreen, fullscreen);
    }

    public XPscreen getComponentScreen(JComponent comp) {
        Container cont;
        for (cont = comp.getParent(); cont != null && !(cont instanceof XPscreen); cont = cont.getParent()) {
        }
        return (XPscreen)cont;
    }

    public boolean isFullScreenMode() {
        return this.fullScreenMode;
    }

    public boolean isDisplayNamePresent(String displayName) {
        Iterator<VScreen> itr = this.vscreens.values().iterator();
        while (itr.hasNext()) {
            if (!itr.next().getDisplayName().equalsIgnoreCase(displayName)) continue;
            return true;
        }
        return false;
    }

    public void removeScreen(VScreen screen) {
        this.vscreens.remove(screen.getName());
    }

    public void addPropertyChangeListener(String prop, PropertyChangeListener l2) {
        this.propMgr.addPropertyChangeListener(prop, l2);
    }

    public void addPropertyChangeListener(PropertyChangeListener l2) {
        this.propMgr.addPropertyChangeListener(l2);
    }

    public void removePropertyChangeListener(String prop, PropertyChangeListener l2) {
        this.propMgr.removePropertyChangeListener(prop, l2);
    }

    public void removePropertyChangeListener(PropertyChangeListener l2) {
        this.propMgr.removePropertyChangeListener(l2);
    }

    public void dispose() {
        this.clearScreen();
        for (VScreen vscreen : this.getScreens()) {
            vscreen.dispose();
        }
        this.vscreens.clear();
        this.vscreens = null;
        this.ports.clear();
        this.ports = null;
        this.originalPortState.dispose();
        this.scrn.removePropertyChangeListener(this.fullScreenListener);
        this.scrn = null;
        this.fullScreenMode = false;
        this.prop.clear();
        this.prop = null;
        this.vscreenNames = null;
        this.currentScreen = null;
        PropertyChangeListener[] lsnrs = this.propMgr.getPropertyChangeListeners();
        int n2 = lsnrs.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.propMgr.removePropertyChangeListener(lsnrs[i2]);
        }
        this.propMgr = null;
    }

    private static class FullScreenPortState {
        Dimension gridSize = null;
        int selectionIndex = 0;
        JComponent port = null;

        private FullScreenPortState() {
        }

        public void dispose() {
            this.gridSize = null;
            this.selectionIndex = 0;
            this.port = null;
        }
    }
}

