/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.screenbuilder;

import com.ge.med.cse.cvf.appframework.ContextProvider;
import com.ge.med.cse.cvf.appframework.DataContext;
import com.ge.med.cse.cvf.screenbuilder.HelperPortLoader;
import com.ge.med.cse.cvf.screenbuilder.LayoutGenerator;
import com.ge.med.cse.cvf.screenbuilder.PortLoaderBase;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.base.XPscreenLayout;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JComponent;

public class VScreen {
    public static final String DISPLAY_NAME_PROP = ".displayName";
    public static final String SCREEN_PROP = "screen.";
    public static final String PORTS_PROP = ".ports";
    public static final String LAYOUT_PROP = ".layout";
    public static final String CUSTOM = ".custom";
    private static final String SCREENS = "screens";
    private static final String LAYOUT_GENERATOR = ".layoutGenerator";
    private static final String COMMA = ",";
    private static final String DATASETS = ".datasets";
    private static LayoutGenerator lg = null;
    private final String name;
    private String displayName;
    private final XPscreenLayout origLayout;
    private XPscreenLayout layout = null;
    private final JComponent[] origPorts;
    private JComponent[] ports = null;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public VScreen(String name, Properties prop, Hashtable<String, JComponent> portMap) throws InstantiationException, ClassNotFoundException, IllegalAccessException {
        String layoutStr;
        this.name = name;
        if (lg == null) {
            Class<?> lc;
            String lgClassName = prop.getProperty("screens.layoutGenerator");
            if (lgClassName != null) {
                lc = Class.forName(lgClassName, false, ClassLoader.getSystemClassLoader());
                lg = (LayoutGenerator)lc.newInstance();
            } else {
                lgClassName = prop.getProperty("screens.layoutGenerator");
                if (lgClassName != null) {
                    lc = Class.forName(lgClassName, false, ClassLoader.getSystemClassLoader());
                    lg = (LayoutGenerator)lc.newInstance();
                } else {
                    lg = new LayoutGenerator();
                }
            }
        }
        String datasets = prop.getProperty(SCREEN_PROP + name + DATASETS);
        StringTokenizer tokenizer = new StringTokenizer(datasets, COMMA);
        String appId = System.getProperty("APP_IDENTIFIER");
        DataContext dataContext = ContextProvider.getDataContext(appId);
        while (tokenizer.hasMoreTokens()) {
            dataContext.addDatasetForScreen(name, tokenizer.nextToken());
        }
        this.displayName = prop.getProperty(SCREEN_PROP + name + DISPLAY_NAME_PROP);
        if (this.displayName == null) {
            this.displayName = prop.getProperty(SCREEN_PROP + name + DISPLAY_NAME_PROP);
        }
        if ((layoutStr = prop.getProperty(SCREEN_PROP + name + LAYOUT_PROP)) == null && (layoutStr = prop.getProperty(SCREEN_PROP + name + LAYOUT_PROP)) == null) {
            throw new InstantiationException("Screen " + name + " has no layout in the property file");
        }
        this.layout = this.origLayout = lg.build(layoutStr);
        String portNames = prop.getProperty(SCREEN_PROP + name + PORTS_PROP);
        if (portNames == null && (portNames = prop.getProperty(SCREEN_PROP + name + PORTS_PROP)) == null) {
            throw new InstantiationException("Screen " + name + " has no defined ports in the property file");
        }
        String[] names = portNames.split(COMMA);
        this.origPorts = new JComponent[names.length];
        for (int i2 = 0; i2 < names.length; ++i2) {
            JComponent comp = names[i2].length() == 0 || names[i2].equalsIgnoreCase("Empty") ? new XPscreen.EmptyPort() : portMap.get(names[i2]);
            if (comp == null) {
                PortLoaderBase pl;
                String loaderName = prop.getProperty(names[i2] + ".loader");
                if (loaderName == null) {
                    pl = new HelperPortLoader();
                } else {
                    Class<?> lc = Class.forName(loaderName, false, ClassLoader.getSystemClassLoader());
                    pl = (PortLoaderBase)lc.newInstance();
                }
                comp = pl.loadPort(names[i2], prop);
                portMap.put(names[i2], comp);
            }
            this.origPorts[i2] = comp;
        }
        this.ports = this.origPorts;
    }

    public VScreen(String name, String displayName, XPscreenLayout screenLayout, JComponent[] ports) {
        this.name = name;
        this.displayName = displayName;
        this.origLayout = this.layout = screenLayout;
        this.ports = ports;
        this.origPorts = ports;
    }

    public void display(XPscreen xpscrn) {
        xpscrn.clearScreen();
        xpscrn.setName(this.name);
        if (this.layout != null) {
            xpscrn.setLayout(this.layout);
        }
        for (int i2 = 0; i2 < this.ports.length; ++i2) {
            xpscrn.addPort(this.ports[i2], i2);
        }
        if (this.ports.length == 1) {
            xpscrn.setSelectedPortNumber(-1);
        }
        xpscrn.setSelectedPortNumber(0);
        if (this.ports.length >= 1 && this.ports[0] != null && this.ports[0] instanceof SelectionCapable) {
            ((SelectionCapable)((Object)this.ports[0])).setComponentSelection(0);
        }
        xpscrn.updateSelection();
    }

    public void restoreLayout() {
        this.layout = this.origLayout;
        this.ports = this.origPorts;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public XPscreenLayout getOriginalLayout() {
        return this.origLayout;
    }

    public XPscreenLayout getLayout() {
        return this.layout;
    }

    public JComponent[] getPorts() {
        return this.ports;
    }

    public static String getScreenDisplayName(Properties props, String vscreenName) {
        return props.getProperty(SCREEN_PROP + vscreenName + DISPLAY_NAME_PROP);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void dispose() {
        for (int i2 = 0; this.ports != null && i2 < this.ports.length; ++i2) {
            if (!(this.ports[i2] instanceof T3DViewport)) continue;
            ((T3DViewport)this.ports[i2]).dispose();
        }
        lg = null;
        this.displayName = null;
        this.layout = null;
        this.ports = null;
        PropertyChangeListener[] lsnrs = this.pcs.getPropertyChangeListeners();
        int n2 = lsnrs.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            this.pcs.removePropertyChangeListener(lsnrs[i3]);
        }
        this.pcs = null;
    }
}

