/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.screenbuilder.helper;

import com.ge.med.cse.cvf.screenbuilder.helper.Helper;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.ActiveAnnotationCapable;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.xpv.ui.ActiveAnnotationControl;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;

public class ActiveAnnotationHelper
implements Helper {
    private static final Logger logger = Logger.getLogger(ActiveAnnotationHelper.class.getName());
    private static final String ACTIVEANNOTATION = "ActiveAnnotation";
    private static final String ACTIVEANNOTATION_ITEMS = "ActiveAnnotation.items";

    @Override
    public void config(JComponent port, String propName, Properties prop) throws Exception {
        if (port == null || propName == null || propName == "" || prop == null) {
            logger.log(Level.WARNING, "Either viewport or property name or property is null");
            throw new Exception("Either viewport or property name or property is null");
        }
        if (port instanceof XpViewport) {
            this.configActiveAnnotations((XpViewport)port, propName, prop);
        } else {
            logger.log(Level.INFO, "port is not instance of XpViewport.");
        }
    }

    private void configActiveAnnotations(XpViewport viewport, String propname, Properties prop) {
        ActiveAnnotationCapable aaCap = null;
        if (viewport instanceof ActiveAnnotationCapable) {
            aaCap = (ActiveAnnotationCapable)((Object)viewport.getCapable(ActiveAnnotationCapable.class.getName()));
        }
        if (aaCap == null) {
            logger.log(Level.INFO, "Unable to configure active annotation controls to viewport, as it is not active annotation capable");
            return;
        }
        aaCap.clearActiveAnnotationListeners();
        String[] aannot = prop.getProperty(propname, prop.getProperty(ACTIVEANNOTATION_ITEMS)).split(",");
        if (aannot != null) {
            for (int i2 = 0; i2 < aannot.length; ++i2) {
                String[] aaitem = aannot[i2].split("#");
                if (aaitem == null) continue;
                Object aac = this.createInstance(aaitem[0]);
                if (aac != null) {
                    if (aac instanceof ActiveAnnotationControl) {
                        aaCap.setActiveAnnotationListener(CvPropertiesManager.getProperty(aaitem[1], aaitem[1]), (MouseInputListener)aac, ((ActiveAnnotationControl)aac).getShortDescription());
                        continue;
                    }
                    if (aac instanceof MouseInputListener) {
                        aaCap.setActiveAnnotationListener(CvPropertiesManager.getProperty(aaitem[1], aaitem[1]), (MouseInputListener)aac, CvUtils.getResourceBundle().getString(aaitem[2]));
                        continue;
                    }
                    logger.log(Level.INFO, aaitem[0] + " active annotation control not supported.");
                    continue;
                }
                logger.log(Level.WARNING, "Unable to set active annotation control : " + aaitem[0] + ", as it is null.");
            }
        }
    }

    private Object createInstance(String className) {
        try {
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader()).newInstance();
        }
        catch (InstantiationException e2) {
            logger.log(Level.WARNING, "Unable to instantiate Class " + className + " " + e2.getLocalizedMessage());
        }
        catch (IllegalAccessException e3) {
            logger.log(Level.WARNING, "Illegal access to constructor of Class " + className + " " + e3.getLocalizedMessage());
        }
        catch (ClassNotFoundException e4) {
            logger.log(Level.WARNING, "Class " + className + " is not found." + e4.getLocalizedMessage());
        }
        return null;
    }
}

