/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.screenbuilder.helper;

import com.ge.med.cse.cvf.screenbuilder.helper.Helper;
import com.ge.med.idc.RowColCapable;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.Container;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class RowColHelper
implements Helper {
    private static final String SCREEN_GRID = ".screenGrid";
    private static final String COLS = ".cols";
    private static final String ROWS = ".rows";
    private static final Logger logger = Logger.getLogger(RowColHelper.class.getName());

    @Override
    public void config(JComponent port, String portName, Properties prop) throws Exception {
        if (port == null || portName == null || portName == "" || prop == null) {
            logger.log(Level.WARNING, "Either viewport or its name or property is null");
            throw new Exception("Either viewport or its name or property is null");
        }
        int rows = RowColHelper.getProperty(prop, portName + ROWS, 1);
        int cols = RowColHelper.getProperty(prop, portName + COLS, 1);
        String screenGridStr = prop.getProperty(portName + SCREEN_GRID);
        if (port instanceof RowColCapable) {
            ((RowColCapable)((Object)port)).setRowCol(rows, cols);
            if (screenGridStr != null) {
                StringTokenizer grids = new StringTokenizer(screenGridStr, "][");
                HashMap<String, Dimension> screenGrid = new HashMap<String, Dimension>();
                screenGrid.put(null, new Dimension(cols, rows));
                while (grids.hasMoreTokens()) {
                    String item = grids.nextToken();
                    String[] param = item.split(",");
                    if (param.length < 3) {
                        throw new IllegalArgumentException("screenGrid items are expected to have 3 components, error parsing " + item);
                    }
                    Dimension dim = new Dimension(Integer.parseInt(param[0]), Integer.parseInt(param[1]));
                    for (int i2 = 2; i2 < param.length; ++i2) {
                        screenGrid.put(param[i2], dim);
                    }
                }
                port.addAncestorListener(new portAL(screenGrid));
            }
        }
        if (port instanceof XpCompositePort) {
            boolean share = RowColHelper.getProperty(prop, portName + ".SharedRenderAttributes", true);
            ((XpCompositePort)port).setSharedRenderAttributes(share);
        }
    }

    public void save(JComponent port, String portName, Properties portStateProperties) {
        if (port instanceof RowColCapable) {
            RowColCapable rowCol = (RowColCapable)((Object)port);
            portStateProperties.setProperty(portName + ROWS, Integer.toString(rowCol.getRows()));
            portStateProperties.setProperty(portName + COLS, Integer.toString(rowCol.getCols()));
        }
    }

    private static int getProperty(Properties prop, String name, int defaultValue) {
        String conf = prop.getProperty(name);
        if (conf != null) {
            return Integer.parseInt(conf);
        }
        return defaultValue;
    }

    private static boolean getProperty(Properties prop, String name, boolean defaultValue) {
        String conf = prop.getProperty(name);
        if (conf != null) {
            if (conf.compareToIgnoreCase("true") == 0 || conf.compareToIgnoreCase("yes") == 0) {
                return true;
            }
            if (conf.compareToIgnoreCase("false") == 0 || conf.compareToIgnoreCase("no") == 0) {
                return false;
            }
            throw new IllegalArgumentException("Property " + name + " cannot be parsed as boolean [" + conf + "]");
        }
        return defaultValue;
    }

    static class portAL
    implements AncestorListener {
        private String lastScreenName = null;
        private Map screenGrid;

        public portAL(Map screenGrid) {
            this.screenGrid = screenGrid;
        }

        @Override
        public void ancestorAdded(AncestorEvent e2) {
            Container c2;
            for (c2 = e2.getAncestorParent(); c2 != null && !(c2 instanceof XPscreen); c2 = c2.getParent()) {
            }
            if (c2 != null) {
                XPscreen scrn = (XPscreen)c2;
                this.lastScreenName = scrn.getName();
                Dimension dim = (Dimension)this.screenGrid.get(this.lastScreenName);
                if (dim == null) {
                    dim = (Dimension)this.screenGrid.get(null);
                }
                ((RowColCapable)((Object)e2.getComponent())).setRowCol(dim.height, dim.width);
            }
        }

        @Override
        public void ancestorRemoved(AncestorEvent e2) {
            if (this.lastScreenName != null) {
                Dimension dim = (Dimension)this.screenGrid.get(this.lastScreenName);
                if (dim == null) {
                    dim = (Dimension)this.screenGrid.get(null);
                }
                RowColCapable rcc = (RowColCapable)((Object)e2.getComponent());
                dim.width = rcc.getCols();
                dim.height = rcc.getRows();
                this.lastScreenName = null;
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent e2) {
        }
    }
}

