/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.sr;

import com.ge.med.cse.cvf.sr.SRUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SRConfigXMLParser {
    private HashMap<String, HashMap<String, SrSOPClassUidElement>> modElementConfig = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(InputStream configStrm) {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser parser = null;
        spf.setNamespaceAware(true);
        spf.setValidating(true);
        SRConfigHandler srHndlr = new SRConfigHandler();
        try {
            parser = spf.newSAXParser();
            parser.parse(configStrm, (DefaultHandler)srHndlr);
        }
        catch (SAXException ex) {
            ex.printStackTrace();
            return;
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        catch (ParserConfigurationException e4) {
            e4.printStackTrace();
        }
        catch (IllegalArgumentException e5) {
            e5.printStackTrace();
        }
        finally {
            if (configStrm != null) {
                try {
                    configStrm.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    public void parseConfigFile(String configFilePath) {
        if (configFilePath == null) {
            return;
        }
        File config = new File(configFilePath);
        InputStream strm = null;
        try {
            strm = config.exists() ? new FileInputStream(config) : this.getClass().getResourceAsStream("SRConfig.xml");
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return;
        }
        if (strm != null) {
            this.parse(strm);
        }
    }

    public SrSOPClassUidElement getSOPClsUidCofigForModality(String modality, String sopClsUid) {
        if (modality != null && modality != "" && sopClsUid != null && sopClsUid != "" && this.modElementConfig.size() >= 1 && this.modElementConfig.containsKey(modality) && this.modElementConfig.get(modality).containsKey(sopClsUid)) {
            return this.modElementConfig.get(modality).get(sopClsUid);
        }
        return null;
    }

    public HashMap<String, HashMap<String, SrSOPClassUidElement>> getConfigInfo() {
        return this.modElementConfig;
    }

    public static class SrSOPClassUidElement {
        public String sopClsUid = "";
        public String xslFile = "";
        public String cssFile = "";
        public HashMap<String, String> i18nFiles = new HashMap();

        public String getXslFile() {
            if (this.xslFile == null) {
                return "CSE_Default.XSL";
            }
            String xslPath = SRUtils.REPOSITORY_PATH + this.xslFile;
            File xslFileObj = new File(xslPath);
            if (xslFileObj.exists()) {
                return xslPath;
            }
            return this.xslFile;
        }

        public void copyCssFile() {
            if (this.cssFile == null) {
                return;
            }
            String cssPath = SRUtils.REPOSITORY_PATH + this.cssFile;
            try {
                File cssFileObj = new File(cssPath);
                String cssFilePath = SRUtils.SRTEMPDIR + cssFileObj.getName();
                if (cssFileObj.exists()) {
                    SRUtils.copyFiles(cssPath, cssFilePath);
                } else {
                    cssFilePath = SRUtils.SRTEMPDIR + this.cssFile;
                    InputStream in = this.getClass().getResourceAsStream(this.cssFile);
                    FileOutputStream out = new FileOutputStream(cssFilePath);
                    SRUtils.copyFiles(in, out);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }

        public HashMap<String, String> getAllLocaleI18nFiles() {
            return this.i18nFiles;
        }

        public String geti18nFileForLocale(String locale) {
            try {
                FileOutputStream out;
                String localeI18n = this.i18nFiles.get(locale);
                if (localeI18n == null) {
                    localeI18n = this.i18nFiles.get("en_US");
                }
                String i18nPath = SRUtils.REPOSITORY_PATH + localeI18n;
                File i18nPathFileObj = new File(i18nPath);
                String pathToReturn = SRUtils.SRTEMPDIR + i18nPathFileObj.getName();
                if (i18nPathFileObj.exists() && SRUtils.copyFiles(i18nPath, pathToReturn)) {
                    return pathToReturn;
                }
                pathToReturn = SRUtils.SRTEMPDIR + localeI18n;
                InputStream in = this.getClass().getResourceAsStream(localeI18n);
                if (SRUtils.copyFiles(in, out = new FileOutputStream(pathToReturn))) {
                    return pathToReturn;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            return "";
        }
    }

    class SRConfigHandler
    extends DefaultHandler {
        String strModality;
        String strSopClsUid;
        String strXslFilePath;
        String strCssFilePath;
        String strLocale;
        String strI18nFile = "";
        SrSOPClassUidElement sopClsElement = null;
        HashMap<String, String> i18nConfig = null;
        HashMap<String, SrSOPClassUidElement> sopClsUidConfig = null;

        SRConfigHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName.equalsIgnoreCase("Modality")) {
                this.strModality = attributes.getValue(0);
                this.sopClsUidConfig = new HashMap();
            } else if (localName.equalsIgnoreCase("SrSopClassUid")) {
                this.strSopClsUid = attributes.getValue(0);
                this.i18nConfig = new HashMap();
            } else if (localName.equalsIgnoreCase("XSL")) {
                this.strXslFilePath = attributes.getValue(0);
            } else if (localName.equalsIgnoreCase("CSS")) {
                this.strCssFilePath = attributes.getValue(0);
            } else if (localName.equalsIgnoreCase("i18nFile") && attributes.getValue(0) != null && attributes.getValue(1) != "" && attributes.getValue(0) != null && attributes.getValue(1) != "") {
                this.i18nConfig.put(attributes.getValue(0), attributes.getValue(1));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equalsIgnoreCase("Modality")) {
                this.strModality = "";
                this.strSopClsUid = "";
                this.strXslFilePath = "";
                this.strCssFilePath = "";
                this.strLocale = "";
                this.strI18nFile = "";
            } else if (localName.equalsIgnoreCase("SrSopClassUid")) {
                this.sopClsElement = new SrSOPClassUidElement();
                this.sopClsElement.sopClsUid = this.strSopClsUid;
                this.sopClsElement.xslFile = this.strXslFilePath;
                this.sopClsElement.cssFile = this.strCssFilePath;
                this.sopClsElement.i18nFiles = this.i18nConfig;
                this.sopClsUidConfig.put(this.strSopClsUid, this.sopClsElement);
                if (SRConfigXMLParser.this.modElementConfig.containsKey(this.strModality)) {
                    ((HashMap)SRConfigXMLParser.this.modElementConfig.get(this.strModality)).put(this.strSopClsUid, this.sopClsElement);
                } else {
                    SRConfigXMLParser.this.modElementConfig.put(this.strModality, this.sopClsUidConfig);
                }
            }
        }
    }
}

