/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.textpage;

import com.ge.hc.cse.commons.interfaces.Formatter;
import com.ge.med.cse.cvf.comparators.NumberComparator;
import com.ge.med.cse.cvf.crossref.XpSliceCollectionRoi;
import com.ge.med.cse.cvf.log.CvGESyslogMessageCode;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.print.PrintProgress;
import com.ge.med.cse.cvf.print.PrinterStatus;
import com.ge.med.cse.cvf.print.SeriesPrint;
import com.ge.med.cse.cvf.print.XpFilmErrorLookup;
import com.ge.med.cse.cvf.roi.CvContinuousReporter;
import com.ge.med.cse.cvf.roi.CvFreeHandRoi;
import com.ge.med.cse.cvf.roi.CvImageGrid;
import com.ge.med.cse.cvf.roi.CvImageMatte;
import com.ge.med.cse.cvf.roi.CvPointRoi;
import com.ge.med.cse.cvf.roi.CvPolygonRoi;
import com.ge.med.cse.cvf.roi.CvRectangularRoi;
import com.ge.med.cse.cvf.textpage.ContentTableModel;
import com.ge.med.cse.cvf.textpage.ROIElement;
import com.ge.med.cse.cvf.textpage.ROITableModel;
import com.ge.med.cse.cvf.textpage.TextPageManager;
import com.ge.med.cse.cvf.textpage.TextPageXMLParser;
import com.ge.med.cse.cvf.textpage.UiElement;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomPageablePort;
import com.ge.med.cse.cvf.util.DicomPrintablePort;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.cse.cvf.util.ScreenSaveUtil;
import com.ge.med.idc.Capable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageRoiVc;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSystem;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.event.PrintJobAttributeEvent;
import javax.print.event.PrintJobAttributeListener;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.xml.sax.SAXException;

public class TextPage
extends JPanel {
    public static final String CLOSE_TEXT_PAGE = "close_text_page";
    private Logger logger = Logger.getLogger(this.getClass().getName());
    protected final int MAX_TABLE_ROWS = Integer.parseInt(CvPropertiesManager.getProperty("TEXTPAGE_HEIGHT"));
    protected int INITIAL_TABLE_ROWS = 0;
    protected int NUMBER_OF_HEADER_LABELS = 0;
    protected final int HEADER_LABEL_HEIGHT = 17;
    private Dimension pageDimensions = new Dimension(Integer.parseInt(CvPropertiesManager.getProperty("PAGE_WIDTH", "512")), Integer.parseInt(CvPropertiesManager.getProperty("PAGE_HEIGHT", "512")));
    public final TextPageManager.TextPageType pageType;
    protected int pageCount;
    public int pageToDisplay = 0;
    protected DMObject[] dmos = null;
    private String strModality;
    private String strImageType = null;
    private DMObject refDMO;
    private String query;
    private String refImagePath = null;
    private TextPageXMLParser parser;
    private String strXmlPath = null;
    private String[] roiTableHeader;
    private JPanel headerPanel;
    private JPanel tblPnl;
    private JPanel buttonPanel;
    private JTable contentTable;
    private JTable roiTable;
    private ContentTableModel[] tableModel;
    private ROITableModel[] roiModel;
    private JScrollPane imgPane;
    private boolean isROIPage = false;
    private JButton quit = new JButton(CvUtils.getIcon("XP_QUIT_ICON"));
    private JButton film = new JButton(CvUtils.getIcon("XP_FILM_ICON"));
    private JButton save = new JButton(CvUtils.getIcon("XP_SAVE_ICON"));
    private JButton previous = new JButton(CvUtils.getIcon("XP_PREVIOUS_ICON"));
    private JButton next = new JButton(CvUtils.getIcon("XP_NEXT_ICON"));
    ROIElement[] roieleElements;
    int pagesLeft = -1;
    PrintJobAttributeListener pjal = new PrintJobAttributeListener(){

        @Override
        public void attributeUpdate(PrintJobAttributeEvent pjae) {
            PrintProgress pp = (PrintProgress)pjae.getAttributes().get(PrintProgress.class);
            TextPage.this.logger.log(Level.FINEST, "{0} printProgress=" + pp.toString());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    --TextPage.this.pagesLeft;
                    if (TextPage.this.pagesLeft < 0) {
                        return;
                    }
                    if (TextPage.this.pagesLeft == 0 && !TextPage.this.film.isEnabled()) {
                        TextPage.this.film.setEnabled(true);
                    }
                }
            });
        }
    };
    PrintJobListener pjl = new PrintJobListener(){

        @Override
        public void printDataTransferCompleted(PrintJobEvent pje) {
            TextPage.this.logger.log(Level.INFO, "{0} Print Data Transfer Completed");
        }

        @Override
        public void printJobCanceled(PrintJobEvent pje) {
        }

        @Override
        public void printJobCompleted(PrintJobEvent pje) {
            TextPage.this.logger.log(Level.INFO, "job is completed");
            if (!TextPage.this.film.isEnabled()) {
                TextPage.this.film.setEnabled(true);
            }
        }

        @Override
        public void printJobFailed(final PrintJobEvent pje) {
            TextPage.this.logger.log(Level.INFO, "Printjob failed");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!TextPage.this.film.isEnabled()) {
                        TextPage.this.film.setEnabled(true);
                    }
                    if (pje.getPrintEventType() == 201) {
                        String error = XpFilmErrorLookup.getErrorString(pje.getPrintEventType());
                        TextPage.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, error});
                    } else if (pje.getPrintEventType() == 202) {
                        String error = XpFilmErrorLookup.getErrorString(pje.getPrintEventType());
                        TextPage.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, error});
                    } else if (pje.getPrintEventType() == 203) {
                        String error = XpFilmErrorLookup.getErrorString(pje.getPrintEventType());
                        TextPage.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, error});
                    } else if (pje.getPrintEventType() == 204) {
                        String error = XpFilmErrorLookup.getErrorString(pje.getPrintEventType());
                        TextPage.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, error});
                    } else if (pje.getPrintEventType() == 205) {
                        String error = XpFilmErrorLookup.getErrorString(pje.getPrintEventType());
                        TextPage.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, error});
                    } else if (pje.getPrintEventType() == 206) {
                        String error = XpFilmErrorLookup.getErrorString(pje.getPrintEventType());
                        TextPage.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, error});
                    } else if (pje.getPrintEventType() == 207) {
                        String error = XpFilmErrorLookup.getErrorString(pje.getPrintEventType());
                        TextPage.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, error});
                    } else if (pje.getPrintEventType() == 103) {
                        String error = CvUtils.getResourceBundle().getString("FILM_JOB_FAILED");
                        TextPage.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, error});
                    } else {
                        String error = CvUtils.getResourceBundle().getString("FILM_ERROR");
                        TextPage.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, error + pje.getPrintEventType()});
                    }
                }
            });
        }

        @Override
        public void printJobNoMoreEvents(PrintJobEvent pje) {
            TextPage.this.logger.log(Level.INFO, "{0} Print Job No More Events");
        }

        @Override
        public void printJobRequiresAttention(PrintJobEvent pje) {
            TextPage.this.logger.log(Level.INFO, "{0} Print Job Requires Attention");
        }
    };
    private boolean showBtnPanel = true;

    public TextPage(Capable cap, TextPageManager.TextPageType type) throws SAXException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.pageType = type;
        DMObject[] seriesObj = this.getSeriesObject(cap);
        if (seriesObj == null || seriesObj.length == 0) {
            this.logger.log(Level.INFO, "Selected port empty");
            throw new InstantiationException("Selected port empty");
        }
        switch (this.pageType) {
            case SERIES: {
                break;
            }
            case EXAM: {
                break;
            }
            case ROI: {
                this.populateROIElements(cap);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported textpage type");
            }
        }
        this.init(seriesObj[0]);
    }

    public TextPage(DMObject seriesObj, TextPageManager.TextPageType type) throws SAXException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (seriesObj == null) {
            this.logger.log(Level.INFO, "Selected port empty");
            throw new InstantiationException("Selected port empty");
        }
        this.pageType = type;
        this.init(seriesObj);
    }

    public TextPage(DMObject seriesObj, TextPageManager.TextPageType type, ROIElement[] rois) throws SAXException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (seriesObj == null) {
            this.logger.log(Level.INFO, "Selected port empty");
            throw new InstantiationException("Selected port empty");
        }
        this.pageType = type;
        this.roieleElements = rois;
        this.init(seriesObj);
    }

    private void populateROIElements(Capable cap) {
        XpViewport port = (XpViewport)((SelectionCapable)cap).getViewportComponent(((SelectionCapable)cap).getComponentSelection());
        Component[] roiVc = null;
        RoiActor[] list = null;
        if (port instanceof XpCompositePort) {
            XpFrameVisualizer viz = ((XpCompositePort)port).getSelectedPort();
            roiVc = viz.getMedicalImageVc().getImageVc().getComponents();
            list = this.getFilteredROI(viz.getRois());
        } else if (port instanceof T3DViewport) {
            roiVc = ((T3DViewport)port).getT3DComponent().getComponents();
        }
        this.roieleElements = new ROIElement[list.length];
        if (list != null) {
            for (int i2 = 0; i2 < list.length; ++i2) {
                ROIElement elem;
                this.roieleElements[i2] = elem = this.getROIInfo(list[i2], roiVc);
            }
        }
    }

    private void init(DMObject seriesObj) throws SAXException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (seriesObj == null) {
            this.logger.log(Level.INFO, "Selected port empty");
            throw new InstantiationException("Selected port empty");
        }
        this.strModality = (String)seriesObj.getValue(8, 96);
        this.strImageType = DicomUtils.getImageType(seriesObj, false);
        switch (this.pageType) {
            case SERIES: {
                this.strXmlPath = this.getTextPageXMLPath(TextPageManager.TextPageType.SERIES);
                this.refDMO = seriesObj;
                break;
            }
            case EXAM: {
                this.strXmlPath = this.getTextPageXMLPath(TextPageManager.TextPageType.EXAM);
                this.refDMO = seriesObj.getRelated("study")[0];
                break;
            }
            case ROI: {
                this.isROIPage = true;
                this.strXmlPath = this.getTextPageXMLPath(TextPageManager.TextPageType.ROI);
                this.refDMO = seriesObj;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported textpage type");
            }
        }
        if (this.strXmlPath == null) {
            throw new IllegalArgumentException("Unsupported textpage type");
        }
        this.parser = new TextPageXMLParser(this.strXmlPath);
        this.initUI();
        if (this.refDMO == null) {
            this.logger.log(Level.INFO, "Selected port empty");
            throw new InstantiationException("Selected port empty");
        }
        if (this.refDMO.getType().equalsIgnoreCase("series")) {
            this.dmos = this.sort(this.refDMO.getRelated("image"), new DMTag(32, 19));
        } else if (this.refDMO.getType().equalsIgnoreCase("study")) {
            this.dmos = this.sort(this.refDMO.getRelated("series"), new DMTag(32, 17));
        } else if (this.refDMO.getType().equalsIgnoreCase("image")) {
            this.dmos = new DMObject[]{this.refDMO};
        } else {
            throw new IllegalArgumentException("Unsupported DMObject types");
        }
        this.buildHeaderPanel();
        this.INITIAL_TABLE_ROWS = this.MAX_TABLE_ROWS * (this.pageDimensions.height - (this.headerPanel.getPreferredSize().height + 25)) / this.pageDimensions.height;
        this.logger.log(Level.INFO, "Is ROI page:" + this.isROIPage + ", INITIAL_TABLE_ROWS: " + this.INITIAL_TABLE_ROWS);
        this.previous.setEnabled(false);
        this.next.setEnabled(this.getPageCount() > 1);
        if (this.isROIPage) {
            this.buildROITableModels();
        } else {
            this.buildTableModels();
        }
        this.buildTextPage();
        this.setPreferredSize(this.pageDimensions);
    }

    private final int getPageTypeIndex() {
        return this.pageType.ordinal();
    }

    private DMObject[] getSeriesObject(Capable cap_) {
        XpImage img;
        FrameOwner focap = (FrameOwner)((Object)cap_.getCapable(FrameOwner.class.getName()));
        this.query = null;
        if (focap != null && (img = focap.getFrame()) instanceof XpMedicalDmImage) {
            XpMedicalDmImage medicalImg = (XpMedicalDmImage)img;
            DMImage dmi = medicalImg.getDMImage();
            this.refImagePath = dmi.getFilePath();
            this.strModality = (String)medicalImg.getDMImage().getValue(8, 96);
            this.strImageType = DicomUtils.getImageType(dmi, false);
            String seriesid = (String)((XpMedicalDmImage)img).getDMImage().getValue(new DMTag(32, 17));
            String seriesuid = (String)((XpMedicalDmImage)img).getDMImage().getValue(new DMTag(32, 14));
            this.query = "(0x0020, 0x000E) = " + seriesuid;
            if (seriesid != null && seriesid.trim().length() != 0) {
                this.query = this.query + " AND (0x0020, 0x0011) = " + seriesid;
            }
            if (this.isROIPage) {
                String imgNumber = (String)((XpMedicalDmImage)img).getDMImage().getValue(new DMTag(32, 19));
                if (imgNumber != null && imgNumber.trim().length() != 0) {
                    this.query = this.query + " AND (0x0020, 0x0013) = " + imgNumber.trim();
                }
                return CvUtils.getDMSystem().getLocalDB().getRelated("image", new DMQuery(this.query));
            }
            return CvUtils.getDMSystem().getLocalDB().getRelated("series", new DMQuery(this.query));
        }
        return null;
    }

    protected void initUI() {
        this.quit.setName("Quit");
        this.film.setName("Film");
        this.save.setName("Save");
        this.previous.setName("Previous");
        this.next.setName("Next");
        this.setName("TextPage");
        this.quit.setMargin(new Insets(0, 0, 0, 0));
        this.film.setMargin(new Insets(0, 0, 0, 0));
        this.save.setMargin(new Insets(0, 0, 0, 0));
        this.previous.setMargin(new Insets(0, 0, 0, 0));
        this.next.setMargin(new Insets(0, 0, 0, 0));
        this.quit.setPreferredSize(new Dimension(70, 30));
        this.film.setPreferredSize(new Dimension(70, 30));
        this.save.setPreferredSize(new Dimension(70, 30));
        this.previous.setPreferredSize(new Dimension(70, 30));
        this.next.setPreferredSize(new Dimension(70, 30));
    }

    public DMObject getRefDMO() {
        return this.refDMO;
    }

    public int getPageCount() {
        if (this.isROIPage) {
            int numberofROI = this.roieleElements != null ? this.roieleElements.length : 0;
            int count = numberofROI - this.INITIAL_TABLE_ROWS;
            return count % this.MAX_TABLE_ROWS > 0 ? count / this.MAX_TABLE_ROWS + 2 : count / this.MAX_TABLE_ROWS + 1;
        }
        int count = this.dmos.length - this.INITIAL_TABLE_ROWS;
        return count % this.MAX_TABLE_ROWS > 0 ? count / this.MAX_TABLE_ROWS + 2 : count / this.MAX_TABLE_ROWS + 1;
    }

    protected TableModel[] buildTableModels() {
        int i2;
        int index = 0;
        UiElement[] columnNames = this.getFilteredForModality(this.parser.getUiElementDetails("ui", "Table"));
        if (columnNames == null) {
            return this.tableModel;
        }
        for (i2 = 0; i2 > columnNames.length; ++i2) {
            columnNames[i2].strName = CvUtils.getResourceBundle().getString(columnNames[i2].strName);
        }
        for (i2 = 0; i2 < columnNames.length; ++i2) {
            columnNames[i2].strName = CvUtils.getResourceBundle().getString(columnNames[i2].strName);
        }
        int INITIAL_TBL_ROWS = Math.min(this.INITIAL_TABLE_ROWS, this.dmos.length);
        int remaining = (this.dmos.length - INITIAL_TBL_ROWS) % this.MAX_TABLE_ROWS;
        this.pageCount = this.getPageCount();
        this.tableModel = new ContentTableModel[this.pageCount];
        DMObject[] first = new DMObject[INITIAL_TBL_ROWS];
        for (int j2 = 0; j2 < INITIAL_TBL_ROWS; ++j2) {
            first[j2] = this.dmos[j2];
        }
        this.tableModel[0] = new ContentTableModel(columnNames, first);
        index += INITIAL_TBL_ROWS;
        for (int i3 = 1; i3 < this.pageCount; ++i3) {
            int j3;
            if (i3 < this.pageCount - 1) {
                DMObject[] rest = new DMObject[this.MAX_TABLE_ROWS];
                for (j3 = 0; j3 < this.MAX_TABLE_ROWS; ++j3) {
                    rest[j3] = this.dmos[j3 + index];
                }
                this.tableModel[i3] = new ContentTableModel(columnNames, rest);
                index += this.MAX_TABLE_ROWS;
                continue;
            }
            if (i3 == this.pageCount - 1 && remaining == 0) {
                DMObject[] rest = new DMObject[this.MAX_TABLE_ROWS];
                for (j3 = 0; j3 < this.MAX_TABLE_ROWS; ++j3) {
                    rest[j3] = this.dmos[j3 + index];
                }
                this.tableModel[i3] = new ContentTableModel(columnNames, rest);
                index += this.MAX_TABLE_ROWS;
                continue;
            }
            if (i3 != this.pageCount - 1 || remaining <= 0) continue;
            DMObject[] rest = new DMObject[remaining];
            for (j3 = 0; j3 < remaining; ++j3) {
                rest[j3] = this.dmos[j3 + index];
            }
            this.tableModel[i3] = new ContentTableModel(columnNames, rest);
            index += remaining;
        }
        return this.tableModel;
    }

    protected void buildROITableModels() {
        int i2;
        UiElement[] columnNames = this.getFilteredForModality(this.parser.getUiElementDetails("ui", "ROITable"));
        int index = 0;
        ROIElement[] first = null;
        ROIElement[] rest = null;
        if (columnNames != null) {
            this.roiTableHeader = new String[columnNames.length];
            for (int i3 = 0; i3 < this.roiTableHeader.length; ++i3) {
                this.roiTableHeader[i3] = columnNames[i3].strName;
            }
        }
        int INITIAL_TBL_ROWS = Math.min(this.INITIAL_TABLE_ROWS, this.roieleElements.length);
        int remaining = (this.roieleElements.length - INITIAL_TBL_ROWS) % this.MAX_TABLE_ROWS;
        this.pageCount = this.getPageCount();
        this.next.setEnabled(this.pageCount > 1);
        this.roiModel = new ROITableModel[this.pageCount];
        for (i2 = 0; i2 < this.pageCount; ++i2) {
            first = new ROIElement[INITIAL_TBL_ROWS];
        }
        if (first != null) {
            for (int j2 = 0; j2 < INITIAL_TBL_ROWS; ++j2) {
                first[j2] = this.roieleElements[j2];
            }
            if (this.roiTableHeader != null) {
                this.roiModel[0] = new ROITableModel(this.roiTableHeader, first);
            }
        }
        index += INITIAL_TBL_ROWS;
        if (this.roiTableHeader != null) {
            for (i2 = 1; i2 < this.pageCount; ++i2) {
                int j3;
                if (i2 < this.pageCount - 1) {
                    rest = new ROIElement[this.MAX_TABLE_ROWS];
                    for (j3 = 0; j3 < this.MAX_TABLE_ROWS; ++j3) {
                        rest[j3] = this.roieleElements[j3 + index];
                    }
                    this.roiModel[i2] = new ROITableModel(this.roiTableHeader, rest);
                    index += this.MAX_TABLE_ROWS;
                    continue;
                }
                if (i2 == this.pageCount - 1 && remaining == 0) {
                    rest = new ROIElement[this.MAX_TABLE_ROWS];
                    for (j3 = 0; j3 < this.MAX_TABLE_ROWS; ++j3) {
                        rest[j3] = this.roieleElements[j3 + index];
                    }
                    this.roiModel[i2] = new ROITableModel(this.roiTableHeader, rest);
                    index += this.MAX_TABLE_ROWS;
                    continue;
                }
                if (i2 != this.pageCount - 1 || remaining <= 0) continue;
                rest = new ROIElement[remaining];
                for (j3 = 0; j3 < remaining; ++j3) {
                    rest[j3] = this.roieleElements[j3 + index];
                }
                this.roiModel[i2] = new ROITableModel(this.roiTableHeader, rest);
                index += remaining;
            }
        }
    }

    private RoiActor[] getFilteredROI(List<RoiActor> toFilter) {
        Vector<RoiActor> toReturn = new Vector<RoiActor>();
        for (int i2 = 0; i2 < toFilter.size(); ++i2) {
            if (toFilter.get(i2) instanceof CvImageMatte || toFilter.get(i2) instanceof CvImageGrid || toFilter.get(i2) instanceof XpSliceCollectionRoi) continue;
            toReturn.add(toFilter.get(i2));
        }
        RoiActor[] rois = toReturn.toArray(new RoiActor[toReturn.size()]);
        toReturn.clear();
        return rois;
    }

    protected DMObject[] sort(DMObject[] toSort, DMTag tag2) {
        Arrays.sort(toSort, new NumberComparator(tag2.getGroup(), tag2.getElement()));
        return toSort;
    }

    public void page(boolean isNext) {
        if (isNext) {
            if (this.pageToDisplay < this.pageCount) {
                ++this.pageToDisplay;
            }
        } else if (this.pageToDisplay > 0) {
            --this.pageToDisplay;
        }
        try {
            this.removeAll();
            this.setModel(this.pageToDisplay);
            if (this.pageToDisplay == 0) {
                this.add((Component)this.headerPanel, "North");
                this.add(this.tblPnl);
                this.add((Component)this.buttonPanel, "South");
                this.previous.setEnabled(false);
                this.next.setEnabled(true);
            } else if (this.pageToDisplay < this.pageCount - 1) {
                this.add(this.tblPnl);
                this.add((Component)this.buttonPanel, "South");
                this.previous.setEnabled(true);
                this.next.setEnabled(true);
            } else {
                this.add(this.tblPnl);
                this.add((Component)this.buttonPanel, "South");
                this.previous.setEnabled(true);
                this.next.setEnabled(false);
            }
            this.revalidate();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.repaint();
    }

    private void setModel(int index) {
        if (!this.isROIPage) {
            this.contentTable.setModel(this.tableModel[index]);
            this.contentTable.repaint();
            this.setColumnWidth(this.contentTable);
        } else {
            this.roiTable.setModel(this.roiModel[index]);
            this.roiTable.repaint();
            this.setColumnWidth(this.roiTable);
        }
    }

    protected void buildTextPage() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.setLayout(new BorderLayout());
        if (!this.isROIPage) {
            this.buildTable();
        } else {
            this.buildROITable();
        }
        this.buildButtonPanel();
        this.add((Component)this.headerPanel, "North");
        this.add(this.tblPnl);
        this.add((Component)this.buttonPanel, "South");
    }

    protected void buildHeaderPanel() throws ClassNotFoundException, InstantiationException, IllegalAccessException, SAXException, IOException {
        JPanel pnl;
        int i2;
        UiElement[] leftpanelElements = this.getFilteredForModality(this.parser.getUiElementDetails("ui", "Left"));
        UiElement[] rightpanelElements = this.getFilteredForModality(this.parser.getUiElementDetails("ui", "Right"));
        this.headerPanel = new JPanel(new GridBagLayout());
        this.headerPanel.setName(TextPage.class.getName() + "headerPanel");
        int labelCount = 0;
        Font font = this.headerPanel.getFont();
        List<JLabel> leftlbl = this.getHeaderPanelLabels(leftpanelElements, font);
        List<JLabel> rightlbl = this.getHeaderPanelLabels(rightpanelElements, font);
        int lsize = leftlbl != null ? leftlbl.size() : 0;
        int rsize = rightlbl != null ? rightlbl.size() : 0;
        labelCount = lsize;
        if (rsize > labelCount) {
            labelCount = rsize;
        }
        if (this.NUMBER_OF_HEADER_LABELS < labelCount) {
            this.NUMBER_OF_HEADER_LABELS = labelCount;
        }
        this.headerPanel.setPreferredSize(new Dimension(this.pageDimensions.width, 17 * this.NUMBER_OF_HEADER_LABELS));
        int minlblsize = lsize > rsize ? rsize : lsize;
        for (i2 = 0; i2 < minlblsize; ++i2) {
            pnl = new JPanel(new GridBagLayout());
            pnl.add((Component)rightlbl.get(i2), new GridBagConstraints(1, i2, 0, 1, 0.0, 0.0, 12, 2, new Insets(0, 10, 5, 5), 0, 0));
            rightlbl.get(i2).setHorizontalAlignment(4);
            pnl.add((Component)leftlbl.get(i2), new GridBagConstraints(0, i2, -1, 1, 1.0, 1.0, 18, 2, new Insets(0, 5, 5, 10), 0, 0));
            leftlbl.get(i2).setHorizontalAlignment(2);
            this.headerPanel.add((Component)pnl, new GridBagConstraints(0, i2, -1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        for (i2 = minlblsize; i2 < lsize; ++i2) {
            pnl = new JPanel(new GridBagLayout());
            pnl.add((Component)leftlbl.get(i2), new GridBagConstraints(0, i2, 0, 1, 1.0, 1.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
            leftlbl.get(i2).setHorizontalAlignment(2);
            this.headerPanel.add((Component)pnl, new GridBagConstraints(0, i2, -1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        for (i2 = minlblsize; i2 < rsize; ++i2) {
            pnl = new JPanel(new GridBagLayout());
            pnl.add((Component)rightlbl.get(i2), new GridBagConstraints(1, i2, 0, 1, 1.0, 1.0, 12, 2, new Insets(0, 5, 5, 5), 0, 0));
            rightlbl.get(i2).setHorizontalAlignment(4);
            this.headerPanel.add((Component)pnl, new GridBagConstraints(0, i2, -1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    private List<JLabel> getHeaderPanelLabels(UiElement[] uielem, Font fnt) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ArrayList<JLabel> labelList = new ArrayList<JLabel>();
        if (uielem != null) {
            try {
                for (int i2 = 0; i2 < uielem.length; ++i2) {
                    String st;
                    if (uielem[i2].getUiElements() != null && uielem[i2].getUiElements().size() > 0 && (st = this.parseUIElementGroup(uielem[i2])) != null && !st.equals("")) {
                        JLabel lbl = new JLabel(st);
                        lbl.setFont(new Font(fnt.getFontName(), 0, Integer.parseInt(CvPropertiesManager.getProperty("TEXTPAGE_FONT_SIZE"))));
                        lbl.setName(uielem[i2].strName.toString());
                        labelList.add(lbl);
                    }
                    String formatter = uielem[i2].getFormatter();
                    Object objAns = null;
                    if (!formatter.equals("null")) {
                        Class<?> c2 = Class.forName(formatter);
                        Formatter f2 = (Formatter)c2.newInstance();
                        objAns = f2.format(this.dmos[0]);
                    } else {
                        DMTag toQuery = uielem[i2].getTag();
                        objAns = toQuery != null ? this.dmos[0].getValue(toQuery) : null;
                    }
                    String ans = "";
                    if (objAns != null) {
                        ans = objAns.toString();
                    }
                    if (ans.equals("") && uielem[i2].strIsMandatory.equals("false")) continue;
                    JLabel lbl = new JLabel(CvUtils.getResourceBundle().getString(uielem[i2].strName.toString()) + ": " + ans);
                    lbl.setFont(new Font(fnt.getFontName(), 0, Integer.parseInt(CvPropertiesManager.getProperty("TEXTPAGE_FONT_SIZE"))));
                    lbl.setName(uielem[i2].strName.toString());
                    labelList.add(lbl);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            return labelList;
        }
        return null;
    }

    private String parseUIElementGroup(UiElement uiElement) {
        StringBuffer uiGroupElement = new StringBuffer("");
        String st = null;
        try {
            ArrayList<UiElement> gorupEle = uiElement.getUiElements();
            for (UiElement uiEle : gorupEle) {
                String formatter = uiEle.getFormatter();
                Object objAns = null;
                if (!formatter.equals("null")) {
                    Class<?> c2 = Class.forName(formatter);
                    Formatter f2 = (Formatter)c2.newInstance();
                    objAns = f2.format(this.dmos[0]);
                    uiGroupElement.append(this.getDisplayString(uiEle, objAns));
                    continue;
                }
                this.logger.log(Level.INFO, "Unable to load the Formatter for the UI Element :" + uiEle.getName());
            }
            st = uiGroupElement.toString();
        }
        catch (Exception e2) {
            this.logger.log(Level.INFO, "" + e2.getLocalizedMessage());
            e2.printStackTrace();
        }
        return st;
    }

    private String getDisplayString(UiElement uiElement, Object objAns) {
        String str;
        StringBuffer lblstring = new StringBuffer("");
        if (!(objAns == null || this.isEmpty(str = (String)objAns) && uiElement.strIsMandatory.equals("false"))) {
            lblstring.append(CvUtils.getResourceBundle().getString(uiElement.strName));
            lblstring.append(": ");
            lblstring.append(str);
            lblstring.append(" ");
        }
        return lblstring.toString();
    }

    private boolean isEmpty(String str) {
        return str == null || str.equals("");
    }

    protected UiElement[] getFilteredForModality(UiElement[] toFilter) {
        Vector<UiElement> toReturn = new Vector<UiElement>();
        for (int i2 = 0; i2 < toFilter.length; ++i2) {
            String[] modality = toFilter[i2].getModality();
            if (modality == null) continue;
            for (int j2 = 0; j2 < modality.length; ++j2) {
                if (!modality[j2].equalsIgnoreCase(this.strModality) || !toFilter[i2].isSupportedModality(modality[j2])) continue;
                toReturn.add(toFilter[i2]);
            }
        }
        return toReturn.size() > 0 ? toReturn.toArray(new UiElement[toReturn.size()]) : null;
    }

    protected void buildTable() {
        this.tblPnl = new JPanel(new BorderLayout());
        this.tblPnl.setPreferredSize(new Dimension(this.pageDimensions.width, 200));
        this.tblPnl.setName(TextPage.class.getName() + "tblPnl");
        Font font = this.tblPnl.getFont();
        this.contentTable = new JTable(this.tableModel[0]);
        this.contentTable.getTableHeader().setFont(new Font(font.getFontName(), font.getStyle(), Integer.parseInt(CvPropertiesManager.getProperty("TEXTPAGE_FONT_SIZE"))));
        this.contentTable.setFont(new Font(font.getFontName(), 0, Integer.parseInt(CvPropertiesManager.getProperty("TEXTPAGE_FONT_SIZE"))));
        this.contentTable.setRowHeight(11);
        this.contentTable.setName("ContentTable");
        try {
            this.setColumnWidth(this.contentTable);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.imgPane = new JScrollPane(this.contentTable, 21, 31);
        this.imgPane.setName(TextPage.class.getName() + "imgPane");
        this.tblPnl.add(this.imgPane);
    }

    private void buildROITable() {
        this.tblPnl = new JPanel(new BorderLayout());
        this.tblPnl.setPreferredSize(new Dimension(this.pageDimensions.width, 200));
        this.tblPnl.setName(TextPage.class.getName() + "tblPnl");
        Font font = this.tblPnl.getFont();
        this.roiTable = new JTable(this.roiModel[0]);
        this.roiTable.getTableHeader().setFont(new Font(font.getFontName(), font.getStyle(), Integer.parseInt(CvPropertiesManager.getProperty("TEXTPAGE_FONT_SIZE"))));
        this.roiTable.setFont(new Font(font.getFontName(), 0, Integer.parseInt(CvPropertiesManager.getProperty("TEXTPAGE_FONT_SIZE"))));
        this.roiTable.setRowHeight(11);
        this.roiTable.setName("RoiTable");
        this.setColumnWidth(this.roiTable);
        this.imgPane = new JScrollPane(this.roiTable, 21, 31);
        this.tblPnl.add(this.imgPane);
    }

    protected void buildButtonPanel() {
        this.buttonPanel = new JPanel(new GridBagLayout());
        this.buttonPanel.add((Component)this.quit, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.film, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.save, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)new JLabel(""), new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 35, 0, 35), 0, 0));
        this.buttonPanel.add((Component)this.previous, new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.next, new GridBagConstraints(5, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.setName(TextPage.class.getName() + "buttonPanel");
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TextPage.this.page(true);
            }
        });
        this.film.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Thread print_th = new Thread(){

                    @Override
                    public void run() {
                        TextPage.this.doPrint();
                    }
                };
                print_th.start();
            }
        });
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Thread print_th = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            TextPage.this.save.setEnabled(false);
                            TextPage.this.savePage();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        finally {
                            if (!TextPage.this.save.isEnabled()) {
                                TextPage.this.save.setEnabled(true);
                            }
                        }
                    }
                };
                print_th.start();
            }
        });
        this.previous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TextPage.this.page(false);
            }
        });
        this.quit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TextPage.this.firePropertyChange(TextPage.CLOSE_TEXT_PAGE, false, true);
            }
        });
    }

    public Object clone() {
        Container page = null;
        try {
            switch (this.pageType) {
                case EXAM: {
                    page = new TextPage(this.refDMO, TextPageManager.TextPageType.EXAM);
                    break;
                }
                case SERIES: {
                    page = new TextPage(this.refDMO, TextPageManager.TextPageType.SERIES);
                    break;
                }
                case ROI: {
                    page = new TextPage(this.refDMO, TextPageManager.TextPageType.ROI, this.roieleElements);
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (page == null) {
            return null;
        }
        page.remove(((TextPage)page).buttonPanel);
        ((JComponent)page).revalidate();
        page.repaint();
        return page;
    }

    public void savePage() {
        boolean screenSaveFailed = false;
        TextPage page = (TextPage)this.clone();
        page.setShowBtnPanel(false);
        page.setSize(this.pageDimensions);
        DMSystem dmsys = CvUtils.getDMSystem();
        int pcount = page.getPageCount();
        String serNo = "-1";
        if (this.refDMO.getType().equalsIgnoreCase("series")) {
            serNo = (String)this.refDMO.getValue(new DMTag(32, 17));
        }
        for (int i2 = 0; i2 < pcount; ++i2) {
            try {
                String imgComments = "";
                switch (page.getPageTypeIndex()) {
                    case 0: {
                        imgComments = "Exam Text Page " + (i2 + 1) + "/" + pcount;
                        break;
                    }
                    case 1: {
                        imgComments = "Series " + serNo + " Text Page " + (i2 + 1) + "/" + pcount;
                        break;
                    }
                    case 2: {
                        imgComments = "ROI Text Page " + (i2 + 1) + "/" + pcount;
                    }
                }
                InputStream is = ScreenSaveUtil.getScreenCapture(this.refDMO, page, page.getWidth(), page.getHeight(), imgComments);
                if (is == null) {
                    this.logger.log(Level.WARNING, "Exception during install : Input stream is NULL while screen capture!!!");
                    this.logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("TP_SS_FAIL"));
                    return;
                }
                dmsys.getLocalDB().install(is);
            }
            catch (Exception e2) {
                screenSaveFailed = true;
                e2.printStackTrace();
            }
            if (i2 < page.getPageCount() - 1) {
                page.setPage(i2 + 1);
            }
            page.revalidate();
            page.repaint();
        }
        this.logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString(screenSaveFailed ? "TP_SS_FAIL" : "TP_SS_DONE"));
    }

    protected void doPrint() {
        TransactionLogName tln = new TransactionLogName("TID=CV_TextPageFilmAction");
        this.logger.log(Level.INFO, "{0} begin", tln);
        SimpleDoc doc = null;
        PrintService service_ = CvUtils.getDefaultPrintService();
        if (service_ == null) {
            String error = CvUtils.getResourceBundle().getString("FC_NOT_RUN");
            this.logger.log(Level.INFO, "{0} Sev5 No print services found !!", tln);
            this.logger.log(UserMessageLevel.USER_MSG, error);
            this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, error});
            return;
        }
        PrinterStatus ps = service_.getAttribute(PrinterStatus.class);
        boolean status = false;
        if (ps != null) {
            status = service_.getAttribute(PrinterStatus.class).getValue();
        }
        if (ps == null && !status) {
            String error = CvUtils.getResourceBundle().getString("FC_NOT_RUN");
            this.logger.log(Level.INFO, "{0} Sev5 Error in printing : Film Composer may not be running", tln);
            this.logger.log(UserMessageLevel.USER_MSG, error);
            this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, error});
            return;
        }
        this.film.setEnabled(false);
        DocPrintJob job = service_.createPrintJob();
        if (job == null) {
            String error = CvUtils.getResourceBundle().getString("FC_NULL_JOB");
            this.logger.log(Level.INFO, "{0} Sev5 Error in printing : NULL Dicom Print Job", tln);
            this.logger.log(UserMessageLevel.USER_MSG, error);
            this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, error});
            return;
        }
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(new SeriesPrint("SeriesPrint", new Locale("en")));
        job.addPrintJobAttributeListener(this.pjal, null);
        job.addPrintJobListener(this.pjl);
        TextPage pageToPrint = (TextPage)this.clone();
        pageToPrint.setShowBtnPanel(false);
        DicomPageablePort pageable = new DicomPageablePort(pageToPrint);
        this.pagesLeft = pageToPrint.getPageCount();
        try {
            doc = new SimpleDoc(pageable, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
            if (doc == null) {
                String error = CvUtils.getResourceBundle().getString("FC_NULL_JOB");
                this.logger.log(Level.SEVERE, "{0} Sev5 Error in printing : NULL Dicom Print doc", tln);
                this.logger.log(UserMessageLevel.USER_MSG, error);
                this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, error});
                return;
            }
            job.print(doc, aset);
            this.logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("TP_FILM_DONE"));
        }
        catch (Exception pe) {
            this.pagesLeft = -1;
            String error = CvUtils.getResourceBundle().getString("TP_FILM_FAIL");
            this.logger.log(Level.SEVERE, "{0} Error in printing due to " + pe.getMessage(), tln);
            this.logger.log(UserMessageLevel.USER_MSG, error);
            this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, error});
            Object data = null;
            try {
                data = doc.getPrintData();
            }
            catch (IOException ioe) {
                this.logger.log(Level.WARNING, "Unable to get print data." + ioe.getLocalizedMessage());
            }
            if (data instanceof DicomPrintablePort) {
                ((DicomPrintablePort)data).dispose();
            } else if (data instanceof DicomPageablePort) {
                ((DicomPageablePort)data).dispose();
            }
            return;
        }
        this.logger.log(Level.INFO, "{0} end", tln);
    }

    private JTable setColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int col = 0; col < table.getColumnCount(); ++col) {
            int maxwidth = 0;
            for (int row = 0; row < table.getRowCount(); ++row) {
                TableCellRenderer rend = table.getCellRenderer(row, col);
                Object value = null;
                try {
                    value = table.getValueAt(row, col);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    value = "";
                }
                Component comp = rend.getTableCellRendererComponent(table, value, false, false, row, col);
                maxwidth = Math.max(comp.getPreferredSize().width, maxwidth);
            }
            TableColumn column = columnModel.getColumn(col);
            column.setPreferredWidth(maxwidth);
            TableCellRenderer headerRend = column.getHeaderRenderer();
            if (headerRend == null) {
                headerRend = table.getTableHeader().getDefaultRenderer();
            }
            Object header = column.getHeaderValue();
            Component headComp = headerRend.getTableCellRendererComponent(table, header, false, false, 0, col);
            maxwidth = Math.max(maxwidth, headComp.getPreferredSize().width);
            column.setPreferredWidth(maxwidth);
        }
        return table;
    }

    private String getTextPageXMLPath(TextPageManager.TextPageType tptype) {
        String defprefix;
        String prefix = defprefix = "Default";
        String type = null;
        String suffix = ".TextPage.Xmlpath";
        String path = null;
        if (this.strModality != null) {
            prefix = this.strModality;
            if (this.strImageType != null) {
                prefix = prefix + "." + this.strImageType;
            }
        }
        switch (tptype) {
            case EXAM: {
                type = ".Exam";
                break;
            }
            case SERIES: {
                type = ".Series";
                break;
            }
            case ROI: {
                type = ".ROI";
                break;
            }
        }
        path = CvPropertiesManager.getProperty(prefix + type + suffix);
        return path != null ? path : CvPropertiesManager.getProperty(defprefix + type + suffix);
    }

    private void setShowBtnPanel(boolean value) {
        this.showBtnPanel = value;
    }

    public void setPage(int pageIndex) {
        if (pageIndex < 0 || pageIndex > this.getPageCount()) {
            return;
        }
        this.removeAll();
        this.setSize(this.pageDimensions);
        this.setModel(pageIndex);
        if (pageIndex == 0) {
            this.add((Component)this.headerPanel, "North");
            this.add(this.tblPnl);
        } else {
            this.add(this.tblPnl);
        }
        if (this.showBtnPanel) {
            this.add((Component)this.buttonPanel, "South");
        }
        this.revalidate();
    }

    public ROIElement getROIInfo(RoiActor ra, Component[] xpvisaulaComponent) {
        Component[] roiVc = xpvisaulaComponent;
        ROIElement elem = new ROIElement();
        if (ra instanceof XpStatisticsRoi) {
            CPoint cpt;
            XpStatisticsRoi stat = (XpStatisticsRoi)ra;
            XpVisualComponent roiVcExp = null;
            for (Component roi : roiVc) {
                if (!(roi instanceof XpImageRoiVc) || !((XpImageRoiVc)roi).getRoiActor().equals(stat)) continue;
                roiVcExp = (XpVisualComponent)roi;
                break;
            }
            CvContinuousReporter toGetRAS = new CvContinuousReporter();
            Rectangle2D rectx = stat.getBounds2D();
            CPoint point = new CPoint(rectx.getX() + rectx.getWidth() / 2.0, rectx.getY() + rectx.getHeight() / 2.0, 0.0, 0);
            toGetRAS.setImage(stat.getImage());
            toGetRAS.setPoint(point);
            if (roiVcExp != null && (cpt = roiVcExp.transform(point, (byte)2)) != null) {
                elem.Center = this.RASFormatter(cpt);
            }
            elem.R = stat.getRoiLabel();
            elem.Ang = Math.toDegrees(stat.getAngle());
            elem.Dim = ROITableModel.getRoundedValue(stat.getBounds2D().getWidth() * stat.getImage().getPixelDimensionX()) + "    " + ROITableModel.getRoundedValue(stat.getBounds2D().getHeight() * stat.getImage().getPixelDimensionY());
            elem.MaxPxl = stat.getPixelStatistics().getMax();
            elem.MinPxl = stat.getPixelStatistics().getMin();
            elem.Mean = stat.getPixelStatistics().getMean();
            elem.Pxls = stat.getPixelStatistics().getNumPixels();
            elem.Sdv = stat.getPixelStatistics().getStdDev();
            if (stat instanceof CvRectangularRoi.Rectangle) {
                CvRectangularRoi.Rectangle rect = (CvRectangularRoi.Rectangle)stat;
                elem.Area = rect.getIdealArea();
            } else if (stat instanceof CvRectangularRoi.Ellipse) {
                CvRectangularRoi.Ellipse ellipse = (CvRectangularRoi.Ellipse)stat;
                elem.Area = ellipse.getIdealArea();
            } else if (stat instanceof CvPolygonRoi) {
                CvPolygonRoi poly = (CvPolygonRoi)stat;
                if (poly.getNumPoints() >= 3 && poly.isClosed()) {
                    elem.Area = stat.getArea();
                    elem.Dim = "";
                } else {
                    elem.Center = "";
                    elem.Mean = 0.0;
                    elem.Pxls = 0;
                    elem.Sdv = 0.0;
                    elem.Area = 0.0;
                    elem.MaxPxl = -1.0;
                    elem.MinPxl = -1.0;
                    elem.Ang = Math.toDegrees(poly.getLineAngle());
                    if (poly.getNumPoints() == 2) {
                        elem.Dim = "" + ROITableModel.getRoundedValue(stat.getLength());
                    } else if (poly.getNumPoints() == 3 && !poly.isClosed()) {
                        elem.Dim = "";
                    }
                }
            } else if (stat instanceof CvFreeHandRoi) {
                CvFreeHandRoi fhroi = (CvFreeHandRoi)stat;
                elem.Center = "";
                elem.Mean = 0.0;
                elem.Pxls = 0;
                elem.Sdv = 0.0;
                elem.Area = 0.0;
                elem.MaxPxl = -1.0;
                elem.MinPxl = -1.0;
                elem.Ang = 0.0;
                elem.Dim = "" + ROITableModel.getRoundedValue(stat.getLength());
            } else if (stat instanceof CvPointRoi) {
                CvPointRoi ptroi = (CvPointRoi)stat;
                elem.Mean = ptroi.getValue();
                elem.Pxls = 1;
                elem.Sdv = 0.0;
                elem.Area = 0.0;
                elem.MaxPxl = elem.Mean;
                elem.MinPxl = elem.Mean;
                elem.Ang = 0.0;
                elem.Dim = "1";
            }
        }
        return elem;
    }

    private String RASFormatter(CPoint cp) {
        String R2 = cp.x > 0.0 ? "R" + Math.round(cp.x) : "L" + Math.round(-cp.x);
        String A2 = cp.y > 0.0 ? "A" + Math.round(cp.y) : "P" + Math.round(-cp.y);
        String S2 = cp.z > 0.0 ? "S" + Math.round(cp.z) : "I" + Math.round(-cp.z);
        return (R2.length() < 3 ? R2 + "  " : R2) + "  " + (A2.length() < 3 ? A2 + "  " : A2) + "  " + (S2.length() < 3 ? S2 + "  " : S2);
    }
}

