/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.ui;

import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.Capable;
import com.ge.med.idc.RowColCapable;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.ui.RowColumnButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class RowColFormatButton
extends JButton
implements PlasmaControl,
MouseMotionListener,
MouseListener,
PropertyChangeListener,
Replicable {
    private static final long serialVersionUID = 1000000000L;
    JPopupMenu popup = new JPopupMenu();
    JList list = new JList();
    JLabel infoLabel = new JLabel();
    JPanel labelPanel = new JPanel();
    JPanel leftPanel = new JPanel();
    Border labelBorder = BorderFactory.createLineBorder(UIManager.getColor("P9"));
    RowColumnButton.ListDataModel model;
    Capable cap_;
    boolean paintRowCols = CvPropertiesManager.getBoolean("RowColFormatButton.paintRowCols", false);

    public RowColFormatButton() {
        this.setFocusable(false);
        this.setIcon(new RowColIcon());
        this.model = new RowColumnButton.ListDataModel(new Dimension(5, 5));
        this.list.setModel(this.model);
        this.list.setUI(new RowColumnButton.RowColumnListUI());
        this.list.addMouseMotionListener(this);
        this.list.addMouseListener(this);
        this.list.setName(RowColFormatButton.class.getName() + "list");
        this.infoLabel.setName("InfoLabel");
        this.infoLabel.addPropertyChangeListener("text", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RowColFormatButton.this.setToolTipText(RowColFormatButton.this.infoLabel.getText());
            }
        });
        this.leftPanel.setPreferredSize(new Dimension(25, 15));
        this.leftPanel.setName(RowColFormatButton.class.getName() + "leftPanel");
        this.labelPanel.setLayout(new BorderLayout());
        this.labelPanel.add((Component)this.leftPanel, "West");
        this.labelPanel.add((Component)this.infoLabel, "Center");
        this.labelPanel.setBorder(this.labelBorder);
        this.labelPanel.setPreferredSize(new Dimension(40, 25));
        this.labelPanel.setName(RowColFormatButton.class.getName() + "labelPanel");
        this.popup.add(this.list);
        this.popup.add(new JSeparator());
        this.popup.add(this.labelPanel);
        this.popup.setName("FormalSelector");
        this.setName(this.getClass().getName());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (!RowColFormatButton.this.popup.isVisible()) {
                    RowColFormatButton.this.popup.show((Component)e2.getSource(), 0, RowColFormatButton.this.getBounds().height);
                }
            }
        });
        this.popup.addPropertyChangeListener("visible", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!RowColFormatButton.this.popup.isVisible()) {
                    RowColFormatButton.this.processRowColRequest();
                }
            }
        });
    }

    @Override
    public void setCapable(Capable s2) {
        this.cap_ = s2;
        RowColCapable rowColCap = this.getRowColCapable();
        this.model.setSelected(new Dimension(rowColCap.getRows(), rowColCap.getCols()));
        this.setToolTipText(rowColCap.getRows() + "X" + rowColCap.getCols());
        s2.removePropertyChangeListener("RowColumnProperty", this);
        s2.addPropertyChangeListener("RowColumnProperty", this);
        s2.removePropertyChangeListener("ComponentSelection", this);
        s2.addPropertyChangeListener("ComponentSelection", this);
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        int index = this.list.locationToIndex(e2.getPoint());
        Dimension dim = (Dimension)((RowColumnButton.ListDataModel)this.list.getModel()).getElementAt(index);
        Dimension sel = ((RowColumnButton.ListDataModel)this.list.getModel()).getSelected();
        int col = (int)sel.getWidth();
        int row = (int)sel.getHeight();
        String label = row + "x" + col;
        this.infoLabel.setText(label);
        if (dim.getWidth() != sel.getWidth() || dim.getHeight() != sel.getHeight()) {
            ((RowColumnButton.ListDataModel)this.list.getModel()).setSelected(dim);
        }
        this.list.repaint();
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        this.popup.setVisible(false);
        this.repaint();
    }

    protected void processRowColRequest() {
        if (!this.popup.isVisible()) {
            Dimension sel = this.model.getSelected();
            RowColCapable rowColCap = this.getRowColCapable();
            rowColCap.setRowCol((int)sel.getHeight(), (int)sel.getWidth());
            rowColCap.repaint();
        }
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        RowColCapable rowColCap = this.getRowColCapable();
        int rows = rowColCap.getRows();
        int cols = rowColCap.getCols();
        this.infoLabel.setText(rows + "X" + cols);
        this.model.setSelected(new Dimension(cols, rows));
    }

    private RowColCapable getRowColCapable() {
        return (RowColCapable)this.cap_.getCapable(RowColCapable.class.getName());
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
    }

    public Dimension getDimension() {
        return this.model.getSelected();
    }

    @Override
    public Object clone() {
        RowColFormatButton rcfb = new RowColFormatButton();
        rcfb.setCapable(this.cap_);
        return rcfb;
    }

    private class RowColIcon
    implements Icon {
        static final int size = 24;
        Dimension dim = new Dimension(2, 2);

        private RowColIcon() {
        }

        @Override
        public int getIconHeight() {
            return 24;
        }

        @Override
        public int getIconWidth() {
            return 24;
        }

        @Override
        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            int i2;
            g2.setColor(Color.GRAY.darker());
            g2.fillRect(x2, y2, 24, 24);
            g2.setColor(Color.white);
            g2.drawRect(x2, y2, 24, 24);
            if (RowColFormatButton.this.paintRowCols) {
                this.dim = RowColFormatButton.this.getDimension();
            }
            for (i2 = 0; i2 < this.dim.width - 1; ++i2) {
                g2.drawLine((i2 + 1) * 24 / this.dim.width + x2, y2, (i2 + 1) * 24 / this.dim.width + x2, y2 + 24 - 1);
            }
            for (i2 = 0; i2 < this.dim.height - 1; ++i2) {
                g2.drawLine(x2, y2 + (i2 + 1) * 24 / this.dim.height, x2 + 24 - 1, y2 + (i2 + 1) * 24 / this.dim.height);
            }
        }
    }
}

