/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import com.ge.med.cse.cvf.util.AvgSubDSAImageOp;
import com.ge.med.cse.cvf.util.DSAImageOp;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.jnu.geom.JnAffineTransform;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageScene;
import com.ge.med.terra.jami.XpImageViewport;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpPipeline;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMSeqItem;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class CvDSAImageUtils {
    public static final String MASK_OP_AVG_SUB = "AVG_SUB";
    public static final String MASK_REMOVED = "MaskRemoved";
    public static final DMTag mask_sub_seq = new DMTag(40, 24832);
    public static final DMTag mask_op_tag = new DMTag(40, 24833);
    public static final DMTag applicable_frame_range_tag = new DMTag(40, 24834);
    public static final DMTag mask_frame_nums_tag = new DMTag(40, 24848);
    public static final DMTag contrast_frame_avg_tag = new DMTag(40, 24850);
    public static final DMTag mask_sub_pixel_shift_tag = new DMTag(40, 24852);
    public static final DMTag recomm_view_mode_tag = new DMTag(40, 4240);
    public static final DMTag multi_frame_tag = new DMTag(40, 8);
    public static final DMTag image_inst_uid_tag = new DMTag(8, 24);
    public static final XpDicomElement image_inst_uid_elem = new XpDicomElement(8, 24);
    public static final String MASK_APPLIED = "mask_applied_property";
    public static final String MANUAL_MASK_INDEX = "manual_mask_index";

    public static void applymask(XpViewport port) {
        DMComposite dmc;
        XpImage img;
        if (port == null) {
            return;
        }
        FrameOwner fcap = (FrameOwner)((Object)port.getCapable(FrameOwner.class.getName()));
        if (fcap != null && (img = fcap.getFrame()) instanceof XpMedicalDmImage && CvDSAImageUtils.isDSASupported(dmc = ((XpMedicalDmImage)img).getDMImage().getComposite()) && MASK_OP_AVG_SUB.equals(CvDSAImageUtils.getMaskOperationType(dmc))) {
            MaskSeqImpl maskseq = new MaskSeqImpl();
            maskseq.load(dmc);
            String uid = (String)dmc.getValue(image_inst_uid_tag);
            CvDSAImageUtils.applyMask(port, maskseq.getMaskItems(), uid);
        }
        port.refreshContents();
        port.repaint();
    }

    public static void applyFrameAsMask(XpViewport port, int frameIndex) {
        if (port == null) {
            return;
        }
        FrameCapable fcap = (FrameCapable)((Object)port.getCapable(FrameCapable.class.getName()));
        FramePositioningCapable fpcap = (FramePositioningCapable)port.getCapable(FramePositioningCapable.class.getName());
        SelectionCapable scap = (SelectionCapable)port.getCapable(SelectionCapable.class.getName());
        if (fpcap != null && fcap != null) {
            int maskIndex = frameIndex;
            if (maskIndex < 1 || maskIndex >= fcap.getNumFrames()) {
                maskIndex = scap != null && scap.getComponentSelection() >= 0 ? fpcap.getFrameIndex() + scap.getComponentSelection() + 1 : fpcap.getFrameIndex() + 1;
            }
            AvgSubMaskItem mask = new AvgSubMaskItem(fcap, new int[]{maskIndex}, null, 0, 0.0, 0.0);
            String uid = null;
            XpImage img = fcap.getFrame(maskIndex - 1);
            if (img instanceof XpDicomObject) {
                ((XpDicomObject)((Object)img)).getValue(image_inst_uid_elem);
                uid = image_inst_uid_elem.getStringValue();
            }
            CvDSAImageUtils.applyMask(port, new MaskItem[]{mask}, uid);
        }
    }

    public static void applyMask(XpViewport port, MaskItem[] masks, String refUID) {
        if (port == null || masks == null || masks.length == 0) {
            return;
        }
        for (int j2 = 0; j2 < masks.length; ++j2) {
            XpImageRenderAttributes ira;
            AvgSubDSAImageOp dsaop;
            XpImageScene sc;
            int idx;
            int i2;
            int nframes;
            int nscenes;
            XpViewport cport;
            MaskItem mitem = masks[j2];
            int[] cframes = mitem.getApplicableContrastFrames();
            if (port instanceof XpCompositePort) {
                cport = (XpCompositePort)port;
                nscenes = ((XpCompositePort)cport).getNumScenes();
                nframes = cframes == null ? nscenes : cframes.length;
                for (i2 = 0; i2 < nframes; ++i2) {
                    int n2 = idx = cframes != null ? cframes[i2] - 1 : i2;
                    if (idx < 0 || idx >= nscenes) continue;
                    sc = ((XpCompositePort)cport).getScene(idx);
                    if (refUID != null && !CvDSAImageUtils.sameUID(sc.getFrame(), refUID)) continue;
                    dsaop = new AvgSubDSAImageOp(mitem, idx);
                    ira = sc.getImageRenderAttributes();
                    ira.addImageOperation(dsaop);
                    sc.setImageRenderAttributes(ira);
                }
                port.putClientProperty(MASK_APPLIED, true);
                port.firePropertyChange(MASK_REMOVED, true, false);
                continue;
            }
            if (!(port instanceof XpImageViewport)) continue;
            cport = (XpImageViewport)port;
            nscenes = ((XpImageViewport)cport).getNumScenes();
            nframes = cframes == null ? nscenes : cframes.length;
            for (i2 = 0; i2 < nframes; ++i2) {
                int n3 = idx = cframes != null ? cframes[i2] - 1 & 0xFF : i2;
                if (idx < 0 || idx >= nscenes || (sc = ((XpImageViewport)cport).getScene(idx)) == null || refUID != null && !CvDSAImageUtils.sameUID(sc.getFrame(), refUID)) continue;
                dsaop = new AvgSubDSAImageOp(mitem);
                ira = sc.getImageRenderAttributes();
                ira.addImageOperation(dsaop);
                sc.setImageRenderAttributes(ira);
            }
            port.putClientProperty(MASK_APPLIED, true);
            port.firePropertyChange(MASK_REMOVED, true, false);
        }
        port.refreshContents();
        port.repaint();
    }

    private static boolean sameUID(XpImage img, String uid) {
        if (uid != null && img instanceof XpDicomObject) {
            ((XpDicomObject)((Object)img)).getValue(image_inst_uid_elem);
            if (uid.equals(CvDSAImageUtils.image_inst_uid_elem.value)) {
                return true;
            }
        }
        return false;
    }

    public static void unapplyMask(XpViewport port) {
        if (port instanceof XpCompositePort) {
            XpCompositePort cport = (XpCompositePort)port;
            int nscenes = cport.getNumScenes();
            for (int i2 = 0; i2 < nscenes; ++i2) {
                XpImageScene sc = cport.getScene(i2);
                XpImageRenderAttributes ira = sc.getImageRenderAttributes();
                List imops = ira.getImageOperations();
                ArrayList newimops = new ArrayList();
                for (Object o2 : imops) {
                    if (o2 instanceof DSAImageOp) continue;
                    newimops.add(o2);
                }
                ira.setImageOperationList(newimops);
                sc.setImageRenderAttributes(ira);
            }
            port.putClientProperty(MASK_APPLIED, false);
            port.firePropertyChange(MASK_REMOVED, false, true);
        } else if (port instanceof XpImageViewport) {
            XpImageViewport cport = (XpImageViewport)port;
            int nscenes = cport.getNumScenes();
            for (int i3 = 0; i3 < nscenes; ++i3) {
                XpImageScene sc = cport.getScene(i3);
                if (sc == null) continue;
                XpImageRenderAttributes ira = sc.getImageRenderAttributes();
                List imops = ira.getImageOperations();
                ArrayList newimops = new ArrayList();
                for (Object o3 : imops) {
                    if (o3 instanceof DSAImageOp) continue;
                    newimops.add(o3);
                }
                ira.setImageOperationList(newimops);
                sc.setImageRenderAttributes(ira);
            }
            port.putClientProperty(MASK_APPLIED, false);
            port.firePropertyChange(MASK_REMOVED, false, true);
        }
        port.refreshContents();
        port.repaint();
    }

    public static boolean isRecommendedViewingModeSUB(DMTagValueInterface image) {
        String o2 = (String)image.getValue(recomm_view_mode_tag);
        return o2 != null && "SUB".equalsIgnoreCase(o2);
    }

    public static boolean isDSASupported(DMTagValueInterface image) {
        DMSeqItem item;
        String maskop;
        DMSequence maskseq;
        int nitems;
        int bpp = DicomUtils.getBitsPerPix(image);
        if (bpp != 16) {
            return false;
        }
        if (CvDSAImageUtils.getNumFrames(image) <= 1) {
            return false;
        }
        Object o2 = image.getValue(mask_sub_seq);
        return o2 instanceof DMSequence && (nitems = (maskseq = (DMSequence)o2).getNumberOfItems()) > 0 && MASK_OP_AVG_SUB.equals(maskop = (String)(item = maskseq.getItem(0)).getValue(mask_op_tag));
    }

    public static String getMaskOperationType(DMTagValueInterface image) {
        DMSequence maskseq;
        int nitems;
        Object o2 = image.getValue(mask_sub_seq);
        if (o2 instanceof DMSequence && (nitems = (maskseq = (DMSequence)o2).getNumberOfItems()) > 0) {
            DMSeqItem item = maskseq.getItem(0);
            String maskop = (String)item.getValue(mask_op_tag);
            return maskop;
        }
        return "NONE";
    }

    public static int getNumFrames(DMTagValueInterface object) {
        Object o2 = object.getValue(multi_frame_tag);
        int numFrames = 1;
        if (o2 instanceof Integer) {
            numFrames = (Integer)o2;
        } else if (o2 instanceof String) {
            numFrames = Integer.parseInt((String)o2);
        }
        return numFrames;
    }

    public static int[] getIntArrayValue(Object value) {
        int[] intArray = null;
        if (value instanceof String) {
            String v2 = (String)value;
            StringTokenizer tokenizer = new StringTokenizer(v2, "\\");
            intArray = new int[tokenizer.countTokens()];
            for (int i2 = 0; i2 < intArray.length; ++i2) {
                intArray[i2] = Integer.parseInt(tokenizer.nextToken());
            }
        } else if (value instanceof Integer[]) {
            Integer[] vals = (Integer[])value;
            intArray = new int[vals.length];
            for (int i3 = 0; i3 < intArray.length; ++i3) {
                intArray[i3] = vals[i3];
            }
        } else if (value instanceof Integer) {
            intArray = new int[]{(Integer)value};
        }
        return intArray;
    }

    public static double[] getDoubleArrayValue(Object value) {
        double[] doubleArray;
        block5: {
            block7: {
                block6: {
                    block4: {
                        int i2;
                        Number[] dv;
                        doubleArray = null;
                        if (value instanceof Double[]) {
                            dv = (Double[])value;
                            doubleArray = new double[dv.length];
                            for (i2 = 0; i2 < dv.length; ++i2) {
                                doubleArray[i2] = (Double)dv[i2];
                            }
                        }
                        if (!(value instanceof Float[])) break block4;
                        dv = (Float[])value;
                        doubleArray = new double[dv.length];
                        for (i2 = 0; i2 < dv.length; ++i2) {
                            doubleArray[i2] = ((Float)dv[i2]).doubleValue();
                        }
                        break block5;
                    }
                    if (!(value instanceof Double)) break block6;
                    doubleArray = new double[]{(Double)value};
                    break block5;
                }
                if (!(value instanceof Float)) break block7;
                doubleArray = new double[]{((Float)value).doubleValue()};
                break block5;
            }
            if (!(value instanceof String)) break block5;
            String v2 = (String)value;
            StringTokenizer tokenizer = new StringTokenizer(v2, "\\");
            doubleArray = new double[tokenizer.countTokens()];
            for (int i3 = 0; i3 < doubleArray.length; ++i3) {
                doubleArray[i3] = Double.parseDouble(tokenizer.nextToken());
            }
        }
        return doubleArray;
    }

    public static BufferedImage average(BufferedImage[] imgs, BufferedImage out) {
        if (imgs == null || imgs.length == 0) {
            return null;
        }
        if (imgs[0].getType() == 11) {
            if (out == null) {
                out = new BufferedImage(imgs[0].getWidth(), imgs[0].getHeight(), imgs[0].getType());
            }
            if (out.getWidth() == imgs[0].getWidth() && out.getHeight() == imgs[0].getHeight() && out.getType() == imgs[0].getType()) {
                short[] odata = ((DataBufferUShort)out.getRaster().getDataBuffer()).getData();
                int n2 = imgs.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    short[] idata = ((DataBufferUShort)imgs[i2].getData().getDataBuffer()).getData();
                    for (int j2 = 0; j2 < odata.length; ++j2) {
                        int n3 = j2;
                        odata[n3] = (short)(odata[n3] + idata[j2]);
                    }
                }
                double div = 1.0 / (double)n2;
                for (int i3 = 0; i3 < odata.length; ++i3) {
                    odata[i3] = (short)((double)odata[i3] * div);
                }
            }
        }
        return out;
    }

    public static class AvgSubMaskItem
    implements MaskItem {
        private DMComposite dmcomp = null;
        private int seqItemIndex = 0;
        private FrameCapable port = null;
        private BufferedImage mask = null;
        private int[] maskFrames = null;
        private int[] applicableContFrames = null;
        private int contFrameAvg = 1;
        private double maskPixelShiftX = 0.0;
        private double maskPixelShiftY = 0.0;
        private JnAffineTransform at = new JnAffineTransform();
        private JnAffineTransform invT = new JnAffineTransform();
        private XpGeomUtils geomUtils = new XpGeomUtils();
        private double[] tx = new double[6];
        private double[] itx = new double[6];

        public AvgSubMaskItem(DMComposite dcomp, int itemIndex) {
            this.dmcomp = dcomp;
            this.seqItemIndex = itemIndex;
            this.init(dcomp);
        }

        public AvgSubMaskItem(FrameCapable port, int[] maskFrameNum, int[] applicableContFrameNum, int contFrameAvgNum, double maskPixShiftRow, double maskPixShiftCol) {
            this.port = port;
            this.maskFrames = maskFrameNum;
            this.applicableContFrames = applicableContFrameNum;
            this.contFrameAvg = contFrameAvgNum;
            this.maskPixelShiftX = maskPixShiftCol;
            this.maskPixelShiftY = maskPixShiftRow;
            if (port != null && this.maskFrames.length > 0) {
                BufferedImage[] imgs = new BufferedImage[this.maskFrames.length];
                for (int i2 = 0; i2 < this.maskFrames.length; ++i2) {
                    int idx = this.maskFrames[i2] - 1;
                    if (idx < 0 || idx >= port.getNumFrames()) continue;
                    imgs[i2] = (BufferedImage)port.getFrame(idx).getPixelData();
                }
                this.generateMask(imgs);
            }
        }

        public double[] getMaskSubPixelShift() {
            return new double[]{this.maskPixelShiftX, this.maskPixelShiftY};
        }

        @Override
        public int[] getApplicableContrastFrames() {
            return this.applicableContFrames;
        }

        public int getContrastFrameAveraging() {
            return this.contFrameAvg;
        }

        public int[] getMaskFrames() {
            return this.maskFrames;
        }

        @Override
        public BufferedImage getMask() {
            return this.mask;
        }

        public BufferedImage getContrastFrame(int index) {
            int nframes;
            if (this.port != null && index > 0 && index <= this.port.getNumFrames()) {
                return (BufferedImage)this.port.getFrame(index - 1).getPixelData();
            }
            if (this.dmcomp != null && (nframes = CvDSAImageUtils.getNumFrames(this.dmcomp)) > 0 && index > 0 && index <= nframes) {
                DMImage[] frames = this.dmcomp.getImages(null);
                return frames[index - 1].getPixelData();
            }
            return null;
        }

        public void load(DMComposite dmc) {
            this.dmcomp = dmc;
            this.init(dmc);
        }

        private void init(DMComposite dmc) {
            DMSeqItem item;
            String maskop;
            DMSequence maskseq;
            int nitems;
            if (dmc == null) {
                return;
            }
            Object o2 = dmc.getValue(mask_sub_seq);
            if (o2 instanceof DMSequence && (nitems = (maskseq = (DMSequence)o2).getNumberOfItems()) > this.seqItemIndex && CvDSAImageUtils.MASK_OP_AVG_SUB.equals(maskop = (String)(item = maskseq.getItem(this.seqItemIndex)).getValue(mask_op_tag))) {
                this.maskFrames = CvDSAImageUtils.getIntArrayValue(item.getValue(mask_frame_nums_tag));
                Object v2 = item.getValue(contrast_frame_avg_tag);
                if (v2 instanceof Short) {
                    this.contFrameAvg = (Short)v2 & 0xFF;
                } else if (v2 instanceof String) {
                    this.contFrameAvg = Short.parseShort((String)v2) & 0xFF;
                }
                int[] cfs = CvDSAImageUtils.getIntArrayValue(item.getValue(applicable_frame_range_tag));
                if (cfs != null) {
                    int i2;
                    Hashtable<Integer, Integer> cfslist = new Hashtable<Integer, Integer>();
                    for (i2 = 0; i2 < cfs.length; i2 += 2) {
                        for (int j2 = cfs[i2]; j2 <= cfs[i2 + 1]; ++j2) {
                            if (cfslist.contains(j2)) continue;
                            cfslist.put(j2, j2);
                        }
                    }
                    this.applicableContFrames = new int[cfslist.size()];
                    i2 = 0;
                    Iterator it = cfslist.keySet().iterator();
                    while (it.hasNext()) {
                        this.applicableContFrames[i2] = (Integer)it.next();
                        ++i2;
                    }
                    Arrays.sort(this.applicableContFrames);
                } else {
                    int nframes = CvDSAImageUtils.getNumFrames(dmc);
                    int lastframe = nframes - this.contFrameAvg + 1;
                    this.applicableContFrames = new int[lastframe];
                    for (int i3 = 0; i3 < lastframe; ++i3) {
                        this.applicableContFrames[i3] = i3 + 1;
                    }
                }
                double[] dvals = CvDSAImageUtils.getDoubleArrayValue(item.getValue(mask_sub_pixel_shift_tag));
                if (dvals != null && dvals.length == 2) {
                    this.maskPixelShiftX = dvals[1];
                    this.maskPixelShiftY = dvals[0];
                }
            }
            if (this.maskFrames != null && this.maskFrames.length > 0) {
                DMImage[] frames = this.dmcomp.getImages(null);
                BufferedImage[] imgs = new BufferedImage[this.maskFrames.length];
                for (int i4 = 0; i4 < this.maskFrames.length; ++i4) {
                    imgs[i4] = frames[this.maskFrames[i4] - 1].getPixelData();
                }
                this.generateMask(imgs);
            }
        }

        private void generateMask(BufferedImage[] imgs) {
            if (imgs != null && imgs.length > 0) {
                BufferedImage tmp = new BufferedImage(imgs[0].getWidth(), imgs[0].getHeight(), imgs[0].getType());
                CvDSAImageUtils.average(imgs, tmp);
                this.mask = new BufferedImage(tmp.getWidth(), tmp.getHeight(), tmp.getType());
                short[] maskdata = ((DataBufferUShort)this.mask.getRaster().getDataBuffer()).getData();
                short[] idata = ((DataBufferUShort)tmp.getData().getDataBuffer()).getData();
                if (this.maskPixelShiftX != 0.0 || this.maskPixelShiftY != 0.0) {
                    this.at.setToIdentity();
                    this.at.translate(-this.maskPixelShiftX, this.maskPixelShiftY);
                    this.at.getMatrix(this.tx);
                    this.geomUtils.calcInverse(this.at, this.invT);
                    this.invT.getMatrix(this.itx);
                    XpPipeline.doBilinearShortToShortUpright(this.tx, this.itx, idata, 0, this.mask.getWidth(), this.mask.getHeight(), 0, 16, maskdata, this.mask.getWidth(), this.mask.getHeight(), (short)0);
                } else {
                    for (int i2 = 0; i2 < maskdata.length; ++i2) {
                        maskdata[i2] = idata[i2];
                    }
                }
            }
        }
    }

    public static class MaskSeqImpl
    implements MaskSeq {
        private MaskItem[] masks = null;

        @Override
        public void load(DMComposite dmc) {
            Object o2 = dmc.getValue(mask_sub_seq);
            if (o2 instanceof DMSequence) {
                DMSequence maskseq = (DMSequence)o2;
                int nitems = maskseq.getNumberOfItems();
                ArrayList<AvgSubMaskItem> mlist = new ArrayList<AvgSubMaskItem>();
                for (int i2 = 0; i2 < nitems; ++i2) {
                    DMSeqItem item = maskseq.getItem(i2);
                    String maskop = (String)item.getValue(mask_op_tag);
                    if (!CvDSAImageUtils.MASK_OP_AVG_SUB.equals(maskop)) continue;
                    AvgSubMaskItem mitem = new AvgSubMaskItem(dmc, i2);
                    mlist.add(mitem);
                }
                if (mlist.size() > 0) {
                    this.masks = mlist.toArray(new MaskItem[mlist.size()]);
                }
            }
        }

        @Override
        public int getNumMaskItems() {
            if (this.masks != null) {
                return this.masks.length;
            }
            return 0;
        }

        @Override
        public MaskItem getMaskItem(int index) {
            if (this.masks != null && index >= 0 && index < this.masks.length) {
                return this.masks[index];
            }
            return null;
        }

        @Override
        public MaskItem[] getMaskItems() {
            return this.masks;
        }
    }

    public static interface MaskItem {
        public BufferedImage getMask();

        public int[] getApplicableContrastFrames();
    }

    public static interface MaskSeq {
        public void load(DMComposite var1);

        public int getNumMaskItems();

        public MaskItem getMaskItem(int var1);

        public MaskItem[] getMaskItems();
    }
}

