/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;

public class CvTransferableGO
implements Transferable {
    public static final DataFlavor roiFlavor = new DataFlavor(RoiActor.class, "RoiActor");
    public static final DataFlavor uaFlavor = new DataFlavor(XpUserAnnotationModel.class, "XpUserAnnotationModel");
    public static final DataFlavor[] supported = new DataFlavor[]{roiFlavor, uaFlavor};
    private RoiActor[] roiObjects;
    private XpUserAnnotationModel[] uaObjects;
    protected ArrayList<RoiActor> roiList = new ArrayList();
    protected ArrayList<XpUserAnnotationModel> uaList = new ArrayList();
    private static CvTransferableGO instance = null;

    private CvTransferableGO() {
    }

    public static CvTransferableGO getInstance() {
        return instance == null ? (instance = new CvTransferableGO()) : instance;
    }

    public Transferable setContents(Object[] go) {
        if (go == null || go.length == 0) {
            throw new IllegalArgumentException("Null or Zero length transferable");
        }
        this.roiList.clear();
        this.uaList.clear();
        for (int i2 = 0; i2 < go.length; ++i2) {
            if (go[i2] instanceof RoiActor) {
                this.roiList.add((RoiActor)go[i2]);
                continue;
            }
            if (!(go[i2] instanceof XpUserAnnotationModel)) continue;
            this.uaList.add((XpUserAnnotationModel)go[i2]);
        }
        if (this.roiList.size() == 0 && this.uaList.size() == 0) {
            throw new UnsupportedOperationException("No ROI or user annotation found for transfer");
        }
        this.roiObjects = new RoiActor[this.roiList.size()];
        this.roiObjects = this.roiList.toArray(this.roiObjects);
        this.uaObjects = new XpUserAnnotationModel[this.uaList.size()];
        this.uaObjects = this.uaList.toArray(this.uaObjects);
        return this;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return supported;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return roiFlavor.equals(flavor) || uaFlavor.equals(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return roiFlavor.equals(flavor) ? this.roiObjects : (uaFlavor.equals(flavor) ? this.uaObjects : null);
    }
}

