/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import com.ge.med.idc.XjDicomObject;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.jdbDicomDict;
import java.lang.reflect.Field;
import java.util.StringTokenizer;

public class DicomUtils {
    public static String CT_SOP_CLASS_UID;
    public static String PET_SOP_CLASS_UID;
    public static String SC_SOP_CLASS_UID;
    public static String BSPS_SOP_CLASS_UID;
    public static String REG_OBJ_SOP_CLASS_UID;
    public static String MR_SOP_CLASS_UID;
    public static String NM_SOP_CLASS_UID;
    public static String US_SOP_CLASS_UID;
    public static XpDicomElement sopInstanceUID;
    public static XpDicomElement sopClassUID;
    public static XpDicomElement studyID;
    public static XpDicomElement seriesUID;
    public static XpDicomElement seriesNo;
    public static XpDicomElement imageNo;
    public static String ARRAY_SEPARATOR;
    public static int[] FileMetaInformationVersion;
    public static int[] MediaStorageSOPClassUID;
    public static int[] MediaStorageSOPInstanceUID;
    public static int[] TransferSyntaxUID;
    public static int[] ImplementationClassUID;
    public static int[] ImplementationVersionName;
    public static int[] PrivateInformationCreatorUID;
    public static int[] PrivateInformation;
    public static int[] SpecificCharacterSet;
    public static int[] ImageType;
    public static int[] InstanceCreationDate;
    public static int[] InstanceCreationTime;
    public static int[] InstanceCreatorUID;
    public static int[] SOPClassUID;
    public static int[] SOPInstanceUID;
    public static int[] StudyDate;
    public static int[] SeriesDate;
    public static int[] AcquisitionDate;
    public static int[] ContentDate;
    public static int[] StudyTime;
    public static int[] SeriesTime;
    public static int[] AcquisitionTime;
    public static int[] ContentTime;
    public static int[] AccessionNumber;
    public static int[] Modality;
    public static int[] ConversionType;
    public static int[] Manufacturer;
    public static int[] InstitutionName;
    public static int[] InstitutionAddress;
    public static int[] ReferringPhysiciansName;
    public static int[] CodeValue;
    public static int[] CodingSchemeDesignator;
    public static int[] TimeZoneOffsetFromUTC;
    public static int[] CodeMeaning;
    public static int[] StationName;
    public static int[] StudyDescription;
    public static int[] ProcedureCodeSequence;
    public static int[] SeriesDescription;
    public static int[] InstitutionalDepartmentName;
    public static int[] PhysicianOfRecord;
    public static int[] PerformingPhysicianName;
    public static int[] NameOfPhysicianReadingStudy;
    public static int[] NominalInterval;
    public static int[] OperatorsName;
    public static int[] AdmittingDiagnosesDescription;
    public static int[] IntervalsAcquired;
    public static int[] IntervalsRejected;
    public static int[] ManufacturerModelName;
    public static int[] ReferencedStudySequence;
    public static int[] ReferencedStudyComponentSequence;
    public static int[] ReferencedPatientSequence;
    public static int[] ReferencedOverlaySequence;
    public static int[] ReferencedImageSequence;
    public static int[] ReferencedCurveSequence;
    public static int[] ReferencedSOPClassUID;
    public static int[] ReferencedSOPInstanceUID;
    public static int[] DerivationDescription;
    public static int[] SourceImageSequence;
    public static int[] AnatomicRegionSequence;
    public static int[] PrimaryAnatomicStructureSequence;
    public static int[] CreatorVersionUID;
    public static int[] FullFidelity;
    public static int[] SuiteID;
    public static int[] ProductID;
    public static int[] ImageActualDate;
    public static int[] EquipmentUID;
    public static int[] TableHeight_PET;
    public static int[] suidOfCtUsedForAcOfPet;
    public static int[] TracerName;
    public static int[] MidPhasePercentage;
    public static int[] PatientName;
    public static int[] PatientID;
    public static int[] PatientBirthDate;
    public static int[] PatientSex;
    public static int[] PatientBirthTime;
    public static int[] OtherPatientIDs;
    public static int[] OtherPatientNames;
    public static int[] EthnicGroup;
    public static int[] PatientComments;
    public static int[] PatientAge;
    public static int[] PatientSize;
    public static int[] PatientWeight;
    public static int[] Occupation;
    public static int[] AdditionalPatientHistory;
    public static int[] gatingType;
    public static int[] numberOfBins;
    public static int[] respiratoryPhase;
    public static int[] respiratoryPhaseMatchedSer;
    public static int[] CTACPercentageVal;
    public static int[] ContrastBolusAgent;
    public static int[] BodyPartExamined;
    public static int[] ScanOptions;
    public static int[] InterventionDrugInformationSequence;
    public static int[] SliceThickness;
    public static int[] KV;
    public static int[] AcquisitionTerminationCondition;
    public static int[] AcquisitionStartCondition;
    public static int[] AcquisitionStartConditionData;
    public static int[] AcquisitionTerminationConditionData;
    public static int[] SpacingBetweenSlices;
    public static int[] DataCollectionDiameter;
    public static int[] DeviceSerialNumber;
    public static int[] SecondaryCaptureDeviceID;
    public static int[] DateOfSecondaryCapture;
    public static int[] TimeOfSecondaryCapture;
    public static int[] SecondaryCaptureDeviceManufacturer;
    public static int[] SecondaryCaptureDeviceManufacturerModelName;
    public static int[] SecondaryCaptureDeviceSoftwareVersion;
    public static int[] SoftwareVersion;
    public static int[] VideoImageFormatAcq;
    public static int[] DigitalImageFormatAcq;
    public static int[] ProtocolName;
    public static int[] Radiopharmaceutical;
    public static int[] ContrastBolusRoute;
    public static int[] SpatialResolution;
    public static int[] TriggerTime;
    public static int[] TriggerSourceOrType;
    public static int[] FrameTime;
    public static int[] FramingType;
    public static int[] RadionuclideVolume;
    public static int[] RadiopharmaceuticalStartTime;
    public static int[] RadionuclideTotalDose;
    public static int[] RadionuclideHalfLife;
    public static int[] RadionuclidePositronFraction;
    public static int[] BeatRejectionFlag;
    public static int[] LowRRValue;
    public static int[] HighRRValue;
    public static int[] PVCRejection;
    public static int[] SkipBeats;
    public static int[] HeartRate;
    public static int[] ReconstructionDiameter;
    public static int[] DistanceSourceToDetector;
    public static int[] DistanceSourceToPatient;
    public static int[] GantryDetectorTilt;
    public static int[] GantryDetectorSlew;
    public static int[] TableHeight_CT;
    public static int[] RotationDirection;
    public static int[] FieldOfViewShape;
    public static int[] FieldOfViewDimension;
    public static int[] ExposureTime;
    public static int[] XRayTubeCurrent;
    public static int[] Exposure;
    public static int[] FilterType;
    public static int[] GeneratorPower;
    public static int[] CollimatorGridName;
    public static int[] CollimatorType;
    public static int[] FocalSpots;
    public static int[] DateOfLastCalibration;
    public static int[] TimeOfLastCalibration;
    public static int[] ConvolutionKernel;
    public static int[] ActualFrameDuration;
    public static int[] PatientPosition;
    public static int[] NumberOfCellsIInDectector;
    public static int[] CellNumberAtTheta;
    public static int[] CellSpacing;
    public static int[] HorizFrameOfRef;
    public static int[] SeriesContrast;
    public static int[] FirstScanRAS;
    public static int[] LastScanRAS;
    public static int[] TableSpeed;
    public static int[] MidScanTime;
    public static int[] MidScanFlag;
    public static int[] DegreesOfAzimuth;
    public static int[] GantryPeriod;
    public static int[] NumberOfTriggers;
    public static int[] AngleOfFirstView;
    public static int[] TriggerFrequency;
    public static int[] ScanFOVType;
    public static int[] SegmentNumber;
    public static int[] TotalSegmentsRequested;
    public static int[] ViewCompressionFactor;
    public static int[] ReconPostProcFlag;
    public static int[] DependentOnNumViewsProcessed;
    public static int[] StudyInstanceUID;
    public static int[] SeriesInstanceUID;
    public static int[] StudyID;
    public static int[] SeriesNumber;
    public static int[] AcquisitionNumber;
    public static int[] InstanceNumber;
    public static int[] PatientOrientation;
    public static int[] ImagePositionPatient;
    public static int[] ImageOrientationPatient;
    public static int[] FrameOfReferenceUID;
    public static int[] Laterality;
    public static int[] ImagesInAcquisition;
    public static int[] PositionReferenceIndicator;
    public static int[] SliceLocation;
    public static int[] ImageComments;
    public static int[] SeriesFromWhichPrescribed;
    public static int[] SeriesPrescribedFrom;
    public static int[] ImagePrescribedFrom;
    public static int[] BiopsyPosition;
    public static int[] BiopsyTLocation;
    public static int[] BiopsyRefLocation;
    public static int[] StartTimeSecsInFirstAxial;
    public static int[] NeuroReorientationParameter;
    public static int[] NeuroWarpedImageParameter_OB;
    public static int[] NeuroImageAtlasName;
    public static int[] NeuroCorticalSurfaceLandmarkFile;
    public static int[] NeuroCorticalWarpedIndices_OB;
    public static int[] NeuroCorticalSurfaceValues;
    public static int[] NeuroPonsZCorticalSurface_OB;
    public static int[] NeuroCerebZCorticalSurface_OB;
    public static int[] NeuroThalmZCorticalSurface_OB;
    public static int[] NeuroGlobalZCorticalSurface_OB;
    public static int[] NeuroNormalsDatabaseName;
    public static int[] NeuroCorticalSurfaceIndices_OB;
    public static int[] NeuroPonsCorticalRegionZ;
    public static int[] NeuroCerebCorticalRegionZ;
    public static int[] NeuroThalmCorticalRegionZ;
    public static int[] NeuroGlobalCorticalRegionZ;
    public static int[] NeuroRegionDefinitionName;
    public static int[] NeuroCorticalOriginalIndicesl_OB;
    public static int[] NeutoAngularExt_OB;
    public static int[] SSPVersions;
    public static int[] NeuroCorticalSurfaceValues_OB;
    public static int[] SourceStudyInstanceUID;
    public static int[] SourceSeriesInstanceUID;
    public static int[] SurfaceName;
    public static int[] NormalizationRegion;
    public static int[] ScoutType;
    public static int[] VmaMamp;
    public static int[] VmaMod;
    public static int[] VmaClip;
    public static int[] SmartScanOnOffFlag;
    public static int[] PlaneType;
    public static int[] CenterRCoordOfPlaneImage;
    public static int[] CenterACoordOfPlaneImage;
    public static int[] CenterSCoordOfPlaneImage;
    public static int[] NormalRCoord;
    public static int[] NormalACoord;
    public static int[] NormalSCoord;
    public static int[] TableStartLocation;
    public static int[] TableEndLocation;
    public static int[] SamplesPerPixel;
    public static int[] PhotometricInterpretation;
    public static int[] PlanarConfiguration;
    public static int[] Rows;
    public static int[] Columns;
    public static int[] PixelSpacing;
    public static int[] PixelAspectRatio;
    public static int[] CorrectedImage;
    public static int[] BitsAllocated;
    public static int[] BitsStored;
    public static int[] HighBit;
    public static int[] PixelRepresentation;
    public static int[] SmallestImagePixelValue;
    public static int[] LargestImagePixelValue;
    public static int[] SmallestPixelValueInseries;
    public static int[] LargestPixelValueInseries;
    public static int[] PixelPaddingValue;
    public static int[] QualityControlImage;
    public static int[] BurnedInAnnotation;
    public static int[] WindowCenter;
    public static int[] WindowWidth;
    public static int[] RescaleIntercept;
    public static int[] RescaleSlope;
    public static int[] RescaleType;
    public static int[] RedPaletteColorLUTDescriptor;
    public static int[] GreenPaletteColorLUTDescriptor;
    public static int[] BluePaletteColorLUTDescriptor;
    public static int[] RedPaletteColorLUTData;
    public static int[] GreenPaletteColorLUTData;
    public static int[] BluePaletteColorLUTData;
    public static int[] LossyImageCompression;
    public static int[] LossyImageCompressionRatio;
    public static int[] ScheduledProcedureStepDescription;
    public static int[] ScheduledProtocolCodeSequence;
    public static int[] ScheduledProcedureStepID;
    public static int[] RequestedProcedureID;
    public static int[] RequestedAttributesSequence;
    public static int[] PerformedProcedureStepStartDate;
    public static int[] PerformedProcedureStepStartTime;
    public static int[] PerformedProcedureStepID;
    public static int[] PerformedProcedureStepDescription;
    public static int[] PerformedProcedureTypeDescription;
    public static int[] PerformedActionItemSequence;
    public static int[] RelationshipType;
    public static int[] VerfiyingOrganization;
    public static int[] VerificationDataTime;
    public static int[] ObservationDataTime;
    public static int[] ValueType;
    public static int[] ConceptNameCodeSequence;
    public static int[] ContinuityOfContent;
    public static int[] VerifyingObserverSequence;
    public static int[] VerifyingObserverName;
    public static int[] VerifyingObserverIdentificationCodeSequence;
    public static int[] PurposeOfReferenceCodeSequence;
    public static int[] PredecessorDocumentsSequence;
    public static int[] CompletionFlag;
    public static int[] CompletionFlagDescription;
    public static int[] VerificationFlag;
    public static int[] ContentTemplateSequence;
    public static int[] IdenticalDocumentsSequence;
    public static int[] ReferencedRequestSequence;
    public static int[] PerformedProcedureCodeSequence;
    public static int[] CurrentRequestedProcedureEvidenceSequence;
    public static int[] PertinentOtherEvidenceSequence;
    public static int[] ContentSequence;
    public static int[] ReferencedContentItemIdentifier;
    public static int[] WindowValue;
    public static int[] XRayChain;
    public static int[] NumberOfOverranges;
    public static int[] DeltaStartTime;
    public static int[] MaxOverrangesInAView;
    public static int[] CorrectedAfterGlowTerms;
    public static int[] ReferenceChannels;
    public static int[] NoViewRefChansBlocked;
    public static int[] ScanPitchRatio;
    public static int[] UniqueImageIden;
    public static int[] PrivateScanOptions;
    public static int[] RACordOfTargetReconCenter;
    public static int[] TriggerOnPosition;
    public static int[] DegreeOfRotation;
    public static int[] DASTriggerSource;
    public static int[] DASFpaGain;
    public static int[] DASOutputSource;
    public static int[] DASAdInput;
    public static int[] DASCalMode;
    public static int[] StartScanToXRayOnDelay;
    public static int[] DurationOfXRayOn;
    public static int[] NumberOfMacroRowsInDetector;
    public static int[] MacroWidthAtISOCenter;
    public static int[] DASType;
    public static int[] DASGain;
    public static int[] DASTemperature;
    public static int[] TableDirection;
    public static int[] ZSmoothingFactor;
    public static int[] ViewWeightingMode;
    public static int[] SigmaRowNumber;
    public static int[] MinimumDASValue;
    public static int[] MaximumOffsetValue;
    public static int[] NumberOfViewShifted;
    public static int[] ZTrackingFlag;
    public static int[] MeanZError;
    public static int[] ZTrackingError;
    public static int[] StartView2A;
    public static int[] NumberOfViews2A;
    public static int[] StartView1A;
    public static int[] SigmaMode;
    public static int[] NumberOfViews1A;
    public static int[] StartView2B;
    public static int[] NumberOfViews2B;
    public static int[] StartView1B;
    public static int[] NumberOfViews1B;
    public static int[] IterboneFlag;
    public static int[] PerisstalticFlag;
    public static int[] CardiacReconAlgorithm;
    public static int[] AvgHeartRateForImage;
    public static int[] TemporalResolution;
    public static int[] PctRpeakDelay;
    public static int[] EkgFullMaStartPhase;
    public static int[] EkgFullMaEndPhase;
    public static int[] EkgModulationMaxMa;
    public static int[] EkgModulationMinMa;
    public static int[] CardiacFilter;
    public static int[] CTCardiacSequence;
    public static int[] HeartRateAtConfirm;
    public static int[] AvgHeartRatePriorToConfirm;
    public static int[] MinHeartRatePriorToConfirm;
    public static int[] MaxHeartRatePriorToConfirm;
    public static int[] StdDevHeartRatePriorToConfirm;
    public static int[] NumHeartRateSamplesPriorToConfirm;
    public static int[] AutoHearRateDetectPredict;
    public static int[] SystemOptimizedHeartRate;
    public static int[] EkgMonitorType;
    public static int[] NumReconSectors;
    public static int[] RpeakTimeStamps;
    public static int[] MultiEnergySourceCount;
    public static int[] MultiEnergyScanType;
    public static int[] MultiEnergyReconType;
    public static int[] MultiEnergyImageType;
    public static int[] MultiEnergyMaterialType;
    public static int[] MultiEnergyMonochromatic;
    public static int[] MultiEnergyWeightedSubtractionWeight1;
    public static int[] MultiEnergyWeightedSubtractionWeight2;
    public static int[] MultiEnergyWeightedSubtractionType;
    public static int[] MultiEnergyAcqMethod;
    public static int[] MultiEnergyFeatAnnotName;
    public static int[] MultiEnergyNoiseReduced;
    public static int[] MultiEnergyNoiseReducedMethod;
    public static int[] SubOptimalIQString;
    public static int[] MultiEnergyHighLowRatio;
    public static int[] GSIReserved0;
    public static int[] GSIReserved1;
    public static int[] GSIReserved2;
    public static int[] GSIReserved3;
    public static int[] AnnotationmA;
    public static int[] CommandedFirstkVp;
    public static int[] CommandedFirstmA;
    public static int[] CommandedSecondkVp;
    public static int[] CommandedSecondmA;
    public static int[] MultiEnergyKVAnnotName;
    public static int[] MultiEnergyKVUnitLabel;
    public static int[] MaterialType1;
    public static int[] MaterialType2;
    public static int[] GSIScanModePreset;
    public static int[] MonoWindowLow;
    public static int[] MonoWindowHigh;
    public static int[] RawMDItemsSequence;
    public static int[] MD_Description;
    public static int[] MD1_Data;
    public static int[] MD1_Intercept;
    public static int[] MD1_Slope;
    public static int[] MD1_Attenuation_Curve;
    public static int[] NM1_Data;
    public static int[] MD2_Data;
    public static int[] MD2_Intercept;
    public static int[] MD2_Slope;
    public static int[] MD2_Attenutation_Curve;
    public static int[] NM2_Data;
    public static int[] GSI_DATA_VERSION;
    public static int[] MARs_Annotation;
    public static int[] GSI_NumberOfValues;
    public static int[] GSI_DescOfPairs;
    public static int[] GSI_PairBlending;
    public static int[] GSI_PairScale;
    public static int[] GSI_MD_XFORM;
    public static int[] ShuttleSliceGroup;
    public static int[] TableSpeedNotReachedTargetFlag;
    public static int[] HelicalShuttleFlag;
    public static int[] IterativeReconAnnotation;
    public static int[] IterativeReconMode;
    public static int[] IterativeReconConfiguration;
    public static int[] IterativeReconLevel;
    public static int[] ReconFlipRotateAnno;
    public static int[] HighResFlag;
    public static int[] RespitoryFlag;
    public static int[] ImagePositionPatientSetting;
    public static int[] ShutterMode;
    public static int[] ShutterModePercent;
    public static int[] ImageBrowserAnnotation;
    public static int[] OverlappedReconFlag;
    public static int[] RowNumberAnnotationFlag;
    public static int[] EnergyWindowRangeSequence;
    public static int[] RadiopharmaceuticalInformationSequence;
    public static int[] NumberOfRRIntervals;
    public static int[] NumberOfTimeSlots;
    public static int[] NumberOfSlices;
    public static int[] NumberOfTimeSlices;
    public static int[] TypeOfDetectorMotion;
    public static int[] ViewSequenceCode;
    public static int[] RadionuclideCodeSequence;
    public static int[] RadiopharmaceuticalCodeSequence;
    public static int[] ImageID;
    public static int[] PatientOrientationCodeSequence;
    public static int[] PatientGantryRelationshipCodeSequence;
    public static int[] SliceProgressionDirection;
    public static int[] SeriesType;
    public static int[] Units;
    public static int[] CountsSource;
    public static int[] ReprojectionMethod;
    public static int[] RandomsCorrectionMethod;
    public static int[] AttenuationCorrectionMethod;
    public static int[] DecayCorrection;
    public static int[] ReconstructionMethod;
    public static int[] DetectorLinesOfResponseUsed;
    public static int[] ScatterCorrectionMethod;
    public static int[] AxialAcceptance;
    public static int[] AxialMash;
    public static int[] TransverseMash;
    public static int[] DetectorElementSize;
    public static int[] CoincidenceWindowWidth;
    public static int[] SecondaryCountsType;
    public static int[] FrameReferenceTime;
    public static int[] PrimaryCountsAccumulated;
    public static int[] SecondaryCountsAccumulated;
    public static int[] SliceSensitivityFactor;
    public static int[] DecayFactor;
    public static int[] DoseCalibrationFactor;
    public static int[] ScatterFractionFactor;
    public static int[] DeadTimeFactor;
    public static int[] ImageIndex;
    public static int[] SOPInstanceStatus;
    public static int[] SOPAuthDateTime;
    public static int[] SOPAuthComment;
    public static int[] AuthEquipmentCertNo;
    public static int[] NeuroAdsResultsAsciiFiles;
    public static int[] NeuroAdsResultsBinaryFiles_OB;
    public static int[] SourceSeriesType;
    public static int[] NormalizationData;
    public static int[] FilterData;
    public static int[] ReformatData;
    public static int[] GroupInfoData;
    public static int[] SplashScreenData;
    public static int[] FiveSliceScreenData;
    public static int[] PolarPlotData;
    public static int[] DisplaySliceThickness;
    public static int[] UserPreferencesData;
    public static int[] MiscInfo1;
    public static int[] MiscInfo2;
    public static int[] PixelData;
    public static int[] ContentLabel;
    public static int[] ContentDescription;
    public static int[] PresentationCreationDate;
    public static int[] PresentationCreationTime;
    public static int[] CreatorName;
    public static int[] ReferencedFrameNumber;
    public static int[] FrameOfReferenceTransformComment;
    public static int[] MatrixRegistrationSequence;
    public static int[] RegistrationObjectSequence;
    public static int[] TransformMatrix;
    public static int[] TransformMatrixType;
    public static int[] MatrixSequence;
    public static int[] OtherStudies;
    public static int[] RegistrationReferencedImageSequence;
    public static int[] ReferencedSeriesSequence;
    public static int[] RegistrationTypeCodeSequence;
    public static int[] ReferencedSOPSequence;
    public static int[] WindowWidthCenterExplanation;
    public static int[] SoftcopyVOILUTSequence;
    public static int[] SoftcopyLUTDescriptor;
    public static int[] SoftcopyLUTExplanation;
    public static int[] SoftcopyLUTData;
    public static int[] DisplayedAreaTopLeftHandCorner;
    public static int[] DisplayedAreaBottomRightHandCorner;
    public static int[] PresentationSizeMode;
    public static int[] PresentationPixelSpacing;
    public static int[] PresentationPixelAspectRatio;
    public static int[] PixelMagnificationRatio;
    public static int[] DisplayedAreaSelectionSequence;
    public static int[] TextBoundingBoxAnnotationUnits;
    public static int[] AnchorPointAnnotationUnits;
    public static int[] UnformattedTextValue;
    public static int[] BoundingBoxTopLeftHandCorner;
    public static int[] BoundingBoxBottomRightHandCorner;
    public static int[] BoundingBoxTextHorizontalJustification;
    public static int[] AnchorPoint;
    public static int[] AnchorPointVisibility;
    public static int[] TextObjectSequenceValue;
    public static int[] GraphicBoundingBoxAnnotationUnits;
    public static int[] GraphicDimensions;
    public static int[] GraphicPoints;
    public static int[] GraphicData;
    public static int[] GraphicType;
    public static int[] GraphicFilled;
    public static int[] GraphicLayer;
    public static int[] GraphicLayerOrder;
    public static int[] GraphicLayerRecommendedDisplayGrayscaleValue;
    public static int[] GraphicLayerRecommendedDisplayCIELabValue;
    public static int[] GraphicLayerDescription;
    public static int[] GraphicLayerSequence;
    public static int[] ImageRotation;
    public static int[] ImageHorizontalFlip;
    public static int[] BlendPosition;
    public static int[] PresentationStateBlendingSequence;
    public static int[] BlendingPercentage;
    public static int[] SpatialRegistrationSequence;
    public static int[] ICCProfile;
    public static int[] GraphicObjectSequence;
    public static int[] GraphicAnnotationSequence;
    public static int[] PresentationLUTSequence;
    public static int[] PresentationLUTShape;
    public static int[] DisplayShutterShape;
    public static int[] DisplayShutterLeftEdge;
    public static int[] DisplayShutterRightEdge;
    public static int[] DisplayShutterUpperEdge;
    public static int[] DisplayShutterLowerEdge;
    public static int[] CircularCenter;
    public static int[] CircularRadius;
    public static int[] PolygonVertices;
    public static int[] DisplayShutterPresentationValue;
    private static XpDicomElement pixtype;
    private static XpDicomElement pixballoc;
    private static DMTag dmatg_pixtype;
    private static DMTag dmtag_pixballoc;
    private static DMTag wwtag;
    private static DMTag wltag;

    public static DMElement getDMElement(int[] gePair) {
        DMElement elem = new DMElement(gePair[0], gePair[1]);
        return elem;
    }

    public static DMTag getDMTag(int[] gePair) {
        DMTag tag2 = new DMTag(gePair[0], gePair[1]);
        return tag2;
    }

    public static DMElement[] getDMElements(int[][] gePairs) {
        DMElement[] elems = new DMElement[gePairs.length];
        for (int i2 = 0; i2 < gePairs.length; ++i2) {
            elems[i2] = new DMElement(gePairs[i2][0], gePairs[i2][1]);
        }
        return elems;
    }

    public static DMElement getDMElement(int[] gePair, Object value) {
        DMElement elem = new DMElement(gePair[0], gePair[1]);
        elem.value = value;
        return elem;
    }

    public static void assignNewTag(int group, int element, String description, int vr2, String vm) {
        jdbDicomDict dictionary = dicomParser.dict;
        if (element == 16) {
            dictionary.addTag(group, element, description, 19535, vm);
        } else {
            dictionary.addTag(group, element, description, vr2, vm);
        }
        if (group % 2 == 1 && element < 256) {
            dictionary.addTag(group, 4096 + element, description, vr2, vm);
        }
    }

    public static DMTag getPrivateTag(DMObject dmObject, int[] tag2, String creatorID) throws DMException {
        return DicomUtils.getPrivateTag(dmObject, tag2[0], tag2[1], creatorID);
    }

    public static DMTag getPrivateTag(DMObject dmObject, int group, int privateElement, String creatorID) throws DMException {
        int element;
        if ((group & 1) == 0) {
            throw new DMException("This method is for private tags only");
        }
        if (privateElement > 255) {
            throw new DMException("Private element must be only the low byte, it must be < 256");
        }
        int thisCreatorElement = 0;
        int freeCreatorElement = 0;
        for (element = 16; element < 256; ++element) {
            Object creatorIDValue = dmObject.getValue(group, element);
            if (creatorIDValue == null && freeCreatorElement == 0) {
                freeCreatorElement = element;
            }
            if (!creatorID.equals(creatorIDValue)) continue;
            thisCreatorElement = element;
            break;
        }
        if (thisCreatorElement == 0) {
            thisCreatorElement = freeCreatorElement;
            DMElement pcid = new DMElement(group, thisCreatorElement);
            pcid.value = creatorID;
            pcid.vrep = 21332;
            dmObject.setValues(new DMElement[]{pcid});
        }
        element = (thisCreatorElement << 8) + privateElement;
        DMTag tag2 = new DMTag(creatorID, group, element);
        return tag2;
    }

    public static int getPrivateValues(XpDicomObject dmo, XpDicomElement[] tags, String creatorID) throws DMException {
        int res = 0;
        for (int i2 = 0; i2 < tags.length; ++i2) {
            res += DicomUtils.getPrivateValue(dmo, tags[i2], creatorID);
        }
        return res;
    }

    public static int getPrivateValue(XpDicomObject dmo, XpDicomElement tag2, String creatorID) throws DMException {
        int key;
        if ((tag2.group & 1) == 0) {
            throw new DMException("This method is for private tags only");
        }
        if (tag2.element > 255) {
            throw new DMException("Private element must be only the low byte, it must be < 256");
        }
        XpDicomElement cid = new XpDicomElement(tag2.group, 0);
        for (key = 16; key < 256; ++key) {
            cid.element = key;
            if (dmo.getValue(cid) == 0 && creatorID.equals(cid.value)) break;
        }
        if (key == 256) {
            return 1;
        }
        XpDicomElement ptag = new XpDicomElement(tag2.group, (key << 8) + tag2.element);
        int res = dmo.getValue(ptag);
        tag2.value = ptag.value;
        return res;
    }

    private static String to4Hex(int i2) {
        String result = Integer.toHexString(i2);
        if (i2 < 16) {
            return "0x000" + result;
        }
        if (i2 < 256) {
            return "0x00" + result;
        }
        if (i2 < 4096) {
            return "0x0" + result;
        }
        return "0x" + result;
    }

    public static void main(String[] argv) {
        Field[] dicomDictFields = DicomUtils.class.getFields();
        System.out.println("DicomUtils fields (" + dicomDictFields.length + " fields)");
        for (int i2 = 0; i2 < dicomDictFields.length; ++i2) {
            class DicomTag {
                public String name;
                public int group;
                public int element;

                public DicomTag(String name, int group, int element) {
                    this.name = name;
                    this.group = group;
                    this.element = element;
                }

                public String toString() {
                    String result = "(" + DicomUtils.to4Hex(this.group) + "," + DicomUtils.to4Hex(this.element) + "): " + this.name;
                    return result;
                }
            }
            DicomTag pp;
            Field thisField = dicomDictFields[i2];
            try {
                int[] ge = (int[])thisField.get(null);
                pp = new DicomTag(thisField.getName(), ge[0], ge[1]);
            }
            catch (Exception ex) {
                pp = new DicomTag(thisField.getName(), 0, 0);
                ex.printStackTrace();
            }
            System.out.println(pp.toString());
        }
    }

    public static int getBitsPerPix(XpDicomObject img) {
        img.getValue(pixtype);
        img.getValue(pixballoc);
        return DicomUtils.bitsPerPix(((String)DicomUtils.pixtype.value).trim(), (Integer)DicomUtils.pixballoc.value);
    }

    public static int getBitsPerPix(XjDicomObject img) {
        String pixType = (String)img.getValue(DicomUtils.pixtype.group, DicomUtils.pixtype.element);
        Integer pixAlloc = (Integer)img.getValue(DicomUtils.pixballoc.group, DicomUtils.pixballoc.element);
        return DicomUtils.bitsPerPix(pixType.trim(), pixAlloc);
    }

    public static int getBitsPerPix(DMTagValueInterface img) {
        String pixType = (String)img.getValue(dmatg_pixtype);
        Integer pixAlloc = (Integer)img.getValue(dmtag_pixballoc);
        return DicomUtils.bitsPerPix(pixType.trim(), pixAlloc);
    }

    private static int bitsPerPix(String pixType, int pixalloc) {
        int bitsPerPix = 0;
        if (pixType.equals("MONOCHROME2") || pixType.equals("MONOCHROME1")) {
            bitsPerPix = pixalloc == 16 ? 16 : 8;
        } else if (pixType.equals("RGB")) {
            bitsPerPix = 24;
        } else if (pixType.equals("PALETTE COLOR")) {
            bitsPerPix = (Integer)DicomUtils.pixballoc.value == 16 ? 16 : 8;
        }
        return bitsPerPix;
    }

    public static int getImageNumber(XpMedicalImage img) {
        if (img == null) {
            return -1;
        }
        XpDicomElement dicmElem = new XpDicomElement(32, 19);
        img.getValue(dicmElem);
        return dicmElem.getIntValue();
    }

    public static int getImageNumber(DMObject img) {
        if (img == null) {
            return -1;
        }
        if (img.getType().equalsIgnoreCase("image")) {
            Integer im_no = (Integer)img.getValue(32, 19);
            return im_no;
        }
        return -1;
    }

    public static double getWindowWidth(DMTagValueInterface img) {
        Object obj = img.getValue(wwtag);
        if (obj instanceof String) {
            StringTokenizer st = new StringTokenizer((String)obj, "\\");
            return Float.parseFloat(st.nextToken());
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).intValue();
        }
        if (obj instanceof Float) {
            return ((Float)obj).floatValue();
        }
        return 0.0;
    }

    public static double getWindowLevel(DMTagValueInterface img) {
        Object obj = img.getValue(wltag);
        if (obj instanceof String) {
            StringTokenizer st = new StringTokenizer((String)obj, "\\");
            return Float.parseFloat(st.nextToken());
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).intValue();
        }
        if (obj instanceof Float) {
            return ((Float)obj).floatValue();
        }
        return 0.0;
    }

    public static double getWindowWidth(XjDicomObject img) {
        Object obj = img.getValue(40, 4177);
        if (obj instanceof String) {
            StringTokenizer st = new StringTokenizer((String)obj, "\\");
            return Float.parseFloat(st.nextToken());
        }
        if (obj instanceof Float) {
            return ((Float)obj).floatValue();
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).intValue();
        }
        return 0.0;
    }

    public static double getWindowLevel(XjDicomObject img) {
        Object obj = img.getValue(40, 4176);
        if (obj instanceof String) {
            StringTokenizer st = new StringTokenizer((String)obj, "\\");
            return Float.parseFloat(st.nextToken());
        }
        if (obj instanceof Float) {
            return ((Float)obj).floatValue();
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).intValue();
        }
        return 0.0;
    }

    public static String getModality(DMTagValueInterface dmObject) {
        String modality = (String)dmObject.getValue(new DMTag(8, 96));
        return DicomUtils.getModality(modality);
    }

    public static String getModality(XjDicomObject dmObject) {
        String modality = (String)dmObject.getValue(8, 96);
        return DicomUtils.getModality(modality);
    }

    public static String getModality(DMImage image) {
        if (image == null) {
            return null;
        }
        String modality = (String)image.getValue(8, 96);
        return DicomUtils.getModality(modality);
    }

    public static String getModality(XpDicomObject image) {
        if (image == null) {
            return null;
        }
        XpDicomElement el = new XpDicomElement(8, 96);
        image.getValue(el);
        return DicomUtils.getModality(el.getStringValue());
    }

    public static String getModality(String modality) {
        if (modality == null) {
            return " ";
        }
        String modality_ = modality.trim();
        if (modality_.equalsIgnoreCase("CT")) {
            return "CT";
        }
        if (modality_.equalsIgnoreCase("MR")) {
            return "MR";
        }
        if (modality_.equalsIgnoreCase("GEMS PET RAW")) {
            return "Raw";
        }
        if (modality_.equalsIgnoreCase("PT")) {
            return "PT";
        }
        if (modality_.equalsIgnoreCase("PR")) {
            return "PR";
        }
        if (modality_.equalsIgnoreCase("SR")) {
            return "SR";
        }
        return modality_;
    }

    public static String getImageType(DMTagValueInterface dmobj, boolean actualType) {
        if (dmobj == null) {
            return null;
        }
        String imageType = (String)dmobj.getValue(new DMTag(8, 8));
        String sopClassUid = (String)dmobj.getValue(new DMTag(8, 22));
        String modality = DicomUtils.getModality(dmobj);
        String petSeriesType = null;
        if (modality.equalsIgnoreCase("pt")) {
            petSeriesType = (String)dmobj.getValue(new DMTag(84, 4096));
        }
        return DicomUtils.getImageType(modality, imageType, sopClassUid, petSeriesType, actualType);
    }

    public static String getImageType(XjDicomObject dmobj, boolean actualType) {
        if (dmobj == null) {
            return null;
        }
        String imageType = (String)dmobj.getValue(8, 8);
        String sopClassUid = (String)dmobj.getValue(8, 22);
        String modality = DicomUtils.getModality(dmobj);
        String petSeriesType = null;
        if (modality.equalsIgnoreCase("pt")) {
            petSeriesType = (String)dmobj.getValue(84, 4096);
        }
        return DicomUtils.getImageType(modality, imageType, sopClassUid, petSeriesType, actualType);
    }

    public static String getImageType(DMImage image, boolean actualType) {
        if (image == null) {
            return null;
        }
        String imageType = (String)image.getValue(8, 8);
        String sopClassUid = (String)image.getValue(8, 22);
        String modality = DicomUtils.getModality(image);
        String petSeriesType = null;
        if (modality.equalsIgnoreCase("pt")) {
            petSeriesType = (String)image.getValue(84, 4096);
        }
        return DicomUtils.getImageType(modality, imageType, sopClassUid, petSeriesType, actualType);
    }

    public static String getImageType(XpDicomObject dmobj, boolean actualType) {
        if (dmobj == null) {
            return null;
        }
        XpDicomElement deImgType = new XpDicomElement(8, 8);
        dmobj.getValue(deImgType);
        XpDicomElement deSopUid = new XpDicomElement(8, 22);
        dmobj.getValue(deSopUid);
        String imageType = deImgType != null ? deImgType.getStringValue() : null;
        String sopClassUid = deSopUid != null ? deSopUid.getStringValue() : null;
        String modality = DicomUtils.getModality(dmobj);
        String petSeriesType = null;
        if (modality.equalsIgnoreCase("pt")) {
            XpDicomElement deSeType = new XpDicomElement(84, 4096);
            dmobj.getValue(deSeType);
            petSeriesType = deSeType != null ? deSeType.getStringValue() : null;
        }
        return DicomUtils.getImageType(modality, imageType, sopClassUid, petSeriesType, actualType);
    }

    public static String getImageType(XpMedicalImage image, boolean actualType) {
        if (image == null) {
            return null;
        }
        XpDicomElement imgType = new XpDicomElement(8, 8);
        XpDicomElement sopuid = new XpDicomElement(8, 22);
        image.getValue(imgType);
        image.getValue(sopuid);
        String modality = DicomUtils.getModality(image);
        String petSeriesType = null;
        if (modality.equalsIgnoreCase("pt")) {
            XpDicomElement ptstype = new XpDicomElement(84, 4096);
            image.getValue(ptstype);
            petSeriesType = ptstype.getStringValue();
        }
        return DicomUtils.getImageType(modality, imgType.getStringValue(), sopuid.getStringValue(), petSeriesType, actualType);
    }

    private static String getImageType(String modality, String imageType, String sopClassUid, String petSeriesType, boolean actualType) {
        if (modality.equalsIgnoreCase("ct")) {
            return DicomUtils.getCTImageType(imageType, sopClassUid, actualType);
        }
        if (modality.equalsIgnoreCase("mr")) {
            return DicomUtils.getMRImageType(imageType, sopClassUid, actualType);
        }
        if (modality.equalsIgnoreCase("pt")) {
            return DicomUtils.getPTImageType(imageType, sopClassUid, petSeriesType, actualType);
        }
        if (sopClassUid != null) {
            if (sopClassUid.equals("1.2.840.10008.5.1.4.1.1.7")) {
                return "SSAVE";
            }
            if (sopClassUid.equals("1.2.840.10008.5.1.4.1.1.11.1")) {
                return "GSPS";
            }
            if (sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.11") || sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.22") || sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.33")) {
                return "SR";
            }
        }
        return null;
    }

    public static String getCTImageType(DMObject seriesObj, boolean actualType) {
        if (seriesObj == null) {
            return null;
        }
        String imageType = (String)seriesObj.getValue(8, 8);
        String sopClassUid = (String)seriesObj.getValue(8, 22);
        return DicomUtils.getCTImageType(imageType, sopClassUid, actualType);
    }

    public static String getCTImageType(String imageType, String sopClassUid, boolean actualType) {
        int i2;
        String[] imgTypeStr = new String[4];
        if (imageType != null) {
            StringTokenizer st = new StringTokenizer(imageType, "\\");
            for (i2 = 0; st.hasMoreTokens() && i2 < 4; ++i2) {
                imgTypeStr[i2] = st.nextToken();
            }
        }
        while (i2 < 4) {
            imgTypeStr[i2] = "";
            ++i2;
        }
        if (imgTypeStr[0].equals("") && imgTypeStr[1].equals("") && imgTypeStr[2].equals("")) {
            if (sopClassUid != null && sopClassUid.equals("1.2.840.113619.4.26")) {
                return "3DMOD";
            }
            if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.11.1")) {
                return "GSPS";
            }
            if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.11")) {
                return "SR";
            }
            if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.22")) {
                return "SR";
            }
            if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.33")) {
                return "SR";
            }
            return "SSAVE";
        }
        if (imgTypeStr[0].equals("ORIGINAL")) {
            if (imgTypeStr[1].equals("PRIMARY")) {
                if (imgTypeStr[2].equals("AXIAL")) {
                    return "PROSP";
                }
                if (imgTypeStr[2].equals("LOCALIZER")) {
                    return "SCOUT";
                }
                if (imgTypeStr[2].equals("CTINTERVENTION")) {
                    if (imgTypeStr[3].equals("")) {
                        return "CTINT";
                    }
                    return "UNKNOWN";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.7")) {
                    return "SSAVE";
                }
                return "UNKNOWN";
            }
            if (imgTypeStr[1].equals("SECONDARY")) {
                if (imgTypeStr[2].equals("AXIAL") || imgTypeStr[2].equals("SEGMENTED")) {
                    return "RETRO";
                }
                if (imgTypeStr[2].equals("CTINTERVENTION")) {
                    if (imgTypeStr[3].equals("")) {
                        return "CTINT";
                    }
                    return "UNKNOWN";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.7")) {
                    return "SSAVE";
                }
                return "UNKNOWN";
            }
        }
        if (imgTypeStr[0].equals("DERIVED")) {
            if (imgTypeStr[1].equals("PRIMARY")) {
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.7")) {
                    return "SSAVE";
                }
                if (imgTypeStr[2].equals("AXIAL")) {
                    return "PROSP";
                }
                if (imgTypeStr[2].equals("LOCALIZER")) {
                    return "SCOUT";
                }
                return "UNKNOWN";
            }
            if (imgTypeStr[1].equals("SECONDARY")) {
                if (imgTypeStr[2].equals("REFORMATTED")) {
                    return "REFMT";
                }
                if (imgTypeStr[2].equals("PROCESSED")) {
                    return "PROC";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.113619.4.26")) {
                    return "3DMOD";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.11.1")) {
                    return "GSPS";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.11")) {
                    return "SR";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.22")) {
                    return "SR";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.33")) {
                    return "SR";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.7")) {
                    if (imgTypeStr[2].equals("3D")) {
                        return "3D";
                    }
                    if (imgTypeStr[2].equals("COMBINED")) {
                        return "COMB";
                    }
                    return "SSAVE";
                }
            }
        }
        return "UNKNOWN";
    }

    public static String getMRImageType(DMObject seriesObj, boolean actualType) {
        if (seriesObj == null) {
            return null;
        }
        String imageType = (String)seriesObj.getValue(8, 8);
        String sopClassUid = (String)seriesObj.getValue(8, 22);
        return DicomUtils.getMRImageType(imageType, sopClassUid, actualType);
    }

    public static String getMRImageType(String imageType, String sopClassUid, boolean actualType) {
        boolean secondaryCapture;
        int i2;
        String[] imgTypeStr = new String[4];
        if (imageType != null) {
            StringTokenizer st = new StringTokenizer(imageType, "\\");
            for (i2 = 0; st.hasMoreTokens() && i2 < 4; ++i2) {
                imgTypeStr[i2] = st.nextToken();
            }
        }
        while (i2 < 4) {
            imgTypeStr[i2] = "";
            ++i2;
        }
        if (imgTypeStr[0].equals("") && imgTypeStr[1].equals("") && imgTypeStr[2].equals("") && imgTypeStr[3].equals("")) {
            if (sopClassUid != null && sopClassUid.equals("1.2.840.113619.4.26")) {
                return "3DMOD";
            }
            if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.11.1")) {
                return "GSPS";
            }
            if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.11")) {
                return "SR";
            }
            if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.22")) {
                return "SR";
            }
            if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.33")) {
                return "SR";
            }
            return "SSAVE";
        }
        boolean bl = secondaryCapture = sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.7");
        if (imgTypeStr[0].equals("ORIGINAL")) {
            if (imgTypeStr[1].equals("PRIMARY")) {
                if (secondaryCapture) {
                    return "SSAVE";
                }
                if (actualType) {
                    if (imgTypeStr[2].equals("OTHER")) {
                        return "PROSP";
                    }
                    return imgTypeStr[2].trim();
                }
                return "PROSP";
            }
            if (imgTypeStr[1].equals("SECONDARY")) {
                if (secondaryCapture) {
                    return "SSAVE";
                }
                if (actualType) {
                    return imgTypeStr[2].trim();
                }
                return "PROSP";
            }
            return "UNKNOWN";
        }
        if (imgTypeStr[0].equals("DERIVED")) {
            if (imgTypeStr[1].equals("PRIMARY")) {
                if (imgTypeStr[2].equals("PROJECTION IMAGE") || imgTypeStr[2].equals("PJN")) {
                    if (imgTypeStr[3].equals("IVI")) {
                        return "PJN";
                    }
                    if (imgTypeStr[3].equals("COLLAPSE") || imgTypeStr[3].equals("VASCULAR")) {
                        return "PROSP";
                    }
                    return "SSAVE";
                }
                if (secondaryCapture) {
                    return "SSAVE";
                }
                if (imgTypeStr[2].equals("PASTED")) {
                    return "PASTED";
                }
                if (actualType) {
                    return imgTypeStr[2].trim();
                }
                if (imgTypeStr[2].equals("CMB")) {
                    return "PROSP";
                }
                return "PROC";
            }
            if (imgTypeStr[1].equals("SECONDARY")) {
                if (imgTypeStr[2].equals("REFORMATTED") || imgTypeStr[2].equals("MPR")) {
                    return "REFMT";
                }
                if (imgTypeStr[2].equals("PROCESSED") || imgTypeStr[2].equals("PROC")) {
                    return "PROC";
                }
                if (imgTypeStr[2].equals("PROJECTION IMAGE") || imgTypeStr[2].equals("PJN")) {
                    return "PJN";
                }
                if (imgTypeStr[2].equals("COMBINED") || imgTypeStr[2].equals("COMB")) {
                    return "COMB";
                }
                if (imgTypeStr[2].equals("PASTED") || imageType.trim().endsWith("PASTED")) {
                    return "PASTED";
                }
                if (secondaryCapture) {
                    if (imgTypeStr[2].equals("3D")) {
                        return "3D";
                    }
                    if (actualType) {
                        return "SSAVE";
                    }
                    if (imgTypeStr[2].equals("COMBINED") || imgTypeStr[2].equals("COMB")) {
                        return "COMB";
                    }
                    return "SSAVE";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.113619.4.26")) {
                    return "3DMOD";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.11.1")) {
                    return "GSPS";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.11")) {
                    return "SR";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.22")) {
                    return "SR";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.88.33")) {
                    return "SR";
                }
                return "UNKNOWN";
            }
        }
        return "UNKNOWN";
    }

    public static String getPTImageType(DMObject seriesObj, boolean actualType) {
        if (seriesObj == null) {
            return null;
        }
        String imageType = (String)seriesObj.getValue(8, 8);
        String sopClassUid = (String)seriesObj.getValue(8, 22);
        String petSeriesType = (String)seriesObj.getValue(84, 4096);
        return DicomUtils.getPTImageType(imageType, sopClassUid, petSeriesType, actualType);
    }

    public static String getPTImageType(String imageType, String sopClassUid, String PETSeriesType, boolean actualType) {
        String[] ptSeriesTypeStr;
        int i2;
        if (imageType == null) {
            return "";
        }
        String[] imgTypeStr = new String[4];
        if (imageType != null) {
            StringTokenizer st = new StringTokenizer(imageType, "\\");
            for (i2 = 0; st.hasMoreTokens() && i2 < 4; ++i2) {
                imgTypeStr[i2] = st.nextToken();
            }
        }
        while (i2 < 4) {
            imgTypeStr[i2] = "";
            ++i2;
        }
        if (PETSeriesType != null) {
            StringTokenizer ptSeriesTypeTok = new StringTokenizer(PETSeriesType, "\\");
            ptSeriesTypeStr = new String[ptSeriesTypeTok.countTokens()];
            i2 = 0;
            while (ptSeriesTypeTok.hasMoreTokens()) {
                ptSeriesTypeStr[i2] = ptSeriesTypeTok.nextToken();
                ++i2;
            }
        } else {
            ptSeriesTypeStr = new String[]{""};
        }
        if (imgTypeStr[0].equals("") && imgTypeStr[1].equals("") && imgTypeStr[2].equals("")) {
            if (sopClassUid != null && sopClassUid.equals("1.2.840.113619.4.26")) {
                return "3DMOD";
            }
            return "SSAVE";
        }
        if (imgTypeStr[0].equals("ORIGINAL") && (imgTypeStr[1].equals("PRIMARY") || imgTypeStr[1].equals("SECONDARY"))) {
            if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.7")) {
                return "SSAVE";
            }
            if (imgTypeStr[2].equals("")) {
                return ptSeriesTypeStr[0].trim();
            }
            return imgTypeStr[2].trim();
        }
        if (imgTypeStr[0].equals("DERIVED")) {
            if (imgTypeStr[1].equals("PRIMARY")) {
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.7")) {
                    return "SSAVE";
                }
                if (imgTypeStr[2].equals("AXIAL")) {
                    return "PROSP";
                }
                if (imgTypeStr[2].equals("LOCALIZER")) {
                    return "SCOUT";
                }
                if (imgTypeStr[2].equals("REFORMATTED") || imgTypeStr[2].equals("")) {
                    return "REFMT";
                }
                return imgTypeStr[2].trim();
            }
            if (imgTypeStr[1].equals("SECONDARY")) {
                if (imgTypeStr[2].equals("REFORMATTED")) {
                    return "REFMT";
                }
                if (imgTypeStr[2].equals("PROCESSED")) {
                    return "PROC";
                }
                if (sopClassUid != null && sopClassUid.equals("1.2.840.10008.5.1.4.1.1.7")) {
                    if (imgTypeStr[2].equals("3D")) {
                        return "3D";
                    }
                    if (imgTypeStr[2].equals("COMBINED")) {
                        return "COMB";
                    }
                    return "SSAVE";
                }
                if (imgTypeStr[2].equals("")) {
                    return "REFMT";
                }
                return imgTypeStr[2].trim();
            }
            return "REFMT";
        }
        return "";
    }

    public static boolean isMRProbeQImage(XpDicomObject dobj) {
        boolean probeQ = false;
        XpDicomElement swVersion = new XpDicomElement(24, 4128);
        XpDicomElement Manufacturer = new XpDicomElement(8, 112);
        XpDicomElement usage_tag = new XpDicomElement(67, 4149);
        XpDicomElement signature_43 = new XpDicomElement(67, 16);
        XpDicomElement GEMS_spectro_quantitations = new XpDicomElement(67, 4243);
        dobj.getValue(swVersion);
        dobj.getValue(Manufacturer);
        dobj.getValue(usage_tag);
        dobj.getValue(signature_43);
        dobj.getValue(GEMS_spectro_quantitations);
        boolean mfgByGE = false;
        mfgByGE = Manufacturer.value != null && ((String)Manufacturer.value).trim().equals("GE MEDICAL SYSTEMS");
        String sw_version = (String)swVersion.value;
        Integer ex_verscre = null;
        try {
            ex_verscre = mfgByGE && sw_version != null ? new Integer(sw_version.split("\\\\")[0]) : new Integer(0);
        }
        catch (Exception e2) {
            // empty catch block
        }
        boolean GEMS_signature_43 = false;
        GEMS_signature_43 = signature_43.value != null && ((String)signature_43.value).trim().equals("GEMS_PARM_01");
        Long GEMS_usage_tag = null;
        if (usage_tag.value instanceof Integer) {
            GEMS_usage_tag = GEMS_signature_43 && usage_tag != null ? new Long(((Integer)usage_tag.value).intValue()) : null;
        } else {
            Long l2 = GEMS_usage_tag = GEMS_signature_43 && usage_tag != null ? (Long)usage_tag.value : null;
        }
        if (ex_verscre != null && ex_verscre < 14) {
            if (GEMS_usage_tag != null && GEMS_usage_tag.intValue() == 1) {
                probeQ = true;
            }
        } else if (GEMS_spectro_quantitations.value != null) {
            probeQ = true;
        }
        return probeQ;
    }

    public static String getImageType(XjDicomObject dobj) {
        String modality = DicomUtils.getModality(dobj);
        String imgType = DicomUtils.getImageType(dobj, false);
        modality = modality.trim().toUpperCase();
        if ((imgType = imgType.trim().toUpperCase()).indexOf("EN SAVE") >= 0 || imgType.indexOf("VXTL STATE") >= 0 || imgType.indexOf("3D") >= 0) {
            return "SSAVE";
        }
        if (modality.equals("CT")) {
            modality = imgType.indexOf("LOCALIZER") >= 0 ? modality + "_SCOUT" : modality + "_REGULAR";
        }
        return modality;
    }

    public static String getImageType(XpDicomObject dobj) {
        String modality = DicomUtils.getModality(dobj);
        String imgType = DicomUtils.getImageType(dobj, false);
        if (modality != null) {
            modality = modality.trim().toUpperCase();
        }
        if (imgType != null) {
            imgType = imgType.trim().toUpperCase();
        }
        if (modality == null || imgType == null) {
            return null;
        }
        if (imgType.indexOf("EN SAVE") >= 0 || imgType.indexOf("VXTL STATE") >= 0 || imgType.indexOf("3D") >= 0) {
            return "SSAVE";
        }
        if (modality.equals("CT")) {
            modality = imgType.indexOf("LOCALIZER") >= 0 ? modality + "_SCOUT" : modality + "_REGULAR";
        }
        return modality;
    }

    public static boolean getGEMS_signature_29(DMObject dmObject) {
        String signature_29 = (String)dmObject.getValue(41, 16);
        return signature_29 != null && signature_29.trim().equals("GEMS_CT_FLRO_1");
    }

    public static String getImplementationClassUID(String modality) {
        if ("CT".equalsIgnoreCase(modality)) {
            return "1.2.840.113619.6.144";
        }
        return "";
    }

    static {
        int i2;
        CT_SOP_CLASS_UID = "1.2.840.10008.5.1.4.1.1.2";
        PET_SOP_CLASS_UID = "1.2.840.10008.5.1.4.1.1.128";
        SC_SOP_CLASS_UID = "1.2.840.10008.5.1.4.1.1.7";
        BSPS_SOP_CLASS_UID = "1.2.840.10008.5.1.4.1.1.11.4";
        REG_OBJ_SOP_CLASS_UID = "1.2.840.10008.5.1.4.1.1.66.1";
        MR_SOP_CLASS_UID = "1.2.840.10008.5.1.4.1.1.4";
        NM_SOP_CLASS_UID = "1.2.840.10008.5.1.4.1.1.20";
        US_SOP_CLASS_UID = "1.2.840.10008.5.1.4.1.1.6.1";
        sopInstanceUID = new XpDicomElement(8, 24);
        sopClassUID = new XpDicomElement(8, 22);
        studyID = new XpDicomElement(32, 13);
        seriesUID = new XpDicomElement(32, 14);
        seriesNo = new XpDicomElement(32, 17);
        imageNo = new XpDicomElement(32, 19);
        ARRAY_SEPARATOR = "\\";
        FileMetaInformationVersion = new int[]{2, 1};
        MediaStorageSOPClassUID = new int[]{2, 2};
        MediaStorageSOPInstanceUID = new int[]{2, 3};
        TransferSyntaxUID = new int[]{2, 16};
        ImplementationClassUID = new int[]{2, 18};
        ImplementationVersionName = new int[]{2, 19};
        PrivateInformationCreatorUID = new int[]{2, 256};
        PrivateInformation = new int[]{2, 258};
        SpecificCharacterSet = new int[]{8, 5};
        ImageType = new int[]{8, 8};
        InstanceCreationDate = new int[]{8, 18};
        InstanceCreationTime = new int[]{8, 19};
        InstanceCreatorUID = new int[]{8, 20};
        SOPClassUID = new int[]{8, 22};
        SOPInstanceUID = new int[]{8, 24};
        StudyDate = new int[]{8, 32};
        SeriesDate = new int[]{8, 33};
        AcquisitionDate = new int[]{8, 34};
        ContentDate = new int[]{8, 35};
        StudyTime = new int[]{8, 48};
        SeriesTime = new int[]{8, 49};
        AcquisitionTime = new int[]{8, 50};
        ContentTime = new int[]{8, 51};
        AccessionNumber = new int[]{8, 80};
        Modality = new int[]{8, 96};
        ConversionType = new int[]{8, 100};
        Manufacturer = new int[]{8, 112};
        InstitutionName = new int[]{8, 128};
        InstitutionAddress = new int[]{8, 129};
        ReferringPhysiciansName = new int[]{8, 144};
        CodeValue = new int[]{8, 256};
        CodingSchemeDesignator = new int[]{8, 258};
        TimeZoneOffsetFromUTC = new int[]{8, 513};
        CodeMeaning = new int[]{8, 260};
        StationName = new int[]{8, 4112};
        StudyDescription = new int[]{8, 4144};
        ProcedureCodeSequence = new int[]{8, 4146};
        SeriesDescription = new int[]{8, 4158};
        InstitutionalDepartmentName = new int[]{8, 4160};
        PhysicianOfRecord = new int[]{8, 4168};
        PerformingPhysicianName = new int[]{8, 4176};
        NameOfPhysicianReadingStudy = new int[]{8, 4192};
        NominalInterval = new int[]{8, 4194};
        OperatorsName = new int[]{8, 4208};
        AdmittingDiagnosesDescription = new int[]{8, 4224};
        IntervalsAcquired = new int[]{8, 4227};
        IntervalsRejected = new int[]{8, 4228};
        ManufacturerModelName = new int[]{8, 4240};
        ReferencedStudySequence = new int[]{8, 4368};
        ReferencedStudyComponentSequence = new int[]{8, 4369};
        ReferencedPatientSequence = new int[]{8, 4384};
        ReferencedOverlaySequence = new int[]{8, 4400};
        ReferencedImageSequence = new int[]{8, 4416};
        ReferencedCurveSequence = new int[]{8, 4421};
        ReferencedSOPClassUID = new int[]{8, 4432};
        ReferencedSOPInstanceUID = new int[]{8, 4437};
        DerivationDescription = new int[]{8, 8465};
        SourceImageSequence = new int[]{8, 8466};
        AnatomicRegionSequence = new int[]{8, 8728};
        PrimaryAnatomicStructureSequence = new int[]{8, 8744};
        CreatorVersionUID = new int[]{8, 37155};
        FullFidelity = new int[]{9, 1};
        SuiteID = new int[]{9, 2};
        ProductID = new int[]{9, 4};
        ImageActualDate = new int[]{9, 39};
        EquipmentUID = new int[]{9, 227};
        TableHeight_PET = new int[]{9, 102};
        suidOfCtUsedForAcOfPet = new int[]{9, 151};
        TracerName = new int[]{9, 4158};
        MidPhasePercentage = new int[]{9, 4323};
        PatientName = new int[]{16, 16};
        PatientID = new int[]{16, 32};
        PatientBirthDate = new int[]{16, 48};
        PatientSex = new int[]{16, 64};
        PatientBirthTime = new int[]{16, 50};
        OtherPatientIDs = new int[]{16, 4096};
        OtherPatientNames = new int[]{16, 4097};
        EthnicGroup = new int[]{16, 8544};
        PatientComments = new int[]{16, 16384};
        PatientAge = new int[]{16, 4112};
        PatientSize = new int[]{16, 4128};
        PatientWeight = new int[]{16, 4144};
        Occupation = new int[]{16, 8576};
        AdditionalPatientHistory = new int[]{16, 8624};
        gatingType = new int[]{21, 26};
        numberOfBins = new int[]{21, 27};
        respiratoryPhase = new int[]{21, 28};
        respiratoryPhaseMatchedSer = new int[]{21, 29};
        CTACPercentageVal = new int[]{21, 30};
        ContrastBolusAgent = new int[]{24, 16};
        BodyPartExamined = new int[]{24, 21};
        ScanOptions = new int[]{24, 34};
        InterventionDrugInformationSequence = new int[]{24, 38};
        SliceThickness = new int[]{24, 80};
        KV = new int[]{24, 96};
        AcquisitionTerminationCondition = new int[]{24, 113};
        AcquisitionStartCondition = new int[]{24, 115};
        AcquisitionStartConditionData = new int[]{24, 116};
        AcquisitionTerminationConditionData = new int[]{24, 117};
        SpacingBetweenSlices = new int[]{24, 136};
        DataCollectionDiameter = new int[]{24, 144};
        DeviceSerialNumber = new int[]{24, 4096};
        SecondaryCaptureDeviceID = new int[]{24, 4112};
        DateOfSecondaryCapture = new int[]{24, 4114};
        TimeOfSecondaryCapture = new int[]{24, 4116};
        SecondaryCaptureDeviceManufacturer = new int[]{24, 4118};
        SecondaryCaptureDeviceManufacturerModelName = new int[]{24, 4120};
        SecondaryCaptureDeviceSoftwareVersion = new int[]{24, 4121};
        SoftwareVersion = new int[]{24, 4128};
        VideoImageFormatAcq = new int[]{24, 4130};
        DigitalImageFormatAcq = new int[]{24, 4131};
        ProtocolName = new int[]{24, 4144};
        Radiopharmaceutical = new int[]{24, 49};
        ContrastBolusRoute = new int[]{24, 4160};
        SpatialResolution = new int[]{24, 4176};
        TriggerTime = new int[]{24, 4192};
        TriggerSourceOrType = new int[]{24, 4193};
        FrameTime = new int[]{24, 4195};
        FramingType = new int[]{24, 4196};
        RadionuclideVolume = new int[]{24, 4209};
        RadiopharmaceuticalStartTime = new int[]{24, 4210};
        RadionuclideTotalDose = new int[]{24, 4212};
        RadionuclideHalfLife = new int[]{24, 4213};
        RadionuclidePositronFraction = new int[]{24, 4214};
        BeatRejectionFlag = new int[]{24, 4224};
        LowRRValue = new int[]{24, 4225};
        HighRRValue = new int[]{24, 4226};
        PVCRejection = new int[]{24, 4229};
        SkipBeats = new int[]{24, 4230};
        HeartRate = new int[]{24, 4232};
        ReconstructionDiameter = new int[]{24, 4352};
        DistanceSourceToDetector = new int[]{24, 4368};
        DistanceSourceToPatient = new int[]{24, 4369};
        GantryDetectorTilt = new int[]{24, 4384};
        GantryDetectorSlew = new int[]{24, 4385};
        TableHeight_CT = new int[]{24, 4400};
        RotationDirection = new int[]{24, 4416};
        FieldOfViewShape = new int[]{24, 4423};
        FieldOfViewDimension = new int[]{24, 4425};
        ExposureTime = new int[]{24, 4432};
        XRayTubeCurrent = new int[]{24, 4433};
        Exposure = new int[]{24, 4434};
        FilterType = new int[]{24, 4448};
        GeneratorPower = new int[]{24, 4464};
        CollimatorGridName = new int[]{24, 4480};
        CollimatorType = new int[]{24, 4481};
        FocalSpots = new int[]{24, 4496};
        DateOfLastCalibration = new int[]{24, 4608};
        TimeOfLastCalibration = new int[]{24, 4609};
        ConvolutionKernel = new int[]{24, 4624};
        ActualFrameDuration = new int[]{24, 4674};
        PatientPosition = new int[]{24, 20736};
        NumberOfCellsIInDectector = new int[]{25, 2};
        CellNumberAtTheta = new int[]{25, 3};
        CellSpacing = new int[]{25, 4};
        HorizFrameOfRef = new int[]{25, 15};
        SeriesContrast = new int[]{25, 17};
        FirstScanRAS = new int[]{25, 24};
        LastScanRAS = new int[]{25, 26};
        TableSpeed = new int[]{25, 35};
        MidScanTime = new int[]{25, 36};
        MidScanFlag = new int[]{25, 37};
        DegreesOfAzimuth = new int[]{25, 38};
        GantryPeriod = new int[]{25, 39};
        NumberOfTriggers = new int[]{25, 44};
        AngleOfFirstView = new int[]{25, 46};
        TriggerFrequency = new int[]{25, 47};
        ScanFOVType = new int[]{25, 57};
        SegmentNumber = new int[]{25, 66};
        TotalSegmentsRequested = new int[]{25, 67};
        ViewCompressionFactor = new int[]{25, 71};
        ReconPostProcFlag = new int[]{25, 82};
        DependentOnNumViewsProcessed = new int[]{25, 106};
        StudyInstanceUID = new int[]{32, 13};
        SeriesInstanceUID = new int[]{32, 14};
        StudyID = new int[]{32, 16};
        SeriesNumber = new int[]{32, 17};
        AcquisitionNumber = new int[]{32, 18};
        InstanceNumber = new int[]{32, 19};
        PatientOrientation = new int[]{32, 32};
        ImagePositionPatient = new int[]{32, 50};
        ImageOrientationPatient = new int[]{32, 55};
        FrameOfReferenceUID = new int[]{32, 82};
        Laterality = new int[]{32, 96};
        ImagesInAcquisition = new int[]{32, 4098};
        PositionReferenceIndicator = new int[]{32, 4160};
        SliceLocation = new int[]{32, 4161};
        ImageComments = new int[]{32, 16384};
        SeriesFromWhichPrescribed = new int[]{33, 3};
        SeriesPrescribedFrom = new int[]{33, 53};
        ImagePrescribedFrom = new int[]{33, 54};
        BiopsyPosition = new int[]{33, 145};
        BiopsyTLocation = new int[]{33, 146};
        BiopsyRefLocation = new int[]{33, 147};
        StartTimeSecsInFirstAxial = new int[]{35, 112};
        NeuroReorientationParameter = new int[]{37, 16};
        NeuroWarpedImageParameter_OB = new int[]{37, 17};
        NeuroImageAtlasName = new int[]{37, 18};
        NeuroCorticalSurfaceLandmarkFile = new int[]{37, 19};
        NeuroCorticalWarpedIndices_OB = new int[]{37, 20};
        NeuroCorticalSurfaceValues = new int[]{37, 21};
        NeuroPonsZCorticalSurface_OB = new int[]{37, 22};
        NeuroCerebZCorticalSurface_OB = new int[]{37, 23};
        NeuroThalmZCorticalSurface_OB = new int[]{37, 24};
        NeuroGlobalZCorticalSurface_OB = new int[]{37, 25};
        NeuroNormalsDatabaseName = new int[]{37, 26};
        NeuroCorticalSurfaceIndices_OB = new int[]{37, 27};
        NeuroPonsCorticalRegionZ = new int[]{37, 28};
        NeuroCerebCorticalRegionZ = new int[]{37, 29};
        NeuroThalmCorticalRegionZ = new int[]{37, 30};
        NeuroGlobalCorticalRegionZ = new int[]{37, 31};
        NeuroRegionDefinitionName = new int[]{37, 32};
        NeuroCorticalOriginalIndicesl_OB = new int[]{37, 33};
        NeutoAngularExt_OB = new int[]{37, 38};
        SSPVersions = new int[]{37, 48};
        NeuroCorticalSurfaceValues_OB = new int[]{37, 49};
        SourceStudyInstanceUID = new int[]{37, 50};
        SourceSeriesInstanceUID = new int[]{37, 51};
        SurfaceName = new int[]{37, 52};
        NormalizationRegion = new int[]{37, 53};
        ScoutType = new int[]{39, 16};
        VmaMamp = new int[]{39, 28};
        VmaMod = new int[]{39, 30};
        VmaClip = new int[]{39, 31};
        SmartScanOnOffFlag = new int[]{39, 32};
        PlaneType = new int[]{39, 53};
        CenterRCoordOfPlaneImage = new int[]{39, 66};
        CenterACoordOfPlaneImage = new int[]{39, 67};
        CenterSCoordOfPlaneImage = new int[]{39, 68};
        NormalRCoord = new int[]{39, 69};
        NormalACoord = new int[]{39, 70};
        NormalSCoord = new int[]{39, 71};
        TableStartLocation = new int[]{39, 80};
        TableEndLocation = new int[]{39, 81};
        SamplesPerPixel = new int[]{40, 2};
        PhotometricInterpretation = new int[]{40, 4};
        PlanarConfiguration = new int[]{40, 6};
        Rows = new int[]{40, 16};
        Columns = new int[]{40, 17};
        PixelSpacing = new int[]{40, 48};
        PixelAspectRatio = new int[]{40, 52};
        CorrectedImage = new int[]{40, 81};
        BitsAllocated = new int[]{40, 256};
        BitsStored = new int[]{40, 257};
        HighBit = new int[]{40, 258};
        PixelRepresentation = new int[]{40, 259};
        SmallestImagePixelValue = new int[]{40, 262};
        LargestImagePixelValue = new int[]{40, 263};
        SmallestPixelValueInseries = new int[]{40, 264};
        LargestPixelValueInseries = new int[]{40, 265};
        PixelPaddingValue = new int[]{40, 288};
        QualityControlImage = new int[]{40, 768};
        BurnedInAnnotation = new int[]{40, 769};
        WindowCenter = new int[]{40, 4176};
        WindowWidth = new int[]{40, 4177};
        RescaleIntercept = new int[]{40, 4178};
        RescaleSlope = new int[]{40, 4179};
        RescaleType = new int[]{40, 4180};
        RedPaletteColorLUTDescriptor = new int[]{40, 4353};
        GreenPaletteColorLUTDescriptor = new int[]{40, 4354};
        BluePaletteColorLUTDescriptor = new int[]{40, 4355};
        RedPaletteColorLUTData = new int[]{40, 4609};
        GreenPaletteColorLUTData = new int[]{40, 4610};
        BluePaletteColorLUTData = new int[]{40, 4611};
        LossyImageCompression = new int[]{40, 8464};
        LossyImageCompressionRatio = new int[]{40, 8466};
        ScheduledProcedureStepDescription = new int[]{64, 7};
        ScheduledProtocolCodeSequence = new int[]{64, 8};
        ScheduledProcedureStepID = new int[]{64, 9};
        RequestedProcedureID = new int[]{64, 4097};
        RequestedAttributesSequence = new int[]{64, 629};
        PerformedProcedureStepStartDate = new int[]{64, 580};
        PerformedProcedureStepStartTime = new int[]{64, 581};
        PerformedProcedureStepID = new int[]{64, 595};
        PerformedProcedureStepDescription = new int[]{64, 596};
        PerformedProcedureTypeDescription = new int[]{64, 597};
        PerformedActionItemSequence = new int[]{64, 608};
        RelationshipType = new int[]{64, 40976};
        VerfiyingOrganization = new int[]{64, 40999};
        VerificationDataTime = new int[]{64, 41008};
        ObservationDataTime = new int[]{64, 41010};
        ValueType = new int[]{64, 41024};
        ConceptNameCodeSequence = new int[]{64, 41027};
        ContinuityOfContent = new int[]{64, 41040};
        VerifyingObserverSequence = new int[]{64, 41075};
        VerifyingObserverName = new int[]{64, 41077};
        VerifyingObserverIdentificationCodeSequence = new int[]{64, 41096};
        PurposeOfReferenceCodeSequence = new int[]{64, 41328};
        PredecessorDocumentsSequence = new int[]{64, 41824};
        CompletionFlag = new int[]{64, 42129};
        CompletionFlagDescription = new int[]{64, 42130};
        VerificationFlag = new int[]{64, 42131};
        ContentTemplateSequence = new int[]{64, 42244};
        IdenticalDocumentsSequence = new int[]{64, 42277};
        ReferencedRequestSequence = new int[]{64, 41840};
        PerformedProcedureCodeSequence = new int[]{64, 41842};
        CurrentRequestedProcedureEvidenceSequence = new int[]{64, 41845};
        PertinentOtherEvidenceSequence = new int[]{64, 41861};
        ContentSequence = new int[]{64, 42800};
        ReferencedContentItemIdentifier = new int[]{64, 56179};
        WindowValue = new int[]{67, 16};
        XRayChain = new int[]{67, 18};
        NumberOfOverranges = new int[]{67, 22};
        DeltaStartTime = new int[]{67, 30};
        MaxOverrangesInAView = new int[]{67, 31};
        CorrectedAfterGlowTerms = new int[]{67, 33};
        ReferenceChannels = new int[]{67, 37};
        NoViewRefChansBlocked = new int[]{67, 38};
        ScanPitchRatio = new int[]{67, 39};
        UniqueImageIden = new int[]{67, 40};
        PrivateScanOptions = new int[]{67, 43};
        RACordOfTargetReconCenter = new int[]{67, 49};
        TriggerOnPosition = new int[]{67, 64};
        DegreeOfRotation = new int[]{67, 65};
        DASTriggerSource = new int[]{67, 66};
        DASFpaGain = new int[]{67, 67};
        DASOutputSource = new int[]{67, 68};
        DASAdInput = new int[]{67, 69};
        DASCalMode = new int[]{67, 70};
        StartScanToXRayOnDelay = new int[]{67, 77};
        DurationOfXRayOn = new int[]{67, 78};
        NumberOfMacroRowsInDetector = new int[]{69, 1};
        MacroWidthAtISOCenter = new int[]{69, 2};
        DASType = new int[]{69, 3};
        DASGain = new int[]{69, 4};
        DASTemperature = new int[]{69, 5};
        TableDirection = new int[]{69, 6};
        ZSmoothingFactor = new int[]{69, 7};
        ViewWeightingMode = new int[]{69, 8};
        SigmaRowNumber = new int[]{69, 9};
        MinimumDASValue = new int[]{69, 10};
        MaximumOffsetValue = new int[]{69, 11};
        NumberOfViewShifted = new int[]{69, 12};
        ZTrackingFlag = new int[]{69, 13};
        MeanZError = new int[]{69, 14};
        ZTrackingError = new int[]{69, 15};
        StartView2A = new int[]{69, 16};
        NumberOfViews2A = new int[]{69, 17};
        StartView1A = new int[]{69, 18};
        SigmaMode = new int[]{69, 19};
        NumberOfViews1A = new int[]{69, 20};
        StartView2B = new int[]{69, 21};
        NumberOfViews2B = new int[]{69, 22};
        StartView1B = new int[]{69, 23};
        NumberOfViews1B = new int[]{69, 24};
        IterboneFlag = new int[]{69, 33};
        PerisstalticFlag = new int[]{69, 34};
        CardiacReconAlgorithm = new int[]{69, 48};
        AvgHeartRateForImage = new int[]{69, 49};
        TemporalResolution = new int[]{69, 50};
        PctRpeakDelay = new int[]{69, 51};
        EkgFullMaStartPhase = new int[]{69, 54};
        EkgFullMaEndPhase = new int[]{69, 55};
        EkgModulationMaxMa = new int[]{69, 56};
        EkgModulationMinMa = new int[]{69, 57};
        CardiacFilter = new int[]{69, 59};
        CTCardiacSequence = new int[]{73, 1};
        HeartRateAtConfirm = new int[]{73, 2};
        AvgHeartRatePriorToConfirm = new int[]{73, 3};
        MinHeartRatePriorToConfirm = new int[]{73, 4};
        MaxHeartRatePriorToConfirm = new int[]{73, 5};
        StdDevHeartRatePriorToConfirm = new int[]{73, 6};
        NumHeartRateSamplesPriorToConfirm = new int[]{73, 7};
        AutoHearRateDetectPredict = new int[]{73, 8};
        SystemOptimizedHeartRate = new int[]{73, 9};
        EkgMonitorType = new int[]{73, 10};
        NumReconSectors = new int[]{73, 11};
        RpeakTimeStamps = new int[]{73, 12};
        MultiEnergySourceCount = new int[]{83, 112};
        MultiEnergyScanType = new int[]{83, 113};
        MultiEnergyReconType = new int[]{83, 114};
        MultiEnergyImageType = new int[]{83, 115};
        MultiEnergyMaterialType = new int[]{83, 116};
        MultiEnergyMonochromatic = new int[]{83, 117};
        MultiEnergyWeightedSubtractionWeight1 = new int[]{83, 118};
        MultiEnergyWeightedSubtractionWeight2 = new int[]{83, 119};
        MultiEnergyWeightedSubtractionType = new int[]{83, 120};
        MultiEnergyAcqMethod = new int[]{83, 121};
        MultiEnergyFeatAnnotName = new int[]{83, 122};
        MultiEnergyNoiseReduced = new int[]{83, 123};
        MultiEnergyNoiseReducedMethod = new int[]{83, 124};
        SubOptimalIQString = new int[]{83, 125};
        MultiEnergyHighLowRatio = new int[]{83, 126};
        GSIReserved0 = new int[]{83, 127};
        GSIReserved1 = new int[]{83, 128};
        GSIReserved2 = new int[]{83, 129};
        GSIReserved3 = new int[]{83, 130};
        AnnotationmA = new int[]{83, 131};
        CommandedFirstkVp = new int[]{83, 132};
        CommandedFirstmA = new int[]{83, 133};
        CommandedSecondkVp = new int[]{83, 134};
        CommandedSecondmA = new int[]{83, 135};
        MultiEnergyKVAnnotName = new int[]{83, 136};
        MultiEnergyKVUnitLabel = new int[]{83, 137};
        MaterialType1 = new int[]{83, 138};
        MaterialType2 = new int[]{83, 139};
        GSIScanModePreset = new int[]{83, 140};
        MonoWindowLow = new int[]{83, 141};
        MonoWindowHigh = new int[]{83, 142};
        RawMDItemsSequence = new int[]{83, 144};
        MD_Description = new int[]{83, 145};
        MD1_Data = new int[]{83, 149};
        MD1_Intercept = new int[]{83, 146};
        MD1_Slope = new int[]{83, 147};
        MD1_Attenuation_Curve = new int[]{83, 143};
        NM1_Data = new int[]{83, 151};
        MD2_Data = new int[]{83, 150};
        MD2_Intercept = new int[]{83, 152};
        MD2_Slope = new int[]{83, 153};
        MD2_Attenutation_Curve = new int[]{83, 155};
        NM2_Data = new int[]{83, 154};
        GSI_DATA_VERSION = new int[]{83, 156};
        MARs_Annotation = new int[]{83, 157};
        GSI_NumberOfValues = new int[]{83, 158};
        GSI_DescOfPairs = new int[]{83, 159};
        GSI_PairBlending = new int[]{83, 1};
        GSI_PairScale = new int[]{83, 2};
        GSI_MD_XFORM = new int[]{83, 3};
        ShuttleSliceGroup = new int[]{83, 32};
        TableSpeedNotReachedTargetFlag = new int[]{83, 33};
        HelicalShuttleFlag = new int[]{83, 34};
        IterativeReconAnnotation = new int[]{83, 64};
        IterativeReconMode = new int[]{83, 65};
        IterativeReconConfiguration = new int[]{83, 66};
        IterativeReconLevel = new int[]{83, 67};
        ReconFlipRotateAnno = new int[]{83, 96};
        HighResFlag = new int[]{83, 97};
        RespitoryFlag = new int[]{83, 98};
        ImagePositionPatientSetting = new int[]{83, 99};
        ShutterMode = new int[]{83, 100};
        ShutterModePercent = new int[]{83, 101};
        ImageBrowserAnnotation = new int[]{83, 102};
        OverlappedReconFlag = new int[]{83, 103};
        RowNumberAnnotationFlag = new int[]{83, 104};
        EnergyWindowRangeSequence = new int[]{84, 19};
        RadiopharmaceuticalInformationSequence = new int[]{84, 22};
        NumberOfRRIntervals = new int[]{84, 97};
        NumberOfTimeSlots = new int[]{84, 113};
        NumberOfSlices = new int[]{84, 129};
        NumberOfTimeSlices = new int[]{84, 257};
        TypeOfDetectorMotion = new int[]{84, 514};
        ViewSequenceCode = new int[]{84, 544};
        RadionuclideCodeSequence = new int[]{84, 768};
        RadiopharmaceuticalCodeSequence = new int[]{84, 772};
        ImageID = new int[]{84, 1024};
        PatientOrientationCodeSequence = new int[]{84, 1040};
        PatientGantryRelationshipCodeSequence = new int[]{84, 1044};
        SliceProgressionDirection = new int[]{84, 1280};
        SeriesType = new int[]{84, 4096};
        Units = new int[]{84, 4097};
        CountsSource = new int[]{84, 4098};
        ReprojectionMethod = new int[]{84, 4100};
        RandomsCorrectionMethod = new int[]{84, 4352};
        AttenuationCorrectionMethod = new int[]{84, 4353};
        DecayCorrection = new int[]{84, 4354};
        ReconstructionMethod = new int[]{84, 4355};
        DetectorLinesOfResponseUsed = new int[]{84, 4356};
        ScatterCorrectionMethod = new int[]{84, 4357};
        AxialAcceptance = new int[]{84, 4608};
        AxialMash = new int[]{84, 4609};
        TransverseMash = new int[]{84, 4610};
        DetectorElementSize = new int[]{84, 4611};
        CoincidenceWindowWidth = new int[]{84, 4624};
        SecondaryCountsType = new int[]{84, 4640};
        FrameReferenceTime = new int[]{84, 4864};
        PrimaryCountsAccumulated = new int[]{84, 4880};
        SecondaryCountsAccumulated = new int[]{84, 4881};
        SliceSensitivityFactor = new int[]{84, 4896};
        DecayFactor = new int[]{84, 4897};
        DoseCalibrationFactor = new int[]{84, 4898};
        ScatterFractionFactor = new int[]{84, 4899};
        DeadTimeFactor = new int[]{84, 4900};
        ImageIndex = new int[]{84, 4912};
        SOPInstanceStatus = new int[]{256, 1040};
        SOPAuthDateTime = new int[]{256, 1056};
        SOPAuthComment = new int[]{256, 1044};
        AuthEquipmentCertNo = new int[]{256, 1046};
        NeuroAdsResultsAsciiFiles = new int[]{87, 33};
        NeuroAdsResultsBinaryFiles_OB = new int[]{87, 177};
        SourceSeriesType = new int[]{87, 4114};
        NormalizationData = new int[]{87, 4115};
        FilterData = new int[]{87, 4116};
        ReformatData = new int[]{87, 4117};
        GroupInfoData = new int[]{87, 4118};
        SplashScreenData = new int[]{87, 4119};
        FiveSliceScreenData = new int[]{87, 4120};
        PolarPlotData = new int[]{87, 4121};
        DisplaySliceThickness = new int[]{87, 4128};
        UserPreferencesData = new int[]{87, 4129};
        MiscInfo1 = new int[]{87, 4144};
        MiscInfo2 = new int[]{87, 4145};
        PixelData = new int[]{32736, 16};
        ContentLabel = new int[]{112, 128};
        ContentDescription = new int[]{112, 129};
        PresentationCreationDate = new int[]{112, 130};
        PresentationCreationTime = new int[]{112, 131};
        CreatorName = new int[]{112, 132};
        ReferencedFrameNumber = new int[]{8, 4448};
        FrameOfReferenceTransformComment = new int[]{12294, 200};
        MatrixRegistrationSequence = new int[]{112, 777};
        RegistrationObjectSequence = new int[]{112, 776};
        TransformMatrix = new int[]{12294, 198};
        TransformMatrixType = new int[]{112, 780};
        MatrixSequence = new int[]{112, 778};
        OtherStudies = new int[]{8, 4608};
        RegistrationReferencedImageSequence = new int[]{8, 4426};
        ReferencedSeriesSequence = new int[]{8, 4373};
        RegistrationTypeCodeSequence = new int[]{112, 781};
        ReferencedSOPSequence = new int[]{8, 4505};
        WindowWidthCenterExplanation = new int[]{40, 4181};
        SoftcopyVOILUTSequence = new int[]{40, 12560};
        SoftcopyLUTDescriptor = new int[]{40, 12290};
        SoftcopyLUTExplanation = new int[]{40, 12291};
        SoftcopyLUTData = new int[]{40, 12294};
        DisplayedAreaTopLeftHandCorner = new int[]{112, 82};
        DisplayedAreaBottomRightHandCorner = new int[]{112, 83};
        PresentationSizeMode = new int[]{112, 256};
        PresentationPixelSpacing = new int[]{112, 257};
        PresentationPixelAspectRatio = new int[]{112, 258};
        PixelMagnificationRatio = new int[]{112, 259};
        DisplayedAreaSelectionSequence = new int[]{112, 90};
        TextBoundingBoxAnnotationUnits = new int[]{112, 3};
        AnchorPointAnnotationUnits = new int[]{112, 4};
        UnformattedTextValue = new int[]{112, 6};
        BoundingBoxTopLeftHandCorner = new int[]{112, 16};
        BoundingBoxBottomRightHandCorner = new int[]{112, 17};
        BoundingBoxTextHorizontalJustification = new int[]{112, 18};
        AnchorPoint = new int[]{112, 20};
        AnchorPointVisibility = new int[]{112, 21};
        TextObjectSequenceValue = new int[]{112, 8};
        GraphicBoundingBoxAnnotationUnits = new int[]{112, 5};
        GraphicDimensions = new int[]{112, 32};
        GraphicPoints = new int[]{112, 33};
        GraphicData = new int[]{112, 34};
        GraphicType = new int[]{112, 35};
        GraphicFilled = new int[]{112, 36};
        GraphicLayer = new int[]{112, 2};
        GraphicLayerOrder = new int[]{112, 98};
        GraphicLayerRecommendedDisplayGrayscaleValue = new int[]{112, 102};
        GraphicLayerRecommendedDisplayCIELabValue = new int[]{112, 1025};
        GraphicLayerDescription = new int[]{112, 104};
        GraphicLayerSequence = new int[]{112, 96};
        ImageRotation = new int[]{112, 66};
        ImageHorizontalFlip = new int[]{112, 65};
        BlendPosition = new int[]{112, 1029};
        PresentationStateBlendingSequence = new int[]{112, 1026};
        BlendingPercentage = new int[]{112, 1027};
        SpatialRegistrationSequence = new int[]{112, 1028};
        ICCProfile = new int[]{40, 8192};
        GraphicObjectSequence = new int[]{112, 9};
        GraphicAnnotationSequence = new int[]{112, 1};
        PresentationLUTSequence = new int[]{8272, 16};
        PresentationLUTShape = new int[]{8272, 32};
        DisplayShutterShape = new int[]{24, 5632};
        DisplayShutterLeftEdge = new int[]{24, 5634};
        DisplayShutterRightEdge = new int[]{24, 5636};
        DisplayShutterUpperEdge = new int[]{24, 5638};
        DisplayShutterLowerEdge = new int[]{24, 5640};
        CircularCenter = new int[]{24, 5648};
        CircularRadius = new int[]{24, 5650};
        PolygonVertices = new int[]{24, 5664};
        DisplayShutterPresentationValue = new int[]{24, 5666};
        for (i2 = 0; i2 < NeuroAdsResultsBinaryFiles_OB[1] - NeuroAdsResultsAsciiFiles[1]; ++i2) {
            DicomUtils.assignNewTag(NeuroAdsResultsAsciiFiles[0], NeuroAdsResultsAsciiFiles[1] + i2, "NeuroAdsResultsFiles", 21844, "1");
        }
        for (i2 = 0; i2 < 256 - NeuroAdsResultsBinaryFiles_OB[1]; ++i2) {
            DicomUtils.assignNewTag(NeuroAdsResultsBinaryFiles_OB[0], NeuroAdsResultsBinaryFiles_OB[1] + i2, "NeuroAdsResultsFiles", 20290, "1");
        }
        pixtype = new XpDicomElement(40, 4);
        pixballoc = new XpDicomElement(40, 256);
        dmatg_pixtype = new DMTag(40, 4);
        dmtag_pixballoc = new DMTag(40, 256);
        wwtag = new DMTag(40, 4177);
        wltag = new DMTag(40, 4176);
    }
}

