/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import com.ge.med.cse.cvf.saveimage.XpSaveUtil;
import com.ge.med.cse.cvf.util.DicomPrintablePort;
import com.ge.med.cse.cvf.util.ScreenSave;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSeqItem;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.DicomData;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;

public class ScreenSaveUtil {
    XPscreen screen_ = null;
    private static final int WINDOW_TAG_LEN_LIMIT = 16;

    private static int swapInteger(int value) {
        return ((value >> 0 & 0xFF) << 24) + ((value >> 8 & 0xFF) << 16) + ((value >> 16 & 0xFF) << 8) + ((value >> 24 & 0xFF) << 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNextScreenSaveNumber() {
        int scrnNumber = 0;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(System.getProperty("DECLARE_SSAVE", "/export/home/sdc/Prefs/.ssave_index"), "rw");
            FileLock lock = raf.getChannel().lock();
            try {
                scrnNumber = ScreenSaveUtil.swapInteger(raf.readInt());
            }
            catch (EOFException eofexp) {
                ++scrnNumber;
            }
            raf.seek(0L);
            if (scrnNumber > 999) {
                scrnNumber = 1;
            }
            raf.writeInt(ScreenSaveUtil.swapInteger(scrnNumber + 1));
            lock.release();
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        return scrnNumber;
    }

    public static InputStream getScreenCapture(DMObject dmo, JComponent comp, int width, int height, String comment) {
        String unk1;
        String SeriesUID = null;
        DMObject exam = null;
        if (dmo.getType().equalsIgnoreCase("study")) {
            exam = dmo;
        } else {
            DMObject[] ex = dmo.getRelated("study");
            exam = ex[0];
        }
        String sseries = "99";
        if (!(comp instanceof XpViewport)) {
            sseries = "98";
        }
        DMObject[] series = exam.getRelated("series");
        for (int i2 = 0; i2 < series.length; ++i2) {
            String seriesNo = (String)series[i2].getValue(32, 17);
            if (seriesNo == null || !seriesNo.equals(sseries)) continue;
            SeriesUID = (String)series[i2].getValue(32, 14);
            break;
        }
        DicomComposite obj = new DicomComposite();
        obj.setValue(2, 1, dmo.getValue(2, 1));
        obj.setValue(2, 2, "1.2.840.10008.4.1.4.1.1.7");
        obj.setValue(2, 3, UidGenerator.newInstanceUID());
        obj.setValue(2, 16, dmo.getValue(2, 16));
        obj.setValue(2, 18, dmo.getValue(2, 18));
        obj.setValue(2, 19, dmo.getValue(2, 19));
        obj.setValue(2, 22, dmo.getValue(2, 22));
        String charSet = (String)dmo.getValue(8, 5);
        if (charSet == null) {
            charSet = "ISO_IR 100";
        }
        obj.setValue(8, 5, charSet);
        String pName = (String)dmo.getValue(16, 16);
        if (pName == null) {
            pName = "";
        }
        obj.setValue(16, 16, pName);
        String pId = (String)dmo.getValue(16, 32);
        if (pId == null) {
            pId = "";
        }
        obj.setValue(16, 32, pId);
        String pBdate = (String)dmo.getValue(16, 48);
        if (pBdate == null) {
            pBdate = "";
        }
        obj.setValue(16, 48, pBdate);
        String pSex = (String)dmo.getValue(16, 64);
        if (pSex == null) {
            pSex = "";
        }
        obj.setValue(16, 64, pSex);
        obj.setValue(32, 13, dmo.getValue(32, 13));
        String exDate = (String)dmo.getValue(8, 32);
        if (exDate == null) {
            exDate = "";
        }
        obj.setValue(8, 32, exDate);
        String exTime = (String)dmo.getValue(8, 48);
        if (exTime == null) {
            exTime = "";
        }
        obj.setValue(8, 48, exTime);
        String refPhy = (String)dmo.getValue(8, 144);
        if (refPhy == null) {
            refPhy = "";
        }
        obj.setValue(8, 144, refPhy);
        String exId = (String)dmo.getValue(32, 16);
        if (exId == null) {
            exId = "";
        }
        obj.setValue(32, 16, exId);
        String accessionNo = (String)dmo.getValue(8, 80);
        if (accessionNo == null) {
            accessionNo = "";
        }
        obj.setValue(8, 80, accessionNo);
        String exDescpt = (String)dmo.getValue(8, 4144);
        if (exDescpt == null) {
            exDescpt = "";
        }
        obj.setValue(8, 4144, exDescpt);
        String patAge = (String)dmo.getValue(16, 4112);
        if (patAge == null) {
            obj.removeTag(16, 4112);
        } else {
            obj.setValue(16, 4112, patAge);
        }
        String pat1 = (String)dmo.getValue(16, 4128);
        if (pat1 == null) {
            pat1 = "";
        }
        obj.setValue(16, 4128, pat1);
        String patWeight = (String)dmo.getValue(16, 4144);
        if (patWeight == null) {
            patWeight = "";
        }
        obj.setValue(16, 4144, patWeight);
        String modality = (String)dmo.getValue(8, 96);
        if (modality == null) {
            modality = "";
        }
        obj.setValue(8, 96, modality);
        if (SeriesUID == null) {
            SeriesUID = UidGenerator.newInstanceUID();
        }
        obj.setValue(32, 14, SeriesUID);
        obj.setValue(32, 17, sseries);
        String laterality = (String)dmo.getValue(32, 96);
        if (laterality == null) {
            laterality = "";
        }
        obj.setValue(32, 96, laterality);
        if (comp instanceof XpViewport) {
            obj.setValue(8, 4158, "Screen Save");
        } else {
            obj.setValue(8, 4158, "Exam/Series Text Page");
            obj.setValue(32, 16384, comment);
        }
        String patPos = (String)dmo.getValue(24, 20736);
        if (patPos == null) {
            patPos = "";
        }
        obj.setValue(24, 20736, patPos);
        String Protocol_Name = (String)dmo.getValue(24, 4144);
        if (Protocol_Name == null) {
            Protocol_Name = "";
        }
        obj.setValue(24, 4144, Protocol_Name);
        ScreenSaveUtil.addPPSTags(obj, dmo);
        String Contrast_on_Screen_Save = (String)dmo.getValue(24, 16);
        if (Contrast_on_Screen_Save != null) {
            obj.setValue(24, 16, Contrast_on_Screen_Save);
        }
        if ((unk1 = (String)dmo.getValue(24, 4160)) == null) {
            unk1 = "";
        }
        obj.setValue(24, 4160, unk1);
        String manuf = (String)dmo.getValue(8, 112);
        if (manuf == null) {
            manuf = "";
        }
        obj.setValue(8, 112, manuf);
        String institutionName = (String)dmo.getValue(8, 128);
        if (institutionName == null) {
            institutionName = "";
        }
        obj.setValue(8, 128, institutionName);
        String unk2 = (String)dmo.getValue(8, 129);
        if (unk2 == null) {
            unk2 = "";
        }
        obj.setValue(8, 129, unk2);
        String stationName = (String)dmo.getValue(8, 4112);
        if (stationName == null) {
            stationName = "";
        }
        obj.setValue(8, 4112, stationName);
        String manfmodel = (String)dmo.getValue(8, 4240);
        if (manfmodel == null) {
            manfmodel = "";
        }
        obj.setValue(8, 4240, manfmodel);
        obj.setValue(8, 100, "WSD");
        obj.setValue(32, 19, new Integer(ScreenSaveUtil.getNextScreenSaveNumber()));
        String unk3 = (String)dmo.getValue(32, 32);
        if (unk3 == null) {
            unk3 = "";
        }
        obj.setValue(32, 32, unk3);
        String date = XpSaveUtil.DICOM_VR_DA_FORMAT.format(new Date());
        obj.setValue(8, 35, date);
        obj.setValue(8, 8, "DERIVED\\SECONDARY\\SCREEN SAVE");
        obj.setValue(8, 22, "1.2.840.10008.5.1.4.1.1.7");
        obj.setValue(8, 24, UidGenerator.newInstanceUID());
        obj.setValue(2, 3, UidGenerator.newInstanceUID());
        if (comp instanceof WindowLevelCapable) {
            String precision;
            int index;
            Matcher matcher;
            double max = ((WindowLevelCapable)((Object)comp)).getWinMax();
            double min = ((WindowLevelCapable)((Object)comp)).getWinMin();
            double ww = max - min;
            double wl = (max + min) / 2.0;
            String wwString = new Double(ww).toString();
            String wlString = new Double(wl).toString();
            if (wwString.length() > 16) {
                matcher = Pattern.compile(Pattern.quote("E"), 2).matcher(wwString);
                if (matcher.find()) {
                    index = matcher.start();
                    precision = wwString.substring(index);
                    wwString = wwString.substring(0, 16 - precision.length());
                    wwString = wwString + precision;
                    ww = Double.valueOf(wwString);
                } else {
                    wwString = wwString.substring(0, 16);
                    ww = Double.valueOf(wwString);
                }
            }
            if (wlString.length() > 16) {
                matcher = Pattern.compile(Pattern.quote("E"), 2).matcher(wlString);
                if (matcher.find()) {
                    index = matcher.start();
                    precision = wlString.substring(index);
                    wlString = wlString.substring(0, 16 - precision.length());
                    wlString = wlString + precision;
                    wl = Double.valueOf(wlString);
                } else {
                    wlString = wlString.substring(0, 16);
                    wl = Double.valueOf(wlString);
                }
            }
            obj.setValue(40, 4177, "" + ww);
            obj.setValue(40, 4176, "" + wl);
        } else {
            obj.setValue(40, 4177, "" + new Integer(1));
            obj.setValue(40, 4176, "" + new Integer(1));
        }
        String ri = (String)dmo.getValue(40, 4178);
        if (ri == null) {
            ri = "0";
        }
        obj.setValue(40, 4178, ri);
        String rs = (String)dmo.getValue(40, 4179);
        if (rs == null) {
            rs = "1";
        }
        obj.setValue(40, 4179, rs);
        String rsd = (String)dmo.getValue(40, 4180);
        if (rsd == null) {
            rsd = "je ne sais pas";
        }
        obj.setValue(40, 4180, rsd);
        obj.setValue(40, 48, "0.488281\\0.488281");
        obj.setValue(40, 769, "YES ");
        ScreenSave ss = new ScreenSave(width, height);
        if (comp instanceof XpSingularPort) {
            if (!ss.isColorImage((XpSingularPort)comp)) {
                obj.setValue(40, 2, new Integer(1));
                obj.setValue(40, 4, "MONOCHROME2");
                obj.setValue(40, 256, new Integer(16));
                obj.setValue(40, 257, new Integer(16));
                obj.setValue(40, 258, new Integer(15));
                obj.setValue(40, 16, new Integer(width));
                obj.setValue(40, 17, new Integer(height));
                obj.setValue(40, 259, new Integer(1));
                BufferedImage bi = ss.generate((XpSingularPort)comp);
                if (bi == null) {
                    return null;
                }
                DataBuffer db = bi.getRaster().getDataBuffer();
                if (db instanceof DataBufferUShort) {
                    short[] data = ((DataBufferUShort)db).getData();
                    byte[] bdata = new byte[2 * data.length];
                    for (int i3 = 0; i3 < data.length; ++i3) {
                        short d2 = data[i3];
                        int lo = (0xFF00 & d2) >> 8;
                        int hi = 0xFF & d2;
                        bdata[2 * i3 + 1] = (byte)lo;
                        bdata[2 * i3] = (byte)hi;
                    }
                    obj.setValue(32736, 16, bdata);
                } else if (db instanceof DataBufferShort) {
                    short[] data = ((DataBufferShort)db).getData();
                    byte[] bdata = new byte[2 * data.length];
                    for (int i4 = 0; i4 < data.length; ++i4) {
                        short d3 = data[i4];
                        int hi = (0xFF00 & d3) >> 8;
                        int lo = 0xFF & d3;
                        bdata[2 * i4 + 1] = (byte)lo;
                        bdata[2 * i4] = (byte)hi;
                    }
                    obj.setValue(32736, 16, bdata);
                }
            } else {
                obj.setValue(40, 2, new Integer(3));
                obj.setValue(40, 6, new Integer(0));
                obj.setValue(40, 4, "RGB");
                obj.setValue(40, 256, new Integer(8));
                obj.setValue(40, 257, new Integer(8));
                obj.setValue(40, 258, new Integer(7));
                obj.setValue(40, 16, new Integer(width));
                obj.setValue(40, 17, new Integer(height));
                obj.setValue(40, 259, new Integer(0));
                BufferedImage bi = ss.generate((XpSingularPort)comp);
                if (bi == null) {
                    return null;
                }
                DataBuffer db = bi.getRaster().getDataBuffer();
                if (db instanceof DataBufferInt) {
                    int[] data = ((DataBufferInt)db).getData();
                    byte[] bdata = new byte[3 * data.length];
                    for (int i5 = 0; i5 < data.length; ++i5) {
                        for (int n2 = 0; n2 < 3; ++n2) {
                            bdata[i5 * 3 + 2 - n2] = (byte)(data[i5] >>> n2 * 8);
                        }
                    }
                    obj.setValue(32736, 16, bdata);
                } else if (db instanceof DataBufferByte) {
                    byte[] bdata = ((DataBufferByte)db).getData();
                    for (int i6 = 0; i6 < bdata.length; i6 += 3) {
                        byte t2 = bdata[i6];
                        bdata[i6] = bdata[i6 + 2];
                        bdata[i6 + 2] = t2;
                    }
                    obj.setValue(32736, 16, bdata);
                }
            }
        } else {
            obj.setValue(40, 2, new Integer(3));
            obj.setValue(40, 4, "RGB");
            obj.setValue(40, 6, new Integer(0));
            obj.setValue(40, 256, new Integer(8));
            obj.setValue(40, 257, new Integer(8));
            obj.setValue(40, 258, new Integer(7));
            obj.setValue(40, 16, new Integer(width));
            obj.setValue(40, 17, new Integer(height));
            obj.setValue(40, 259, new Integer(0));
            DicomPrintablePort textpage = new DicomPrintablePort(comp);
            BufferedImage bi = ScreenSaveUtil.getBufferedImage(textpage, 0, width, height, 5);
            if (bi == null) {
                return null;
            }
            DataBufferByte dbi = (DataBufferByte)bi.getRaster().getDataBuffer();
            byte[] bb = dbi.getData();
            for (int i7 = 0; i7 < bb.length; i7 += 3) {
                byte t3 = bb[i7];
                bb[i7] = bb[i7 + 2];
                bb[i7 + 2] = t3;
            }
            obj.setValue(32736, 16, bb);
        }
        return obj.getInputStream(true, (String)dmo.getValue(2, 16));
    }

    private static void addPPSTags(DicomComposite dcomp, DMObject refObj) {
        Object patientHistory;
        Object accessionNo;
        Object Issuer_of_Admission_ID;
        Object issuerOfPID;
        Object perFormedLocation;
        Object perFormedStepID;
        Object pefProcStep;
        Object perFormedStnName;
        Object admissionID;
        Object newSequence;
        Object perFormedProtocolCodeSeq;
        Object requestedProcedureCodeSequence;
        Object performingPhysicianName;
        String OperatorName;
        Object refStudySeq;
        String studyDescription;
        Object ppsSequence = refObj.getValue(8, 4369);
        if (ppsSequence instanceof DMSequence) {
            ScreenSaveUtil.addSequenceToDicomComposite(dcomp, (DMSequence)ppsSequence, 8, 4369);
        }
        if ((studyDescription = (String)refObj.getValue(64, 4192)) != null) {
            dcomp.setValue(64, 4192, studyDescription);
        }
        if ((refStudySeq = refObj.getValue(8, 4368)) instanceof DMSequence) {
            ScreenSaveUtil.addSequenceToDicomComposite(dcomp, (DMSequence)refStudySeq, 8, 4368);
        }
        if ((OperatorName = (String)refObj.getValue(8, 4208)) != null) {
            dcomp.setValue(8, 4208, OperatorName);
        }
        if ((performingPhysicianName = refObj.getValue(8, 4176)) != null) {
            dcomp.setValue(8, 4176, performingPhysicianName);
        }
        if ((requestedProcedureCodeSequence = refObj.getValue(50, 4196)) instanceof DMSequence) {
            ScreenSaveUtil.addSequenceToDicomComposite(dcomp, (DMSequence)requestedProcedureCodeSequence, 50, 4196);
        }
        Object privateSequence = refObj.getValue(35, 4224);
        String creatorId = (String)refObj.getValue(35, 16);
        if (privateSequence instanceof DMSequence && creatorId != null) {
            dicomParser.addTag(35, 4224, "PPS Sequence", 21329, "1");
            dcomp.setValue(35, 16, creatorId);
            ScreenSaveUtil.addSequenceToDicomComposite(dcomp, (DMSequence)privateSequence, 35, 4224);
        }
        if ((perFormedProtocolCodeSeq = refObj.getValue(64, 608)) instanceof DMSequence) {
            ScreenSaveUtil.addSequenceToDicomComposite(dcomp, (DMSequence)perFormedProtocolCodeSeq, 64, 608);
        }
        if ((newSequence = refObj.getValue(64, 629)) instanceof DMSequence) {
            ScreenSaveUtil.addSequenceToDicomComposite(dcomp, (DMSequence)newSequence, 64, 629);
        }
        if ((admissionID = refObj.getValue(56, 16)) != null) {
            dcomp.setValue(56, 16, admissionID);
        }
        if ((perFormedStnName = refObj.getValue(64, 578)) != null) {
            dcomp.setValue(64, 578, perFormedStnName);
        }
        if ((pefProcStep = refObj.getValue(64, 596)) != null) {
            dcomp.setValue(64, 596, pefProcStep);
        }
        if ((perFormedStepID = refObj.getValue(64, 595)) != null) {
            dcomp.setValue(64, 595, perFormedStepID);
        }
        if ((perFormedLocation = refObj.getValue(64, 579)) != null) {
            dcomp.setValue(64, 579, perFormedLocation);
        }
        if ((issuerOfPID = refObj.getValue(16, 33)) != null) {
            dcomp.setValue(16, 33, issuerOfPID);
        }
        if ((Issuer_of_Admission_ID = refObj.getValue(56, 17)) != null) {
            dcomp.setValue(56, 17, Issuer_of_Admission_ID);
        }
        if ((accessionNo = refObj.getValue(8, 80)) != null) {
            dcomp.setValue(8, 80, accessionNo);
        }
        if ((patientHistory = refObj.getValue(16, 8624)) != null) {
            dcomp.setValue(16, 8624, patientHistory);
        }
    }

    private static void addSequenceToDicomComposite(DicomComposite dicomComposite, DMSequence seq, int seqGroup, int seqElement) {
        int items = seq.getNumberOfItems();
        for (int itemIndex = 0; itemIndex < items; ++itemIndex) {
            DicomData seqItemdata = new DicomData();
            dicomComposite.setValue(seqGroup, seqElement, itemIndex, seqItemdata);
            DMSeqItem dmsqItem = seq.getItem(itemIndex);
            DMTag[] tags = dmsqItem.getTags();
            for (int j2 = 0; j2 < tags.length; ++j2) {
                Object value = dmsqItem.getValue(tags[j2]);
                if (value instanceof DMSequence) {
                    DMSequence dmSeq = (DMSequence)value;
                    ScreenSaveUtil.addSequenceToDicomData(seqItemdata, dmSeq, tags[j2].getGroup(), tags[j2].getElement());
                    continue;
                }
                seqItemdata.setValue(tags[j2].getGroup(), tags[j2].getElement(), value);
            }
        }
    }

    private static void addSequenceToDicomData(DicomData dicomData, DMSequence seq, int seqGroup, int seqElement) {
        int items = seq.getNumberOfItems();
        for (int itemIndex = 0; itemIndex < items; ++itemIndex) {
            DicomData seqItemdata = new DicomData();
            dicomData.setValue(seqGroup, seqElement, itemIndex, seqItemdata);
            DMSeqItem dmsqItem = seq.getItem(itemIndex);
            DMTag[] tags = dmsqItem.getTags();
            for (int j2 = 0; j2 < tags.length; ++j2) {
                Object value = dmsqItem.getValue(tags[j2]);
                if (value instanceof DMSequence) {
                    DMSequence dmSeq = (DMSequence)value;
                    ScreenSaveUtil.addSequenceToDicomData(dicomData, dmSeq, tags[j2].getGroup(), tags[j2].getElement());
                    continue;
                }
                seqItemdata.setValue(tags[j2].getGroup(), tags[j2].getElement(), value);
            }
        }
    }

    private static BufferedImage getBufferedImage(Printable painter, int pageIndex, int width, int height, int imgType) {
        BufferedImage bi = new BufferedImage(width, height, imgType);
        Paper pp = new Paper();
        pp.setSize(width, height);
        pp.setImageableArea(0.0, 0.0, width, height);
        PageFormat pf = new PageFormat();
        pf.setPaper(pp);
        try {
            painter.print(bi.getGraphics(), pf, pageIndex);
        }
        catch (PrinterException ex) {
            return null;
        }
        return bi;
    }

    protected void build() {
    }
}

