/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.Jama;

import com.ge.med.jnu.Jama.Matrix;
import java.io.Serializable;

public class CholeskyDecomposition
implements Serializable {
    private double[][] L;
    private int n;
    private boolean isspd;

    public CholeskyDecomposition(Matrix Arg) {
        double[][] A2 = Arg.getArray();
        this.n = Arg.getRowDimension();
        this.L = new double[this.n][this.n];
        this.isspd = Arg.getColumnDimension() == this.n;
        for (int j2 = 0; j2 < this.n; ++j2) {
            int k2;
            double[] Lrowj = this.L[j2];
            double d2 = 0.0;
            for (k2 = 0; k2 < j2; ++k2) {
                double[] Lrowk = this.L[k2];
                double s2 = 0.0;
                for (int i2 = 0; i2 < k2; ++i2) {
                    s2 += Lrowk[i2] * Lrowj[i2];
                }
                Lrowj[k2] = s2 = (A2[j2][k2] - s2) / this.L[k2][k2];
                d2 += s2 * s2;
                this.isspd &= A2[k2][j2] == A2[j2][k2];
            }
            this.isspd &= (d2 = A2[j2][j2] - d2) > 0.0;
            this.L[j2][j2] = Math.sqrt(Math.max(d2, 0.0));
            for (k2 = j2 + 1; k2 < this.n; ++k2) {
                this.L[j2][k2] = 0.0;
            }
        }
    }

    public boolean isSPD() {
        return this.isspd;
    }

    public Matrix getL() {
        return new Matrix(this.L, this.n, this.n);
    }

    public Matrix solve(Matrix B) {
        int j2;
        int j3;
        int i2;
        int k2;
        if (B.getRowDimension() != this.n) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isspd) {
            throw new RuntimeException("Matrix is not symmetric positive definite.");
        }
        double[][] X = B.getArrayCopy();
        int nx = B.getColumnDimension();
        for (k2 = 0; k2 < this.n; ++k2) {
            for (i2 = k2 + 1; i2 < this.n; ++i2) {
                for (j3 = 0; j3 < nx; ++j3) {
                    double[] dArray = X[i2];
                    int n2 = j3;
                    dArray[n2] = dArray[n2] - X[k2][j3] * this.L[i2][k2];
                }
            }
            j2 = 0;
            while (j2 < nx) {
                double[] dArray = X[k2];
                int n3 = j2++;
                dArray[n3] = dArray[n3] / this.L[k2][k2];
            }
        }
        for (k2 = this.n - 1; k2 >= 0; --k2) {
            j2 = 0;
            while (j2 < nx) {
                double[] dArray = X[k2];
                int n4 = j2++;
                dArray[n4] = dArray[n4] / this.L[k2][k2];
            }
            for (i2 = 0; i2 < k2; ++i2) {
                for (j3 = 0; j3 < nx; ++j3) {
                    double[] dArray = X[i2];
                    int n5 = j3;
                    dArray[n5] = dArray[n5] - X[k2][j3] * this.L[k2][i2];
                }
            }
        }
        return new Matrix(X, this.n, nx);
    }
}

