/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.Jama;

import com.ge.med.jnu.Jama.Matrix;
import com.ge.med.jnu.Jama.util.Maths;
import java.io.Serializable;

public class EigenvalueDecomposition
implements Serializable {
    private int n;
    private boolean issymmetric;
    private double[] d;
    private double[] e;
    private double[][] V;
    private double[][] H;
    private double[] ort;
    private transient double cdivr;
    private transient double cdivi;

    private void tred2() {
        int i2;
        int j2;
        for (j2 = 0; j2 < this.n; ++j2) {
            this.d[j2] = this.V[this.n - 1][j2];
        }
        for (i2 = this.n - 1; i2 > 0; --i2) {
            int k2;
            double scale = 0.0;
            double h2 = 0.0;
            for (k2 = 0; k2 < i2; ++k2) {
                scale += Math.abs(this.d[k2]);
            }
            if (scale == 0.0) {
                this.e[i2] = this.d[i2 - 1];
                for (int j3 = 0; j3 < i2; ++j3) {
                    this.d[j3] = this.V[i2 - 1][j3];
                    this.V[i2][j3] = 0.0;
                    this.V[j3][i2] = 0.0;
                }
            } else {
                int j4;
                int j5;
                for (k2 = 0; k2 < i2; ++k2) {
                    int n2 = k2;
                    this.d[n2] = this.d[n2] / scale;
                    h2 += this.d[k2] * this.d[k2];
                }
                double f2 = this.d[i2 - 1];
                double g2 = Math.sqrt(h2);
                if (f2 > 0.0) {
                    g2 = -g2;
                }
                this.e[i2] = scale * g2;
                h2 -= f2 * g2;
                this.d[i2 - 1] = f2 - g2;
                for (j5 = 0; j5 < i2; ++j5) {
                    this.e[j5] = 0.0;
                }
                for (j5 = 0; j5 < i2; ++j5) {
                    this.V[j5][i2] = f2 = this.d[j5];
                    g2 = this.e[j5] + this.V[j5][j5] * f2;
                    for (int k3 = j5 + 1; k3 <= i2 - 1; ++k3) {
                        g2 += this.V[k3][j5] * this.d[k3];
                        int n3 = k3;
                        this.e[n3] = this.e[n3] + this.V[k3][j5] * f2;
                    }
                    this.e[j5] = g2;
                }
                f2 = 0.0;
                for (j5 = 0; j5 < i2; ++j5) {
                    int n4 = j5;
                    this.e[n4] = this.e[n4] / h2;
                    f2 += this.e[j5] * this.d[j5];
                }
                double hh = f2 / (h2 + h2);
                for (j4 = 0; j4 < i2; ++j4) {
                    int n5 = j4;
                    this.e[n5] = this.e[n5] - hh * this.d[j4];
                }
                for (j4 = 0; j4 < i2; ++j4) {
                    f2 = this.d[j4];
                    g2 = this.e[j4];
                    for (int k4 = j4; k4 <= i2 - 1; ++k4) {
                        double[] dArray = this.V[k4];
                        int n6 = j4;
                        dArray[n6] = dArray[n6] - (f2 * this.e[k4] + g2 * this.d[k4]);
                    }
                    this.d[j4] = this.V[i2 - 1][j4];
                    this.V[i2][j4] = 0.0;
                }
            }
            this.d[i2] = h2;
        }
        for (i2 = 0; i2 < this.n - 1; ++i2) {
            int k5;
            this.V[this.n - 1][i2] = this.V[i2][i2];
            this.V[i2][i2] = 1.0;
            double h3 = this.d[i2 + 1];
            if (h3 != 0.0) {
                for (k5 = 0; k5 <= i2; ++k5) {
                    this.d[k5] = this.V[k5][i2 + 1] / h3;
                }
                for (int j6 = 0; j6 <= i2; ++j6) {
                    int k6;
                    double g3 = 0.0;
                    for (k6 = 0; k6 <= i2; ++k6) {
                        g3 += this.V[k6][i2 + 1] * this.V[k6][j6];
                    }
                    for (k6 = 0; k6 <= i2; ++k6) {
                        double[] dArray = this.V[k6];
                        int n7 = j6;
                        dArray[n7] = dArray[n7] - g3 * this.d[k6];
                    }
                }
            }
            for (k5 = 0; k5 <= i2; ++k5) {
                this.V[k5][i2 + 1] = 0.0;
            }
        }
        for (j2 = 0; j2 < this.n; ++j2) {
            this.d[j2] = this.V[this.n - 1][j2];
            this.V[this.n - 1][j2] = 0.0;
        }
        this.V[this.n - 1][this.n - 1] = 1.0;
        this.e[0] = 0.0;
    }

    private void tql2() {
        for (int i2 = 1; i2 < this.n; ++i2) {
            this.e[i2 - 1] = this.e[i2];
        }
        this.e[this.n - 1] = 0.0;
        double f2 = 0.0;
        double tst1 = 0.0;
        double eps = Math.pow(2.0, -52.0);
        for (int l2 = 0; l2 < this.n; ++l2) {
            int m2;
            tst1 = Math.max(tst1, Math.abs(this.d[l2]) + Math.abs(this.e[l2]));
            for (m2 = l2; m2 < this.n && !(Math.abs(this.e[m2]) <= eps * tst1); ++m2) {
            }
            if (m2 > l2) {
                int iter = 0;
                do {
                    double c2;
                    ++iter;
                    double g2 = this.d[l2];
                    double p2 = (this.d[l2 + 1] - g2) / (2.0 * this.e[l2]);
                    double r2 = Maths.hypot(p2, 1.0);
                    if (p2 < 0.0) {
                        r2 = -r2;
                    }
                    this.d[l2] = this.e[l2] / (p2 + r2);
                    this.d[l2 + 1] = this.e[l2] * (p2 + r2);
                    double dl1 = this.d[l2 + 1];
                    double h2 = g2 - this.d[l2];
                    int i3 = l2 + 2;
                    while (i3 < this.n) {
                        int n2 = i3++;
                        this.d[n2] = this.d[n2] - h2;
                    }
                    f2 += h2;
                    p2 = this.d[m2];
                    double c22 = c2 = 1.0;
                    double c3 = c2;
                    double el1 = this.e[l2 + 1];
                    double s2 = 0.0;
                    double s22 = 0.0;
                    for (int i4 = m2 - 1; i4 >= l2; --i4) {
                        c3 = c22;
                        c22 = c2;
                        s22 = s2;
                        g2 = c2 * this.e[i4];
                        h2 = c2 * p2;
                        r2 = Maths.hypot(p2, this.e[i4]);
                        this.e[i4 + 1] = s2 * r2;
                        s2 = this.e[i4] / r2;
                        c2 = p2 / r2;
                        p2 = c2 * this.d[i4] - s2 * g2;
                        this.d[i4 + 1] = h2 + s2 * (c2 * g2 + s2 * this.d[i4]);
                        for (int k2 = 0; k2 < this.n; ++k2) {
                            h2 = this.V[k2][i4 + 1];
                            this.V[k2][i4 + 1] = s2 * this.V[k2][i4] + c2 * h2;
                            this.V[k2][i4] = c2 * this.V[k2][i4] - s2 * h2;
                        }
                    }
                    p2 = -s2 * s22 * c3 * el1 * this.e[l2] / dl1;
                    this.e[l2] = s2 * p2;
                    this.d[l2] = c2 * p2;
                } while (Math.abs(this.e[l2]) > eps * tst1);
            }
            this.d[l2] = this.d[l2] + f2;
            this.e[l2] = 0.0;
        }
        for (int i5 = 0; i5 < this.n - 1; ++i5) {
            int j2;
            int k3 = i5;
            double p3 = this.d[i5];
            for (j2 = i5 + 1; j2 < this.n; ++j2) {
                if (!(this.d[j2] < p3)) continue;
                k3 = j2;
                p3 = this.d[j2];
            }
            if (k3 == i5) continue;
            this.d[k3] = this.d[i5];
            this.d[i5] = p3;
            for (j2 = 0; j2 < this.n; ++j2) {
                p3 = this.V[j2][i5];
                this.V[j2][i5] = this.V[j2][k3];
                this.V[j2][k3] = p3;
            }
        }
    }

    private void orthes() {
        int m2;
        int low = 0;
        int high = this.n - 1;
        for (m2 = low + 1; m2 <= high - 1; ++m2) {
            double f2;
            double scale = 0.0;
            for (int i2 = m2; i2 <= high; ++i2) {
                scale += Math.abs(this.H[i2][m2 - 1]);
            }
            if (scale == 0.0) continue;
            double h2 = 0.0;
            for (int i3 = high; i3 >= m2; --i3) {
                this.ort[i3] = this.H[i3][m2 - 1] / scale;
                h2 += this.ort[i3] * this.ort[i3];
            }
            double g2 = Math.sqrt(h2);
            if (this.ort[m2] > 0.0) {
                g2 = -g2;
            }
            h2 -= this.ort[m2] * g2;
            this.ort[m2] = this.ort[m2] - g2;
            for (int j2 = m2; j2 < this.n; ++j2) {
                int i4;
                f2 = 0.0;
                for (i4 = high; i4 >= m2; --i4) {
                    f2 += this.ort[i4] * this.H[i4][j2];
                }
                f2 /= h2;
                for (i4 = m2; i4 <= high; ++i4) {
                    double[] dArray = this.H[i4];
                    int n2 = j2;
                    dArray[n2] = dArray[n2] - f2 * this.ort[i4];
                }
            }
            for (int i5 = 0; i5 <= high; ++i5) {
                int j3;
                f2 = 0.0;
                for (j3 = high; j3 >= m2; --j3) {
                    f2 += this.ort[j3] * this.H[i5][j3];
                }
                f2 /= h2;
                for (j3 = m2; j3 <= high; ++j3) {
                    double[] dArray = this.H[i5];
                    int n3 = j3;
                    dArray[n3] = dArray[n3] - f2 * this.ort[j3];
                }
            }
            this.ort[m2] = scale * this.ort[m2];
            this.H[m2][m2 - 1] = scale * g2;
        }
        for (int i6 = 0; i6 < this.n; ++i6) {
            for (int j4 = 0; j4 < this.n; ++j4) {
                this.V[i6][j4] = i6 == j4 ? 1.0 : 0.0;
            }
        }
        for (m2 = high - 1; m2 >= low + 1; --m2) {
            if (this.H[m2][m2 - 1] == 0.0) continue;
            for (int i7 = m2 + 1; i7 <= high; ++i7) {
                this.ort[i7] = this.H[i7][m2 - 1];
            }
            for (int j5 = m2; j5 <= high; ++j5) {
                int i8;
                double g3 = 0.0;
                for (i8 = m2; i8 <= high; ++i8) {
                    g3 += this.ort[i8] * this.V[i8][j5];
                }
                g3 = g3 / this.ort[m2] / this.H[m2][m2 - 1];
                for (i8 = m2; i8 <= high; ++i8) {
                    double[] dArray = this.V[i8];
                    int n4 = j5;
                    dArray[n4] = dArray[n4] + g3 * this.ort[i8];
                }
            }
        }
    }

    private void cdiv(double xr, double xi, double yr, double yi) {
        if (Math.abs(yr) > Math.abs(yi)) {
            double r2 = yi / yr;
            double d2 = yr + r2 * yi;
            this.cdivr = (xr + r2 * xi) / d2;
            this.cdivi = (xi - r2 * xr) / d2;
        } else {
            double r3 = yr / yi;
            double d3 = yi + r3 * yr;
            this.cdivr = (r3 * xr + xi) / d3;
            this.cdivi = (r3 * xi - xr) / d3;
        }
    }

    private void hqr2() {
        double y2;
        int i2;
        int j2;
        double x2;
        double w2;
        int l2;
        int j3;
        int nn = this.n;
        int n2 = nn - 1;
        int low = 0;
        int high = nn - 1;
        double eps = Math.pow(2.0, -52.0);
        double exshift = 0.0;
        double p2 = 0.0;
        double q2 = 0.0;
        double r2 = 0.0;
        double s2 = 0.0;
        double z2 = 0.0;
        double norm = 0.0;
        for (int i3 = 0; i3 < nn; ++i3) {
            if (i3 < low | i3 > high) {
                this.d[i3] = this.H[i3][i3];
                this.e[i3] = 0.0;
            }
            for (j3 = Math.max(i3 - 1, 0); j3 < nn; ++j3) {
                norm += Math.abs(this.H[i3][j3]);
            }
        }
        int iter = 0;
        block2: while (n2 >= low) {
            int m2;
            for (l2 = n2; l2 > low; --l2) {
                s2 = Math.abs(this.H[l2 - 1][l2 - 1]) + Math.abs(this.H[l2][l2]);
                if (s2 == 0.0) {
                    s2 = norm;
                }
                if (Math.abs(this.H[l2][l2 - 1]) < eps * s2) break;
            }
            if (l2 == n2) {
                this.H[n2][n2] = this.H[n2][n2] + exshift;
                this.d[n2] = this.H[n2][n2];
                this.e[n2] = 0.0;
                --n2;
                iter = 0;
                continue;
            }
            if (l2 == n2 - 1) {
                w2 = this.H[n2][n2 - 1] * this.H[n2 - 1][n2];
                p2 = (this.H[n2 - 1][n2 - 1] - this.H[n2][n2]) / 2.0;
                q2 = p2 * p2 + w2;
                z2 = Math.sqrt(Math.abs(q2));
                this.H[n2][n2] = this.H[n2][n2] + exshift;
                this.H[n2 - 1][n2 - 1] = this.H[n2 - 1][n2 - 1] + exshift;
                x2 = this.H[n2][n2];
                if (q2 >= 0.0) {
                    z2 = p2 >= 0.0 ? p2 + z2 : p2 - z2;
                    this.d[n2 - 1] = x2 + z2;
                    this.d[n2] = this.d[n2 - 1];
                    if (z2 != 0.0) {
                        this.d[n2] = x2 - w2 / z2;
                    }
                    this.e[n2 - 1] = 0.0;
                    this.e[n2] = 0.0;
                    x2 = this.H[n2][n2 - 1];
                    s2 = Math.abs(x2) + Math.abs(z2);
                    p2 = x2 / s2;
                    q2 = z2 / s2;
                    r2 = Math.sqrt(p2 * p2 + q2 * q2);
                    p2 /= r2;
                    q2 /= r2;
                    for (j2 = n2 - 1; j2 < nn; ++j2) {
                        z2 = this.H[n2 - 1][j2];
                        this.H[n2 - 1][j2] = q2 * z2 + p2 * this.H[n2][j2];
                        this.H[n2][j2] = q2 * this.H[n2][j2] - p2 * z2;
                    }
                    for (i2 = 0; i2 <= n2; ++i2) {
                        z2 = this.H[i2][n2 - 1];
                        this.H[i2][n2 - 1] = q2 * z2 + p2 * this.H[i2][n2];
                        this.H[i2][n2] = q2 * this.H[i2][n2] - p2 * z2;
                    }
                    for (i2 = low; i2 <= high; ++i2) {
                        z2 = this.V[i2][n2 - 1];
                        this.V[i2][n2 - 1] = q2 * z2 + p2 * this.V[i2][n2];
                        this.V[i2][n2] = q2 * this.V[i2][n2] - p2 * z2;
                    }
                } else {
                    this.d[n2 - 1] = x2 + p2;
                    this.d[n2] = x2 + p2;
                    this.e[n2 - 1] = z2;
                    this.e[n2] = -z2;
                }
                n2 -= 2;
                iter = 0;
                continue;
            }
            x2 = this.H[n2][n2];
            y2 = 0.0;
            w2 = 0.0;
            if (l2 < n2) {
                y2 = this.H[n2 - 1][n2 - 1];
                w2 = this.H[n2][n2 - 1] * this.H[n2 - 1][n2];
            }
            if (iter == 10) {
                exshift += x2;
                i2 = low;
                while (i2 <= n2) {
                    double[] dArray = this.H[i2];
                    int n3 = i2++;
                    dArray[n3] = dArray[n3] - x2;
                }
                s2 = Math.abs(this.H[n2][n2 - 1]) + Math.abs(this.H[n2 - 1][n2 - 2]);
                x2 = y2 = 0.75 * s2;
                w2 = -0.4375 * s2 * s2;
            }
            if (iter == 30) {
                s2 = (y2 - x2) / 2.0;
                if ((s2 = s2 * s2 + w2) > 0.0) {
                    s2 = Math.sqrt(s2);
                    if (y2 < x2) {
                        s2 = -s2;
                    }
                    s2 = x2 - w2 / ((y2 - x2) / 2.0 + s2);
                    i2 = low;
                    while (i2 <= n2) {
                        double[] dArray = this.H[i2];
                        int n4 = i2++;
                        dArray[n4] = dArray[n4] - s2;
                    }
                    exshift += s2;
                    w2 = 0.964;
                    y2 = 0.964;
                    x2 = 0.964;
                }
            }
            ++iter;
            for (m2 = n2 - 2; m2 >= l2; --m2) {
                z2 = this.H[m2][m2];
                r2 = x2 - z2;
                s2 = y2 - z2;
                p2 = (r2 * s2 - w2) / this.H[m2 + 1][m2] + this.H[m2][m2 + 1];
                q2 = this.H[m2 + 1][m2 + 1] - z2 - r2 - s2;
                r2 = this.H[m2 + 2][m2 + 1];
                s2 = Math.abs(p2) + Math.abs(q2) + Math.abs(r2);
                if (m2 == l2 || Math.abs(this.H[m2][m2 - 1]) * (Math.abs(q2 /= s2) + Math.abs(r2 /= s2)) < eps * (Math.abs(p2 /= s2) * (Math.abs(this.H[m2 - 1][m2 - 1]) + Math.abs(z2) + Math.abs(this.H[m2 + 1][m2 + 1])))) break;
            }
            for (int i4 = m2 + 2; i4 <= n2; ++i4) {
                this.H[i4][i4 - 2] = 0.0;
                if (i4 <= m2 + 2) continue;
                this.H[i4][i4 - 3] = 0.0;
            }
            for (int k2 = m2; k2 <= n2 - 1; ++k2) {
                int i5;
                boolean notlast;
                boolean bl = notlast = k2 != n2 - 1;
                if (k2 != m2) {
                    p2 = this.H[k2][k2 - 1];
                    q2 = this.H[k2 + 1][k2 - 1];
                    r2 = notlast ? this.H[k2 + 2][k2 - 1] : 0.0;
                    x2 = Math.abs(p2) + Math.abs(q2) + Math.abs(r2);
                    if (x2 != 0.0) {
                        p2 /= x2;
                        q2 /= x2;
                        r2 /= x2;
                    }
                }
                if (x2 == 0.0) continue block2;
                s2 = Math.sqrt(p2 * p2 + q2 * q2 + r2 * r2);
                if (p2 < 0.0) {
                    s2 = -s2;
                }
                if (s2 == 0.0) continue;
                if (k2 != m2) {
                    this.H[k2][k2 - 1] = -s2 * x2;
                } else if (l2 != m2) {
                    this.H[k2][k2 - 1] = -this.H[k2][k2 - 1];
                }
                x2 = (p2 += s2) / s2;
                y2 = q2 / s2;
                z2 = r2 / s2;
                q2 /= p2;
                r2 /= p2;
                for (int j4 = k2; j4 < nn; ++j4) {
                    p2 = this.H[k2][j4] + q2 * this.H[k2 + 1][j4];
                    if (notlast) {
                        this.H[k2 + 2][j4] = this.H[k2 + 2][j4] - (p2 += r2 * this.H[k2 + 2][j4]) * z2;
                    }
                    this.H[k2][j4] = this.H[k2][j4] - p2 * x2;
                    this.H[k2 + 1][j4] = this.H[k2 + 1][j4] - p2 * y2;
                }
                for (i5 = 0; i5 <= Math.min(n2, k2 + 3); ++i5) {
                    p2 = x2 * this.H[i5][k2] + y2 * this.H[i5][k2 + 1];
                    if (notlast) {
                        this.H[i5][k2 + 2] = this.H[i5][k2 + 2] - (p2 += z2 * this.H[i5][k2 + 2]) * r2;
                    }
                    this.H[i5][k2] = this.H[i5][k2] - p2;
                    this.H[i5][k2 + 1] = this.H[i5][k2 + 1] - p2 * q2;
                }
                for (i5 = low; i5 <= high; ++i5) {
                    p2 = x2 * this.V[i5][k2] + y2 * this.V[i5][k2 + 1];
                    if (notlast) {
                        this.V[i5][k2 + 2] = this.V[i5][k2 + 2] - (p2 += z2 * this.V[i5][k2 + 2]) * r2;
                    }
                    this.V[i5][k2] = this.V[i5][k2] - p2;
                    this.V[i5][k2 + 1] = this.V[i5][k2 + 1] - p2 * q2;
                }
            }
        }
        if (norm == 0.0) {
            return;
        }
        for (n2 = nn - 1; n2 >= 0; --n2) {
            double t2;
            p2 = this.d[n2];
            q2 = this.e[n2];
            if (q2 == 0.0) {
                l2 = n2;
                this.H[n2][n2] = 1.0;
                for (i2 = n2 - 1; i2 >= 0; --i2) {
                    int j5;
                    w2 = this.H[i2][i2] - p2;
                    r2 = 0.0;
                    for (j5 = l2; j5 <= n2; ++j5) {
                        r2 += this.H[i2][j5] * this.H[j5][n2];
                    }
                    if (this.e[i2] < 0.0) {
                        z2 = w2;
                        s2 = r2;
                        continue;
                    }
                    l2 = i2;
                    if (this.e[i2] == 0.0) {
                        this.H[i2][n2] = w2 != 0.0 ? -r2 / w2 : -r2 / (eps * norm);
                    } else {
                        x2 = this.H[i2][i2 + 1];
                        y2 = this.H[i2 + 1][i2];
                        q2 = (this.d[i2] - p2) * (this.d[i2] - p2) + this.e[i2] * this.e[i2];
                        this.H[i2][n2] = t2 = (x2 * s2 - z2 * r2) / q2;
                        this.H[i2 + 1][n2] = Math.abs(x2) > Math.abs(z2) ? (-r2 - w2 * t2) / x2 : (-s2 - y2 * t2) / z2;
                    }
                    t2 = Math.abs(this.H[i2][n2]);
                    if (!(eps * t2 * t2 > 1.0)) continue;
                    for (j5 = i2; j5 <= n2; ++j5) {
                        this.H[j5][n2] = this.H[j5][n2] / t2;
                    }
                }
                continue;
            }
            if (!(q2 < 0.0)) continue;
            l2 = n2 - 1;
            if (Math.abs(this.H[n2][n2 - 1]) > Math.abs(this.H[n2 - 1][n2])) {
                this.H[n2 - 1][n2 - 1] = q2 / this.H[n2][n2 - 1];
                this.H[n2 - 1][n2] = -(this.H[n2][n2] - p2) / this.H[n2][n2 - 1];
            } else {
                this.cdiv(0.0, -this.H[n2 - 1][n2], this.H[n2 - 1][n2 - 1] - p2, q2);
                this.H[n2 - 1][n2 - 1] = this.cdivr;
                this.H[n2 - 1][n2] = this.cdivi;
            }
            this.H[n2][n2 - 1] = 0.0;
            this.H[n2][n2] = 1.0;
            for (i2 = n2 - 2; i2 >= 0; --i2) {
                int j6;
                double ra = 0.0;
                double sa = 0.0;
                for (j6 = l2; j6 <= n2; ++j6) {
                    ra += this.H[i2][j6] * this.H[j6][n2 - 1];
                    sa += this.H[i2][j6] * this.H[j6][n2];
                }
                w2 = this.H[i2][i2] - p2;
                if (this.e[i2] < 0.0) {
                    z2 = w2;
                    r2 = ra;
                    s2 = sa;
                    continue;
                }
                l2 = i2;
                if (this.e[i2] == 0.0) {
                    this.cdiv(-ra, -sa, w2, q2);
                    this.H[i2][n2 - 1] = this.cdivr;
                    this.H[i2][n2] = this.cdivi;
                } else {
                    double vi;
                    x2 = this.H[i2][i2 + 1];
                    y2 = this.H[i2 + 1][i2];
                    double vr2 = (this.d[i2] - p2) * (this.d[i2] - p2) + this.e[i2] * this.e[i2] - q2 * q2;
                    if (vr2 == 0.0 & (vi = (this.d[i2] - p2) * 2.0 * q2) == 0.0) {
                        vr2 = eps * norm * (Math.abs(w2) + Math.abs(q2) + Math.abs(x2) + Math.abs(y2) + Math.abs(z2));
                    }
                    this.cdiv(x2 * r2 - z2 * ra + q2 * sa, x2 * s2 - z2 * sa - q2 * ra, vr2, vi);
                    this.H[i2][n2 - 1] = this.cdivr;
                    this.H[i2][n2] = this.cdivi;
                    if (Math.abs(x2) > Math.abs(z2) + Math.abs(q2)) {
                        this.H[i2 + 1][n2 - 1] = (-ra - w2 * this.H[i2][n2 - 1] + q2 * this.H[i2][n2]) / x2;
                        this.H[i2 + 1][n2] = (-sa - w2 * this.H[i2][n2] - q2 * this.H[i2][n2 - 1]) / x2;
                    } else {
                        this.cdiv(-r2 - y2 * this.H[i2][n2 - 1], -s2 - y2 * this.H[i2][n2], z2, q2);
                        this.H[i2 + 1][n2 - 1] = this.cdivr;
                        this.H[i2 + 1][n2] = this.cdivi;
                    }
                }
                t2 = Math.max(Math.abs(this.H[i2][n2 - 1]), Math.abs(this.H[i2][n2]));
                if (!(eps * t2 * t2 > 1.0)) continue;
                for (j6 = i2; j6 <= n2; ++j6) {
                    this.H[j6][n2 - 1] = this.H[j6][n2 - 1] / t2;
                    this.H[j6][n2] = this.H[j6][n2] / t2;
                }
            }
        }
        for (int i6 = 0; i6 < nn; ++i6) {
            if (!(i6 < low | i6 > high)) continue;
            for (j2 = i6; j2 < nn; ++j2) {
                this.V[i6][j2] = this.H[i6][j2];
            }
        }
        for (j3 = nn - 1; j3 >= low; --j3) {
            for (i2 = low; i2 <= high; ++i2) {
                z2 = 0.0;
                for (int k3 = low; k3 <= Math.min(j3, high); ++k3) {
                    z2 += this.V[i2][k3] * this.H[k3][j3];
                }
                this.V[i2][j3] = z2;
            }
        }
    }

    public EigenvalueDecomposition(Matrix Arg) {
        int i2;
        double[][] A2 = Arg.getArray();
        this.n = Arg.getColumnDimension();
        this.V = new double[this.n][this.n];
        this.d = new double[this.n];
        this.e = new double[this.n];
        this.issymmetric = true;
        int j2 = 0;
        while (j2 < this.n & this.issymmetric) {
            i2 = 0;
            while (i2 < this.n & this.issymmetric) {
                this.issymmetric = A2[i2][j2] == A2[j2][i2];
                ++i2;
            }
            ++j2;
        }
        if (this.issymmetric) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                for (int j3 = 0; j3 < this.n; ++j3) {
                    this.V[i3][j3] = A2[i3][j3];
                }
            }
            this.tred2();
            this.tql2();
        } else {
            this.H = new double[this.n][this.n];
            this.ort = new double[this.n];
            for (j2 = 0; j2 < this.n; ++j2) {
                for (i2 = 0; i2 < this.n; ++i2) {
                    this.H[i2][j2] = A2[i2][j2];
                }
            }
            this.orthes();
            this.hqr2();
        }
    }

    public Matrix getV() {
        return new Matrix(this.V, this.n, this.n);
    }

    public double[] getRealEigenvalues() {
        return this.d;
    }

    public double[] getImagEigenvalues() {
        return this.e;
    }

    public Matrix getD() {
        Matrix X = new Matrix(this.n, this.n);
        double[][] D = X.getArray();
        for (int i2 = 0; i2 < this.n; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                D[i2][j2] = 0.0;
            }
            D[i2][i2] = this.d[i2];
            if (this.e[i2] > 0.0) {
                D[i2][i2 + 1] = this.e[i2];
                continue;
            }
            if (!(this.e[i2] < 0.0)) continue;
            D[i2][i2 - 1] = this.e[i2];
        }
        return X;
    }
}

