/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu;

import com.ge.med.jnu.Jama.EigenvalueDecomposition;
import com.ge.med.jnu.Jama.LUDecomposition;
import com.ge.med.jnu.Jama.Matrix;
import com.ge.med.jnu.JnEigenvalueDecomposition;
import com.ge.med.jnu.JnUtils;
import com.ge.med.jnu.JnVector;
import java.io.PrintStream;
import java.util.Arrays;

public class JnMatrix {
    public double[] data = null;
    public int rows = 0;
    public int cols = 0;

    public JnMatrix(int r2, int c2) {
        this.initData(r2, c2);
    }

    public JnMatrix(int r2, int c2, double val) {
        this(r2, c2);
        Arrays.fill(this.data, val);
    }

    public JnMatrix(double[] data, int nrows) {
        int cols = data.length / nrows;
        this.initData(nrows, cols);
        System.arraycopy(data, 0, this.data, 0, data.length);
    }

    public JnMatrix(JnMatrix m2) {
        this.initData(m2.rows, m2.cols);
        System.arraycopy(m2.data, 0, this.data, 0, this.data.length);
    }

    private final void initData(int r2, int c2) {
        this.data = new double[r2 * c2];
        this.rows = r2;
        this.cols = c2;
    }

    public final boolean set(double[] data) {
        if (this.data.length != data.length) {
            return false;
        }
        System.arraycopy(data, 0, this.data, 0, data.length);
        return true;
    }

    public final int getNumRow() {
        return this.rows;
    }

    public final int getNumCol() {
        return this.cols;
    }

    public final int getNumElements() {
        return this.data.length;
    }

    public final boolean getData(double[] data) {
        int len = this.getNumElements();
        if (len > data.length) {
            return false;
        }
        System.arraycopy(this.data, 0, data, 0, data.length);
        return true;
    }

    public final void setIdentity() {
        this.setScale(1.0);
    }

    public final void setScale(double scale) {
        this.setZero();
        for (int i2 = 0; i2 < this.rows; ++i2) {
            this.data[i2 * this.cols + i2] = scale;
        }
    }

    public final void setZero() {
        Arrays.fill(this.data, 0.0);
    }

    public final void mul(double scalar) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = scalar * this.data[i2];
        }
    }

    public final void mul(double scalar, JnMatrix m2) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = scalar * m2.data[i2];
        }
    }

    public final void mul(JnMatrix m1) {
        Matrix M1 = JnMatrix.getJamaMatrix(this);
        Matrix M2 = JnMatrix.getJamaMatrix(m1);
        Matrix p2 = M1.times(M2);
        JnMatrix.setJamaMatrix(this, p2);
    }

    public final void mul(JnMatrix m1, JnMatrix m2) {
        Matrix M1 = JnMatrix.getJamaMatrix(m1);
        Matrix M2 = JnMatrix.getJamaMatrix(m2);
        Matrix p2 = M1.times(M2);
        JnMatrix.setJamaMatrix(this, p2);
    }

    public final boolean isIdentity() {
        for (int i2 = 0; i2 < this.rows; ++i2) {
            int offset = i2 * this.cols;
            for (int j2 = 0; j2 < this.cols; ++j2) {
                double d2 = this.data[offset + j2];
                if (!(i2 == j2 ? !JnUtils.one(d2) : !JnUtils.zero(d2))) continue;
                return false;
            }
        }
        return true;
    }

    public final boolean equals(Object o2) {
        if (null == o2) {
            return false;
        }
        JnMatrix m2 = (JnMatrix)o2;
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            double val = Math.abs(this.data[i2] - m2.data[i2]);
            if (JnUtils.zero(val)) continue;
            return false;
        }
        return true;
    }

    public final void negate() {
        this.mul(-1.0);
    }

    public final double determinant() {
        Matrix m2 = JnMatrix.getJamaMatrix(this);
        double ans = m2.det();
        return ans;
    }

    public final void invert() {
        Matrix m2 = JnMatrix.getJamaMatrix(this);
        Matrix inv = m2.inverse();
        JnMatrix.setJamaMatrix(this, inv);
    }

    public final void invert(JnMatrix m1) {
        Matrix m2 = JnMatrix.getJamaMatrix(m1);
        Matrix inv = m2.inverse();
        JnMatrix.setJamaMatrix(this, inv);
    }

    public final JnMatrix transpose() {
        JnMatrix t2 = new JnMatrix(this.cols, this.rows);
        int index = 0;
        for (int j2 = 0; j2 < this.rows; ++j2) {
            int i2 = 0;
            while (i2 < this.cols) {
                t2.data[i2 * this.rows + j2] = this.data[index];
                ++i2;
                ++index;
            }
        }
        return t2;
    }

    public final boolean LUDSolve(JnVector b2, JnVector x2) {
        Matrix M = JnMatrix.getJamaMatrix(this);
        Matrix B = JnMatrix.getJamaMatrix(b2);
        LUDecomposition lud = M.lu();
        Matrix X = M.solve(B);
        JnMatrix.setJamaMatrix(x2, X);
        return true;
    }

    private static final Matrix getJamaMatrix(JnMatrix M) {
        Matrix m2 = new Matrix(M.rows, M.cols);
        for (int i2 = 0; i2 < M.rows; ++i2) {
            int offset = i2 * M.cols;
            for (int j2 = 0; j2 < M.cols; ++j2) {
                m2.set(i2, j2, M.data[offset + j2]);
            }
        }
        return m2;
    }

    public final boolean transform(JnVector t2, JnVector res) {
        if (t2.data.length != res.data.length) {
            return false;
        }
        if (t2.data.length != this.rows) {
            return false;
        }
        for (int i2 = 0; i2 < this.rows; ++i2) {
            int offset = i2 * this.cols;
            res.data[i2] = 0.0;
            for (int j2 = 0; j2 < this.cols; ++j2) {
                int n2 = i2;
                res.data[n2] = res.data[n2] + this.data[offset + j2] * t2.data[j2];
            }
        }
        return true;
    }

    public final double trace() {
        Matrix m2 = JnMatrix.getJamaMatrix(this);
        return m2.trace();
    }

    public final JnEigenvalueDecomposition getEigenValueDecomposition() {
        Matrix m2 = JnMatrix.getJamaMatrix(this);
        return new EValueDecomposition(m2.eig());
    }

    private static final Matrix getJamaMatrix(JnVector v2) {
        Matrix m2 = new Matrix(v2.data, v2.getSize());
        return m2;
    }

    private static void setJamaMatrix(JnMatrix M, Matrix m2) {
        double[][] d2 = m2.getArray();
        for (int i2 = 0; i2 < M.rows; ++i2) {
            int offset = i2 * M.cols;
            for (int j2 = 0; j2 < M.cols; ++j2) {
                M.data[offset + j2] = d2[i2][j2];
            }
        }
    }

    private static void setJamaMatrix(JnVector v2, Matrix m2) {
        double[][] d2 = m2.getArray();
        for (int i2 = 0; i2 < d2.length; ++i2) {
            v2.data[i2] = d2[i2][0];
        }
    }

    public final void print() {
        this.print(System.out);
    }

    public final void print(PrintStream ps) {
        for (int i2 = 0; i2 < this.rows; ++i2) {
            for (int j2 = 0; j2 < this.cols; ++j2) {
                String val = JnUtils.format(this.data[i2 * this.cols + j2]);
                ps.print(val + " ");
            }
            ps.println();
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    private static class EValueDecomposition
    implements JnEigenvalueDecomposition {
        private EigenvalueDecomposition evd = null;
        private JnMatrix eigenMatrix = null;

        public EValueDecomposition(EigenvalueDecomposition evd) {
            this.evd = evd;
        }

        @Override
        public double[] getImagEigenValues() {
            return this.evd.getImagEigenvalues();
        }

        @Override
        public double[] getRealEigenValues() {
            return this.evd.getRealEigenvalues();
        }

        @Override
        public JnMatrix getEigenVectors() {
            if (this.eigenMatrix == null) {
                Matrix m2 = this.evd.getV();
                this.eigenMatrix = new JnMatrix(m2.getRowDimension(), m2.getColumnDimension());
                JnMatrix.setJamaMatrix(this.eigenMatrix, m2);
            }
            return this.eigenMatrix;
        }
    }
}

