/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu;

public class JnTupleArrayFloat {
    protected float[] data = null;
    protected int capacity;
    protected int totalCapacity;
    protected int numTuples;
    protected int size;
    protected int numComponents;

    public JnTupleArrayFloat() {
        this.capacity = 10;
        this.totalCapacity = 10;
        this.numComponents = 1;
        this.numTuples = 0;
        this.size = 0;
        this.data = new float[this.capacity];
    }

    public JnTupleArrayFloat(int numComponents) {
        this.numComponents = numComponents < 1 ? 1 : numComponents;
        this.capacity = 10;
        this.totalCapacity = this.capacity * this.numComponents;
        this.numTuples = 0;
        this.size = 0;
        this.data = new float[this.totalCapacity];
    }

    public JnTupleArrayFloat(int numComponents, int initialCapacity) {
        this.numComponents = numComponents < 1 ? 1 : numComponents;
        this.capacity = initialCapacity < 1 ? 1 : initialCapacity;
        this.totalCapacity = this.capacity * this.numComponents;
        this.numTuples = 0;
        this.size = 0;
        this.data = new float[this.totalCapacity];
    }

    public JnTupleArrayFloat(int numComponents, float[] data, int numTuples) {
        this.numComponents = numComponents < 1 ? 1 : numComponents;
        this.totalCapacity = data.length;
        this.capacity = this.totalCapacity / this.numComponents;
        int n2 = this.numTuples = numTuples < 0 ? 0 : numTuples;
        if (this.numTuples > this.capacity) {
            this.numTuples = this.capacity;
        }
        this.size = this.numTuples * this.numComponents;
        this.data = data;
    }

    public Object clone() {
        JnTupleArrayFloat clone = new JnTupleArrayFloat(this.numComponents, this.capacity);
        clone.copy(this);
        return clone;
    }

    public void copy(JnTupleArrayFloat src) {
        if (src != this && src != null) {
            if (this.data != null && this.capacity != src.getCapacity()) {
                this.data = null;
            }
            this.numComponents = src.getNumComponents();
            this.capacity = src.getCapacity();
            this.totalCapacity = this.capacity * this.numComponents;
            this.numTuples = src.getNumTuples();
            this.size = this.numTuples * this.numComponents;
            if (this.data == null) {
                this.data = new float[this.totalCapacity];
            }
            System.arraycopy(src.getData(), 0, this.data, 0, this.size);
        }
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public int getNumTuples() {
        return this.numTuples;
    }

    public boolean isEmpty() {
        return this.numTuples == 0;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public float[] get(int id, float[] tuple) {
        if (tuple == null || tuple.length < this.numComponents) {
            tuple = new float[this.numComponents];
        }
        int index = this.numComponents * id;
        int i2 = 0;
        while (i2 < this.numComponents) {
            tuple[i2] = this.data[index];
            ++i2;
            ++index;
        }
        return tuple;
    }

    public int getTupleIndex(int id) {
        return this.numComponents * id;
    }

    public void set(int id, float[] newData) {
        int index = this.numComponents * id;
        int i2 = 0;
        while (i2 < this.numComponents) {
            this.data[index] = newData[i2];
            ++i2;
            ++index;
        }
    }

    public float[] getData() {
        return this.data;
    }

    public int add(float[] tuple) {
        ++this.numTuples;
        this.size += this.numComponents;
        if (this.numTuples > this.capacity) {
            this.extend();
        }
        int index = this.size - this.numComponents;
        int i2 = 0;
        while (i2 < this.numComponents) {
            this.data[index] = tuple[i2];
            ++i2;
            ++index;
        }
        return this.numTuples - 1;
    }

    public int addSingle(float x2) {
        if (this.numComponents != 1) {
            throw new UnsupportedOperationException();
        }
        ++this.numTuples;
        this.size += this.numComponents;
        if (this.numTuples > this.capacity) {
            this.extend();
        }
        int index = this.size - this.numComponents;
        this.data[index] = x2;
        return this.numTuples - 1;
    }

    public int addDouble(float x2, float y2) {
        if (this.numComponents != 2) {
            throw new UnsupportedOperationException();
        }
        ++this.numTuples;
        this.size += this.numComponents;
        if (this.numTuples > this.capacity) {
            this.extend();
        }
        int index = this.size - this.numComponents;
        this.data[index] = x2;
        this.data[index + 1] = y2;
        return this.numTuples - 1;
    }

    public int addTriple(float x2, float y2, float z2) {
        if (this.numComponents != 3) {
            throw new UnsupportedOperationException();
        }
        ++this.numTuples;
        this.size += this.numComponents;
        if (this.numTuples > this.capacity) {
            this.extend();
        }
        int index = this.size - this.numComponents;
        this.data[index++] = x2;
        this.data[index++] = y2;
        this.data[index] = z2;
        return this.numTuples - 1;
    }

    public void insert(int index, float[] tuple) {
        if (index == this.numTuples) {
            this.add(tuple);
            return;
        }
        ++this.numTuples;
        this.size += this.numComponents;
        if (this.numTuples > this.capacity) {
            this.extend();
        }
        int dataIndex = index * this.numComponents;
        int dataShiftLength = (this.numTuples - 1 - index) * this.numComponents;
        System.arraycopy(this.data, dataIndex, this.data, dataIndex + this.numComponents, dataShiftLength);
        int i2 = 0;
        while (i2 < this.numComponents) {
            this.data[dataIndex] = tuple[i2];
            ++i2;
            ++dataIndex;
        }
    }

    public void insertSingle(int index, float x2) {
        if (this.numComponents != 1) {
            throw new UnsupportedOperationException();
        }
        if (index == this.numTuples) {
            this.addSingle(x2);
            return;
        }
        ++this.numTuples;
        this.size += this.numComponents;
        if (this.numTuples > this.capacity) {
            this.extend();
        }
        int dataShiftLength = this.numTuples - 1 - index;
        System.arraycopy(this.data, index, this.data, index + 1, dataShiftLength);
        this.data[index] = x2;
    }

    public void insertDouble(int index, float x2, float y2) {
        if (this.numComponents != 2) {
            throw new UnsupportedOperationException();
        }
        if (index == this.numTuples) {
            this.addDouble(x2, y2);
            return;
        }
        ++this.numTuples;
        this.size += this.numComponents;
        if (this.numTuples > this.capacity) {
            this.extend();
        }
        int dataIndex = index * this.numComponents;
        int dataShiftLength = (this.numTuples - 1 - index) * this.numComponents;
        System.arraycopy(this.data, dataIndex, this.data, dataIndex + this.numComponents, dataShiftLength);
        this.data[dataIndex] = x2;
        this.data[dataIndex + 1] = y2;
    }

    public void insertTriple(int index, float x2, float y2, float z2) {
        if (this.numComponents != 3) {
            throw new UnsupportedOperationException();
        }
        if (index == this.numTuples) {
            this.addTriple(x2, y2, z2);
            return;
        }
        ++this.numTuples;
        this.size += this.numComponents;
        if (this.numTuples > this.capacity) {
            this.extend();
        }
        int dataIndex = index * this.numComponents;
        int dataShiftLength = (this.numTuples - 1 - index) * this.numComponents;
        System.arraycopy(this.data, dataIndex, this.data, dataIndex + this.numComponents, dataShiftLength);
        this.data[dataIndex++] = x2;
        this.data[dataIndex++] = y2;
        this.data[dataIndex] = z2;
    }

    public void append(JnTupleArrayFloat src) {
        if (src == null || src == this) {
            return;
        }
        if (this.getNumComponents() != src.getNumComponents()) {
            throw new IllegalArgumentException("Number of components did not match in append method.");
        }
        int newNumTuples = this.getNumTuples() + src.getNumTuples();
        if (newNumTuples > this.getCapacity()) {
            this.resize(newNumTuples);
        }
        System.arraycopy(src.getData(), 0, this.data, this.size, src.size);
        this.numTuples = newNumTuples;
        this.size = this.numTuples * this.numComponents;
    }

    public boolean removeLastTuple() {
        if (this.size == 0) {
            return false;
        }
        --this.numTuples;
        this.size -= this.numComponents;
        return true;
    }

    public void remove(int index) {
        if (index < 0 || index >= this.getNumTuples()) {
            throw new IndexOutOfBoundsException();
        }
        if (index != this.getNumTuples() - 1) {
            int dataIndex = index * this.numComponents;
            int dataShiftLength = (this.numTuples - 1 - index) * this.numComponents;
            System.arraycopy(this.data, dataIndex + this.numComponents, this.data, dataIndex, dataShiftLength);
        }
        --this.numTuples;
        this.size -= this.numComponents;
    }

    public void squeeze() {
        this.resize(this.numTuples);
    }

    public void resize(int numTuples) {
        if (numTuples != this.capacity) {
            int newTotalCapacity = numTuples * this.numComponents;
            float[] newArray = null;
            newArray = new float[newTotalCapacity];
            if (numTuples > this.numTuples) {
                System.arraycopy(this.data, 0, newArray, 0, this.totalCapacity);
            } else {
                System.arraycopy(this.data, 0, newArray, 0, newTotalCapacity);
            }
            this.capacity = numTuples;
            this.totalCapacity = newTotalCapacity;
            this.data = newArray;
        }
    }

    public void clear() {
        this.size = 0;
        this.numTuples = 0;
    }

    protected void extend() {
        int newTotalCapacity = Math.max(this.totalCapacity + this.size, 100000);
        float[] newArray = null;
        newArray = new float[newTotalCapacity];
        System.arraycopy(this.data, 0, newArray, 0, this.totalCapacity);
        this.capacity = this.numTuples + this.capacity;
        this.totalCapacity = newTotalCapacity;
        this.data = newArray;
    }
}

