/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu;

import com.ge.med.jnu.JnUtils;
import java.io.PrintStream;
import java.util.Arrays;

public class JnVector {
    public double[] data = null;

    public JnVector(int n2) {
        this.data = new double[n2];
    }

    public JnVector(double[] d2) {
        this.data = new double[d2.length];
        System.arraycopy(d2, 0, this.data, 0, d2.length);
    }

    public JnVector(JnVector v2) {
        this.data = new double[v2.data.length];
        this.set(v2);
    }

    public final int getSize() {
        return this.data.length;
    }

    public final boolean set(double[] data) {
        if (this.data.length != data.length) {
            return false;
        }
        System.arraycopy(data, 0, this.data, 0, data.length);
        return true;
    }

    public final boolean equals(Object o2) {
        JnVector m2 = (JnVector)o2;
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            double val = Math.abs(this.data[i2] - m2.data[i2]);
            if (JnUtils.zero(val)) continue;
            return false;
        }
        return true;
    }

    public final void set(JnVector v2) {
        if (v2.data.length != this.data.length) {
            return;
        }
        System.arraycopy(v2.data, 0, this.data, 0, this.data.length);
    }

    public final void add(JnVector v2) {
        if (v2.data.length != this.data.length) {
            return;
        }
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            int n2 = i2;
            this.data[n2] = this.data[n2] + v2.data[i2];
        }
    }

    public final void add(JnVector v1, JnVector v2) {
        if (v1.data.length != this.data.length) {
            return;
        }
        if (v2.data.length != this.data.length) {
            return;
        }
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = v1.data[i2] + v2.data[i2];
        }
    }

    public final void sub(JnVector v2) {
        if (v2.data.length != this.data.length) {
            return;
        }
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            int n2 = i2;
            this.data[n2] = this.data[n2] - v2.data[i2];
        }
    }

    public final void sub(JnVector v1, JnVector v2) {
        if (v1.data.length != this.data.length) {
            return;
        }
        if (v2.data.length != this.data.length) {
            return;
        }
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = v1.data[i2] - v2.data[i2];
        }
    }

    public final void scale(double s2) {
        int i2 = 0;
        while (i2 < this.data.length) {
            int n2 = i2++;
            this.data[n2] = this.data[n2] * s2;
        }
    }

    public final void scaleAdd(double s2, JnVector v2) {
        if (v2.data.length != this.data.length) {
            return;
        }
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            int n2 = i2;
            this.data[n2] = this.data[n2] + s2 * v2.data[i2];
        }
    }

    public final double lengthSquared() {
        double val = 0.0;
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            val += this.data[i2] * this.data[i2];
        }
        return val;
    }

    public final double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public final double dot(JnVector v2) {
        if (v2.data.length != this.data.length) {
            return Double.NaN;
        }
        double val = 0.0;
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            val += this.data[i2] * v2.data[i2];
        }
        return val;
    }

    public final double angle(JnVector v2) {
        double dotVal = this.dot(v2);
        double l1 = this.length();
        double l2 = v2.length();
        double angle = Math.acos(dotVal / (l1 * l2));
        return angle;
    }

    public final void normalize() {
        double len = this.length();
        int i2 = 0;
        while (i2 < this.data.length) {
            int n2 = i2++;
            this.data[n2] = this.data[n2] / len;
        }
    }

    public final void printVector() {
        this.printVector(System.out);
    }

    public final void printVector(PrintStream ps) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            String val = JnUtils.format(this.data[i2]);
            ps.print(val + " ");
            ps.println();
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }
}

