/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu;

import com.ge.med.jnu.JnTuple3i;

public class JnVector3i
extends JnTuple3i {
    public JnVector3i() {
    }

    public JnVector3i(int x2, int y2, int z2) {
        this.set(x2, y2, z2);
    }

    public JnVector3i(int[] v2) {
        this.set(v2);
    }

    public final void get(int[] v2) {
        v2[0] = this.x;
        v2[1] = this.y;
        v2[2] = this.z;
    }

    public final void set(JnVector3i v2) {
        this.x = v2.x;
        this.y = v2.y;
        this.z = v2.z;
    }

    public final void set(int x2, int y2, int z2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
    }

    public final void set(int[] v2) {
        this.x = v2[0];
        this.y = v2[1];
        this.z = v2[2];
    }

    public final void add(JnVector3i v2) {
        this.x += v2.x;
        this.y += v2.y;
        this.z += v2.z;
    }

    public final void add(JnVector3i v1, JnVector3i v2) {
        this.x = v1.x + v2.x;
        this.y = v1.y + v2.y;
        this.z = v1.z + v2.z;
    }

    public final void sub(JnVector3i v2) {
        this.x -= v2.x;
        this.y -= v2.y;
        this.z -= v2.z;
    }

    public final void sub(JnVector3i v1, JnVector3i v2) {
        this.x = v1.x - v2.x;
        this.y = v1.y - v2.y;
        this.z = v1.z - v2.z;
    }

    public final void scale(int s2) {
        this.x *= s2;
        this.y *= s2;
        this.z *= s2;
    }

    public final void scaleAdd(int s2, JnVector3i v2) {
        this.x += s2 * v2.x;
        this.y += s2 * v2.y;
        this.z += s2 * v2.z;
    }

    public final void scaleAdd(int s2, JnVector3i v1, JnVector3i v2) {
        this.x = s2 * v1.x + v2.x;
        this.y = s2 * v1.y + v2.y;
        this.z = s2 * v1.z + v2.z;
    }

    public final int lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public final int dot(JnVector3i v2) {
        return this.x * v2.x + this.y * v2.y + this.z * v2.z;
    }

    public static JnVector3i cross(JnVector3i v1, JnVector3i v2) {
        JnVector3i result = new JnVector3i();
        JnVector3i.cross(v1, v2, result);
        return result;
    }

    public static void cross(JnVector3i v1, JnVector3i v2, JnVector3i result) {
        result.x = v1.y * v2.z - v1.z * v2.y;
        result.y = v1.z * v2.x - v1.x * v2.z;
        result.z = v1.x * v2.y - v1.y * v2.x;
    }

    public static JnVector3i cross(int[] v1, int[] v2) {
        JnVector3i result = new JnVector3i();
        result.x = v1[1] * v2[2] - v1[2] * v2[1];
        result.y = v1[2] * v2[0] - v1[0] * v2[2];
        result.z = v1[0] * v2[1] - v1[1] * v2[0];
        return result;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        JnVector3i v3d = (JnVector3i)other;
        return this.x == v3d.x && this.y == v3d.y && this.z == v3d.z;
    }

    public final double angle(JnVector3i v2) {
        double dotVal = this.dot(v2);
        double l1 = this.length();
        double l2 = v2.length();
        double angle = Math.acos(dotVal / (l1 * l2));
        return angle;
    }

    public final int[] generateArray() {
        int[] a2 = new int[]{this.x, this.y, this.z};
        return a2;
    }

    public final String toString() {
        return "[" + this.x + "," + this.y + "," + this.z + "]";
    }

    public final void setLocation(int x2, int y2, int z2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
    }

    public final void setLocation(JnVector3i v2) {
        this.setLocation(v2.x, v2.y, v2.z);
    }

    public final int magnitudeSq() {
        return this.lengthSquared();
    }

    public final double magnitude() {
        return this.length();
    }

    public final void subtract(JnVector3i p2) {
        this.sub(p2);
    }

    public final void multiplyBy(int d2) {
        this.scale(d2);
    }

    public final double distance(JnVector3i p2) {
        return Math.sqrt(this.sqDistance(p2));
    }

    public final int sqDistance(JnVector3i p2) {
        int dx = p2.x - this.x;
        int dy = p2.y - this.y;
        int dz = p2.z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public final void fillArray(int[] array, int offset, int stride) {
        array[offset] = this.x;
        array[offset + stride] = this.y;
        array[offset + 2 * stride] = this.z;
    }

    public final void fillArray(int[] array, int offset) {
        this.fillArray(array, offset, 1);
    }

    public final Object clone() {
        Object o2 = null;
        try {
            o2 = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return o2;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }
}

