/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import com.ge.med.jnu.JnMatrix3d;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.jnu.JnVector3d;

public class GeomUtils {
    private static JnMatrix4d temp1 = new JnMatrix4d();
    private static JnMatrix4d temp2 = new JnMatrix4d();
    public static final double EPSILON = 1.0E-6;
    private static int[][] FACES = new int[][]{{0, 1, 2, 3}, {4, 5, 6, 7}, {0, 1, 5, 4}, {3, 2, 6, 7}, {0, 3, 7, 4}, {1, 2, 6, 5}};

    private GeomUtils() {
    }

    public static final double linePlaneIntersection(double[] A2, double[] B, double[] C, double[] p0, double[] p1) {
        temp1.set(1.0, 1.0, 1.0, 1.0, A2[0], B[0], C[0], p0[0], A2[1], B[1], C[1], p0[1], A2[2], B[2], C[2], p0[2]);
        temp2.set(1.0, 1.0, 1.0, 0.0, A2[0], B[0], C[0], p1[0] - p0[0], A2[1], B[1], C[1], p1[1] - p0[1], A2[2], B[2], C[2], p1[2] - p0[2]);
        double det = temp2.determinant();
        if (det == 0.0) {
            throw new RuntimeException("line parallel to plane!");
        }
        return -temp1.determinant() / det;
    }

    public static final double linePlaneIntersection(double[] look, double[] eye, double[] p0, double[] p1) {
        double[] view = new double[]{look[0] - eye[0], look[1] - eye[1], look[2] - eye[2]};
        double norm = (p1[0] - p0[0]) * view[0] + (p1[1] - p0[1]) * view[1] + (p1[2] - p0[2]) * view[2];
        if (norm == 0.0) {
            throw new RuntimeException("line parallel to plane!");
        }
        return ((look[0] - p0[0]) * view[0] + (look[1] - p0[1]) * view[1] + (look[2] - p0[2]) * view[2]) / norm;
    }

    public static final double pointDistanceToPlane(double[] look, double[] eye, double[] p2) {
        double[] view = new double[]{look[0] - eye[0], look[1] - eye[1], look[2] - eye[2]};
        double viewNormInv = 1.0 / Math.sqrt(view[0] * view[0] + view[1] * view[1] + view[2] * view[2]);
        view[0] = view[0] * viewNormInv;
        view[1] = view[1] * viewNormInv;
        view[2] = view[2] * viewNormInv;
        double[] v2 = new double[]{look[0] - p2[0], look[1] - p2[1], look[2] - p2[2]};
        return v2[0] * view[0] + v2[1] * view[1] + v2[2] * view[2];
    }

    public static final double pointDistanceToPlane(double planePointX, double planePointY, double planePointZ, double planeNormalX, double planeNormalY, double planeNormalZ, double pointX, double pointY, double pointZ) {
        double pointVectorX = pointX - planePointX;
        double pointVectorY = pointY - planePointY;
        double pointVectorZ = pointZ - planePointZ;
        return pointVectorX * planeNormalX + pointVectorY * planeNormalY + pointVectorZ * planeNormalZ;
    }

    public static final void clipLineSegment(double point1X, double point1Y, double point1Z, double point2X, double point2Y, double point2Z, double p1DistanceToPlane, double p2DistanceToPlane, double[] clipPoint, int offset) {
        double weight = p1DistanceToPlane / (p1DistanceToPlane - p2DistanceToPlane);
        clipPoint[offset] = point1X + weight * (point2X - point1X);
        clipPoint[offset + 1] = point1Y + weight * (point2Y - point1Y);
        clipPoint[offset + 2] = point1Z + weight * (point2Z - point1Z);
    }

    public static void calcDirectionVectors(double[] lookpoint, double[] eyepoint, double[] up, JnVector3d r2, JnVector3d u2, JnVector3d v2) {
        v2.set(lookpoint[0] - eyepoint[0], lookpoint[1] - eyepoint[1], lookpoint[2] - eyepoint[2]);
        v2.normalize();
        u2.set(-up[0], -up[1], -up[2]);
        u2.normalize();
        JnVector3d.cross(u2, v2, r2);
        r2.normalize();
        if (v2.dot(u2) > 0.001) {
            JnVector3d.cross(v2, r2, u2);
            u2.normalize();
        }
    }

    public static final boolean linePlaneIntersection(double planePointX, double planePointY, double planePointZ, double planeNormalX, double planeNormalY, double planeNormalZ, double point1X, double point1Y, double point1Z, double point2X, double point2Y, double point2Z, double[] intersectionPoint, int offset) {
        double d1 = GeomUtils.pointDistanceToPlane(planePointX, planePointY, planePointZ, planeNormalX, planeNormalY, planeNormalZ, point1X, point1Y, point1Z);
        double d2 = GeomUtils.pointDistanceToPlane(planePointX, planePointY, planePointZ, planeNormalX, planeNormalY, planeNormalZ, point2X, point2Y, point2Z);
        if (d1 < 0.0 && d2 > 0.0 || d1 > 0.0 && d2 < 0.0) {
            GeomUtils.clipLineSegment(point1X, point1Y, point1Z, point2X, point2Y, point2Z, d1, d2, intersectionPoint, offset);
            return true;
        }
        return false;
    }

    public static final int planeTriangleIntersection(double planePointX, double planePointY, double planePointZ, double planeNormalX, double planeNormalY, double planeNormalZ, double point1X, double point1Y, double point1Z, double point2X, double point2Y, double point2Z, double point3X, double point3Y, double point3Z, double[] intersectionPoints) {
        int triangleCase = 0;
        double d1 = GeomUtils.pointDistanceToPlane(planePointX, planePointY, planePointZ, planeNormalX, planeNormalY, planeNormalZ, point1X, point1Y, point1Z);
        double d2 = GeomUtils.pointDistanceToPlane(planePointX, planePointY, planePointZ, planeNormalX, planeNormalY, planeNormalZ, point2X, point2Y, point2Z);
        double d3 = GeomUtils.pointDistanceToPlane(planePointX, planePointY, planePointZ, planeNormalX, planeNormalY, planeNormalZ, point3X, point3Y, point3Z);
        if (d1 > 0.0) {
            triangleCase |= 2;
        } else if (d1 == 0.0) {
            triangleCase |= 1;
        }
        if (d2 > 0.0) {
            triangleCase |= 8;
        } else if (d2 == 0.0) {
            triangleCase |= 4;
        }
        if (d3 > 0.0) {
            triangleCase |= 0x20;
        } else if (d3 == 0.0) {
            triangleCase |= 0x10;
        }
        switch (triangleCase) {
            case 0: 
            case 1: 
            case 3: 
            case 16: 
            case 26: 
            case 38: 
            case 41: 
            case 42: {
                return 0;
            }
            case 2: 
            case 40: {
                double vec1X = point2X - point1X;
                double vec1Y = point2Y - point1Y;
                double vec1Z = point2Z - point1Z;
                double w2 = d1 / (d1 - d2);
                double vec2X = vec1X * w2;
                double vec2Y = vec1Y * w2;
                double vec2Z = vec1Z * w2;
                intersectionPoints[0] = point1X + vec2X;
                intersectionPoints[1] = point1Y + vec2Y;
                intersectionPoints[2] = point1Z + vec2Z;
                vec1X = point3X - point1X;
                vec1Y = point3Y - point1Y;
                vec1Z = point3Z - point1Z;
                w2 = d1 / (d1 - d3);
                vec2X = vec1X * w2;
                vec2Y = vec1Y * w2;
                vec2Z = vec1Z * w2;
                intersectionPoints[3] = point1X + vec2X;
                intersectionPoints[4] = point1Y + vec2Y;
                intersectionPoints[5] = point1Z + vec2Z;
                return 1;
            }
            case 8: 
            case 34: {
                double vec1X = point2X - point1X;
                double vec1Y = point2Y - point1Y;
                double vec1Z = point2Z - point1Z;
                double w3 = d1 / (d1 - d2);
                double vec2X = vec1X * w3;
                double vec2Y = vec1Y * w3;
                double vec2Z = vec1Z * w3;
                intersectionPoints[0] = point1X + vec2X;
                intersectionPoints[1] = point1Y + vec2Y;
                intersectionPoints[2] = point1Z + vec2Z;
                vec1X = point3X - point2X;
                vec1Y = point3Y - point2Y;
                vec1Z = point3Z - point2Z;
                w3 = d2 / (d2 - d3);
                vec2X = vec1X * w3;
                vec2Y = vec1Y * w3;
                vec2Z = vec1Z * w3;
                intersectionPoints[3] = point2X + vec2X;
                intersectionPoints[4] = point2Y + vec2Y;
                intersectionPoints[5] = point2Z + vec2Z;
                return 1;
            }
            case 10: 
            case 32: {
                double vec1X = point3X - point1X;
                double vec1Y = point3Y - point1Y;
                double vec1Z = point3Z - point1Z;
                double w4 = d1 / (d1 - d3);
                double vec2X = vec1X * w4;
                double vec2Y = vec1Y * w4;
                double vec2Z = vec1Z * w4;
                intersectionPoints[0] = point1X + vec2X;
                intersectionPoints[1] = point1Y + vec2Y;
                intersectionPoints[2] = point1Z + vec2Z;
                vec1X = point3X - point2X;
                vec1Y = point3Y - point2Y;
                vec1Z = point3Z - point2Z;
                w4 = d2 / (d2 - d3);
                vec2X = vec1X * w4;
                vec2Y = vec1Y * w4;
                vec2Z = vec1Z * w4;
                intersectionPoints[3] = point2X + vec2X;
                intersectionPoints[4] = point2Y + vec2Y;
                intersectionPoints[5] = point2Z + vec2Z;
                return 1;
            }
            case 6: 
            case 36: {
                intersectionPoints[0] = point2X;
                intersectionPoints[1] = point2Y;
                intersectionPoints[2] = point2Z;
                double vec1X = point3X - point1X;
                double vec1Y = point3Y - point1Y;
                double vec1Z = point3Z - point1Z;
                double w5 = d1 / (d1 - d3);
                double vec2X = vec1X * w5;
                double vec2Y = vec1Y * w5;
                double vec2Z = vec1Z * w5;
                intersectionPoints[3] = point1X + vec2X;
                intersectionPoints[4] = point1Y + vec2Y;
                intersectionPoints[5] = point1Z + vec2Z;
                return 1;
            }
            case 9: 
            case 33: {
                intersectionPoints[0] = point1X;
                intersectionPoints[1] = point1Y;
                intersectionPoints[2] = point1Z;
                double vec1X = point3X - point2X;
                double vec1Y = point3Y - point2Y;
                double vec1Z = point3Z - point2Z;
                double w6 = d2 / (d2 - d3);
                double vec2X = vec1X * w6;
                double vec2Y = vec1Y * w6;
                double vec2Z = vec1Z * w6;
                intersectionPoints[3] = point2X + vec2X;
                intersectionPoints[4] = point2Y + vec2Y;
                intersectionPoints[5] = point2Z + vec2Z;
                return 1;
            }
            case 18: 
            case 24: {
                intersectionPoints[0] = point3X;
                intersectionPoints[1] = point3Y;
                intersectionPoints[2] = point3Z;
                double vec1X = point2X - point1X;
                double vec1Y = point2Y - point1Y;
                double vec1Z = point2Z - point1Z;
                double w7 = d1 / (d1 - d2);
                double vec2X = vec1X * w7;
                double vec2Y = vec1Y * w7;
                double vec2Z = vec1Z * w7;
                intersectionPoints[3] = point1X + vec2X;
                intersectionPoints[4] = point1Y + vec2Y;
                intersectionPoints[5] = point1Z + vec2Z;
                return 1;
            }
            case 5: 
            case 37: {
                intersectionPoints[0] = point1X;
                intersectionPoints[1] = point1Y;
                intersectionPoints[1] = point1Z;
                intersectionPoints[3] = point2X;
                intersectionPoints[4] = point2Y;
                intersectionPoints[5] = point2Z;
                return 1;
            }
            case 17: 
            case 25: {
                intersectionPoints[0] = point1X;
                intersectionPoints[1] = point1Y;
                intersectionPoints[2] = point1Z;
                intersectionPoints[3] = point3X;
                intersectionPoints[4] = point3Y;
                intersectionPoints[5] = point3Z;
                return 1;
            }
            case 20: 
            case 22: {
                intersectionPoints[0] = point2X;
                intersectionPoints[1] = point2Y;
                intersectionPoints[2] = point2Z;
                intersectionPoints[3] = point3X;
                intersectionPoints[4] = point3Y;
                intersectionPoints[5] = point3Z;
                return 1;
            }
            case 21: {
                intersectionPoints[0] = point1X;
                intersectionPoints[1] = point1Y;
                intersectionPoints[2] = point1Z;
                intersectionPoints[3] = point2X;
                intersectionPoints[4] = point2Y;
                intersectionPoints[5] = point2Z;
                intersectionPoints[6] = point1X;
                intersectionPoints[7] = point1Y;
                intersectionPoints[8] = point1Z;
                intersectionPoints[9] = point3X;
                intersectionPoints[10] = point3Y;
                intersectionPoints[11] = point3Z;
                intersectionPoints[12] = point2X;
                intersectionPoints[13] = point2Y;
                intersectionPoints[14] = point2Z;
                intersectionPoints[15] = point3X;
                intersectionPoints[16] = point3Y;
                intersectionPoints[17] = point3Z;
                return 3;
            }
        }
        return 0;
    }

    public static final int planeZ0TriangleIntersection(double point1X, double point1Y, double point1Z, double point2X, double point2Y, double point2Z, double point3X, double point3Y, double point3Z, double[] intersectionPoints) {
        int triangleCase = 0;
        if (point1Z > 0.0) {
            triangleCase |= 2;
        } else if (point1Z == 0.0) {
            triangleCase |= 1;
        }
        if (point2Z > 0.0) {
            triangleCase |= 8;
        } else if (point2Z == 0.0) {
            triangleCase |= 4;
        }
        if (point3Z > 0.0) {
            triangleCase |= 0x20;
        } else if (point3Z == 0.0) {
            triangleCase |= 0x10;
        }
        switch (triangleCase) {
            case 0: 
            case 1: 
            case 3: 
            case 16: 
            case 26: 
            case 38: 
            case 41: 
            case 42: {
                return 0;
            }
            case 2: 
            case 40: {
                double vec1X = point2X - point1X;
                double vec1Y = point2Y - point1Y;
                double w2 = point1Z / (point1Z - point2Z);
                double vec2X = vec1X * w2;
                double vec2Y = vec1Y * w2;
                intersectionPoints[0] = point1X + vec2X;
                intersectionPoints[1] = point1Y + vec2Y;
                intersectionPoints[2] = 0.0;
                vec1X = point3X - point1X;
                vec1Y = point3Y - point1Y;
                w2 = point1Z / (point1Z - point3Z);
                vec2X = vec1X * w2;
                vec2Y = vec1Y * w2;
                intersectionPoints[3] = point1X + vec2X;
                intersectionPoints[4] = point1Y + vec2Y;
                intersectionPoints[5] = 0.0;
                return 1;
            }
            case 8: 
            case 34: {
                double vec1X = point2X - point1X;
                double vec1Y = point2Y - point1Y;
                double w3 = point1Z / (point1Z - point2Z);
                double vec2X = vec1X * w3;
                double vec2Y = vec1Y * w3;
                intersectionPoints[0] = point1X + vec2X;
                intersectionPoints[1] = point1Y + vec2Y;
                intersectionPoints[2] = 0.0;
                vec1X = point3X - point2X;
                vec1Y = point3Y - point2Y;
                w3 = point2Z / (point2Z - point3Z);
                vec2X = vec1X * w3;
                vec2Y = vec1Y * w3;
                intersectionPoints[3] = point2X + vec2X;
                intersectionPoints[4] = point2Y + vec2Y;
                intersectionPoints[5] = 0.0;
                return 1;
            }
            case 10: 
            case 32: {
                double vec1X = point3X - point1X;
                double vec1Y = point3Y - point1Y;
                double w4 = point1Z / (point1Z - point3Z);
                double vec2X = vec1X * w4;
                double vec2Y = vec1Y * w4;
                intersectionPoints[0] = point1X + vec2X;
                intersectionPoints[1] = point1Y + vec2Y;
                intersectionPoints[2] = 0.0;
                vec1X = point3X - point2X;
                vec1Y = point3Y - point2Y;
                w4 = point2Z / (point2Z - point3Z);
                vec2X = vec1X * w4;
                vec2Y = vec1Y * w4;
                intersectionPoints[3] = point2X + vec2X;
                intersectionPoints[4] = point2Y + vec2Y;
                intersectionPoints[5] = 0.0;
                return 1;
            }
            case 6: 
            case 36: {
                intersectionPoints[0] = point2X;
                intersectionPoints[1] = point2Y;
                intersectionPoints[2] = 0.0;
                double vec1X = point3X - point1X;
                double vec1Y = point3Y - point1Y;
                double w5 = point1Z / (point1Z - point3Z);
                double vec2X = vec1X * w5;
                double vec2Y = vec1Y * w5;
                intersectionPoints[3] = point1X + vec2X;
                intersectionPoints[4] = point1Y + vec2Y;
                intersectionPoints[5] = 0.0;
                return 1;
            }
            case 9: 
            case 33: {
                intersectionPoints[0] = point1X;
                intersectionPoints[1] = point1Y;
                intersectionPoints[2] = 0.0;
                double vec1X = point3X - point2X;
                double vec1Y = point3Y - point2Y;
                double w6 = point2Z / (point2Z - point3Z);
                double vec2X = vec1X * w6;
                double vec2Y = vec1Y * w6;
                intersectionPoints[3] = point2X + vec2X;
                intersectionPoints[4] = point2Y + vec2Y;
                intersectionPoints[5] = 0.0;
                return 1;
            }
            case 18: 
            case 24: {
                intersectionPoints[0] = point3X;
                intersectionPoints[1] = point3Y;
                intersectionPoints[2] = 0.0;
                double vec1X = point2X - point1X;
                double vec1Y = point2Y - point1Y;
                double w7 = point1Z / (point1Z - point2Z);
                double vec2X = vec1X * w7;
                double vec2Y = vec1Y * w7;
                intersectionPoints[3] = point1X + vec2X;
                intersectionPoints[4] = point1Y + vec2Y;
                intersectionPoints[5] = 0.0;
                return 1;
            }
            case 5: 
            case 37: {
                intersectionPoints[0] = point1X;
                intersectionPoints[1] = point1Y;
                intersectionPoints[1] = 0.0;
                intersectionPoints[3] = point2X;
                intersectionPoints[4] = point2Y;
                intersectionPoints[5] = 0.0;
                return 1;
            }
            case 17: 
            case 25: {
                intersectionPoints[0] = point1X;
                intersectionPoints[1] = point1Y;
                intersectionPoints[2] = 0.0;
                intersectionPoints[3] = point3X;
                intersectionPoints[4] = point3Y;
                intersectionPoints[5] = 0.0;
                return 1;
            }
            case 20: 
            case 22: {
                intersectionPoints[0] = point2X;
                intersectionPoints[1] = point2Y;
                intersectionPoints[2] = 0.0;
                intersectionPoints[3] = point3X;
                intersectionPoints[4] = point3Y;
                intersectionPoints[5] = 0.0;
                return 1;
            }
            case 21: {
                intersectionPoints[0] = point1X;
                intersectionPoints[1] = point1Y;
                intersectionPoints[2] = 0.0;
                intersectionPoints[3] = point2X;
                intersectionPoints[4] = point2Y;
                intersectionPoints[5] = 0.0;
                intersectionPoints[6] = point1X;
                intersectionPoints[7] = point1Y;
                intersectionPoints[8] = 0.0;
                intersectionPoints[9] = point3X;
                intersectionPoints[10] = point3Y;
                intersectionPoints[11] = 0.0;
                intersectionPoints[12] = point2X;
                intersectionPoints[13] = point2Y;
                intersectionPoints[14] = 0.0;
                intersectionPoints[15] = point3X;
                intersectionPoints[16] = point3Y;
                intersectionPoints[17] = 0.0;
                return 3;
            }
        }
        return 0;
    }

    public static final double[] RAStoDisplay(double[] ras, double[] eye, double[] look, double[] up, double viewHeight, int portWidth, int portHeight, double[] result) {
        if (result == null || result.length < 3) {
            result = new double[3];
        }
        JnVector3d viewv = new JnVector3d(look);
        viewv.sub(eye);
        viewv.normalize();
        JnVector3d upv = new JnVector3d(up);
        upv.normalize();
        JnVector3d rightv = JnVector3d.cross(viewv, upv);
        JnVector3d projectionV = new JnVector3d(ras);
        projectionV.sub(look);
        double pixelPerMM = (double)portHeight / viewHeight;
        result[0] = projectionV.dot(rightv) * pixelPerMM + (double)(portWidth >>> 1);
        result[1] = (double)(portHeight >>> 1) - projectionV.dot(upv) * pixelPerMM;
        result[2] = projectionV.dot(viewv) * pixelPerMM;
        return result;
    }

    public static final double[] DisplayToRAS(int[] disp, double[] eye, double[] look, double[] up, double viewHeight, int portWidth, int portHeight, double[] result) {
        if (result == null || result.length < 3) {
            result = new double[3];
        }
        JnVector3d viewv = new JnVector3d(look);
        viewv.sub(eye);
        viewv.normalize();
        JnVector3d upv = new JnVector3d(up);
        upv.normalize();
        JnVector3d rightv = JnVector3d.cross(viewv, upv);
        JnVector3d resultv = new JnVector3d(look);
        int xoff = disp[0] - (portWidth >>> 1);
        int yoff = (portHeight >>> 1) - disp[1];
        double mmPerPixel = viewHeight / (double)portHeight;
        resultv.scaleAdd((double)xoff * mmPerPixel, rightv);
        resultv.scaleAdd((double)yoff * mmPerPixel, upv);
        resultv.scaleAdd((double)disp[2] * mmPerPixel, viewv);
        result[0] = resultv.x;
        result[1] = resultv.y;
        result[2] = resultv.z;
        return result;
    }

    public static double[] lineTriangleIntersection(JnVector3d linePoint, JnVector3d lineVector, JnVector3d triVert0, JnVector3d triVert1, JnVector3d triVert2) {
        JnVector3d edge1 = new JnVector3d();
        edge1.sub(triVert1, triVert0);
        JnVector3d edge2 = new JnVector3d();
        edge2.sub(triVert2, triVert0);
        JnVector3d pvec = JnVector3d.cross(lineVector, edge2);
        double det = edge1.dot(pvec);
        if (det > -1.0E-6 && det < 1.0E-6) {
            return null;
        }
        double inv_det = 1.0 / det;
        JnVector3d tvec = new JnVector3d();
        tvec.sub(linePoint, triVert0);
        double[] intersection = new double[3];
        intersection[1] = tvec.dot(pvec) * inv_det;
        if (intersection[1] < -1.0E-6 || intersection[1] > 1.000001) {
            return null;
        }
        JnVector3d qvec = JnVector3d.cross(tvec, edge1);
        intersection[2] = lineVector.dot(qvec) * inv_det;
        if (intersection[2] < -1.0E-6 || intersection[1] + intersection[2] > 1.000001) {
            return null;
        }
        intersection[0] = edge2.dot(qvec) * inv_det;
        return intersection;
    }

    public static boolean lineTriangleIntersection(JnVector3d linePoint, JnVector3d lineVector, JnVector3d triVert0, JnVector3d triVert1, JnVector3d triVert2, JnVector3d intersectionPoint) {
        double[] intersection = GeomUtils.lineTriangleIntersection(linePoint, lineVector, triVert0, triVert1, triVert2);
        if (intersection == null) {
            return false;
        }
        if (intersectionPoint == null) {
            intersectionPoint = new JnVector3d();
        }
        intersectionPoint.set(lineVector);
        intersectionPoint.multiplyBy(intersection[0]);
        intersectionPoint.add(linePoint);
        return true;
    }

    public static boolean lineParallelepipedIntersection(JnVector3d linePoint, JnVector3d lineVector, JnVector3d origin, JnVector3d edgeVector0, JnVector3d edgeVector1, JnVector3d edgeVector2, JnVector3d intersectionPoint1, JnVector3d intersectionPoint2) {
        JnVector3d[] vertices = new JnVector3d[8];
        vertices[0] = origin;
        for (int i2 = 1; i2 < 8; ++i2) {
            vertices[i2] = new JnVector3d();
        }
        vertices[1].add(origin, edgeVector0);
        vertices[2].add(vertices[1], edgeVector1);
        vertices[3].add(origin, edgeVector1);
        vertices[4].add(origin, edgeVector2);
        vertices[5].add(vertices[4], edgeVector0);
        vertices[6].add(vertices[5], edgeVector1);
        vertices[7].add(vertices[4], edgeVector1);
        int numPointsFound = 0;
        JnVector3d intersectionPoint = intersectionPoint1;
        for (int i3 = 0; i3 < 6; ++i3) {
            for (int triangle = 0; triangle < 2; ++triangle) {
                if (!GeomUtils.lineTriangleIntersection(linePoint, lineVector, vertices[FACES[i3][1]], vertices[FACES[i3][3]], vertices[FACES[i3][triangle * 2]], intersectionPoint)) continue;
                if (numPointsFound == 1) {
                    if (GeomUtils.fuzzyEquals(intersectionPoint1, intersectionPoint2)) continue;
                    return true;
                }
                ++numPointsFound;
                intersectionPoint = intersectionPoint2;
            }
        }
        return false;
    }

    public static double[] lineParallelepipedIntersection(JnVector3d linePoint, JnVector3d lineVector, JnVector3d origin, JnVector3d edgeVector0, JnVector3d edgeVector1, JnVector3d edgeVector2) {
        JnVector3d[] vertices = new JnVector3d[8];
        vertices[0] = origin;
        for (int i2 = 1; i2 < 8; ++i2) {
            vertices[i2] = new JnVector3d();
        }
        vertices[1].add(origin, edgeVector0);
        vertices[2].add(vertices[1], edgeVector1);
        vertices[3].add(origin, edgeVector1);
        vertices[4].add(origin, edgeVector2);
        vertices[5].add(vertices[4], edgeVector0);
        vertices[6].add(vertices[5], edgeVector1);
        vertices[7].add(vertices[4], edgeVector1);
        int numPointsFound = 0;
        double[] intersectionPoints = new double[2];
        for (int i3 = 0; i3 < 6; ++i3) {
            for (int triangle = 0; triangle < 2; ++triangle) {
                double[] intersectionArray = GeomUtils.lineTriangleIntersection(linePoint, lineVector, vertices[FACES[i3][1]], vertices[FACES[i3][3]], vertices[FACES[i3][triangle * 2]]);
                if (intersectionArray == null) continue;
                if (numPointsFound == 1) {
                    intersectionPoints[1] = intersectionArray[0];
                    if (GeomUtils.fuzzyEquals(intersectionPoints[0], intersectionPoints[1])) continue;
                    return intersectionPoints;
                }
                ++numPointsFound;
                intersectionPoints[0] = intersectionArray[0];
            }
        }
        return null;
    }

    public static boolean fuzzyEquals(double d1, double d2) {
        return Math.abs(d2 - d1) < 1.0E-6;
    }

    public static boolean fuzzyEquals(JnVector3d v1, JnVector3d v2) {
        return Math.abs(v2.x - v1.x) < 1.0E-6 && Math.abs(v2.y - v1.y) < 1.0E-6 && Math.abs(v2.z - v1.z) < 1.0E-6;
    }

    public static double[] matrixToAngles(JnMatrix3d rotationMatrix, double[] rotationAngles) {
        if (rotationAngles == null || rotationAngles.length < 3) {
            rotationAngles = new double[3];
        }
        if (GeomUtils.fuzzyEquals(rotationMatrix.m10, 1.0)) {
            rotationAngles[2] = 90.0;
            rotationAngles[1] = 0.0;
            rotationAngles[0] = Math.toDegrees(Math.atan2(rotationMatrix.m02, rotationMatrix.m22));
        } else if (GeomUtils.fuzzyEquals(rotationMatrix.m10, 1.0)) {
            rotationAngles[2] = -90.0;
            rotationAngles[1] = 0.0;
            rotationAngles[0] = Math.toDegrees(Math.atan2(rotationMatrix.m02, rotationMatrix.m22));
        } else {
            rotationAngles[1] = Math.toDegrees(Math.atan2(-rotationMatrix.m20, rotationMatrix.m00));
            rotationAngles[2] = Math.toDegrees(Math.asin(rotationMatrix.m10));
            rotationAngles[0] = Math.toDegrees(Math.atan2(-rotationMatrix.m12, rotationMatrix.m11));
        }
        return rotationAngles;
    }

    public static double[] rotationAnglesBetweenSlices(JnVector3d origSliceI, JnVector3d origSliceJ, JnVector3d origSliceN, JnVector3d rotatedSliceI, JnVector3d rotatedSliceJ, JnVector3d rotatedSliceN, double[] rotationAngles) {
        JnMatrix3d origMatrix = new JnMatrix3d();
        origMatrix.set(origSliceI.x, origSliceJ.x, origSliceN.x, origSliceI.y, origSliceJ.y, origSliceN.y, origSliceI.z, origSliceJ.z, origSliceN.z);
        JnMatrix3d rotatedMatrix = new JnMatrix3d();
        rotatedMatrix.set(rotatedSliceI.x, rotatedSliceJ.x, rotatedSliceN.x, rotatedSliceI.y, rotatedSliceJ.y, rotatedSliceN.y, rotatedSliceI.z, rotatedSliceJ.z, rotatedSliceN.z);
        origMatrix.invert();
        JnMatrix3d rotationMatrix = new JnMatrix3d();
        rotationMatrix.mul(rotatedMatrix, origMatrix);
        return GeomUtils.matrixToAngles(rotationMatrix, rotationAngles);
    }

    public static final double[] RAStoVoxelIndex(double[] ras, double[] xDir, double[] yDir, double[] zDir, double[] orig, double[] result) {
        if (result == null) {
            result = new double[3];
        }
        double distx = ras[0] - orig[0];
        double disty = ras[1] - orig[1];
        double distz = ras[2] - orig[2];
        double normxsq = xDir[0] * xDir[0] + xDir[1] * xDir[1] + xDir[2] * xDir[2];
        double normysq = yDir[0] * yDir[0] + yDir[1] * yDir[1] + yDir[2] * yDir[2];
        double normzsq = zDir[0] * zDir[0] + zDir[1] * zDir[1] + zDir[2] * zDir[2];
        result[0] = (distx * xDir[0] + disty * xDir[1] + distz * xDir[2]) / normxsq;
        result[1] = (distx * yDir[0] + disty * yDir[1] + distz * yDir[2]) / normysq;
        result[2] = (distx * zDir[0] + disty * zDir[1] + distz * zDir[2]) / normzsq;
        return result;
    }

    public static final boolean isInVolume(double[] ras, double[] orig, double[] xdir, double[] ydir, double[] zdir, int[] dims) {
        double[] volIndex = GeomUtils.RAStoVoxelIndex(ras, xdir, ydir, zdir, orig, null);
        return volIndex[0] >= 0.0 && volIndex[0] < (double)dims[0] && volIndex[1] >= 0.0 && volIndex[1] < (double)dims[1] && volIndex[2] >= 0.0 && volIndex[2] < (double)dims[2];
    }

    public static boolean isInsideVolume(double[] ulc, double[] xside, double[] yside, double[] zside, double[] pt) {
        JnVector3d pt2 = new JnVector3d(pt);
        pt2.sub(ulc);
        double x2 = pt2.dot(xside) / (xside[0] * xside[0] + xside[1] * xside[1] + xside[2] * xside[2]);
        double y2 = pt2.dot(yside) / (yside[0] * yside[0] + yside[1] * yside[1] + yside[2] * yside[2]);
        double z2 = pt2.dot(zside) / (zside[0] * zside[0] + zside[1] * zside[1] + zside[2] * zside[2]);
        return x2 >= 0.0 && x2 <= 1.0 && y2 >= 0.0 && y2 <= 1.0 && z2 >= 0.0 && z2 <= 1.0;
    }
}

