/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import com.ge.med.jnu.geom.JnPoint2D;
import com.ge.med.jnu.geom.JnRectangle;
import com.ge.med.jnu.geom.JnRectangle2D;
import com.ge.med.jnu.geom.JnShape;

public abstract class JnLine2D
implements JnShape {
    protected JnLine2D() {
    }

    public abstract double getX1();

    public abstract double getY1();

    public abstract JnPoint2D getP1();

    public abstract double getX2();

    public abstract double getY2();

    public abstract JnPoint2D getP2();

    public abstract void setLine(double var1, double var3, double var5, double var7);

    public void setLine(JnPoint2D p1, JnPoint2D p2) {
        this.setLine(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public void setLine(JnLine2D l2) {
        this.setLine(l2.getX1(), l2.getY1(), l2.getX2(), l2.getY2());
    }

    @Override
    public boolean contains(double x2, double y2) {
        return false;
    }

    public boolean contains(JnPoint2D p2) {
        return false;
    }

    public boolean intersects(double x2, double y2, double w2, double h2) {
        return this.intersects(new JnRectangle2D.Double(x2, y2, w2, h2));
    }

    public boolean intersects(JnRectangle2D r2) {
        return r2.intersectsLine(this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    public boolean contains(double x2, double y2, double w2, double h2) {
        return false;
    }

    public boolean contains(JnRectangle2D r2) {
        return false;
    }

    @Override
    public JnRectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public static class Double
    extends JnLine2D {
        public double x1;
        public double y1;
        public double x2;
        public double y2;

        public Double() {
        }

        public Double(double x1, double y1, double x2, double y2) {
            this.setLine(x1, y1, x2, y2);
        }

        public Double(JnPoint2D p1, JnPoint2D p2) {
            this.setLine(p1, p2);
        }

        @Override
        public double getX1() {
            return this.x1;
        }

        @Override
        public double getY1() {
            return this.y1;
        }

        @Override
        public JnPoint2D getP1() {
            return new JnPoint2D.Double(this.x1, this.y1);
        }

        @Override
        public double getX2() {
            return this.x2;
        }

        @Override
        public double getY2() {
            return this.y2;
        }

        @Override
        public JnPoint2D getP2() {
            return new JnPoint2D.Double(this.x2, this.y2);
        }

        @Override
        public void setLine(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        @Override
        public JnRectangle2D getBounds2D() {
            double h2;
            double y2;
            double w2;
            double x2;
            if (this.x1 < this.x2) {
                x2 = this.x1;
                w2 = this.x2 - this.x1;
            } else {
                x2 = this.x2;
                w2 = this.x1 - this.x2;
            }
            if (this.y1 < this.y2) {
                y2 = this.y1;
                h2 = this.y2 - this.y1;
            } else {
                y2 = this.y2;
                h2 = this.y1 - this.y2;
            }
            return new JnRectangle2D.Double(x2, y2, w2, h2);
        }
    }

    public static class Float
    extends JnLine2D {
        public float x1;
        public float y1;
        public float x2;
        public float y2;

        public Float() {
        }

        public Float(float x1, float y1, float x2, float y2) {
            this.setLine(x1, y1, x2, y2);
        }

        public Float(JnPoint2D p1, JnPoint2D p2) {
            this.setLine(p1, p2);
        }

        @Override
        public double getX1() {
            return this.x1;
        }

        @Override
        public double getY1() {
            return this.y1;
        }

        @Override
        public JnPoint2D getP1() {
            return new JnPoint2D.Float(this.x1, this.y1);
        }

        @Override
        public double getX2() {
            return this.x2;
        }

        @Override
        public double getY2() {
            return this.y2;
        }

        @Override
        public JnPoint2D getP2() {
            return new JnPoint2D.Float(this.x2, this.y2);
        }

        @Override
        public void setLine(double x1, double y1, double x2, double y2) {
            this.x1 = (float)x1;
            this.y1 = (float)y1;
            this.x2 = (float)x2;
            this.y2 = (float)y2;
        }

        public void setLine(float x1, float y1, float x2, float y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        @Override
        public JnRectangle2D getBounds2D() {
            float h2;
            float y2;
            float w2;
            float x2;
            if (this.x1 < this.x2) {
                x2 = this.x1;
                w2 = this.x2 - this.x1;
            } else {
                x2 = this.x2;
                w2 = this.x1 - this.x2;
            }
            if (this.y1 < this.y2) {
                y2 = this.y1;
                h2 = this.y2 - this.y1;
            } else {
                y2 = this.y2;
                h2 = this.y1 - this.y2;
            }
            return new JnRectangle2D.Float(x2, y2, w2, h2);
        }
    }
}

