/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.ParametricCurve3D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class PolyLine3D
implements ParametricCurve3D {
    private static final Logger LOGGER = Logger.getLogger(PolyLine3D.class.getName());
    private List points = null;
    private double[] points_t = null;
    private double[] lengths = null;
    private JnVector3d[] velocities = null;
    private double total_length = 0.0;
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public synchronized void refresh() {
        this.update();
    }

    private void update() {
        if (this.points != null && this.points.size() > 0) {
            int i2;
            this.lengths = new double[this.points.size() - 1];
            this.velocities = new JnVector3d[this.points.size() - 1];
            this.total_length = 0.0;
            for (i2 = 0; i2 < this.lengths.length; ++i2) {
                JnVector3d temp = new JnVector3d();
                this.lengths[i2] = temp.sub((double[])this.points.get(i2 + 1), (double[])this.points.get(i2)).magnitude();
                this.velocities[i2] = temp;
                this.total_length += this.lengths[i2];
            }
            this.points_t = new double[this.points.size()];
            this.points_t[0] = 0.0;
            for (i2 = 0; i2 < this.points.size() - 1; ++i2) {
                this.points_t[i2 + 1] = this.lengths[i2] / this.total_length;
                this.velocities[i2].multiplyBy(1.0 / this.points_t[i2 + 1]);
                int n2 = i2 + 1;
                this.points_t[n2] = this.points_t[n2] + this.points_t[i2];
            }
            this.points_t[this.points.size() - 1] = 1.0;
        } else {
            this.lengths = null;
            this.velocities = null;
            this.total_length = 0.0;
        }
    }

    @Override
    public void positionAt(double t2, double[] position) {
        if (this.points != null && this.points.size() > 0) {
            if (this.points_t.length == 1) {
                System.arraycopy(this.points.get(0), 0, position, 0, 3);
                return;
            }
            for (int i2 = 0; i2 < this.points_t.length - 1; ++i2) {
                if (!(t2 < this.points_t[i2 + 1])) continue;
                System.arraycopy(this.points.get(i2), 0, position, 0, 3);
                double scale = t2 - this.points_t[i2];
                position[0] = position[0] + scale * this.velocities[i2].x;
                position[1] = position[1] + scale * this.velocities[i2].y;
                position[2] = position[2] + scale * this.velocities[i2].z;
                return;
            }
            if (t2 == 1.0) {
                System.arraycopy(this.points.get(this.points.size() - 1), 0, position, 0, 3);
                return;
            }
        }
        throw new RuntimeException("Error in curve position at t=" + t2);
    }

    @Override
    public void velocityAt(double t2, double[] velocity) {
        for (int i2 = 0; i2 < this.points_t.length - 1; ++i2) {
            if (!(t2 < this.points_t[i2 + 1])) continue;
            velocity[0] = this.velocities[i2].x;
            velocity[1] = this.velocities[i2].y;
            velocity[2] = this.velocities[i2].z;
            return;
        }
        throw new RuntimeException("Error in curve velocity at t=" + t2);
    }

    @Override
    public synchronized double length() {
        return this.total_length;
    }

    @Override
    public List getControlPoints() {
        return this.points;
    }

    @Override
    public synchronized void setControlPoints(List points) {
        this.points = points;
        Iterator itr = this.points.iterator();
        while (itr.hasNext()) {
            if (itr.next() != null) continue;
            LOGGER.warning("Null value in control point list. The null control point has been removed.");
            itr.remove();
        }
        this.update();
        this.pcs.firePropertyChange("CURVE_PROPERTY", null, this);
    }

    @Override
    public synchronized Object clone() {
        PolyLine3D copy;
        try {
            copy = (PolyLine3D)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            copy = new PolyLine3D();
        }
        copy.points = new ArrayList(this.points.size());
        Iterator itr = this.points.iterator();
        while (itr.hasNext()) {
            copy.points.add(((double[])itr.next()).clone());
        }
        copy.points_t = this.points_t;
        copy.lengths = this.lengths;
        copy.velocities = this.velocities;
        copy.total_length = this.total_length;
        return copy;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(prop, pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }
}

