/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class RayCastPlaneVolumeBase {
    private BufferedImage debugRaster = null;
    private ImgPanel debugImgPanel = null;
    private JFrame debugFrame = null;

    protected void raycast_debug1(int w2, int h2) {
        if (this.debugRaster == null || w2 != this.debugRaster.getWidth() || h2 != this.debugRaster.getHeight()) {
            this.debugRaster = new BufferedImage(w2, h2, 10);
            if (this.debugImgPanel == null) {
                this.debugImgPanel = this.displayImage(this.debugRaster, "VR VolumeBox");
            } else {
                this.debugImgPanel.setImage(this.debugRaster);
                this.debugImgPanel.setPreferredSize(new Dimension(w2, h2));
                this.debugFrame.pack();
            }
        }
    }

    protected void raycast_debug2(byte[] raster) {
        byte[] braster = ((DataBufferByte)this.debugRaster.getRaster().getDataBuffer()).getData();
        System.arraycopy(raster, 0, braster, 0, raster.length);
        this.debugImgPanel.repaint();
    }

    private ImgPanel displayImage(BufferedImage img, String msg) {
        ImgPanel ip = new ImgPanel();
        JFrame jf = new JFrame(msg);
        ip.setImage(img);
        ip.setPreferredSize(new Dimension(img.getWidth(), img.getHeight()));
        jf.setLocation(100, 100);
        jf.setDefaultCloseOperation(3);
        jf.setContentPane(ip);
        jf.pack();
        jf.setVisible(true);
        this.debugFrame = jf;
        return ip;
    }

    private static class ImgPanel
    extends JPanel
    implements MouseMotionListener {
        private BufferedImage img = null;

        private ImgPanel() {
        }

        public void setImage(BufferedImage img) {
            this.img = img;
            this.addMouseMotionListener(this);
        }

        @Override
        public void paintComponent(Graphics g2) {
            Graphics2D g2d = (Graphics2D)g2;
            g2d.drawRenderedImage(this.img, null);
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
        }

        @Override
        public void mouseMoved(MouseEvent arg0) {
        }
    }
}

