/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.IntersectionPath;
import com.ge.med.jnu.geom.PathIterator3D;
import com.ge.med.jnu.geom.Rectangular3DShape;
import com.ge.med.jnu.geom.ShapeDescriptor;

public class Rectangle3D
extends Rectangular3DShape {
    public static final int OUT_LEFT = 1;
    public static final int OUT_TOP = 2;
    public static final int OUT_RIGHT = 4;
    public static final int OUT_BOTTOM = 8;
    public static final int OUT_FRONT = 16;
    public static final int OUT_BACK = 32;
    private JnVector3d normal = new JnVector3d();
    private JnVector3d v0 = new JnVector3d();
    private JnVector3d v1 = new JnVector3d();
    private JnVector3d res = new JnVector3d();
    private boolean[] facepos = new boolean[32];
    private static final double EPSILON = 1.0E-5;

    public Rectangle3D() {
    }

    public Rectangle3D(double x2, double y2, double z2, double w2, double h2, double d2) {
        super(x2, y2, z2, w2, h2, d2);
    }

    public int outcode(double x2, double y2, double z2) {
        int out = 0;
        if (this.width <= 0.0) {
            out |= 5;
        } else if (x2 < this.x) {
            out |= 1;
        } else if (x2 > this.x + this.width) {
            out |= 4;
        }
        if (this.height <= 0.0) {
            out |= 0xA;
        } else if (y2 < this.y) {
            out |= 2;
        } else if (y2 > this.y + this.height) {
            out |= 8;
        }
        if (this.depth <= 0.0) {
            out |= 0x30;
        } else if (z2 < this.z) {
            out |= 0x10;
        } else if (z2 > this.z + this.depth) {
            out |= 0x20;
        }
        return out;
    }

    public int outcode(JnVector3d p2) {
        return this.outcode(p2.x, p2.y, p2.z);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Rectangle3D) {
            Rectangle3D r3d = (Rectangle3D)obj;
            return this.getX() == r3d.getX() && this.getY() == r3d.getY() && this.getZ() == r3d.getZ() && this.getWidth() == r3d.getWidth() && this.getHeight() == r3d.getHeight() && this.getDepth() == r3d.getDepth();
        }
        return false;
    }

    @Override
    public ShapeDescriptor getShapeDescriptor() {
        return new RectShapeDescriptor();
    }

    private void rayPlane(double a2, double b2, double c2, double d2, JnVector3d from, JnVector3d to, JnVector3d res) {
        double dx = to.x - from.x;
        double dy = to.y - from.y;
        double dz = to.z - from.z;
        double denom = a2 * dx + b2 * dy + c2 * dz;
        double num = d2 - a2 * from.x - b2 * from.y - c2 * from.z;
        double t2 = num / denom;
        res.set(from.x + t2 * dx, from.y + t2 * dy, from.z + t2 * dz);
    }

    @Override
    public PathIterator3D getIntersection(JnVector3d ul, JnVector3d ur, JnVector3d bl) {
        this.v0.sub(ur, ul);
        this.v1.sub(bl, ul);
        JnVector3d.cross(this.v0, this.v1, this.normal);
        this.normal.normalize();
        double a2 = this.normal.x;
        double b2 = this.normal.y;
        double c2 = this.normal.z;
        double d2 = a2 * ul.x + b2 * ul.y + c2 * ul.z;
        IntersectionPath pit = new IntersectionPath();
        RectShapeDescriptor rsd = new RectShapeDescriptor();
        int nFaces = rsd.getNumFaces();
        for (int i2 = 0; i2 < nFaces; ++i2) {
            int[] face = rsd.getFace(i2);
            boolean intersects = true;
            int above = 0;
            int below = 0;
            for (int j2 = 0; j2 < face.length; ++j2) {
                rsd.getPoint(face[j2], this.v0);
                boolean bl2 = this.facepos[j2] = d2 - a2 * this.v0.x - b2 * this.v0.y - c2 * this.v0.z > 0.0;
                if (this.facepos[j2]) {
                    ++above;
                    continue;
                }
                ++below;
            }
            if (above == face.length || below == face.length) continue;
            int npts = 0;
            int lface = face.length;
            for (int j3 = 0; j3 < face.length; ++j3) {
                if ((!this.facepos[j3 % lface] || this.facepos[(j3 + 1) % lface]) && (this.facepos[j3 % lface] || !this.facepos[(j3 + 1) % lface])) continue;
                rsd.getPoint(face[j3 % lface], this.v0);
                rsd.getPoint(face[(j3 + 1) % lface], this.v1);
                this.rayPlane(a2, b2, c2, d2, this.v0, this.v1, this.res);
                if (npts == 0) {
                    pit.add(0, this.res.x, this.res.y, this.res.z);
                } else {
                    pit.add(1, this.res.x, this.res.y, this.res.z);
                }
                ++npts;
            }
        }
        return pit;
    }

    public class RectShapeDescriptor
    implements ShapeDescriptor.Polygonal {
        double[][] pts;
        int[][] faces;

        public RectShapeDescriptor() {
            this.pts = new double[][]{{Rectangle3D.this.x, Rectangle3D.this.y, Rectangle3D.this.z}, {Rectangle3D.this.x + Rectangle3D.this.width, Rectangle3D.this.y, Rectangle3D.this.z}, {Rectangle3D.this.x + Rectangle3D.this.width, Rectangle3D.this.y + Rectangle3D.this.height, Rectangle3D.this.z}, {Rectangle3D.this.x, Rectangle3D.this.y + Rectangle3D.this.height, Rectangle3D.this.z}, {Rectangle3D.this.x, Rectangle3D.this.y, Rectangle3D.this.z + Rectangle3D.this.depth}, {Rectangle3D.this.x + Rectangle3D.this.width, Rectangle3D.this.y, Rectangle3D.this.z + Rectangle3D.this.depth}, {Rectangle3D.this.x + Rectangle3D.this.width, Rectangle3D.this.y + Rectangle3D.this.height, Rectangle3D.this.z + Rectangle3D.this.depth}, {Rectangle3D.this.x, Rectangle3D.this.y + Rectangle3D.this.height, Rectangle3D.this.z + Rectangle3D.this.depth}};
            this.faces = new int[][]{{0, 1, 2, 3}, {4, 5, 6, 7}, {0, 1, 5, 4}, {2, 3, 7, 6}, {0, 3, 7, 4}, {1, 2, 6, 5}};
        }

        @Override
        public final void getPoint(int pointIdx, JnVector3d result) {
            result.x = this.pts[pointIdx][0];
            result.y = this.pts[pointIdx][1];
            result.z = this.pts[pointIdx][2];
        }

        @Override
        public final int[] getFace(int faceIdx) {
            return this.faces[faceIdx];
        }

        @Override
        public int getNumFaces() {
            return 6;
        }
    }
}

