/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.wl;

import com.ge.med.jnu.JnUtils;
import com.ge.med.jnu.wl.WLFilter;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.text.DecimalFormat;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class WL {
    private static final DecimalFormat df = new DecimalFormat("####0.00");
    public static final int WL_OK = 1;
    public static final int WL_ERROR = 0;
    private double[] temp1 = null;
    private double[] upLow = null;
    private double[] upHi = null;
    private int[] sgnpart = null;
    private double[] tempSource = null;
    private double[] tempDest = null;
    private int[] rSplit = null;
    private int[] cSplit = null;
    private double[] temp2D = null;

    public final int FwtVector(double[] source, double[] dest, int length, int levels, WLFilter lowpass, WLFilter hipass) {
        return this.FwtVector(source, dest, 0, 0, length, levels, lowpass, hipass);
    }

    public final int FwtVector(double[] source, double[] dest, int offset, int out_offset, int length, int levels, WLFilter lowpass, WLFilter hipass) {
        int hisize = hipass.length;
        int lowsize = lowpass.length;
        double[] hicoefs = hipass.coefs;
        double[] lowcoefs = lowpass.coefs;
        int left = Math.max(lowpass.offset, hipass.offset);
        int right = Math.max(lowpass.length - lowpass.offset - 1, hipass.length - hipass.offset - 1);
        int len = length + left + right;
        if (this.temp1 == null || this.temp1.length != len) {
            this.temp1 = new double[len];
        }
        if (source != dest) {
            System.arraycopy(source, offset, dest, out_offset, length);
        }
        int level = 0;
        while (level < levels) {
            int i2;
            int j2 = 0;
            for (i2 = length - left; i2 < length; ++i2) {
                this.temp1[j2++] = dest[i2 + out_offset];
            }
            for (i2 = 0; i2 < length; ++i2) {
                this.temp1[j2++] = dest[i2 + out_offset];
            }
            for (i2 = 0; i2 < right; ++i2) {
                this.temp1[j2++] = dest[i2 + out_offset];
            }
            int lowresult = out_offset;
            int hiresult = out_offset + length / 2;
            int lowdata = left - lowpass.offset;
            int hidata = left - hipass.offset;
            i2 = 0;
            while (i2 < length) {
                double lowsum = 0.0;
                double hisum = 0.0;
                for (j2 = 0; j2 < lowsize; ++j2) {
                    lowsum += this.temp1[lowdata + j2] * lowcoefs[j2];
                }
                for (j2 = 0; j2 < hisize; ++j2) {
                    hisum += this.temp1[hidata + j2] * hicoefs[j2];
                }
                dest[lowresult++] = lowsum;
                dest[hiresult++] = hisum;
                i2 += 2;
                lowdata += 2;
                hidata += 2;
            }
            ++level;
            length /= 2;
        }
        return 1;
    }

    public final int IwtVector(double[] source, double[] dest, int length, int levels, WLFilter lowpass, WLFilter hipass) {
        return this.IwtVector(source, dest, 0, 0, length, levels, lowpass, hipass);
    }

    public final int IwtVector(double[] source, double[] dest, int offset, int out_offset, int length, int levels, WLFilter lowpass, WLFilter hipass) {
        int hisize = hipass.length;
        int lowsize = lowpass.length;
        double[] hicoefs = hipass.coefs;
        double[] lowcoefs = lowpass.coefs;
        int left = Math.max(lowpass.offset, hipass.offset);
        int right = Math.max(lowpass.length - lowpass.offset - 1, hipass.length - hipass.offset - 1);
        if (this.sgnpart == null || this.sgnpart.length != levels + 1) {
            this.sgnpart = new int[levels + 1];
        }
        int len = length + left + right;
        if (this.upLow == null || this.upHi == null || this.upLow.length != len || this.upHi.length != len) {
            this.upLow = new double[len];
            this.upHi = new double[len];
        }
        System.arraycopy(source, offset, dest, out_offset, length /= JnUtils.pow2(levels - 1));
        int level = 0;
        while (level < levels) {
            int i2;
            int j2 = left;
            for (i2 = 0; i2 < length / 2; ++i2) {
                this.upLow[j2] = dest[out_offset + i2];
                this.upHi[j2] = source[offset + length / 2 + i2];
                this.upLow[++j2] = 0.0;
                this.upHi[j2] = 0.0;
                ++j2;
            }
            j2 = 0;
            i2 = length - left;
            while (i2 < length) {
                this.upLow[j2] = this.upLow[left + i2];
                this.upHi[j2] = this.upHi[left + i2];
                ++i2;
                ++j2;
            }
            i2 = 0;
            while (i2 < length) {
                this.upLow[j2] = this.upLow[left + i2];
                this.upHi[j2] = this.upHi[left + i2];
                ++i2;
                ++j2;
            }
            i2 = 0;
            while (i2 < right) {
                this.upLow[j2] = this.upLow[left + i2];
                this.upHi[j2] = this.upHi[left + i2];
                ++i2;
                ++j2;
            }
            int lowdata = left - lowpass.offset;
            int hidata = left - hipass.offset;
            int result = 0;
            i2 = 0;
            while (i2 < length) {
                double sum = 0.0;
                for (j2 = 0; j2 < lowsize; ++j2) {
                    sum += this.upLow[lowdata + j2] * lowcoefs[j2];
                }
                for (j2 = 0; j2 < hisize; ++j2) {
                    sum += this.upHi[hidata + j2] * hicoefs[j2];
                }
                dest[out_offset + result++] = sum;
                ++i2;
                ++lowdata;
                ++hidata;
            }
            ++level;
            length *= 2;
        }
        return 1;
    }

    protected final int FswtVector(double[] source, double[] dest, int length, int levels, WLFilter lowpass, WLFilter hipass) {
        return this.FswtVector(source, dest, 0, 0, length, levels, lowpass, hipass);
    }

    protected int FswtVector(double[] source, double[] dest, int offset, int out_offset, int length, int levels, WLFilter lowpass, WLFilter hipass) {
        int hisize = hipass.length;
        int lowsize = lowpass.length;
        double[] hicoefs = hipass.coefs;
        double[] lowcoefs = lowpass.coefs;
        int left = Math.max(lowpass.offset, hipass.offset);
        int right = Math.max(lowpass.length - lowpass.offset - 1, hipass.length - hipass.offset - 1);
        int len = length + left + right;
        if (this.temp1 == null || this.temp1.length != len) {
            this.temp1 = new double[len];
        }
        if (source != dest) {
            System.arraycopy(source, offset, dest, out_offset, length);
        }
        for (int level = 0; level < levels; ++level) {
            double lowsum;
            int i2;
            int j2;
            if (lowsize % 2 != 0) {
                j2 = 0;
                for (i2 = out_offset + left; i2 > out_offset; --i2) {
                    this.temp1[j2++] = dest[i2];
                }
                for (i2 = out_offset; i2 < length + out_offset; ++i2) {
                    this.temp1[j2++] = dest[i2];
                }
                for (i2 = out_offset + length - 2; i2 > out_offset + length - 2 - right; --i2) {
                    this.temp1[j2++] = dest[i2];
                }
            } else {
                j2 = 0;
                for (i2 = out_offset + left - 1; i2 >= out_offset; --i2) {
                    this.temp1[j2++] = dest[i2];
                }
                for (i2 = out_offset; i2 < out_offset + length; ++i2) {
                    this.temp1[j2++] = dest[i2];
                }
                for (i2 = out_offset + length - 1; i2 >= out_offset + length - right; --i2) {
                    this.temp1[j2++] = dest[i2];
                }
            }
            int lowresult = out_offset;
            int hiresult = out_offset + (length + 1) / 2;
            int lowdata = left - lowpass.offset;
            int hidata = left - hipass.offset;
            for (i2 = 0; i2 < length - 1; i2 += 2) {
                lowsum = 0.0;
                double hisum = 0.0;
                for (j2 = 0; j2 < lowsize; ++j2) {
                    lowsum += this.temp1[lowdata + j2] * lowcoefs[j2];
                }
                for (j2 = 0; j2 < hisize; ++j2) {
                    hisum += this.temp1[hidata + j2] * hicoefs[j2];
                }
                dest[lowresult++] = lowsum;
                dest[hiresult++] = hisum;
                lowdata += 2;
                hidata += 2;
            }
            if (length % 2 != 0) {
                lowsum = 0.0;
                for (j2 = 0; j2 < lowsize; ++j2) {
                    lowsum += this.temp1[lowdata + j2] * lowcoefs[j2];
                }
                dest[lowresult] = lowsum;
            }
            length = (length + 1) / 2;
        }
        return 1;
    }

    public int IswtVector(double[] source, double[] dest, int length, int levels, WLFilter lowpass, WLFilter hipass) {
        return this.IswtVector(source, dest, 0, 0, length, levels, lowpass, hipass);
    }

    protected int IswtVector(double[] source, double[] dest, int offset, int out_offset, int length, int levels, WLFilter lowpass, WLFilter hipass) {
        int level;
        int hisize = hipass.length;
        int lowsize = lowpass.length;
        double[] hicoefs = hipass.coefs;
        double[] lowcoefs = lowpass.coefs;
        int left = Math.max(lowpass.offset, hipass.offset);
        int right = Math.max(lowpass.length - lowpass.offset - 1, hipass.length - hipass.offset - 1);
        int result = 0;
        if (this.sgnpart == null || this.sgnpart.length != levels + 1) {
            this.sgnpart = new int[levels + 1];
        }
        int len = length + left + right;
        if (this.upLow == null || this.upHi == null || this.upLow.length != len || this.upHi.length != len) {
            this.upLow = new double[len];
            this.upHi = new double[len];
        }
        int tmp = length;
        for (level = levels; level > 0; --level) {
            this.sgnpart[level] = tmp / 2;
            tmp = (tmp + 1) / 2;
        }
        this.sgnpart[0] = tmp;
        System.arraycopy(source, offset, dest, out_offset, this.sgnpart[0] + this.sgnpart[1]);
        int wBound = this.sgnpart[0];
        for (level = 0; level < levels; ++level) {
            int i2;
            int j2 = left;
            for (i2 = out_offset; i2 < wBound + out_offset; ++i2) {
                this.upLow[j2] = dest[i2];
                this.upLow[++j2] = 0.0;
                ++j2;
            }
            j2 = left;
            for (i2 = 0; i2 < this.sgnpart[level + 1]; ++i2) {
                this.upHi[j2] = source[offset + wBound + i2];
                this.upHi[++j2] = 0.0;
                ++j2;
            }
            length = wBound + this.sgnpart[level + 1];
            if (lowsize % 2 == 1) {
                if (length % 2 == 0) {
                    j2 = 0;
                    for (i2 = 2 * left; i2 > left; --i2) {
                        this.upLow[j2++] = this.upLow[i2];
                    }
                    j2 = left + length;
                    for (i2 = left + length - 2; i2 > left + length - 2 - right; --i2) {
                        this.upLow[j2++] = this.upLow[i2];
                    }
                    this.upHi[left - 1] = 0.0;
                    j2 = 0;
                    for (i2 = 2 * left - 2; i2 >= left; --i2) {
                        this.upHi[j2++] = this.upHi[i2];
                    }
                    j2 = length + left;
                    for (i2 = left + length - 4; i2 > left + length - 4 - right; --i2) {
                        this.upHi[j2++] = this.upHi[i2];
                    }
                } else {
                    j2 = left - 1;
                    for (i2 = left + 1; i2 <= 2 * left; ++i2) {
                        this.upLow[j2--] = this.upLow[i2];
                    }
                    j2 = length + left;
                    for (i2 = length + left - 2; i2 > left + length - 2 - right; --i2) {
                        this.upLow[j2++] = this.upLow[i2];
                    }
                    this.upHi[left - 1] = 0.0;
                    j2 = left - 2;
                    for (i2 = left; i2 < 2 * left - 1; ++i2) {
                        this.upHi[j2--] = this.upHi[i2];
                    }
                    this.upHi[length + left - 1] = this.upHi[length + left - 3];
                    j2 = length + left;
                    for (i2 = length + left - 4; i2 > left + length - 4 - right; --i2) {
                        this.upHi[j2++] = this.upHi[i2];
                    }
                }
            } else if (length % 2 == 0) {
                this.upLow[left - 1] = 0.0;
                j2 = 0;
                for (i2 = 2 * left - 2; i2 >= left; --i2) {
                    this.upLow[j2++] = this.upLow[i2];
                }
                j2 = left + length;
                for (i2 = left + length - 2; i2 > left + length - 2 - right; --i2) {
                    this.upLow[j2++] = this.upLow[i2];
                }
                this.upHi[left - 1] = 0.0;
                j2 = 0;
                for (i2 = 2 * left - 2; i2 >= left; --i2) {
                    this.upHi[j2++] = -this.upHi[i2];
                }
                j2 = left + length;
                for (i2 = left + length - 2; i2 > left + length - 2 - right; --i2) {
                    this.upHi[j2++] = -this.upHi[i2];
                }
            } else {
                this.upLow[left - 1] = 0.0;
                j2 = left - 2;
                for (i2 = left; i2 < 2 * left - 1; ++i2) {
                    this.upLow[j2--] = this.upLow[i2];
                }
                j2 = length + left;
                for (i2 = length + left - 2; i2 > left + length - 2 - right; --i2) {
                    this.upLow[j2++] = this.upLow[i2];
                }
                this.upHi[left - 1] = 0.0;
                j2 = left - 2;
                for (i2 = left; i2 < 2 * left - 1; ++i2) {
                    this.upHi[j2--] = -this.upHi[i2];
                }
                this.upHi[length + left - 1] = -this.upHi[length + left - 5];
                j2 = length + left;
                for (i2 = length + left - 6; i2 > left + length - 6 - right; --i2) {
                    this.upHi[j2++] = -this.upHi[i2];
                }
            }
            int lowdata = left - lowpass.offset;
            int hidata = left - hipass.offset;
            result = out_offset;
            i2 = 0;
            while (i2 < length) {
                double sum = 0.0;
                for (j2 = 0; j2 < lowsize; ++j2) {
                    sum += this.upLow[lowdata + j2] * lowcoefs[j2];
                }
                for (j2 = 0; j2 < hisize; ++j2) {
                    sum += this.upHi[hidata + j2] * hicoefs[j2];
                }
                dest[result++] = sum;
                ++i2;
                ++lowdata;
                ++hidata;
            }
            wBound += this.sgnpart[level + 1];
        }
        return 1;
    }

    public final int FwtMatrix(short[] source, double[] dest, int rows, int cols, int levels, WLFilter lowpass, WLFilter hipass) {
        int len = rows * cols;
        if (this.temp2D == null || this.temp2D.length != len) {
            this.temp2D = new double[len];
        }
        for (int i2 = 0; i2 < len; ++i2) {
            this.temp2D[i2] = source[i2];
        }
        return this.FwtMatrix(this.temp2D, dest, rows, cols, levels, lowpass, hipass);
    }

    public final int FwtMatrix(double[] source, double[] dest, int rows, int cols, int levels, WLFilter lowpass, WLFilter hipass) {
        int width = cols;
        int mat_len = rows * cols;
        if (this.tempSource == null || this.tempDest == null || this.tempSource.length != rows || this.tempDest.length != rows) {
            this.tempSource = new double[rows];
            this.tempDest = new double[rows];
        }
        if (source != dest) {
            System.arraycopy(source, 0, dest, 0, mat_len);
        }
        int level = 0;
        while (level < levels) {
            int r2;
            for (r2 = 0; r2 < rows; ++r2) {
                if (this.FwtVector(dest, dest, r2 * width, r2 * width, cols, 1, lowpass, hipass) == 1) continue;
                return 0;
            }
            for (int c2 = 0; c2 < cols; ++c2) {
                for (r2 = 0; r2 < rows; ++r2) {
                    this.tempSource[r2] = dest[r2 * width + c2];
                }
                if (this.FwtVector(this.tempSource, this.tempDest, rows, 1, lowpass, hipass) != 1) {
                    return 0;
                }
                for (r2 = 0; r2 < rows; ++r2) {
                    dest[r2 * width + c2] = this.tempDest[r2];
                }
            }
            ++level;
            rows /= 2;
            cols /= 2;
        }
        return 1;
    }

    public final int IwtMatrix(double[] source, double[] dest, int rows, int cols, int levels, WLFilter lowpass, WLFilter hipass) {
        int width = cols;
        if (this.tempSource == null || this.tempDest == null || this.tempSource.length != rows || this.tempDest.length != rows) {
            this.tempSource = new double[rows];
            this.tempDest = new double[rows];
        }
        System.arraycopy(source, 0, dest, 0, source.length);
        rows /= JnUtils.pow2(levels - 1);
        cols /= JnUtils.pow2(levels - 1);
        int level = 0;
        while (level < levels) {
            int r2;
            for (int c2 = 0; c2 < cols; ++c2) {
                for (r2 = 0; r2 < rows; ++r2) {
                    this.tempSource[r2] = dest[r2 * width + c2];
                }
                if (this.IwtVector(this.tempSource, this.tempDest, rows, 1, lowpass, hipass) != 1) {
                    return 0;
                }
                for (r2 = 0; r2 < rows; ++r2) {
                    dest[r2 * width + c2] = this.tempDest[r2];
                }
            }
            for (r2 = 0; r2 < rows; ++r2) {
                if (this.IwtVector(dest, dest, r2 * width, r2 * width, cols, 1, lowpass, hipass) == 1) continue;
                return 0;
            }
            ++level;
            rows *= 2;
            cols *= 2;
        }
        return 1;
    }

    protected final int FswtMatrix(short[] source, double[] dest, int rows, int cols, int levels, WLFilter lowpass, WLFilter hipass) {
        int len = rows * cols;
        if (this.temp2D == null || this.temp2D.length != len) {
            this.temp2D = new double[len];
        }
        for (int i2 = 0; i2 < len; ++i2) {
            this.temp2D[i2] = source[i2];
        }
        return this.FswtMatrix(this.temp2D, dest, rows, cols, levels, lowpass, hipass);
    }

    protected final int FswtMatrix(double[] source, double[] dest, int rows, int cols, int levels, WLFilter lowpass, WLFilter hipass) {
        int width = cols;
        int mat_len = rows * cols;
        if (this.tempSource == null || this.tempDest == null || this.tempSource.length != rows || this.tempDest.length != rows) {
            this.tempSource = new double[rows];
            this.tempDest = new double[rows];
        }
        System.arraycopy(source, 0, dest, 0, mat_len);
        for (int level = 0; level < levels; ++level) {
            int r2;
            for (r2 = 0; r2 < rows; ++r2) {
                if (this.FswtVector(dest, dest, r2 * width, r2 * width, cols, 1, lowpass, hipass) == 1) continue;
                return 0;
            }
            for (int c2 = 0; c2 < cols; ++c2) {
                for (r2 = 0; r2 < rows; ++r2) {
                    this.tempSource[r2] = dest[r2 * width + c2];
                }
                if (this.FswtVector(this.tempSource, this.tempDest, rows, 1, lowpass, hipass) != 1) {
                    return 0;
                }
                for (r2 = 0; r2 < rows; ++r2) {
                    dest[r2 * width + c2] = this.tempDest[r2];
                }
            }
            rows = (rows + 1) / 2;
            cols = (cols + 1) / 2;
        }
        return 1;
    }

    protected final int IswtMatrix(double[] source, double[] dest, int rows, int cols, int levels, WLFilter lowpass, WLFilter hipass) {
        int level;
        int width = cols;
        if (this.rSplit == null || this.cSplit == null || this.rSplit.length != levels + 1 || this.cSplit.length != levels + 1) {
            this.rSplit = new int[levels + 1];
            this.cSplit = new int[levels + 1];
        }
        if (this.tempSource == null || this.tempDest == null || this.tempSource.length != rows || this.tempDest.length != rows) {
            this.tempSource = new double[rows];
            this.tempDest = new double[rows];
        }
        System.arraycopy(source, 0, dest, 0, source.length);
        int c2 = cols;
        int r2 = rows;
        for (level = levels; level > 0; --level) {
            this.rSplit[level] = r2 / 2;
            r2 = (r2 + 1) / 2;
            this.cSplit[level] = c2 / 2;
            c2 = (c2 + 1) / 2;
        }
        this.rSplit[0] = r2;
        this.cSplit[0] = c2;
        rows = this.rSplit[0];
        cols = this.cSplit[0];
        for (level = 1; level < levels + 1; ++level) {
            rows += this.rSplit[level];
            cols += this.cSplit[level];
            for (c2 = 0; c2 < cols; ++c2) {
                for (r2 = 0; r2 < rows; ++r2) {
                    this.tempSource[r2] = dest[r2 * width + c2];
                }
                if (this.IswtVector(this.tempSource, this.tempDest, rows, 1, lowpass, hipass) != 1) {
                    return 0;
                }
                for (r2 = 0; r2 < rows; ++r2) {
                    dest[r2 * width + c2] = this.tempDest[r2];
                }
            }
            for (r2 = 0; r2 < rows; ++r2) {
                if (this.IswtVector(dest, dest, r2 * width, r2 * width, cols, 1, lowpass, hipass) == 1) continue;
                return 0;
            }
        }
        return 1;
    }

    public static BufferedImage toLuminanceImage(Image img) {
        int w2 = img.getWidth(null);
        int h2 = img.getHeight(null);
        BufferedImage bi = new BufferedImage(w2, h2, 11);
        Graphics2D g2 = (Graphics2D)bi.getGraphics();
        g2.drawImage(img, 0, 0, null);
        return bi;
    }

    public static BufferedImage toLuminanceImage(double[] raster, int w2, int h2) {
        int MAX = 64000;
        BufferedImage bi = new BufferedImage(w2, h2, 11);
        int len = raster.length;
        short[] out = ((DataBufferUShort)bi.getRaster().getDataBuffer()).getData();
        double min = 9.99999999E8;
        double max = -9.99999999E8;
        for (int i2 = 0; i2 < raster.length; ++i2) {
            double val = Math.abs(raster[i2]);
            if (min > val) {
                min = val;
            }
            if (!(max < val)) continue;
            max = val;
        }
        double range = max - min;
        for (int i3 = 0; i3 < raster.length; ++i3) {
            double val = Math.abs(raster[i3]);
            out[i3] = (short)((double)MAX * ((val - min) / range));
        }
        return bi;
    }

    public static BufferedImage toShortImage(double[] raster, int w2, int h2) {
        BufferedImage bi = new BufferedImage(w2, h2, 11);
        int len = raster.length;
        short[] out = ((DataBufferUShort)bi.getRaster().getDataBuffer()).getData();
        for (int i2 = 0; i2 < raster.length; ++i2) {
            out[i2] = (short)raster[i2];
        }
        return bi;
    }

    public static void showImage(Image img, String imgName) {
        WL.showImage(img, imgName, 0, 0);
    }

    public static void showImage(Image img, String imgName, int x2, int y2) {
        JFrame jf = new JFrame(imgName);
        ImgPanel ip = new ImgPanel(img);
        jf.setContentPane(ip);
        jf.setLocation(x2, y2);
        jf.pack();
        jf.setVisible(true);
    }

    private static void printSignal(double[] signal, int nelem) {
        int ELEM = 16;
        System.out.println("");
        for (int i2 = 0; i2 < nelem; ++i2) {
            System.out.print(" " + df.format(signal[i2]));
            if ((i2 + 1) % ELEM != 0) continue;
            System.out.println("");
        }
    }

    private static class ImgPanel
    extends JPanel {
        private Image img = null;

        public ImgPanel(Image img) {
            this.img = img;
            int w2 = img.getWidth(this);
            int h2 = img.getHeight(this);
            this.setPreferredSize(new Dimension(w2, h2));
        }

        @Override
        public void paintComponent(Graphics g2) {
            Graphics2D g22 = (Graphics2D)g2;
            g22.drawImage(this.img, 0, 0, null);
        }
    }
}

