/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk;

import com.ge.med.ptk.RoundedCornerBorder;
import com.ge.med.ptk.border.CuiBorder;
import com.ge.med.ptk.border.CuiButtonBorder;
import com.ge.med.ptk.border.RenderedShapeBorder;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.shape.EdgeProfileFrame;
import com.ge.med.ptk.shape.RoundRectangleShapeGenerator;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Insets;
import javax.swing.border.Border;

public class PtkBorderFactory {
    public static final int MAXIMIZE_AREA = 0;
    public static final int MAXIMIZE_WIDTH = 1;
    public static final int MAXIMIZE_HEIGHT = 2;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8 202102030211 (Sun Microsystems Inc.|1.6.0_45|50.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public static Border createRoundedCornerBorder(int top, int left, int bottom, int right, double corner, Color matteColor, Color cornerColor) {
        return new RoundedCornerBorder(top, left, bottom, right, corner, matteColor, cornerColor);
    }

    public static Border createRoundedCornerBorder(int top, int left, int bottom, int right, double[] corners, Color matteColor, Color cornerColor) {
        return new RoundedCornerBorder(top, left, bottom, right, corners, matteColor, cornerColor);
    }

    public static Border createRoundedCornerBorder(Insets insets, double[] corners) {
        return new CuiBorder(0.0, 0.0, corners, new boolean[]{true, true, true, true}, new boolean[]{true, true, true, true}, insets, (int)Math.ceil(Math.max(corners[0], corners[1])) <= insets.left && (int)Math.ceil(Math.max(corners[3], corners[2])) <= insets.right ? 2 : ((int)Math.ceil(Math.max(corners[0], corners[3])) <= insets.top && (int)Math.ceil(Math.max(corners[1], corners[2])) <= insets.bottom ? 1 : 0));
    }

    public static Border createLoweredBorder() {
        return new CuiBorder(0.0, CuiLookAndFeel.getExteriorEdge(), new double[]{0.0, 0.0, 0.0, 0.0}, new boolean[]{true, true, true, true}, new boolean[]{true, true, true, true}, new Insets(0, 0, 0, 0), 0);
    }

    public static Border createRaisedBorder() {
        return new CuiBorder(CuiLookAndFeel.getInteriorEdge(), 0.0, new double[]{0.0, 0.0, 0.0, 0.0}, new boolean[]{true, true, true, true}, new boolean[]{true, true, true, true}, new Insets(0, 0, 0, 0), 0);
    }

    public static Border createCuiBorder() {
        return new CuiBorder();
    }

    public static Border createCuiBorder(boolean interiorEdge, boolean exteriorEdge, boolean cornerRoundedTopLeft, boolean cornerRoundedLeftBottom, boolean cornerRoundedBottomRight, boolean cornerRoundedRightTop) {
        return new CuiBorder(interiorEdge ? CuiLookAndFeel.getInteriorEdge() : 0.0, exteriorEdge ? CuiLookAndFeel.getExteriorEdge() : 0.0, new double[]{cornerRoundedTopLeft ? CuiLookAndFeel.getCornerRadius() : 0.0, cornerRoundedLeftBottom ? CuiLookAndFeel.getCornerRadius() : 0.0, cornerRoundedBottomRight ? CuiLookAndFeel.getCornerRadius() : 0.0, cornerRoundedRightTop ? CuiLookAndFeel.getCornerRadius() : 0.0}, new boolean[]{true, true, true, true}, new boolean[]{true, true, true, true}, new Insets(0, 0, 0, 0), 0);
    }

    public static Border createCuiBorder(boolean interiorEdge, boolean exteriorEdge, boolean cornerRoundedTopLeft, boolean cornerRoundedLeftBottom, boolean cornerRoundedBottomRight, boolean cornerRoundedRightTop, Insets minimumMargin, int insetRule) {
        return new CuiBorder(interiorEdge ? CuiLookAndFeel.getInteriorEdge() : 0.0, exteriorEdge ? CuiLookAndFeel.getExteriorEdge() : 0.0, new double[]{cornerRoundedTopLeft ? CuiLookAndFeel.getCornerRadius() : 0.0, cornerRoundedLeftBottom ? CuiLookAndFeel.getCornerRadius() : 0.0, cornerRoundedBottomRight ? CuiLookAndFeel.getCornerRadius() : 0.0, cornerRoundedRightTop ? CuiLookAndFeel.getCornerRadius() : 0.0}, new boolean[]{true, true, true, true}, new boolean[]{true, true, true, true}, minimumMargin, insetRule);
    }

    public static Border createCuiBorder(boolean interiorEdge, boolean exteriorEdge, double cornerRadiusTopLeft, double cornerRadiusLeftBottom, double cornerRadiusBottomRight, double cornerRadiusRightTop, Insets minimumMargin, int insetRule) {
        return new CuiBorder(interiorEdge ? CuiLookAndFeel.getInteriorEdge() : 0.0, exteriorEdge ? CuiLookAndFeel.getExteriorEdge() : 0.0, new double[]{cornerRadiusTopLeft, cornerRadiusLeftBottom, cornerRadiusBottomRight, cornerRadiusRightTop}, new boolean[]{true, true, true, true}, new boolean[]{true, true, true, true}, minimumMargin, insetRule);
    }

    public static Border createButtonBorder(boolean top, boolean left, boolean bottom, boolean right) {
        return new CuiButtonBorder(CuiLookAndFeel.getInteriorEdge(), CuiLookAndFeel.getExteriorEdge(), new double[]{top && left ? CuiLookAndFeel.getCornerRadius() : 0.0, left && bottom ? CuiLookAndFeel.getCornerRadius() : 0.0, bottom && right ? CuiLookAndFeel.getCornerRadius() : 0.0, right && top ? CuiLookAndFeel.getCornerRadius() : 0.0}, top, left, bottom, right);
    }

    public static Border createFrameBorder(int width) {
        EdgeProfileFrame profileFrame = new EdgeProfileFrame(width, CuiLookAndFeel.getExteriorEdge(), CuiLookAndFeel.getInteriorEdge());
        RoundRectangleShapeGenerator shapeFrame = new RoundRectangleShapeGenerator(profileFrame, 0.0);
        return new RenderedShapeBorder(shapeFrame.getInsets(), shapeFrame, profileFrame);
    }
}

