/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.border;

import com.ge.med.ptk.graphics.RenderedShapeFactory;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.shape.EdgeProfile;
import com.ge.med.ptk.shape.EdgeProfileRounded;
import com.ge.med.ptk.shape.RoundRectangleShapeGenerator;
import com.ge.med.ptk.shape.ShapeGenerator;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.swing.border.Border;

public class CuiToolPaletteBorder
implements Border {
    protected Insets insets_;
    protected ShapeGenerator shape_;
    protected EdgeProfile profile_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8 202102030211 (Sun Microsystems Inc.|1.6.0_45|50.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public CuiToolPaletteBorder(Insets insets) {
        this(insets, new RoundRectangleShapeGenerator(new EdgeProfileRounded(CuiLookAndFeel.getInteriorEdge(), 0.0), 0.0), new EdgeProfileRounded(CuiLookAndFeel.getInteriorEdge(), 0.0));
    }

    public CuiToolPaletteBorder(Insets insets, ShapeGenerator shape, EdgeProfile profile) {
        this.insets_ = insets;
        this.shape_ = shape;
        this.profile_ = profile;
    }

    @Override
    public Insets getBorderInsets(Component c2) {
        return this.insets_;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
        Insets insets = this.getBorderInsets(c2);
        if (insets.top > 0) {
            h2 = insets.top;
        } else if (insets.left > 0) {
            w2 = insets.left;
        } else if (insets.bottom > 0) {
            y2 = y2 + h2 - insets.bottom;
            h2 = insets.bottom;
        } else if (insets.right > 0) {
            x2 = x2 + w2 - insets.right;
            w2 = insets.right;
        }
        Dimension size = new Dimension(w2, h2);
        Rectangle cutout = null;
        Shape shape = this.shape_.getShape(size);
        EdgeProfile profile = this.profile_;
        Color interiorColor = c2.getBackground();
        Color exteriorColor = c2.getParent() == null || !c2.getParent().isOpaque() ? new Color(0, true) : c2.getParent().getBackground();
        BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(size, shape, profile, interiorColor, exteriorColor, cutout);
        g2.drawImage(renderedShape, x2, y2, null);
    }
}

