/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.border;

import com.ge.med.ptk.graphics.RenderedShapeFactory;
import com.ge.med.ptk.graphics.StretchedImageIcon;
import com.ge.med.ptk.shape.EdgeProfile;
import com.ge.med.ptk.shape.EdgeProfileRounded;
import com.ge.med.ptk.shape.RoundRectangleShapeGenerator;
import com.ge.med.ptk.shape.ShapeGenerator;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class RenderedShapeBorder
implements Border {
    protected Insets insets_;
    protected ShapeGenerator shape_;
    protected EdgeProfile profile_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8 202102030211 (Sun Microsystems Inc.|1.6.0_45|50.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public static void main1(String[] argv) {
        UIManager.put("ptk.lightingCoefficients", new double[]{0.0, 0.0, 1.0, 1.0, 4.0, 1.0, 1.0});
        JFrame f2 = new JFrame();
        f2.setDefaultCloseOperation(3);
        f2.getContentPane().setLayout(new GridLayout(4, 4, 10, 10));
        if (f2.getContentPane() instanceof JComponent) {
            ((JComponent)f2.getContentPane()).setBorder(new EmptyBorder(10, 10, 10, 10));
        }
        f2.getContentPane().setBackground(Color.pink);
        EdgeProfileRounded profile = new EdgeProfileRounded(20.0, 10.0);
        RoundRectangleShapeGenerator shape = new RoundRectangleShapeGenerator(profile, 15.0);
        for (int i2 = 0; i2 < 16; ++i2) {
            JPanel p2 = new JPanel();
            p2.setBorder(new RenderedShapeBorder(shape.getInsets(), shape, profile));
            p2.setBackground(Color.gray);
            p2.setPreferredSize(new Dimension(200, 200));
            f2.getContentPane().add(p2);
        }
        f2.pack();
        f2.setVisible(true);
    }

    public RenderedShapeBorder(Insets insets, ShapeGenerator shape, EdgeProfile profile) {
        this.insets_ = insets;
        this.shape_ = shape;
        this.profile_ = profile;
    }

    @Override
    public Insets getBorderInsets(Component c2) {
        return this.insets_;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
        Color interior = c2.getBackground();
        Color exterior = c2.getParent() == null || !c2.getParent().isOpaque() ? new Color(0, true) : c2.getParent().getBackground();
        Insets insets = this.getBorderInsets(c2);
        int maxInset = Math.max(Math.max(insets.left, insets.right), Math.max(insets.top, insets.bottom));
        Dimension size = new Dimension(Math.min(w2, 3 * maxInset + 1), Math.min(h2, 3 * maxInset + 1));
        Rectangle cutout = new Rectangle(insets.left, insets.top, size.width - (insets.left + insets.right), size.height - (insets.top + insets.bottom));
        Shape shape = this.shape_.getShape(size);
        EdgeProfile profile = this.profile_;
        BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(size, shape, profile, interior, exterior, cutout);
        new StretchedImageIcon(renderedShape, w2, h2).paintIcon(c2, g2, x2, y2);
    }
}

