/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.graphics;

import com.ge.med.ptk.utilities.VersionStamp;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MathFunctions {
    protected static Logger logger_ = Logger.getLogger(MathFunctions.class.getName());
    protected static int traceLimit_ = 10;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8 202102030211 (Sun Microsystems Inc.|1.6.0_45|50.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    static double smooth(double xMin, double xMax, double xControl, double yMin, double yMax, double yControl, double x2) {
        double xMinP = xMin;
        double xMaxP = xMax;
        double xControlP = xControl;
        double yMinP = yMin;
        double yMaxP = yMax;
        double yControlP = yControl;
        double xP = x2;
        try {
            double y2;
            if (xMax >= xMin && (xControl > xMax || xControl < xMin) || xMax <= xMin && (xControl < xMax || xControl > xMin) || yMax >= yMin && (yControl > yMax || yControl < yMin) || yMax <= yMin && (yControl < yMax || yControl > yMin)) {
                throw new IllegalArgumentException("xControl,yControl must be in the xMin-xMax,yMin-yMax range.");
            }
            x2 -= xControl;
            xMin -= xControl;
            xMax -= xControl;
            yMin -= yControl;
            yMax -= yControl;
            if (xMin > xMax) {
                double tmp = xMin;
                xMin = xMax;
                xMax = tmp;
                x2 = -x2;
            }
            if (x2 >= xMax) {
                return yMax + yControl;
            }
            if (x2 <= xMin) {
                return yMin + yControl;
            }
            if (yMin == yMax) {
                return yControl;
            }
            double xLimit = x2 < 0.0 ? xMin : xMax;
            double yLimit = x2 < 0.0 ? yMin : yMax;
            double xSlope = (yMax - yMin) / (xMax - xMin);
            double ySlope = (xMax - xMin) / (yMax - yMin);
            if (x2 == 0.0) {
                y2 = 0.0;
            } else if (xMin / xMax == yMin / yMax) {
                y2 = x2 * xSlope;
            } else if (x2 < 0.0 ^ xMin / xMax < yMin / yMax) {
                double yZero = yLimit - xLimit * xSlope;
                y2 = yZero * (x2 / xLimit) * (x2 / xLimit) + (yLimit - yZero) * x2 / xLimit;
            } else {
                double xZero = xLimit - yLimit * ySlope;
                double yIntercept = xSlope * x2;
                if (xZero == 0.0) {
                    y2 = yIntercept;
                } else {
                    double a2 = xSlope * xSlope;
                    double b2 = -2.0 * xSlope * yIntercept - yLimit * yLimit / xZero;
                    double c2 = yIntercept * yIntercept;
                    double sign = x2 > 0.0 ? -1.0 : 1.0;
                    y2 = yIntercept - xSlope * (-b2 + sign * Math.sqrt(Math.abs(b2 * b2 - 4.0 * a2 * c2))) / (2.0 * a2);
                }
            }
            if (Double.isNaN(y2)) {
                throw new RuntimeException("Double.isNaN(y).");
            }
            return y2 += yControl;
        }
        catch (Exception ex) {
            xMin = xMinP;
            xMax = xMaxP;
            xControl = xControlP;
            yMin = yMinP;
            yMax = yMaxP;
            yControl = yControlP;
            x2 = xP;
            if (traceLimit_ > 0) {
                --traceLimit_;
                logger_.log(Level.WARNING, "xMin:{0} xMax:{1} xControl:[2} yMin:{3} yMax:{4} yControl:{5} x:{6}", new String[]{"" + xMin, "" + xMax, "" + xControl, "" + yMin, "" + yMax, "" + yControl, "" + x2});
                logger_.log(Level.WARNING, "" + ex, ex);
            }
            try {
                if (xMin > xMax) {
                    double tmp = xMin;
                    xMin = xMax;
                    xMax = tmp;
                    x2 = -x2;
                }
                x2 = Math.max(x2, xMin);
                double y3 = (x2 = Math.min(x2, xMax)) < xControl ? yMin + (x2 - xMin) / (xControl - xMin) * (yControl - yMin) : yMax - (xMax - x2) / (xMax - xControl) * (yMax - yControl);
                if (Double.isNaN(y3)) {
                    throw new RuntimeException("Double.isNaN(y).");
                }
                return y3;
            }
            catch (Exception exx) {
                return yControl;
            }
        }
    }
}

