/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.graphics;

import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class StretchedImageIcon
implements Icon {
    static Map corners_ = new HashMap();
    protected BufferedImage image_;
    protected int rw_;
    protected int rh_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8 202102030211 (Sun Microsystems Inc.|1.6.0_45|50.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public StretchedImageIcon(BufferedImage image, int width, int height) {
        this.image_ = image;
        this.rw_ = width;
        this.rh_ = height;
    }

    @Override
    public int getIconWidth() {
        return this.rw_;
    }

    @Override
    public int getIconHeight() {
        return this.rh_;
    }

    @Override
    public void paintIcon(Component c2, Graphics g2, int rx, int ry) {
        int alpha;
        int rgb;
        int i2;
        int iw = this.image_.getWidth();
        int ih = this.image_.getHeight();
        int iw2 = iw / 2;
        int ih2 = ih / 2;
        Image[] corners = (Image[])corners_.get(this.image_);
        if (corners == null) {
            corners = new Image[4];
            corners_.put(this.image_, corners);
            if (iw2 > 0 && ih2 > 0) {
                int[] x1 = new int[]{0, iw - iw2, 0, iw - iw2};
                int[] y1 = new int[]{0, 0, ih - ih2, ih - ih2};
                for (int i3 = 0; i3 < 4; ++i3) {
                    int imageTransparency = this.image_.getColorModel().getTransparency();
                    int cornerTransparency = 1;
                    for (int x2 = x1[i3]; x2 < x1[i3] + iw2 && imageTransparency > cornerTransparency; ++x2) {
                        for (int y2 = y1[i3]; y2 < y1[i3] + ih2 && imageTransparency > cornerTransparency; ++y2) {
                            int alpha2 = this.image_.getRGB(x2, y2) >>> 24;
                            if (alpha2 < 255) {
                                cornerTransparency = 3;
                            }
                            if (alpha2 != 0) continue;
                            cornerTransparency = 2;
                        }
                    }
                    corners[i3] = cornerTransparency == 1 && c2 != null ? new BufferedImage(iw2, ih2, 1) : new BufferedImage(iw2, ih2, 2);
                    corners[i3].getGraphics().drawImage(this.image_, -x1[i3], -y1[i3], null);
                }
            }
        }
        int rw2 = Math.min(iw2, this.rw_ / 2);
        int rh2 = Math.min(ih2, this.rh_ / 2);
        if (rw2 > 0 && rh2 > 0) {
            if (rw2 == iw2 && rh2 == ih2) {
                if (g2.hitClip(rx, ry, rw2, rh2)) {
                    g2.drawImage(corners[0], rx, ry, null);
                }
                if (g2.hitClip(rx + this.rw_ - rw2, ry, rw2, rh2)) {
                    g2.drawImage(corners[1], rx + this.rw_ - rw2, ry, null);
                }
                if (g2.hitClip(rx, ry + this.rh_ - rh2, rw2, rh2)) {
                    g2.drawImage(corners[2], rx, ry + this.rh_ - rh2, null);
                }
                if (g2.hitClip(rx + this.rw_ - rw2, ry + this.rh_ - rh2, rw2, rh2)) {
                    g2.drawImage(corners[3], rx + this.rw_ - rw2, ry + this.rh_ - rh2, null);
                }
            } else {
                g2.drawImage(this.image_.getSubimage(0, 0, rw2, rh2), rx, ry, null);
                g2.drawImage(this.image_.getSubimage(iw - rw2, 0, rw2, rh2), rx + this.rw_ - rw2, ry, null);
                g2.drawImage(this.image_.getSubimage(0, ih - rh2, rw2, rh2), rx, ry + this.rh_ - rh2, null);
                g2.drawImage(this.image_.getSubimage(iw - rw2, ih - rh2, rw2, rh2), rx + this.rw_ - rw2, ry + this.rh_ - rh2, null);
            }
        }
        int sw = this.rw_ - (iw2 + iw2);
        int sh = this.rh_ - (ih2 + ih2);
        if (sw > 0) {
            if (g2.hitClip(rx + iw2, ry, sw, rh2)) {
                for (i2 = 0; i2 < rh2; ++i2) {
                    rgb = this.image_.getRGB(rw2, i2);
                    alpha = rgb >>> 24;
                    if (alpha == 0) continue;
                    g2.setColor(new Color(rgb, alpha < 255));
                    g2.fillRect(rx + iw2, ry + i2, sw, 1);
                }
            }
            if (g2.hitClip(rx + iw2, ry + this.rh_ - rh2, sw, rh2)) {
                for (i2 = 0; i2 < rh2; ++i2) {
                    rgb = this.image_.getRGB(rw2, ih - rh2 + i2);
                    alpha = rgb >>> 24;
                    if (alpha == 0) continue;
                    g2.setColor(new Color(rgb, alpha < 255));
                    g2.fillRect(rx + iw2, ry + this.rh_ - rh2 + i2, sw, 1);
                }
            }
        }
        if (sh > 0) {
            if (g2.hitClip(rx, ry + ih2, rw2, sh)) {
                for (i2 = 0; i2 < rw2; ++i2) {
                    rgb = this.image_.getRGB(i2, rh2);
                    alpha = rgb >>> 24;
                    if (alpha == 0) continue;
                    g2.setColor(new Color(rgb, alpha < 255));
                    g2.fillRect(rx + i2, ry + ih2, 1, sh);
                }
            }
            if (g2.hitClip(rx + this.rw_ - rw2, ry + ih2, rw2, sh)) {
                for (i2 = 0; i2 < rw2; ++i2) {
                    rgb = this.image_.getRGB(iw - rw2 + i2, rh2);
                    alpha = rgb >>> 24;
                    if (alpha == 0) continue;
                    g2.setColor(new Color(rgb, alpha < 255));
                    g2.fillRect(rx + this.rw_ - rw2 + i2, ry + ih2, 1, sh);
                }
            }
        }
        if (sw > 0 && sh > 0 && g2.hitClip(rx + rw2, ry + rh2, sw, sh) && (alpha = (rgb = this.image_.getRGB(rw2, rh2)) >>> 24) > 0) {
            g2.setColor(new Color(rgb, alpha < 255));
            g2.fillRect(rx + rw2, ry + rh2, sw, sh);
        }
    }
}

