/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.laf.CuiTheme;
import com.ge.med.ptk.laf.TextUtilities;
import com.ge.med.ptk.laf.Utilities;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Font;
import java.util.Map;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class CuiLookAndFeel
extends MetalLookAndFeel {
    protected MetalTheme theme_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8 202102030211 (Sun Microsystems Inc.|1.6.0_45|50.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public CuiLookAndFeel() {
        this.theme_ = new CuiTheme();
    }

    protected CuiLookAndFeel(Map properties) {
        this.theme_ = new CuiTheme(properties);
    }

    @Override
    public String getName() {
        return "CUI";
    }

    @Override
    public String getID() {
        return "GEMS_CUI";
    }

    @Override
    public String getDescription() {
        return "GE Medical Systems Common Look and Feel";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public void initialize() {
        CuiLookAndFeel.setCurrentTheme(this.theme_);
        super.initialize();
    }

    @Override
    public void uninitialize() {
        super.uninitialize();
        CuiLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
    }

    public void update() {
        ((CuiTheme)this.theme_).update();
    }

    public static void setTextUtilities(TextUtilities textUtilities) {
        Utilities.setTextUtilities(textUtilities);
    }

    public static double getScale() {
        return CuiLookAndFeel.getDoubleProperty("cui.scale", 1.0);
    }

    public static double getInteriorEdge() {
        return CuiLookAndFeel.getDoubleProperty("cui.interiorEdge", 0.0);
    }

    public static double getExteriorEdge() {
        return CuiLookAndFeel.getDoubleProperty("cui.exteriorEdge", 0.0);
    }

    public static double getCornerRadius() {
        return CuiLookAndFeel.getDoubleProperty("cui.cornerRadius", 0.0);
    }

    public static double getRoundoverSlope() {
        return CuiLookAndFeel.getDoubleProperty("cui.roundoverSlope", 0.0);
    }

    public static double getBevelSlope() {
        return CuiLookAndFeel.getDoubleProperty("cui.bevelSlope", 0.0);
    }

    public static int getTextAntialiasing() {
        return CuiLookAndFeel.getIntProperty("cui.textAntialiasing", 12);
    }

    public static Font getSansserifPlain() {
        return CuiLookAndFeel.getFontProperty("cui.sansserifPlain", "sansserif 12");
    }

    public static Font getSansserifBold() {
        return CuiLookAndFeel.getFontProperty("cui.sansserifBold", "sansserif Bold 12");
    }

    protected static double getDoubleProperty(String key, double defaultValue) {
        Object value = UIManager.get(key);
        return value instanceof Number ? ((Number)value).doubleValue() : defaultValue;
    }

    protected static int getIntProperty(String key, int defaultValue) {
        Object value = UIManager.get(key);
        return value instanceof Number ? ((Number)value).intValue() : defaultValue;
    }

    protected static boolean getBooleanProperty(String key, boolean defaultValue) {
        Object value = UIManager.get(key);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    protected static Font getFontProperty(String key, String defaultValue) {
        Object value = UIManager.get(key);
        return value instanceof Font ? (Font)value : Font.decode(defaultValue);
    }
}

