/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.graphics.RenderedShapeFactory;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.laf.Utilities;
import com.ge.med.ptk.shape.EdgeProfileRounded;
import com.ge.med.ptk.shape.NamedShape;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class CuiRadioButtonIcon
implements Icon,
UIResource,
Serializable {
    protected int size_;
    protected int air_;
    protected double exteriorEdge_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8 202102030211 (Sun Microsystems Inc.|1.6.0_45|50.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public CuiRadioButtonIcon() {
        this(12);
    }

    public CuiRadioButtonIcon(int size) {
        this.size_ = (int)Math.round((double)size * CuiLookAndFeel.getScale());
        this.air_ = this.size_ / 6;
        this.exteriorEdge_ = CuiLookAndFeel.getExteriorEdge();
    }

    @Override
    public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
        AbstractButton b2 = (AbstractButton)c2;
        ButtonModel model = b2.getModel();
        Container parent = b2.getParent();
        boolean menu = b2 instanceof JMenuItem;
        boolean selected = b2.isSelected();
        boolean enabled = model.isEnabled();
        boolean armed = model.isArmed();
        boolean pressed = model.isPressed();
        boolean filled = b2.isBorderPainted() && b2.isContentAreaFilled();
        String classKey = menu ? "RadioButtonMenuItem" : "RadioButton";
        int exteriorEdge = (int)Math.ceil(this.exteriorEdge_);
        Dimension size = new Dimension(this.size_ + 2 * exteriorEdge, this.size_ + 2 * exteriorEdge);
        if (size.width <= 0 || size.height <= 0) {
            return;
        }
        String shapeID = "Ellipse[" + exteriorEdge + "," + this.size_ + "]";
        Shape shape = (Shape)Utilities.shapeCache_.get(shapeID);
        if (shape == null) {
            shape = new NamedShape(shapeID, new Ellipse2D.Double(exteriorEdge, exteriorEdge, this.size_, this.size_));
            Utilities.shapeCache_.put(shapeID, shape);
        }
        EdgeProfileRounded profile = new EdgeProfileRounded(0.0, this.exteriorEdge_);
        Color exteriorColor = null;
        if (filled && enabled && !menu && pressed) {
            exteriorColor = UIManager.getColor(classKey + ".press");
        } else if (filled && enabled && !menu && selected || menu && armed) {
            exteriorColor = UIManager.getColor(classKey + ".select");
        } else if (filled && enabled || c2.isOpaque()) {
            exteriorColor = c2.getBackground();
        } else if (parent != null && parent.isOpaque()) {
            exteriorColor = parent.getBackground();
        }
        if (exteriorColor == null) {
            exteriorColor = new Color(0, true);
        }
        Color interiorColor = null;
        if (enabled) {
            interiorColor = pressed && armed ? UIManager.getColor(classKey + ".press") : UIManager.getColor(classKey + ".circleBackground");
        }
        if (interiorColor == null) {
            interiorColor = exteriorColor;
        }
        Rectangle cutout = null;
        BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(size, shape, profile, interiorColor, exteriorColor, cutout);
        g2.drawImage(renderedShape, x2, y2, null);
        if (selected) {
            shapeID = "Ellipse[" + (exteriorEdge + this.air_) + "," + (this.size_ - 2 * this.air_) + "]";
            shape = (Shape)Utilities.shapeCache_.get(shapeID);
            if (shape == null) {
                shape = new NamedShape(shapeID, new Ellipse2D.Double(exteriorEdge + this.air_, exteriorEdge + this.air_, this.size_ - 2 * this.air_, this.size_ - 2 * this.air_));
                Utilities.shapeCache_.put(shapeID, shape);
            }
            profile = enabled ? new EdgeProfileRounded((this.size_ - 2 * this.air_) / 2, 0.0) : new EdgeProfileRounded(0.0, 0.0);
            Color interiorColor2 = UIManager.getColor(classKey + (enabled ? ".foreground" : ".disabledText"));
            Color exteriorColor2 = new Color(0, true);
            cutout = null;
            renderedShape = RenderedShapeFactory.getRenderedShape(size, shape, profile, interiorColor2, exteriorColor2, cutout);
            g2.drawImage(renderedShape, x2, y2, null);
        }
    }

    @Override
    public int getIconWidth() {
        return this.size_ + 2 * (int)Math.ceil(this.exteriorEdge_);
    }

    @Override
    public int getIconHeight() {
        return this.size_ + 2 * (int)Math.ceil(this.exteriorEdge_);
    }
}

