/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.laf.Utilities;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class CuiTreeCellRenderer
extends DefaultTreeCellRenderer {
    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8 202102030211 (Sun Microsystems Inc.|1.6.0_45|50.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean focus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, focus);
        Object root = tree.getModel().getRoot();
        TreePath path = row < 0 ? null : tree.getPathForRow(row);
        TreePath ppath = path == null ? null : path.getParentPath();
        Object parent = ppath == null ? null : ppath.getLastPathComponent();
        boolean isRoot = value == root;
        boolean isRootChild = parent == root;
        boolean parentExpanded = ppath != null && tree.isExpanded(ppath);
        boolean exp = expanded && !isRoot || parentExpanded && !isRoot && !isRootChild;
        this.setOpaque(true);
        if (selected) {
            this.setForeground(Utilities.getUIPropertyColor(tree, "Tree.selectionForeground", Color.white));
            this.setBackground(Utilities.getUIPropertyColor(tree, "Tree.selectionBackground", Color.black));
        } else {
            List rowColors;
            Color foreground = Utilities.getUIPropertyColor(tree, "Tree.textForeground", Color.black);
            Color background = Utilities.getUIPropertyColor(tree, "Tree.background", Color.white);
            if (exp) {
                foreground = Utilities.getUIPropertyColor(tree, "Tree.expandedForeground", foreground);
                background = Utilities.getUIPropertyColor(tree, "Tree.expandedBackground", background);
            }
            if ((rowColors = (List)tree.getClientProperty("rowColors")) != null && row >= 0 && row < rowColors.size()) {
                this.setBackground((Color)rowColors.get(row));
                this.setForeground(foreground);
            } else {
                this.setForeground(foreground);
                this.setBackground(background);
            }
        }
        Border border = null;
        if (focus) {
            border = Utilities.getUIPropertyBorder(tree, "Tree.focusCellHighlightBorder");
        }
        if (!focus || border == null) {
            border = Utilities.getUIPropertyBorder(tree, "Tree.cellBorder");
        }
        if (border != null) {
            this.setBorder(border);
        }
        return this;
    }

    @Override
    public Color getBackgroundSelectionColor() {
        return null;
    }

    @Override
    public Color getBorderSelectionColor() {
        return null;
    }

    public static class UIResource
    extends CuiTreeCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

