/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.shape;

import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.shape.EdgeProfile;
import com.ge.med.ptk.utilities.VersionStamp;

public class EdgeProfileRounded
implements EdgeProfile {
    protected double interiorWidth_;
    protected double exteriorWidth_;
    protected double slope_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8 202102030211 (Sun Microsystems Inc.|1.6.0_45|50.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public EdgeProfileRounded() {
        this(CuiLookAndFeel.getInteriorEdge(), CuiLookAndFeel.getExteriorEdge(), CuiLookAndFeel.getRoundoverSlope());
    }

    public EdgeProfileRounded(double interiorWidth, double exteriorWidth) {
        this(interiorWidth, exteriorWidth, 1.0);
    }

    public EdgeProfileRounded(double interiorWidth, double exteriorWidth, double slope) {
        this.interiorWidth_ = interiorWidth;
        this.exteriorWidth_ = exteriorWidth;
        this.slope_ = slope;
    }

    @Override
    public double getInteriorWidth() {
        return this.interiorWidth_;
    }

    @Override
    public double getExteriorWidth() {
        return this.exteriorWidth_;
    }

    @Override
    public double getSlope(double distanceFromShape) {
        if (distanceFromShape <= -this.exteriorWidth_ || distanceFromShape >= this.interiorWidth_) {
            return 0.0;
        }
        if (distanceFromShape < 0.0) {
            return -this.slope_ * (this.exteriorWidth_ + distanceFromShape) * (this.exteriorWidth_ + distanceFromShape) / (this.exteriorWidth_ * this.exteriorWidth_);
        }
        return this.slope_ * (this.interiorWidth_ - distanceFromShape) * (this.interiorWidth_ - distanceFromShape) / (this.interiorWidth_ * this.interiorWidth_);
    }

    public String toString() {
        return "EdgeProfileRounded[" + this.getInteriorWidth() + "," + this.getExteriorWidth() + "," + this.slope_ + "]";
    }
}

