/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.shape;

import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.RoundRectangle2D;
import java.util.NoSuchElementException;

public class RoundCornerRectangle
extends RoundRectangle2D.Double {
    public double[] arcWidthArray_;
    public double[] arcHeightArray_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8 202102030211 (Sun Microsystems Inc.|1.6.0_45|50.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getBounds2D() + "," + this.arcWidthArray_[0] + "x" + this.arcHeightArray_[0] + "," + this.arcWidthArray_[1] + "x" + this.arcHeightArray_[1] + "," + this.arcWidthArray_[2] + "x" + this.arcHeightArray_[2] + "," + this.arcWidthArray_[3] + "x" + this.arcHeightArray_[3] + "]";
    }

    public RoundCornerRectangle(double x2, double y2, double w2, double h2, double[] arcw, double[] arch) {
        super(x2, y2, w2, h2, Math.max(Math.max(arcw[0], arcw[1]), Math.max(arcw[2], arcw[3])), Math.max(Math.max(arch[0], arch[1]), Math.max(arch[2], arch[3])));
        this.arcWidthArray_ = arcw;
        this.arcHeightArray_ = arch;
    }

    @Override
    public boolean contains(double x2, double y2) {
        if (this.isEmpty()) {
            return false;
        }
        double left = this.getX();
        double top = this.getY();
        double right = left + this.getWidth();
        double bottom = top + this.getHeight();
        if (x2 < left || y2 < top || x2 >= right || y2 >= bottom) {
            return false;
        }
        if (x2 <= left + this.arcWidthArray_[0] / 2.0 && y2 <= top + this.arcHeightArray_[0] / 2.0) {
            return (x2 = 1.0 - (x2 - left) / (this.arcWidthArray_[0] / 2.0)) * x2 + (y2 = 1.0 - (y2 - top) / (this.arcHeightArray_[0] / 2.0)) * y2 <= 1.0;
        }
        if (x2 <= left + this.arcWidthArray_[1] / 2.0 && y2 >= bottom - this.arcHeightArray_[1] / 2.0) {
            return (x2 = 1.0 - (x2 - left) / (this.arcWidthArray_[1] / 2.0)) * x2 + (y2 = 1.0 - (bottom - y2) / (this.arcHeightArray_[1] / 2.0)) * y2 <= 1.0;
        }
        if (x2 >= right - this.arcWidthArray_[2] / 2.0 && y2 >= bottom - this.arcHeightArray_[2] / 2.0) {
            return (x2 = 1.0 - (right - x2) / (this.arcWidthArray_[2] / 2.0)) * x2 + (y2 = 1.0 - (bottom - y2) / (this.arcHeightArray_[2] / 2.0)) * y2 <= 1.0;
        }
        if (x2 >= right - this.arcWidthArray_[3] / 2.0 && y2 <= top + this.arcHeightArray_[3] / 2.0) {
            return (x2 = 1.0 - (right - x2) / (this.arcWidthArray_[3] / 2.0)) * x2 + (y2 = 1.0 - (y2 - top) / (this.arcHeightArray_[3] / 2.0)) * y2 <= 1.0;
        }
        return true;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new RoundCornerRectIterator(this, at);
    }

    protected static class RoundCornerRectIterator
    implements PathIterator {
        public double x;
        public double y;
        public double w;
        public double h;
        public AffineTransform affine;
        public int index;
        public double[] aw_ = new double[4];
        public double[] ah_ = new double[4];
        private static final double angle = 0.7853981633974483;
        private static final double a = 1.0 - Math.cos(0.7853981633974483);
        private static final double b = Math.tan(0.7853981633974483);
        private static final double c = Math.sqrt(1.0 + b * b) - 1.0 + a;
        private static final double cv = 1.3333333333333333 * a * b / c;
        private static final double acv = (1.0 - cv) / 2.0;
        private static double[][] ctrlpts = new double[][]{{0.0, 0.0, 0.0, 0.5}, {0.0, 0.0, 1.0, -0.5}, {0.0, 0.0, 1.0, -acv, 0.0, acv, 1.0, 0.0, 0.0, 0.5, 1.0, 0.0}, {1.0, -0.5, 1.0, 0.0}, {1.0, -acv, 1.0, 0.0, 1.0, 0.0, 1.0, -acv, 1.0, 0.0, 1.0, -0.5}, {1.0, 0.0, 0.0, 0.5}, {1.0, 0.0, 0.0, acv, 1.0, -acv, 0.0, 0.0, 1.0, -0.5, 0.0, 0.0}, {0.0, 0.5, 0.0, 0.0}, {0.0, acv, 0.0, 0.0, 0.0, 0.0, 0.0, acv, 0.0, 0.0, 0.0, 0.5}, new double[0]};
        private static int[] types = new int[]{0, 1, 3, 1, 3, 1, 3, 1, 3, 4};
        private static int[] corner = new int[]{0, 1, 1, 2, 2, 3, 3, 0, 0, 0};

        public RoundCornerRectIterator(RoundCornerRectangle rr, AffineTransform at) {
            this.x = rr.getX();
            this.y = rr.getY();
            this.w = rr.getWidth();
            this.h = rr.getHeight();
            System.arraycopy(rr.arcWidthArray_, 0, this.aw_, 0, 4);
            System.arraycopy(rr.arcHeightArray_, 0, this.ah_, 0, 4);
            this.affine = at;
        }

        @Override
        public int getWindingRule() {
            return 1;
        }

        @Override
        public boolean isDone() {
            return this.index >= ctrlpts.length;
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public int currentSegment(float[] coords) {
            if (this.isDone()) {
                throw new NoSuchElementException("roundcornerrect iterator out of bounds");
            }
            if (types[this.index] == 3 && (this.aw_[corner[this.index]] == 0.0 || this.ah_[corner[this.index]] == 0.0)) {
                ++this.index;
            }
            double[] ctrls = ctrlpts[this.index];
            int nc = 0;
            for (int i2 = 0; i2 < ctrls.length; i2 += 4) {
                coords[nc++] = (float)(this.x + ctrls[i2 + 0] * this.w + ctrls[i2 + 1] * this.aw_[corner[this.index]]);
                coords[nc++] = (float)(this.y + ctrls[i2 + 2] * this.h + ctrls[i2 + 3] * this.ah_[corner[this.index]]);
            }
            if (this.affine != null) {
                this.affine.transform(coords, 0, coords, 0, nc / 2);
            }
            return types[this.index];
        }

        @Override
        public int currentSegment(double[] coords) {
            if (this.isDone()) {
                throw new NoSuchElementException("roundcornerrect iterator out of bounds");
            }
            if (types[this.index] == 3 && (this.aw_[corner[this.index]] == 0.0 || this.ah_[corner[this.index]] == 0.0)) {
                ++this.index;
            }
            double[] ctrls = ctrlpts[this.index];
            int nc = 0;
            for (int i2 = 0; i2 < ctrls.length; i2 += 4) {
                coords[nc++] = this.x + ctrls[i2 + 0] * this.w + ctrls[i2 + 1] * this.aw_[corner[this.index]];
                coords[nc++] = this.y + ctrls[i2 + 2] * this.h + ctrls[i2 + 3] * this.ah_[corner[this.index]];
            }
            if (this.affine != null) {
                this.affine.transform(coords, 0, coords, 0, nc / 2);
            }
            return types[this.index];
        }
    }
}

