/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.shape;

import com.ge.med.ptk.shape.EdgeProfile;
import com.ge.med.ptk.shape.RoundCornerRectangle;
import com.ge.med.ptk.shape.ShapeGenerator;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Shape;

public class RoundRectangleShapeGenerator
implements ShapeGenerator {
    protected EdgeProfile profile_;
    protected double[] radii_;
    protected boolean top_;
    protected boolean left_;
    protected boolean bottom_;
    protected boolean right_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8 202102030211 (Sun Microsystems Inc.|1.6.0_45|50.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public RoundRectangleShapeGenerator(EdgeProfile profile, double[] radii, boolean top, boolean left, boolean bottom, boolean right) {
        this.profile_ = profile;
        this.radii_ = radii;
        this.top_ = top;
        this.left_ = left;
        this.bottom_ = bottom;
        this.right_ = right;
    }

    public RoundRectangleShapeGenerator(EdgeProfile profile, double radius, boolean top, boolean left, boolean bottom, boolean right) {
        this(profile, new double[]{radius, radius, radius, radius}, top, left, bottom, right);
    }

    public RoundRectangleShapeGenerator(EdgeProfile profile, double radius) {
        this(profile, radius, true, true, true, true);
    }

    @Override
    public Shape getShape(Dimension size) {
        int exterior = (int)Math.ceil(this.profile_.getExteriorWidth());
        int offset = (int)Math.ceil(this.profile_.getExteriorWidth());
        return new RoundCornerRectangle((double)(exterior - (this.left_ ? 0 : offset)), (double)(exterior - (this.top_ ? 0 : offset)), (double)(size.width - 2 * exterior + (this.left_ ? 0 : offset) + (this.right_ ? 0 : offset)), (double)(size.height - 2 * exterior + (this.top_ ? 0 : offset) + (this.bottom_ ? 0 : offset)), new double[]{2.0 * this.radii_[0], 2.0 * this.radii_[1], 2.0 * this.radii_[2], 2.0 * this.radii_[3]}, new double[]{2.0 * this.radii_[0], 2.0 * this.radii_[1], 2.0 * this.radii_[2], 2.0 * this.radii_[3]});
    }

    public Insets getInsets() {
        int exterior = (int)Math.ceil(this.profile_.getExteriorWidth());
        double interior = this.profile_.getInteriorWidth();
        double radius = Math.max(Math.max(this.radii_[0], this.radii_[1]), Math.max(this.radii_[2], this.radii_[3]));
        int inset = (int)Math.ceil(Math.max(interior, (radius - interior) * Math.sqrt(2.0) / 2.0));
        return new Insets((this.top_ ? exterior : 0) + inset, (this.left_ ? exterior : 0) + inset, (this.bottom_ ? exterior : 0) + inset, (this.right_ ? exterior : 0) + inset);
    }

    public Insets getInsetsH() {
        int exterior = (int)Math.ceil(this.profile_.getExteriorWidth());
        int interior = (int)Math.ceil(this.profile_.getInteriorWidth());
        int radius = (int)Math.ceil(Math.max(Math.max(this.radii_[0], this.radii_[1]), Math.max(this.radii_[2], this.radii_[3])));
        return new Insets((this.top_ ? exterior : 0) + Math.max(interior, radius), (this.left_ ? exterior : 0) + interior, (this.bottom_ ? exterior : 0) + Math.max(interior, radius), (this.right_ ? exterior : 0) + interior);
    }

    public Insets getInsetsV() {
        int exterior = (int)Math.ceil(this.profile_.getExteriorWidth());
        int interior = (int)Math.ceil(this.profile_.getInteriorWidth());
        int radius = (int)Math.ceil(Math.max(Math.max(this.radii_[0], this.radii_[1]), Math.max(this.radii_[2], this.radii_[3])));
        return new Insets((this.top_ ? exterior : 0) + interior, (this.left_ ? exterior : 0) + Math.max(interior, radius), (this.bottom_ ? exterior : 0) + interior, (this.right_ ? exterior : 0) + Math.max(interior, radius));
    }
}

