/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.utilities;

import com.ge.med.ptk.laf.Utilities;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Component;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class PtkUtilities {
    private static Vector imagePath_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8 202102030211 (Sun Microsystems Inc.|1.6.0_45|50.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    private static String[] tokenize(String s2, String separators) {
        StringTokenizer tk = new StringTokenizer(s2, separators);
        String[] tokens = new String[tk.countTokens()];
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            tokens[i2] = tk.nextToken();
        }
        return tokens;
    }

    public static void setImagePath(String path) {
        imagePath_ = new Vector();
        if (path == null) {
            return;
        }
        StringTokenizer tk = new StringTokenizer(path, ":");
        while (tk.hasMoreTokens()) {
            PtkUtilities.appendImagePath(tk.nextToken());
        }
    }

    public static void appendImagePath(String s2) {
        if (!s2.endsWith("/")) {
            s2 = s2 + "/";
        }
        imagePath_.addElement(s2);
    }

    public static void prependImagePath(String s2) {
        if (!s2.endsWith("/")) {
            s2 = s2 + "/";
        }
        imagePath_.insertElementAt(s2, 0);
    }

    public static BufferedImage getScaledImage(Image image) {
        BufferedImage bi = PtkUtilities.getImage(image);
        if (Utilities.monitor(1.0) == 1.0) {
            return bi;
        }
        return new AffineTransformOp(AffineTransform.getScaleInstance((double)Utilities.monitor(bi.getWidth()) / (double)bi.getWidth(), (double)Utilities.monitor(bi.getHeight()) / (double)bi.getHeight()), 2).filter(bi, null);
    }

    public static BufferedImage getImage(Image image) {
        if (image == null) {
            return null;
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        int iw = image.getWidth(null);
        int ih = image.getHeight(null);
        if (iw <= 0 || ih <= 0) {
            return null;
        }
        BufferedImage bi = new BufferedImage(iw, ih, 2);
        bi.getGraphics().drawImage(image, 0, 0, null);
        return bi;
    }

    public static BufferedImage getScaledImage(String path) {
        return PtkUtilities.getScaledImage(PtkUtilities.getImage(path));
    }

    public static BufferedImage getImage(String path) {
        BufferedImage image = PtkUtilities.findImage(path);
        if (image != null) {
            return image;
        }
        for (int i2 = 0; i2 < imagePath_.size(); ++i2) {
            image = PtkUtilities.findImage((String)imagePath_.elementAt(i2) + path);
            if (image == null) continue;
            return image;
        }
        return null;
    }

    public static BufferedImage findImage(String path) {
        if (path == null) {
            return null;
        }
        URL resource = ClassLoader.getSystemResource(path);
        Image image = (resource == null ? new ImageIcon(path) : new ImageIcon(resource)).getImage();
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        int iw = image.getWidth(null);
        int ih = image.getHeight(null);
        if (iw <= 0 || ih <= 0) {
            return null;
        }
        BufferedImage bi = new BufferedImage(iw, ih, 2);
        bi.getGraphics().drawImage(image, 0, 0, null);
        return bi;
    }

    public static BufferedImage getImage(Icon icon) {
        if (icon == null) {
            return null;
        }
        int iw = icon.getIconWidth();
        int ih = icon.getIconHeight();
        if (iw <= 0 || ih <= 0) {
            return null;
        }
        BufferedImage bi = new BufferedImage(iw, ih, 2);
        icon.paintIcon(new Component(){}, bi.getGraphics(), 0, 0);
        return bi;
    }

    static {
        try {
            PtkUtilities.setImagePath(System.getProperty("ptk.imagePath", ""));
        }
        catch (Exception e2) {
            imagePath_ = new Vector();
        }
    }
}

