/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.jnu.JnMatrix3d;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.JnAffineTransform;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransformBase;
import java.io.Serializable;

public class CTransform
extends CTransformBase
implements Serializable {
    public static final CTransform Identity = new CTransform();

    public CTransform() {
        this.loadIdentity();
    }

    public final Object clone() {
        CTransform ct = new CTransform();
        System.arraycopy(this.m, 0, ct.m, 0, this.m.length);
        System.arraycopy(this.x, 0, ct.x, 0, this.x.length);
        System.arraycopy(this.y, 0, ct.y, 0, this.y.length);
        System.arraycopy(this._mat, 0, ct._mat, 0, this._mat.length);
        return ct;
    }

    public CTransform(CTransform t2) {
        this.load(t2.m);
    }

    @Override
    public final void loadIdentity() {
        int i2;
        for (i2 = 0; i2 < 16; ++i2) {
            this.m[i2] = 0.0;
        }
        for (i2 = 0; i2 < 4; ++i2) {
            this.m[4 * i2 + i2] = 1.0;
        }
    }

    public final void load(double[] vals) {
        int len = this.m.length <= vals.length ? this.m.length : vals.length;
        for (int i2 = 0; i2 < len; ++i2) {
            this.m[i2] = vals[i2];
        }
    }

    public final void set(double d00, double d01, double d02, double d03, double d10, double d11, double d12, double d13, double d20, double d21, double d22, double d23, double d30, double d31, double d32, double d33) {
        this.m[0] = d00;
        this.m[1] = d01;
        this.m[2] = d02;
        this.m[3] = d03;
        this.m[4] = d10;
        this.m[5] = d11;
        this.m[6] = d12;
        this.m[7] = d13;
        this.m[8] = d20;
        this.m[9] = d21;
        this.m[10] = d22;
        this.m[11] = d23;
        this.m[12] = d30;
        this.m[13] = d31;
        this.m[14] = d32;
        this.m[15] = d33;
    }

    public final void getVals(JnMatrix4d mat) {
        mat.m00 = this.m[0];
        mat.m01 = this.m[1];
        mat.m02 = this.m[2];
        mat.m03 = this.m[3];
        mat.m10 = this.m[4];
        mat.m11 = this.m[5];
        mat.m12 = this.m[6];
        mat.m13 = this.m[7];
        mat.m20 = this.m[8];
        mat.m21 = this.m[9];
        mat.m22 = this.m[10];
        mat.m23 = this.m[11];
        mat.m30 = this.m[12];
        mat.m31 = this.m[13];
        mat.m32 = this.m[14];
        mat.m33 = this.m[15];
    }

    public final void load(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23, double m30, double m31, double m32, double m33) {
        this.m[0] = m00;
        this.m[1] = m01;
        this.m[2] = m02;
        this.m[3] = m03;
        this.m[4] = m10;
        this.m[5] = m11;
        this.m[6] = m12;
        this.m[7] = m13;
        this.m[8] = m20;
        this.m[9] = m21;
        this.m[10] = m22;
        this.m[11] = m23;
        this.m[12] = m30;
        this.m[13] = m31;
        this.m[14] = m32;
        this.m[15] = m33;
    }

    public final void load(JnMatrix4d jm) {
        this.m[0] = jm.m00;
        this.m[1] = jm.m01;
        this.m[2] = jm.m02;
        this.m[3] = jm.m03;
        this.m[4] = jm.m10;
        this.m[5] = jm.m11;
        this.m[6] = jm.m12;
        this.m[7] = jm.m13;
        this.m[8] = jm.m20;
        this.m[9] = jm.m21;
        this.m[10] = jm.m22;
        this.m[11] = jm.m23;
        this.m[12] = jm.m30;
        this.m[13] = jm.m31;
        this.m[14] = jm.m32;
        this.m[15] = jm.m33;
    }

    public final void load(JnMatrix3d jm) {
        this.m[0] = jm.m00;
        this.m[1] = jm.m01;
        this.m[2] = jm.m02;
        this.m[3] = 0.0;
        this.m[4] = jm.m10;
        this.m[5] = jm.m11;
        this.m[6] = jm.m12;
        this.m[7] = 0.0;
        this.m[8] = jm.m20;
        this.m[9] = jm.m21;
        this.m[10] = jm.m22;
        this.m[11] = 0.0;
        this.m[12] = 0.0;
        this.m[13] = 0.0;
        this.m[14] = 0.0;
        this.m[15] = 1.0;
    }

    public final void load(CTransform ct) {
        System.arraycopy(ct.m, 0, this.m, 0, this.m.length);
    }

    public final void load(JnAffineTransform tx) {
        this.loadIdentity();
        tx.getMatrix(this._mat);
        this.m[0] = this._mat[0];
        this.m[4] = this._mat[1];
        this.m[1] = this._mat[2];
        this.m[5] = this._mat[3];
        this.m[3] = this._mat[4];
        this.m[7] = this._mat[5];
    }

    public final void getTransform2D(JnAffineTransform at) {
        at.setTransform(this.m[0], this.m[4], this.m[1], this.m[5], this.m[3], this.m[7]);
    }

    public final void getInvTransform2D(JnAffineTransform at) {
        double m00 = this.m[0];
        double m01 = this.m[1];
        double m10 = this.m[4];
        double m11 = this.m[5];
        double tx = -this.m[3];
        double ty = -this.m[7];
        double det = 1.0 / (m00 * m11 - m01 * m10);
        at.setTransform(m11 * det, -m10 * det, -m01 * det, m00 * det, tx, ty);
    }

    public final double[] getElements() {
        return this.m;
    }

    public final double getElement(int row, int col) {
        return this.m[row * 4 + col];
    }

    public final void setElement(int row, int col, double val) {
        this.m[row * 4 + col] = val;
    }

    static final double det2x2(double a2, double b2, double c2, double d2) {
        return a2 * d2 - b2 * c2;
    }

    static final double det3x3(double a1, double a2, double a3, double b1, double b2, double b3, double c1, double c2, double c3) {
        return a1 * CTransform.det2x2(b2, b3, c2, c3) - b1 * CTransform.det2x2(a2, a3, c2, c3) + c1 * CTransform.det2x2(a2, a3, b2, b3);
    }

    public final double determinant() {
        double a1 = this.getElement(0, 0);
        double b1 = this.getElement(0, 1);
        double c1 = this.getElement(0, 2);
        double d1 = this.getElement(0, 3);
        double a2 = this.getElement(1, 0);
        double b2 = this.getElement(1, 1);
        double c2 = this.getElement(1, 2);
        double d2 = this.getElement(1, 3);
        double a3 = this.getElement(2, 0);
        double b3 = this.getElement(2, 1);
        double c3 = this.getElement(2, 2);
        double d3 = this.getElement(2, 3);
        double a4 = this.getElement(3, 0);
        double b4 = this.getElement(3, 1);
        double c4 = this.getElement(3, 2);
        double d4 = this.getElement(3, 3);
        return a1 * CTransform.det3x3(b2, b3, b4, c2, c3, c4, d2, d3, d4) - b1 * CTransform.det3x3(a2, a3, a4, c2, c3, c4, d2, d3, d4) + c1 * CTransform.det3x3(a2, a3, a4, b2, b3, b4, d2, d3, d4) - d1 * CTransform.det3x3(a2, a3, a4, b2, b3, b4, c2, c3, c4);
    }

    public final CTransform adjoint() {
        CTransform out = new CTransform();
        this.adjoint(out);
        return out;
    }

    public final void adjoint(CTransform out) {
        double a1 = this.getElement(0, 0);
        double b1 = this.getElement(0, 1);
        double c1 = this.getElement(0, 2);
        double d1 = this.getElement(0, 3);
        double a2 = this.getElement(1, 0);
        double b2 = this.getElement(1, 1);
        double c2 = this.getElement(1, 2);
        double d2 = this.getElement(1, 3);
        double a3 = this.getElement(2, 0);
        double b3 = this.getElement(2, 1);
        double c3 = this.getElement(2, 2);
        double d3 = this.getElement(2, 3);
        double a4 = this.getElement(3, 0);
        double b4 = this.getElement(3, 1);
        double c4 = this.getElement(3, 2);
        double d4 = this.getElement(3, 3);
        out.setElement(0, 0, CTransform.det3x3(b2, b3, b4, c2, c3, c4, d2, d3, d4));
        out.setElement(1, 0, -CTransform.det3x3(a2, a3, a4, c2, c3, c4, d2, d3, d4));
        out.setElement(2, 0, CTransform.det3x3(a2, a3, a4, b2, b3, b4, d2, d3, d4));
        out.setElement(3, 0, -CTransform.det3x3(a2, a3, a4, b2, b3, b4, c2, c3, c4));
        out.setElement(0, 1, -CTransform.det3x3(b1, b3, b4, c1, c3, c4, d1, d3, d4));
        out.setElement(1, 1, CTransform.det3x3(a1, a3, a4, c1, c3, c4, d1, d3, d4));
        out.setElement(2, 1, -CTransform.det3x3(a1, a3, a4, b1, b3, b4, d1, d3, d4));
        out.setElement(3, 1, CTransform.det3x3(a1, a3, a4, b1, b3, b4, c1, c3, c4));
        out.setElement(0, 2, CTransform.det3x3(b1, b2, b4, c1, c2, c4, d1, d2, d4));
        out.setElement(1, 2, -CTransform.det3x3(a1, a2, a4, c1, c2, c4, d1, d2, d4));
        out.setElement(2, 2, CTransform.det3x3(a1, a2, a4, b1, b2, b4, d1, d2, d4));
        out.setElement(3, 2, -CTransform.det3x3(a1, a2, a4, b1, b2, b4, c1, c2, c4));
        out.setElement(0, 3, -CTransform.det3x3(b1, b2, b3, c1, c2, c3, d1, d2, d3));
        out.setElement(1, 3, CTransform.det3x3(a1, a2, a3, c1, c2, c3, d1, d2, d3));
        out.setElement(2, 3, -CTransform.det3x3(a1, a2, a3, b1, b2, b3, d1, d2, d3));
        out.setElement(3, 3, CTransform.det3x3(a1, a2, a3, b1, b2, b3, c1, c2, c3));
    }

    public final CTransform inverse() {
        CTransform out = new CTransform();
        this.inverse(out);
        return out;
    }

    public final void inverse(CTransform mi) {
        double det = this.determinant();
        if (-1.0E-100 < det && det < 1.0E-100) {
            throw new ArithmeticException("matrix determinant " + det);
        }
        this.adjoint(mi);
        double idet = 1.0 / det;
        int i2 = 0;
        while (i2 < 16) {
            int n2 = i2++;
            mi.m[n2] = mi.m[n2] * idet;
        }
    }

    public final synchronized void transform(JnVector3d res) {
        this.x[0] = res.x;
        this.x[1] = res.y;
        this.x[2] = res.z;
        this.x[3] = 1.0;
        this.transform(this.x, this.y);
        res.x = this.y[0];
        res.y = this.y[1];
        res.z = this.y[2];
    }

    public final synchronized void transform(double[] res) {
        this.x[0] = res[0];
        this.x[1] = res[1];
        this.x[2] = res[2];
        this.x[3] = res.length > 3 ? res[3] : 1.0;
        this.transform(this.x, this.y);
        res[0] = this.y[0];
        res[1] = this.y[1];
        res[2] = this.y[2];
        if (res.length > 3) {
            res[3] = this.y[3];
        }
    }

    public final synchronized void transform(CPoint p2) {
        this.x[0] = p2.x;
        this.x[1] = p2.y;
        this.x[2] = p2.z;
        this.x[3] = 1.0;
        this.transform(this.x, this.y);
        p2.x = this.y[0];
        p2.y = this.y[1];
        p2.z = this.y[2];
    }

    public final synchronized void transform(CPoint p2, CPoint out) {
        this.x[0] = p2.x;
        this.x[1] = p2.y;
        this.x[2] = p2.z;
        this.x[3] = 1.0;
        this.transform(this.x, this.y);
        out.x = this.y[0];
        out.y = this.y[1];
        out.z = this.y[2];
    }

    public synchronized void itransform(CPoint p2) {
        this.x[0] = p2.x;
        this.x[1] = p2.y;
        this.x[2] = p2.z;
        this.x[3] = 1.0;
        this.itransform(this.x, this.y);
        p2.x = this.y[0];
        p2.y = this.y[1];
        p2.z = this.y[2];
    }

    public synchronized void itransform(CPoint p2, CPoint out) {
        this.x[0] = p2.x;
        this.x[1] = p2.y;
        this.x[2] = p2.z;
        this.x[3] = 1.0;
        this.itransform(this.x, this.y);
        out.x = this.y[0];
        out.y = this.y[1];
        out.z = this.y[2];
    }

    public final void transform(double[] a2, double[] b2) {
        for (int i2 = 0; i2 < 4; ++i2) {
            b2[i2] = 0.0;
            int offset = 4 * i2;
            for (int j2 = 0; j2 < 4; ++j2) {
                int n2 = i2;
                b2[n2] = b2[n2] + this.m[offset + j2] * a2[j2];
            }
        }
    }

    public final void itransform(double[] a2, double[] b2) {
        CTransform inv = this.inverse();
        for (int i2 = 0; i2 < 4; ++i2) {
            b2[i2] = 0.0;
            int offset = 4 * i2;
            for (int j2 = 0; j2 < 4; ++j2) {
                int n2 = i2;
                b2[n2] = b2[n2] + inv.m[offset + j2] * a2[j2];
            }
        }
    }

    public String toString() {
        String s2 = this.getClass().getName() + "{";
        for (int j2 = 0; j2 < 4; ++j2) {
            s2 = s2 + "\n";
            for (int i2 = 0; i2 < 4; ++i2) {
                s2 = s2 + "  " + this.m[i2 + 4 * j2];
            }
        }
        s2 = s2 + "\n}";
        return s2;
    }

    public final void leftMultiply(CTransform t2, CTransform result) {
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j2 = 0; j2 < 4; ++j2) {
                result.m[j2 * 4 + i2] = 0.0;
                int joffset = 4 * j2;
                for (int k2 = 0; k2 < 4; ++k2) {
                    int n2 = joffset + i2;
                    result.m[n2] = result.m[n2] + this.m[k2 * 4 + i2] * t2.m[joffset + k2];
                }
            }
        }
    }

    public final CTransform multiplyBy(CTransform t2) {
        CTransform result = new CTransform();
        this.leftMultiply(t2, result);
        return result;
    }

    public final void translate(CPoint delta) {
        this.m[3] = this.m[3] + delta.x;
        this.m[7] = this.m[7] + delta.y;
        this.m[11] = this.m[11] + delta.z;
    }

    public final void scale(double sx, double sy, double sz) {
        this.m[0] = this.m[0] * sx;
        this.m[5] = this.m[5] * sy;
        this.m[10] = this.m[10] * sz;
    }

    final boolean ze(double x2) {
        return -1.0E-10 < x2 && x2 < 1.0E-10;
    }

    final boolean eq(double x2, double y2) {
        return this.ze(x2 - y2);
    }

    public final boolean isTransform2D() {
        return this.ze(this.m[2]) && this.ze(this.m[6]) && this.ze(this.m[8]) && this.ze(this.m[9]) && this.eq(this.m[10], 1.0) && this.ze(this.m[11]) && this.eq(this.m[15], 1.0);
    }

    public static void main(String[] args) {
        CTransform t2 = new CTransform();
        System.out.println("unit = " + t2);
        JnAffineTransform tx = new JnAffineTransform();
        tx.scale(2.0, 2.0);
        t2.load(tx);
        System.out.println("scaled 2 = " + t2);
        tx.rotate(0.1);
        t2.load(tx);
        System.out.println("scaled 2 and rotated = " + t2);
    }
}

