/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.Draw2DUtilsBase;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Draw2DUtils
extends Draw2DUtilsBase {
    private Draw2DUtils() {
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("LineFast");
        String[] params = null;
        if (args.length > 0) {
            params = new String[]{"file", args[0]};
        }
        ImgPanel jp = new ImgPanel(500, 500);
        frame.setBounds(100, 100, 512, 512);
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(jp);
        frame.setVisible(true);
    }

    private static class ImgPanel
    extends JPanel
    implements Draw2DUtilsBase.Raster1D,
    Draw2DUtilsBase.Raster2D {
        private BufferedImage bi = null;
        private byte[] pixels = null;

        public ImgPanel(int w2, int h2) {
            this.bi = new BufferedImage(w2, h2, 10);
            this.pixels = ((DataBufferByte)this.bi.getRaster().getDataBuffer()).getData();
            this.drawLines(w2, h2, this);
        }

        public void drawLines(int w2, int h2, Draw2DUtilsBase.Raster2D r2) {
            Draw2DUtilsBase.lineBresenham(0, 0, w2 - 1, h2 - 1, r2);
            Draw2DUtilsBase.lineBresenham(w2 - 1, 0, 0, h2 - 1, r2);
            Draw2DUtilsBase.lineBresenham(w2 / 2, 0, w2 / 2, h2 - 1, r2);
            Draw2DUtilsBase.lineBresenham(0, h2 / 2, w2 - 1, h2 / 2, r2);
        }

        @Override
        public int getWidth() {
            return this.bi.getWidth();
        }

        @Override
        public int getHeight() {
            return this.bi.getHeight();
        }

        @Override
        public void clear() {
            Arrays.fill(this.pixels, (byte)0);
        }

        @Override
        public void setPixel(int idx) {
            this.pixels[idx] = 125;
        }

        @Override
        public void setPixel(int x2, int y2) {
            this.pixels[y2 * this.bi.getWidth() + x2] = 125;
        }

        @Override
        public void paintComponent(Graphics g2) {
            Graphics2D g22 = (Graphics2D)g2;
            g22.drawRenderedImage(this.bi, null);
        }
    }

    public static class ImageBuffer
    implements Draw2DUtilsBase.Raster2D {
        private BufferedImage bi = null;
        private int w = 0;
        private int h = 0;
        private byte[] pixels = null;

        public ImageBuffer(int w2, int h2) {
            this.bi = new BufferedImage(w2, h2, 10);
            this.pixels = ((DataBufferByte)this.bi.getRaster().getDataBuffer()).getData();
            this.w = w2;
            this.h = h2;
        }

        public final BufferedImage getImage() {
            return this.bi;
        }

        @Override
        public int getWidth() {
            return this.bi.getWidth();
        }

        @Override
        public int getHeight() {
            return this.bi.getHeight();
        }

        @Override
        public void clear() {
            Arrays.fill(this.pixels, (byte)0);
        }

        @Override
        public void setPixel(int x2, int y2) {
            if (x2 < 0 || x2 >= this.w || y2 < 0 || y2 >= this.h) {
                return;
            }
            this.pixels[y2 * this.w + x2] = 125;
        }
    }
}

