/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.XpStackLayout;
import com.ge.med.terra.jami.XpVisualComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

public class PlaneNavigatorVc
extends XpVisualComponent {
    public static final String ROI_PROPERTY = "ROI_PROPERTY";
    private boolean paintStuff = false;
    private double outerWidth = 0.4;
    private double outerHeight = 0.2;
    private Rectangle2D inner = new Rectangle2D.Double();
    private Rectangle2D inner_draw = new Rectangle2D.Double();
    private Rectangle2D drawOuter = new Rectangle2D.Double();
    private Rectangle2D drawInner = new Rectangle2D.Double();
    private MouseNavigator mn = new MouseNavigator();
    private BufferedImage icon = null;
    private boolean continuousUpdate = false;
    private boolean init = true;

    public PlaneNavigatorVc() {
        this.setForeground(Color.orange);
        this.addMouseListener(this.mn);
        this.addMouseMotionListener(this.mn);
    }

    @Override
    public boolean contains(int x2, int y2) {
        return true;
    }

    @Override
    public void paintComponent(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        int w2 = this.getWidth();
        int h2 = this.getHeight();
        double ratio = (double)w2 / (double)h2;
        if (this.init) {
            double imgratio = this.outerWidth / this.outerHeight;
            this.inner.setFrame(0.2, 0.2, 0.2 * ratio / imgratio, 0.2);
            this.init = false;
        }
        if (this.paintStuff) {
            if (this.icon != null) {
                AffineTransform xform = AffineTransform.getTranslateInstance(this.drawOuter.getX(), this.drawOuter.getY());
                g22.drawRenderedImage(this.icon, xform);
            }
            double out_w = this.getNavigationDomainWidth();
            double out_h = this.getNavigationDomainHeight();
            double in_w = this.inner_draw.getWidth() * out_w;
            double in_h = this.inner_draw.getHeight() * out_h;
            double in_x = this.inner_draw.getX() * out_w + this.drawOuter.getX();
            double in_y = this.inner_draw.getY() * out_h + this.drawOuter.getY();
            g22.draw(this.drawOuter);
            this.drawInner.setFrame(in_x, in_y, in_w, in_h);
            g22.draw(this.drawInner);
        }
    }

    public boolean isContinuousUpdate() {
        return this.continuousUpdate;
    }

    public void setContinuousUpdate(boolean update) {
        this.continuousUpdate = update;
    }

    public void setNavigationImage(BufferedImage bimg) {
        this.icon = bimg;
    }

    public double getNavigationDomainWidth() {
        return this.outerWidth * (double)this.getWidth();
    }

    public double getNavigationDomainHeight() {
        return this.outerHeight * (double)this.getHeight();
    }

    public static void main(String[] args) {
        int DIM = 512;
        JFrame jf = new JFrame("PlaneNavigatorVc");
        final BufferedImage bimg = new BufferedImage(512, 512, 1);
        Graphics2D g2 = (Graphics2D)bimg.getGraphics();
        Line2D.Double l2 = new Line2D.Double();
        g2.setColor(new Color(-1863327520, true));
        for (int y2 = 0; y2 < 512; y2 += 16) {
            ((Line2D)l2).setLine(0.0, y2, 511.0, y2);
            g2.draw(l2);
            for (int x2 = 0; x2 < 512; x2 += 16) {
                ((Line2D)l2).setLine(x2, 0.0, x2, 511.0);
                g2.draw(l2);
            }
        }
        JPanel p2 = new JPanel(){

            @Override
            public void paintComponent(Graphics g2) {
                Graphics2D g22 = (Graphics2D)g2;
                g22.drawRenderedImage(bimg, null);
            }
        };
        jf.setContentPane(p2);
        p2.setPreferredSize(new Dimension(512, 512));
        p2.setLayout(new XpStackLayout());
        PlaneNavigatorVc pnv = new PlaneNavigatorVc();
        p2.add(pnv);
        jf.pack();
        jf.setVisible(true);
        jf.setDefaultCloseOperation(3);
    }

    private class MouseNavigator
    extends MouseInputAdapter {
        private int start_x = 0;
        private int start_y = 0;
        private Rectangle2D rect_start = new Rectangle2D.Double();

        private MouseNavigator() {
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
            super.mouseDragged(e2);
            int mod = e2.getModifiers();
            boolean b1 = 0 != (mod & 0x10);
            boolean b2 = 0 != (mod & 8);
            boolean b3 = 0 != (mod & 4);
            boolean shift = 0 != (mod & 1);
            int w2 = PlaneNavigatorVc.this.getWidth();
            int h2 = PlaneNavigatorVc.this.getHeight();
            double ratio = (double)w2 / (double)h2;
            double deltaX = e2.getX() - this.start_x;
            double deltaY = e2.getY() - this.start_y;
            double dx = deltaX / PlaneNavigatorVc.this.getNavigationDomainWidth();
            double dy = deltaY / PlaneNavigatorVc.this.getNavigationDomainHeight();
            if (b1) {
                PlaneNavigatorVc.this.inner.setFrame(this.rect_start.getX() + dx, this.rect_start.getY() + dy, this.rect_start.getWidth(), this.rect_start.getHeight());
                PlaneNavigatorVc.this.inner_draw.setFrame(PlaneNavigatorVc.this.inner);
                double filter_x = PlaneNavigatorVc.this.inner_draw.getX();
                double filter_y = PlaneNavigatorVc.this.inner_draw.getY();
                double filter_w = PlaneNavigatorVc.this.inner_draw.getWidth();
                double filter_h = PlaneNavigatorVc.this.inner_draw.getHeight();
                if (filter_x < 0.0) {
                    filter_x = 0.0;
                }
                if (filter_y < 0.0) {
                    filter_y = 0.0;
                }
                if (filter_x + filter_w > 1.0) {
                    filter_x = 1.0 - filter_w;
                }
                if (filter_y + filter_h > 1.0) {
                    filter_y = 1.0 - filter_h;
                }
                PlaneNavigatorVc.this.inner_draw.setFrame(filter_x, filter_y, filter_w, filter_h);
            } else if (b3) {
                PlaneNavigatorVc.this.inner.setFrame(this.rect_start.getX() - dx, this.rect_start.getY() - dx, this.rect_start.getWidth() + 2.0 * dx, this.rect_start.getHeight() + 2.0 * dx);
                PlaneNavigatorVc.this.inner_draw.setFrame(PlaneNavigatorVc.this.inner);
                double filter_x1 = PlaneNavigatorVc.this.inner_draw.getX();
                double filter_y1 = PlaneNavigatorVc.this.inner_draw.getY();
                double filter_x2 = filter_x1 + PlaneNavigatorVc.this.inner_draw.getWidth();
                double filter_y2 = filter_y1 + PlaneNavigatorVc.this.inner_draw.getHeight();
                if (filter_x1 < 0.0) {
                    filter_x1 = 0.0;
                }
                if (filter_y1 < 0.0) {
                    filter_y1 = 0.0;
                }
                if (filter_x2 > 1.0) {
                    filter_x2 = 1.0;
                }
                if (filter_y2 > 1.0) {
                    filter_y2 = 1.0;
                }
                PlaneNavigatorVc.this.inner_draw.setFrameFromDiagonal(filter_x1, filter_y1, filter_x2, filter_y2);
            }
            if (PlaneNavigatorVc.this.isContinuousUpdate()) {
                PlaneNavigatorVc.this.firePropertyChange(PlaneNavigatorVc.ROI_PROPERTY, this.rect_start, PlaneNavigatorVc.this.inner_draw);
            }
            PlaneNavigatorVc.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            super.mousePressed(e2);
            this.start_x = e2.getX();
            this.start_y = e2.getY();
            this.rect_start.setFrame(PlaneNavigatorVc.this.inner);
            double out_w = PlaneNavigatorVc.this.getNavigationDomainWidth();
            double out_h = PlaneNavigatorVc.this.getNavigationDomainHeight();
            double in_w = PlaneNavigatorVc.this.inner.getWidth() * out_w;
            double in_h = PlaneNavigatorVc.this.inner.getHeight() * out_h;
            double rel_x = PlaneNavigatorVc.this.inner.getX() * out_w;
            double rel_y = PlaneNavigatorVc.this.inner.getY() * out_h;
            double in_x = (double)this.start_x - in_w * 0.5;
            double in_y = (double)this.start_y - in_h * 0.5;
            double out_x = in_x - rel_x;
            double out_y = in_y - rel_y;
            PlaneNavigatorVc.this.drawOuter.setFrame(out_x, out_y, out_w, out_h);
            PlaneNavigatorVc.this.paintStuff = true;
            PlaneNavigatorVc.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            super.mouseReleased(e2);
            PlaneNavigatorVc.this.inner.setFrame(PlaneNavigatorVc.this.inner_draw);
            PlaneNavigatorVc.this.paintStuff = false;
            PlaneNavigatorVc.this.repaint();
            PlaneNavigatorVc.this.firePropertyChange(PlaneNavigatorVc.ROI_PROPERTY, this.rect_start, PlaneNavigatorVc.this.inner_draw);
        }
    }
}

