/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.CineCapable;

public class XpCineMotor
implements Runnable {
    private static int motorCnt = 0;
    protected int frame = 0;
    private long delayFrame = 0L;
    protected boolean projection = true;
    private boolean pause = false;
    protected long frameCount = 0L;
    private int fps = 30;
    private CineCapable cc = null;
    private Thread projectorThread = null;

    public XpCineMotor(CineCapable ccap, int rate) {
        this.cc = ccap;
        this.setCineRate(rate);
    }

    public boolean isPause() {
        return this.pause;
    }

    public CineCapable getCineCapable() {
        return this.cc;
    }

    public void pause() {
        this.pause = true;
    }

    public void resume() {
        this.pause = false;
    }

    public void start() {
        this.projectorThread = new Thread(this);
        this.projectorThread.setName("JAMI CINE [" + motorCnt + "]");
        ++motorCnt;
        this.projectorThread.start();
    }

    @Override
    public void run() {
        int cineSkip = this.cc.getCineSkip();
        this.projection = true;
        this.frame = this.cc.getOffset();
        while (this.projection) {
            if (this.pause) {
                while (this.pause && this.projection) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {}
                }
            }
            long t1 = System.currentTimeMillis();
            int startFrame = this.cc.getStartOffset();
            int endFrame = this.cc.getEndOffset();
            if (this.cc.getCineMode() == 0) {
                if (this.frame > endFrame) {
                    this.frame = startFrame;
                }
                if (this.frame < startFrame) {
                    this.frame = endFrame;
                }
                cineSkip = Math.abs(cineSkip);
            } else if (this.frame > endFrame) {
                this.frame = endFrame - 1;
                cineSkip = -Math.abs(cineSkip);
                this.cc.setCineSkip(cineSkip);
            } else if (this.frame < startFrame) {
                this.frame = startFrame + 1;
                cineSkip = Math.abs(cineSkip);
                this.cc.setCineSkip(cineSkip);
            }
            this.cc.setOffset(this.frame);
            this.cc.repaint();
            this.frame += cineSkip;
            ++this.frameCount;
            long t2 = System.currentTimeMillis();
            long duration = t2 - t1;
            long delayTime = this.delayFrame - duration;
            if (delayTime <= 0L) continue;
            try {
                Thread.sleep(delayTime);
            }
            catch (InterruptedException e2) {}
        }
    }

    public void setCineFps(int fps) {
        this.delayFrame = (int)(1000.0 / (double)fps);
        this.fps = fps;
    }

    public void setCineRate(int rate) {
        this.delayFrame = rate;
        this.fps = (int)(1000.0 / (double)this.delayFrame);
    }

    public double getCineRate() {
        return this.delayFrame;
    }

    public double getCineFps() {
        return this.fps;
    }

    public long getFramesPaged() {
        return this.frameCount;
    }

    public int getFrame() {
        return this.frame;
    }

    public boolean isProjecting() {
        return this.projection;
    }

    public void stopProjection() {
        this.projection = false;
        this.projectorThread = null;
    }
}

