/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.XpSliceCollection;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportDirector;
import com.ge.med.terra.jami.XpVisualComponent;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class XpCrossReferenceDirector
implements XpViewportDirector,
PropertyChangeListener,
Serializable {
    private XpViewport vp1 = null;
    private XpViewport vp2 = null;
    private Color selectedlineColor = Color.red;
    private Color unSelectedlineColor = Color.cyan;
    private String lineStyle = "DOTTED";
    private Integer newIndex = new Integer(0);
    private int index = 0;
    private List<XpSliceCollection> rlList = new ArrayList<XpSliceCollection>();
    private XpVisualComponent ivc_target;
    static int whichXpSceneVc = 0;
    static final String REF_KEY = "Cross Reference Slices";

    public XpCrossReferenceDirector() {
    }

    public XpCrossReferenceDirector(XpViewport vp1, XpViewport vp2) {
        this();
        this.connectViewport(vp1);
        this.connectViewport(vp2);
        this.vp1 = vp1;
        this.vp2 = vp2;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e2) {
        Object value = e2.getNewValue();
        if (value instanceof Integer) {
            this.newIndex = (Integer)value;
            this.index = this.newIndex;
            if (this.vp1 instanceof FramePositioningCapable) {
                FramePositioningCapable fpc = (FramePositioningCapable)((Object)this.vp1);
                fpc.setFrameIndex(this.index);
            }
            this.vp1.repaint();
        }
    }

    public final void paintallSlices() {
        for (int i2 = 0; i2 < this.rlList.size(); ++i2) {
            XpSliceCollection refLines = this.rlList.get(i2);
            refLines.setSelectedlineColor(this.selectedlineColor);
            refLines.setlineStyle(this.lineStyle);
            refLines.setUnSelectedlineColor(this.unSelectedlineColor);
            refLines.repaint();
        }
    }

    @Override
    public void connectViewport(XpViewport viewport) {
        if (this.vp1 == null) {
            this.vp1 = viewport;
        } else if (this.vp2 == null) {
            this.vp2 = viewport;
        }
    }

    @Override
    public void disconnectViewport(XpViewport vp) {
        if (vp == this.vp1) {
            this.vp1 = null;
        }
        if (vp == this.vp2) {
            this.vp2 = null;
        }
    }

    @Override
    public void disconnectAllViewports() {
        this.removeAllSlices();
        this.disconnectViewport(this.vp1);
        this.disconnectViewport(this.vp2);
    }

    public void removeAllSlices() {
        for (int i2 = 0; i2 < this.rlList.size(); ++i2) {
            XpSliceCollection refLines = this.rlList.get(i2);
            refLines.removeAllSlices();
        }
    }

    public boolean postCrossReference() {
        Iterator isel = this.vp2.getVcIterator(XpImage2DVc.class);
        int posted = 0;
        while (isel.hasNext()) {
            this.ivc_target = (XpImage2DVc)isel.next();
            if (this.ivc_target == null) continue;
            XpSliceCollection refLines = new XpSliceCollection();
            refLines.addPropertyChangeListener(this);
            refLines.setName(REF_KEY);
            this.rlList.add(refLines);
            this.vp1.addPropertyChangeListener(refLines);
            XpMedicalImage[] images = this.vp1.getImages();
            for (int i2 = 0; i2 < images.length; ++i2) {
                refLines.addSlice(new XpSlice(images[i2]));
            }
            if (refLines.getNumberOfSlices() <= 0) continue;
            this.ivc_target.add(refLines);
            this.ivc_target.invalidate();
            this.ivc_target.validate();
            ++posted;
        }
        return posted > 0;
    }

    public void setlineStyle(String style) {
        this.lineStyle = style;
    }

    public void setSelectedlineColor(Color c2) {
        this.selectedlineColor = c2;
    }

    public void setUnSelectedlineColor(Color c2) {
        this.unSelectedlineColor = c2;
    }
}

