/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.XpLog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class XpDynamicGridLayout
implements LayoutManager,
Serializable {
    private int rows = 1;
    private int cols = 1;
    private static final int PREFERRED_SIZE = 0;
    private static final int MINIMUM_SIZE = 1;
    private boolean squareComponents = false;

    public XpDynamicGridLayout(int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        if (this.rows < 1) {
            this.rows = 1;
        }
        if (this.cols < 1) {
            this.cols = 1;
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        XpLog.logger().info("Add Layout Component   : " + name + "  Component=" + comp.getClass());
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        XpLog.logger().info("Remove Layout Component: " + comp.getClass());
    }

    private Dimension getEffectiveDimension(Container parent) {
        Insets is = parent.getInsets();
        Dimension d2 = parent.getSize();
        Dimension pd = new Dimension((int)d2.getWidth() - is.left - is.right, (int)d2.getHeight() - is.top - is.bottom);
        return pd;
    }

    private Dimension getLayoutSize(Container parent, int sizeType) {
        Insets is = parent.getInsets();
        Component[] comps = parent.getComponents();
        int nComps = comps.length;
        int w2 = 0;
        int h2 = 0;
        int cIdx = 0;
        for (int i2 = 0; i2 < this.rows; ++i2) {
            int maxH = 0;
            int rowW = 0;
            for (int j2 = 0; j2 < this.cols; ++j2) {
                if (cIdx < nComps) {
                    Dimension dim = null;
                    switch (sizeType) {
                        case 0: {
                            dim = comps[cIdx].getPreferredSize();
                            break;
                        }
                        case 1: {
                            dim = comps[cIdx].getMinimumSize();
                            break;
                        }
                        default: {
                            dim = comps[cIdx].getSize();
                        }
                    }
                    int comp_h = (int)dim.getHeight();
                    int comp_w = (int)dim.getWidth();
                    if (comp_h > maxH) {
                        maxH = comp_h;
                    }
                    rowW += comp_w;
                }
                ++cIdx;
            }
            h2 += maxH;
            if (rowW <= w2) continue;
            w2 = rowW;
        }
        Dimension d2 = new Dimension(w2 += is.left + is.right, h2 += is.bottom + is.top);
        return d2;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.getLayoutSize(parent, 0);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.getLayoutSize(parent, 1);
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets is = parent.getInsets();
        Dimension d2 = this.getEffectiveDimension(parent);
        Component[] comps = parent.getComponents();
        int nComps = comps.length;
        int w2 = (int)((d2.getWidth() + 1.0) / (double)this.cols);
        int h2 = (int)((d2.getHeight() + 1.0) / (double)this.rows);
        int startX = 0;
        int startY = 0;
        if (this.squareComponents) {
            if (w2 > h2) {
                w2 = h2;
                startX = (int)((d2.getWidth() - (double)(this.cols * w2)) * 0.5);
            } else {
                h2 = w2;
                startY = (int)((d2.getHeight() - (double)(this.rows * h2)) * 0.5);
            }
        }
        int x2 = is.left + startX;
        int y2 = is.top + startY;
        int cIdx = 0;
        for (int i2 = 0; i2 < this.rows; ++i2) {
            x2 = is.left + startX;
            for (int j2 = 0; j2 < this.cols; ++j2) {
                if (cIdx < nComps) {
                    comps[cIdx].setLocation(x2, y2);
                    comps[cIdx].setSize(w2, h2);
                }
                ++cIdx;
                x2 += w2;
            }
            y2 += h2;
        }
    }

    public int getColumns() {
        return this.cols;
    }

    public int getRows() {
        return this.rows;
    }

    public void setColumns(int cols) {
        if (cols < 1) {
            return;
        }
        this.cols = cols;
    }

    public void setRows(int rows) {
        if (rows < 1) {
            return;
        }
        this.rows = rows;
    }

    public final boolean isSquareComponents() {
        return this.squareComponents;
    }

    public final void setSquareComponents(boolean squareComponents) {
        this.squareComponents = squareComponents;
    }
}

