/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.CTransformCapable;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class XpHandle
implements Serializable {
    private transient Shape shape = HANDLE_BOX;
    private CPoint location = new CPoint(0);
    private XpAnchorable anchorable = null;
    private int anchorPtIndex = -1;
    private boolean visable = true;
    public static Shape DEFAULT_SHAPE;
    public static Shape HANDLE_CROSSHAIR;
    public static transient Shape HANDLE_BOX;
    private transient Shape containmentShape = DEFAULT_SHAPE;
    private int mModifier = 28;
    private boolean filled = true;
    private transient XpGeomUtils gu = new XpGeomUtils();
    private transient Point2D dispPoint = new Point2D.Double();
    private static Color handleColor;
    private static final Cursor SELECTION_CURSOR;
    private CPoint tmpPoint = new CPoint();
    private CPoint dispPt = new CPoint(1);
    private CPoint _dragV = new CPoint();
    private transient Point pMouse = null;
    private Cursor cursor = SELECTION_CURSOR;

    public double getX() {
        return this.location.x;
    }

    public double getY() {
        return this.location.y;
    }

    public void setLocation(double x2, double y2) {
        this.location.setLocation(x2, y2, 0.0);
    }

    public void setLocation(Point2D p2) {
        this.setLocation(p2.getX(), p2.getY());
    }

    public void setLocation(Point p2) {
        this.setLocation(p2.x, p2.y);
    }

    public void setLocation(double x2, double y2, double z2) {
        this.location.setLocation(x2, y2, z2);
    }

    public void setLocation(CPoint p2) {
        if (p2.csystem == this.location.csystem) {
            this.setLocation(p2.x, p2.y, p2.z);
        }
    }

    public Color getForeground() {
        return handleColor;
    }

    public void setShape(Shape s2, Shape containmentShape) {
        this.shape = s2;
        this.containmentShape = containmentShape;
    }

    public Shape getDrawShape() {
        return this.shape;
    }

    public Shape getContainsShape() {
        return this.containmentShape;
    }

    public XpHandle(XpAnchorable anchorable, int ptIndex) {
        this.anchorable = anchorable;
        this.anchorPtIndex = ptIndex;
    }

    public XpHandle(XpAnchorable anchorable, int ptIndex, int mModifier) {
        this(anchorable, ptIndex);
        this.mModifier = mModifier;
    }

    public XpHandle(XpAnchorable anchorable, int ptIndex, byte bCoordSys) {
        this.location = new CPoint(bCoordSys);
        this.anchorable = anchorable;
        this.anchorPtIndex = ptIndex;
    }

    public XpHandle(XpAnchorable anchorable, int ptIndex, int mModifier, byte bCoordSys) {
        this(anchorable, ptIndex, bCoordSys);
        this.mModifier = mModifier;
    }

    public void paintHandle(XpVisualComponent vc, Graphics2D g2) {
        if (!this.visable) {
            return;
        }
        vc.transform(this.location, this.dispPt, (byte)1);
        g2.setColor(handleColor);
        g2.translate(this.dispPt.x, this.dispPt.y);
        if (this.filled) {
            g2.fill(this.shape);
        } else {
            g2.draw(this.shape);
        }
        g2.translate(-this.dispPt.x, -this.dispPt.y);
    }

    public boolean contains(XpVisualComponent vc, int x2, int y2) {
        if (!this.visable) {
            return false;
        }
        this.dispPoint.setLocation((double)x2 - this.dispPt.x, (double)y2 - this.dispPt.y);
        boolean inside = this.containmentShape.contains(this.dispPoint);
        return inside;
    }

    public final void getDisplayLocation(XpVisualComponent vc, Point2D p2) {
        vc.transform(this.location, this.tmpPoint, (byte)1);
        p2.setLocation(this.tmpPoint.x, this.tmpPoint.y);
    }

    public final Point2D getDisplayLocation(XpVisualComponent vc) {
        Point2D.Double p2 = new Point2D.Double();
        this.getDisplayLocation(vc, p2);
        return p2;
    }

    public final Point2D getDisplayLocation() {
        return new Point2D.Double(this.dispPt.x, this.dispPt.y);
    }

    public void handlePressed(MouseEvent e2) {
        boolean processDrag = this.buttonTrigger(e2);
        if (processDrag) {
            this.anchorable.anchorPressed(e2, this);
        }
        this.pMouse = e2.getPoint();
    }

    public void handleClicked(MouseEvent e2) {
    }

    public void handleExited(MouseEvent e2) {
        e2.getComponent().setCursor(Cursor.getDefaultCursor());
    }

    public void handleEntered(MouseEvent e2) {
        e2.getComponent().setCursor(this.cursor);
    }

    public void handleReleased(MouseEvent e2) {
        boolean processDrag = this.buttonTrigger(e2);
        if (processDrag) {
            this.anchorable.anchorReleased(e2, this);
        }
        this.pMouse = null;
    }

    public boolean buttonTrigger(MouseEvent e2) {
        boolean processEvent = false;
        int modifiers = e2.getModifiers();
        int mbutton1 = this.mModifier & 0x10;
        int mbutton2 = this.mModifier & 8;
        int mbutton3 = this.mModifier & 4;
        int button1 = modifiers & 0x10;
        int button2 = modifiers & 8;
        int button3 = modifiers & 4;
        if (mbutton1 != 0 && button1 != 0) {
            processEvent = true;
        }
        if (mbutton2 != 0 && button2 != 0) {
            processEvent = true;
        }
        if (mbutton3 != 0 && button3 != 0) {
            processEvent = true;
        }
        return processEvent;
    }

    public void handleDragged(MouseEvent e2) {
        boolean processDrag;
        if (this.pMouse != null && (processDrag = this.buttonTrigger(e2))) {
            this.gu.calcDragVector(e2.getPoint(), this.pMouse, this.location.csystem, (CTransformCapable)((Object)e2.getComponent()), this._dragV);
            this.anchorable.anchorDragged(e2, this._dragV, this);
        }
        this.pMouse = e2.getPoint();
    }

    public void handleMove(MouseEvent e2) {
    }

    public void setFilled(boolean filled) {
        this.filled = filled;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public static Color getHandleColor() {
        return handleColor;
    }

    public static void setHandleColor(Color handleColor) {
        XpHandle.handleColor = handleColor;
    }

    public int getAnchorPointIndex() {
        return this.anchorPtIndex;
    }

    public void setVisible(boolean visable) {
        this.visable = visable;
    }

    public boolean isVisible() {
        return this.visable;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        try {
            s2.defaultWriteObject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException {
        try {
            s2.defaultReadObject();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.gu = new XpGeomUtils();
        this.dispPoint = new Point2D.Double();
        this.shape = HANDLE_BOX;
        HANDLE_BOX = DEFAULT_SHAPE;
        this.containmentShape = DEFAULT_SHAPE;
    }

    static {
        int[] idims;
        int crosshair = 4;
        GeneralPath gp = new GeneralPath();
        gp.moveTo(0.0f, -crosshair);
        gp.lineTo(0.0f, crosshair);
        gp.moveTo(-crosshair, 0.0f);
        gp.lineTo(crosshair, 0.0f);
        HANDLE_CROSSHAIR = gp;
        String dims = XpPropertiesManager.getProperty("jami.handlesize");
        int x2 = -3;
        int y2 = -3;
        int w2 = 7;
        int h2 = 7;
        if (dims != null && (idims = XpPropertiesManager.parseIntList(dims, ", ")) != null && idims.length >= 4) {
            x2 = idims[0];
            y2 = idims[1];
            w2 = idims[2];
            h2 = idims[3];
        }
        HANDLE_BOX = DEFAULT_SHAPE = new Rectangle(x2, y2, w2, h2);
        handleColor = Color.red;
        SELECTION_CURSOR = new Cursor(1);
    }
}

