/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.CTransformCapable;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.event.MouseInputListener;

public class XpHandleVc
extends XpVisualComponent
implements MouseInputListener {
    private static Color handleColor;
    private static final Cursor SELECTION_CURSOR;
    private static Shape DEFAULT_SHAPE;
    private CPoint tmpPoint = new CPoint();
    private CPoint dispPt = new CPoint(1);
    private CPoint _anchorPt = new CPoint();
    private CPoint _dragV = new CPoint();
    private Point pMouse = null;
    private XpAnchorable anchorable = null;
    private int anchorPtIndex = -1;
    private Shape shape = null;
    private Shape containmentShape = null;
    private int mModifier = 28;
    private boolean filled = true;
    private XpGeomUtils gu = new XpGeomUtils();
    private Point2D dispPoint = new Point2D.Double();
    private boolean drawLabel = false;
    private String label = "";

    public XpHandleVc(XpAnchorable anchorable, int ptIndex) {
        this.setForeground(XpHandleVc.getHandleColor());
        this.anchorable = anchorable;
        this.anchorPtIndex = ptIndex;
        this.initialize();
    }

    public XpHandleVc(XpAnchorable anchorable, int ptIndex, int mModifier) {
        this(anchorable, ptIndex);
        this.mModifier = mModifier;
    }

    private void initialize() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public final Shape getContainmentShape() {
        if (this.containmentShape == null) {
            this.setShape(DEFAULT_SHAPE);
        }
        return this.containmentShape;
    }

    public final XpAnchorable getAnchorable() {
        return this.anchorable;
    }

    public final Shape getShape() {
        if (this.shape == null) {
            this.setShape(DEFAULT_SHAPE);
        }
        return this.shape;
    }

    public final void setShape(Shape shape) {
        this.shape = shape;
        this.containmentShape = shape.getBounds();
    }

    public final void setLocation(double x2, double y2) {
        this._anchorPt.setPoint(x2, y2, 0.0, (byte)0);
    }

    public final void setLocation(Point2D p2) {
        this.setLocation(p2.getX(), p2.getY());
    }

    public final double getHandleX() {
        return this._anchorPt.x;
    }

    public final double getHandleY() {
        return this._anchorPt.y;
    }

    public final void setAnchorPointIndex(int anchorPtIndex) {
        this.anchorPtIndex = anchorPtIndex;
    }

    public final int getAnchorPointIndex() {
        return this.anchorPtIndex;
    }

    @Override
    public void paintComponent(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        this.transform(this._anchorPt, this.dispPt, (byte)1);
        g22.setColor(this.getForeground());
        g22.translate(this.dispPt.x, this.dispPt.y);
        Shape s2 = this.getShape();
        if (this.isFilled()) {
            g22.fill(s2);
        } else {
            g22.draw(s2);
        }
        if (this.drawLabel) {
            g22.drawString(this.label, 8, -8);
        }
        g22.translate(-this.dispPt.x, -this.dispPt.y);
    }

    public final void getDisplayLocation(Point2D p2) {
        this.transform(this._anchorPt, this.tmpPoint, (byte)1);
        p2.setLocation(this.tmpPoint.x, this.tmpPoint.y);
    }

    public final Point2D getDisplayLocation() {
        Point2D.Double p2 = new Point2D.Double();
        this.getDisplayLocation(p2);
        return p2;
    }

    @Override
    public boolean contains(int x2, int y2) {
        this.dispPoint.setLocation((double)x2 - this.dispPt.x, (double)y2 - this.dispPt.y);
        Shape cShape = this.getContainmentShape();
        boolean inside = cShape != null ? cShape.contains(this.dispPoint) : false;
        return inside;
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        boolean processDrag = this.buttonTrigger(e2);
        if (processDrag) {
            this.anchorable.anchorPressed(e2, this);
        }
        this.pMouse = e2.getPoint();
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
        this.setCursor(SELECTION_CURSOR);
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        boolean processDrag = this.buttonTrigger(e2);
        if (processDrag) {
            this.anchorable.anchorReleased(e2, this);
        }
        this.pMouse = null;
    }

    private boolean buttonTrigger(MouseEvent e2) {
        boolean processEvent = false;
        int modifiers = e2.getModifiers();
        int mbutton1 = this.mModifier & 0x10;
        int mbutton2 = this.mModifier & 8;
        int mbutton3 = this.mModifier & 4;
        int button1 = modifiers & 0x10;
        int button2 = modifiers & 8;
        int button3 = modifiers & 4;
        if (mbutton1 != 0 && button1 != 0) {
            processEvent = true;
        }
        if (mbutton2 != 0 && button2 != 0) {
            processEvent = true;
        }
        if (mbutton3 != 0 && button3 != 0) {
            processEvent = true;
        }
        return processEvent;
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        boolean processDrag;
        if (this.pMouse != null && (processDrag = this.buttonTrigger(e2))) {
            this.gu.calcDragVector(e2.getPoint(), this.pMouse, (byte)0, (CTransformCapable)this, this._dragV);
            this.anchorable.anchorDragged(e2, this._dragV, this);
        }
        this.pMouse = e2.getPoint();
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
    }

    public void setFilled(boolean filled) {
        this.filled = filled;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public final boolean isDrawLabel() {
        return this.drawLabel;
    }

    public final void setDrawLabel(boolean drawLabel) {
        this.drawLabel = drawLabel;
    }

    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(String label) {
        this.label = label;
    }

    public static Color getHandleColor() {
        return handleColor;
    }

    public static void setHandleColor(Color handleColor) {
        XpHandleVc.handleColor = handleColor;
    }

    static {
        int[] idims;
        handleColor = Color.red;
        SELECTION_CURSOR = new Cursor(1);
        DEFAULT_SHAPE = null;
        String dims = XpPropertiesManager.getProperty("jami.handlesize");
        int x2 = -3;
        int y2 = -3;
        int w2 = 7;
        int h2 = 7;
        if (dims != null && (idims = XpPropertiesManager.parseIntList(dims, ",")) != null && idims.length == 4) {
            x2 = idims[0];
            y2 = idims[1];
            w2 = idims[2];
            h2 = idims[3];
        }
        DEFAULT_SHAPE = new Rectangle(x2, y2, w2, h2);
    }
}

